
/* Callback type for do_input_dialog() */
typedef int (*input_callback_t)(struct game *, gpointer, const char *);

/* Constants for do_life_dialog() */
#define SET_LIFE	1
#define GAIN_LIFE	2
#define LOSE_LIFE	3
#define INCREMENT_LIFE	4
#define DECREMENT_LIFE	5

/* newgame.c */
void new_game_dialog (struct game *game);
void close_new_game_dialog (struct game *game);
void start_new_game (struct game *game);

/* dialogs.c */
void do_message_dialog (const char *message);
void do_input_dialog (struct game *game, const char *title,
		      const char *prompt, const char *def,
		      input_callback_t callback, gpointer data);
void do_verify_dialog (struct game *game, const char *title,
		       const char *prompt, input_callback_t callback);
void do_life_dialog (struct game *game, int what_todo);
void do_library_dialog (struct game *game);
void do_zone_dialog (struct game *game, int pid, int znum, int qty);
void view_card_selected_in_zone_list (struct game *, int, int);
int gtk_clist_get_selected_row (GtkCList *clist);
void do_create_card_dialog (struct game *game);
void align_and_attach (GtkWidget *, GtkWidget *, int, int, int, int);
void do_view_card_dialog (struct game *game, int cid);
GtkWidget *new_wide_button (const char *text, int pad);
void do_preferences_dialog (struct game *game);
void do_sideboard_dialog (struct game *game);
void do_find_cardinfo_dialog (struct game *game);

/* mindless.c */
void local_player_shuffle (struct game *game);
