/*-
 * Copyright 2003 John-Mark Gurney.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: main.c,v 1.5 2003/09/15 23:37:19 jmg Exp $
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <ct.h>
#include <mime.h>
#include <mimemisc.h>

void
dumpattach(struct mime_message *mm)
{
	int i;

	if (mm == NULL) {
		printf("%s\n", "mime_message invalid");
		return;
	}

	printf("%s\n", mime_getvalue(mime_getmsgheaders(mm), "content-type"));
	printf("nattach: %d\n", mime_nattachment(mm));

	if (ct_cmpct(mime_getvalue(mime_getmsgheaders(mm), "content-type"), "message/rfc822") == 0) {
		printf("another message!\n");
		dumpattach(mime_readmessage(mime_getmsgbody(mm), mime_getmsgbodylen(mm), "\n"));
	}

	for (i = 0; i < mime_nattachment(mm); i++) {
		printf("%d:\n", i);
		dumpattach(mime_getattachment(mm, i));
	}
}

int
main(int argc, char *argv[])
{
	struct attrib *cta;
	struct mime_header *mh;
	struct mime_message *mm;
	struct mime_message **attach;
	int nattach;
	const char *e;
	const char *ct;
	char *buf;
	int p;
	int i;
	static int step = 16384;

	buf = malloc(step);
	p = 0;

	while ((i = read(STDIN_FILENO, buf + p, step)) != -1 && i != 0) {
		p += i;
		buf = realloc(buf, p + step);
	}

	if (i == -1) {
		perror("read");
		exit(1);
	}

#if 1
	mh = mime_parseheader(buf, p, &e, "\n");

	for (argc--, argv++; argc > 0; argc--, argv++)
		printf("%s:\t%s\n", *argv, mime_getvalue(mh, *argv));

	ct = mime_getvalue(mh, "content-type");

	if (ct != NULL) {
		printf("multipart: %d\n", ct_cmptype(ct, "multipart"));
		printf("text: %d\n", ct_cmptype(ct, "text"));
		printf("plain: %d\n", ct_cmpsubtype(ct, "plain"));
		printf("mixed: %d\n", ct_cmpsubtype(ct, "mixed"));

		cta = mime_getattrib(ct);
		printf("boundary: %s\n", attrib_get(cta, "boundary", NULL));
	}

	mm = mime_readmessage(buf, p, "\n");

	dumpattach(mm);
#else

	if (argc != 2) {
		printf("need to specify boundary on command line\n");
		exit(1);
	}

	/*ct_cmpct(NULL, NULL);*/

	attach = mime_parsemultipart(buf, p, argv[1], &nattach, NULL, "\n");

	for (i = 0; i < nattach; i++) {
		ct = mime_getvalue(mime_getmsgheaders(attach[i]), "content-disposition");
		cta = mime_getattrib(ct);

		printf("attach %d: %s\n", i, attrib_get(cta, "name", NULL));
	}

#endif
	return 0;
}
