/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

@Named
@Component(role=VersionRangeResolver.class)
public class DefaultVersionRangeResolver
implements VersionRangeResolver,
Service {
    private static final String MAVEN_METADATA_XML = "maven-metadata.xml";
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private MetadataResolver metadataResolver;
    @Requirement
    private SyncContextFactory syncContextFactory;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;

    public DefaultVersionRangeResolver() {
    }

    @Inject
    DefaultVersionRangeResolver(MetadataResolver metadataResolver, SyncContextFactory syncContextFactory, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setMetadataResolver(metadataResolver);
        this.setSyncContextFactory(syncContextFactory);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
    }

    public DefaultVersionRangeResolver setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultVersionRangeResolver setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultVersionRangeResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultVersionRangeResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        VersionConstraint versionConstraint;
        VersionRangeResult result = new VersionRangeResult(request);
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionConstraint = versionScheme.parseVersionConstraint(request.getArtifact().getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            result.addException(e);
            throw new VersionRangeResolutionException(result);
        }
        result.setVersionConstraint(versionConstraint);
        if (versionConstraint.getRange() == null) {
            result.addVersion(versionConstraint.getVersion());
        } else {
            Map<String, ArtifactRepository> versionIndex = this.getVersions(session, result, request);
            ArrayList<Version> versions = new ArrayList<Version>();
            for (Map.Entry<String, ArtifactRepository> v : versionIndex.entrySet()) {
                try {
                    Version ver = versionScheme.parseVersion(v.getKey());
                    if (!versionConstraint.containsVersion(ver)) continue;
                    versions.add(ver);
                    result.setRepository(ver, v.getValue());
                }
                catch (InvalidVersionSpecificationException e) {
                    result.addException(e);
                }
            }
            Collections.sort(versions);
            result.setVersions(versions);
        }
        return result;
    }

    private Map<String, ArtifactRepository> getVersions(RepositorySystemSession session, VersionRangeResult result, VersionRangeRequest request) {
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        HashMap<String, ArtifactRepository> versionIndex = new HashMap<String, ArtifactRepository>();
        DefaultMetadata metadata = new DefaultMetadata(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), MAVEN_METADATA_XML, Metadata.Nature.RELEASE_OR_SNAPSHOT);
        ArrayList<MetadataRequest> metadataRequests = new ArrayList<MetadataRequest>(request.getRepositories().size());
        metadataRequests.add(new MetadataRequest(metadata, null, request.getRequestContext()));
        for (RemoteRepository repository : request.getRepositories()) {
            MetadataRequest metadataRequest = new MetadataRequest(metadata, repository, request.getRequestContext());
            metadataRequest.setDeleteLocalCopyIfMissing(true);
            metadataRequest.setTrace(trace);
            metadataRequests.add(metadataRequest);
        }
        List<MetadataResult> metadataResults = this.metadataResolver.resolveMetadata(session, metadataRequests);
        WorkspaceReader workspace = session.getWorkspaceReader();
        if (workspace != null) {
            List<String> versions = workspace.findVersions(request.getArtifact());
            for (String version : versions) {
                versionIndex.put(version, workspace.getRepository());
            }
        }
        for (MetadataResult metadataResult : metadataResults) {
            result.addException(metadataResult.getException());
            ArtifactRepository repository = metadataResult.getRequest().getRepository();
            if (repository == null) {
                repository = session.getLocalRepository();
            }
            Versioning versioning = this.readVersions(session, trace, metadataResult.getMetadata(), repository, result);
            for (String version : versioning.getVersions()) {
                if (versionIndex.containsKey(version)) continue;
                versionIndex.put(version, repository);
            }
        }
        return versionIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Versioning readVersions(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, VersionRangeResult result) {
        Versioning versioning;
        block9: {
            versioning = null;
            FileInputStream fis = null;
            try {
                if (metadata == null) break block9;
                SyncContext syncContext = this.syncContextFactory.newInstance(session, true);
                try {
                    syncContext.acquire(null, Collections.singleton(metadata));
                    if (metadata.getFile() != null && metadata.getFile().exists()) {
                        fis = new FileInputStream(metadata.getFile());
                        org.apache.maven.artifact.repository.metadata.Metadata m = new MetadataXpp3Reader().read(fis, false);
                        versioning = m.getVersioning();
                    }
                }
                finally {
                    syncContext.close();
                }
            }
            catch (Exception e) {
                this.invalidMetadata(session, trace, metadata, repository, e);
                result.addException(e);
            }
            finally {
                IOUtil.close(fis);
            }
        }
        return versioning != null ? versioning : new Versioning();
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setException(exception);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

