/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#include "inc_iostream.h"
#include "Metview.h"
#include "MvQService.h"
#include "MvQServiceApplication.h"

//#include "MvScm.h"
#include "ScmDataEditor.h"

using namespace std;

// Globals
int ac;
char** av;


class Base : public MvQService
{
protected:
    Base(char* a) :
        MvQService(a){};
};

class MvScmDataEditor : public Base
{
public:
    MvScmDataEditor(char* a) :
        Base(a) {}
    void serve(MvRequest&, MvRequest&);
};


void MvScmDataEditor::serve(MvRequest& in, MvRequest&)
{
    //Create the qt application
    MvQServiceApplication app(ac, av);

    QFont font = app.font();
    font.setPointSize(9);
    app.setFont(font);

    //Initialise resorces from a static library (libMvQtGui)
    Q_INIT_RESOURCE(examiner);
    Q_INIT_RESOURCE(window);

    cout << "--------------ScmDataEditor::serve()--------------" << endl;
    in.print();

    // Get input file name
    const char* fName = in("PATH");
    if (!fName) {
        setError(1, "MvScmDataEditor-> parameter PATH not defined");
        return;
    }

    string name(fName);
    MvScm data(name);

    ScmDataEditor* browser = new ScmDataEditor;
    browser->init(&data);
    browser->setAppIcon("SCM_INPUT_DATA");
    browser->show();

    // register for callbacks from Desktop
    registerToDesktop(browser);

    //Listen to the mars event loop!
    setupSocketNotifier();

    // Send message to Desktop
    // to turn the icon green; otherwise, it will stay orange.
    if (strcmp(getenv("METVIEW_MODE"), "edit") != 0) {
        acknowledgeGuiStartup();
    }

    //Enter the app loop
    app.exec();
}


int main(int argc, char** argv)
{
    ac = argc;
    av = argv;

    MvApplication theApp(argc, argv, "ScmDataEditor");

    MvScmDataEditor editor("SCM_INPUT_DATA");
    MvScmDataEditor editor2("NETCDF_RTTOV_INPUT");

    theApp.run();
}
