/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQListFolderViewBase_H
#define MvQListFolderViewBase_H

#include <QListView>

#include "MvQ.h"
#include "MvQFolderViewBase.h"
#include "MvQFolderModel.h"

class MvQIconDelegate;
class MvQCurrentFolderFilterModel;

class Folder;
class IconObject;

class MvQListFolderViewBase :  public QListView, public MvQFolderViewBase
{
Q_OBJECT

public:	
  	MvQListFolderViewBase(MvQFolderModel *,QWidget *parent=0);
  	virtual ~MvQListFolderViewBase();
	QWidget* concreteWidget();
	void doReset();
	
public slots:
	void slotIconShortCut();
	void slotDefaultShortCut();
	void slotContextMenu(const QPoint &);
	void slotSelectItem(const QModelIndex&);
	void slotDoubleClickItem(const QModelIndex&);
	void slotEntered(const QModelIndex&);
	void reset();
	
signals:	
	void currentFolderChanged(Folder*);  
	void folderDoubleCliked(QString); 
	void itemEntered(QString);
	void iconCommandRequested(QString,IconObjectH);
	void desktopCommandRequested(QString,QPoint);
	
protected:
	void attachModel() {};
	void detachModel() {};
	
	void setAllowMoveAction(bool b) {allowMoveAction_=b;}
	void setEnterFolders(bool b) {enterFolders_=b;}
	
	void setupShortCut();
	void setPositions() {};
	void blink(const QModelIndex&);
	void showIcon(const QModelIndex&) {};
	void rename(IconObject*);
	
	void folderChanged();
        void iconCommandFromMain(QString) {};	
	virtual void iconCommand(QString,IconObjectH);
	virtual void desktopCommand(QString,QPoint);
	
	bool event(QEvent* event); 
	void leaveEvent(QEvent *event);
	void keyPressEvent(QKeyEvent*);
	void mousePressEvent(QMouseEvent*);
	void mouseMoveEvent(QMouseEvent*);
	void performDrag(Qt::DropAction,QPoint);
	void dragEnterEvent(QDragEnterEvent*);
	void dragMoveEvent(QDragMoveEvent*);
 	void dropEvent(QDropEvent*); 
	
	QRect itemRect(QList<IconObject*>);
	QRect itemRect(IconObject*);
	QRect pixmapRect(QList<IconObject*>);
	QRect pixmapRect(IconObject*);
	
	bool ignoreItemPositionForCm() {return false;};
	
	MvQIconDelegate* delegate_;

private:
	bool allowMoveAction_;
	bool enterFolders_;
	QPoint startPos_;
	bool canDrag_;	
	QShortcut* defaultShortCut_;
	QString itemInfo_;
	
};

#endif