/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "RootFolder.h"
#include "IconClass.h"
#include "FolderInfo.h"
#include "FolderSettings.h"

RootFolder::RootFolder() :
    SystemFolder(0, IconClass::find("HOME"), "", 0)
{
    // Make sure this one is never deleted
    //	_attach();
}

RootFolder::~RootFolder()
{
}

Path RootFolder::dotPath() const
{
    string p = "/";
    return Path(p);
    //return path().add(".MainWindowResources");
}

string RootFolder::fullName() const
{
    return "/";
}

Path RootFolder::path() const
{
    static Path user = string(getenv("METVIEW_USER_DIRECTORY"));
    return user;
}

Folder* RootFolder::parent() const
{
    return 0;
}

Path RootFolder::logPath()
{
    string p = Folder::folder("temporary")->path().str() + "/messages";
    return Path(p);
}
