/***************************** LICENSE START ***********************************

 Copyright 2017 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ShareTargets_H
#define ShareTargets_H

#include <string>
#include <vector>
#include "MvRequest.h"
#include "Presentable.h"

/* The classes here define each 'share' target of uPlot */

//**********************************************************
// The base class from which the 'real' share targets inherit

class ShareTarget
{
public:
   ShareTarget(const std::string&, const std::string&);
   ~ShareTarget() {};

   virtual std::string &name() {return name_;}
   virtual std::string &icon() {return icon_;}

   virtual bool dialog(Presentable* pres=0) = 0;
//   virtual bool requirementsMet(std::string &msg) = 0;
   virtual void customisePlotRequest(MvRequest&, MvRequest&) = 0;
   virtual bool upload() = 0;

protected:
   Presentable* presentable_;  // SuperPage containing plotting elements

private:
   std::string name_;          // share target name
   std::string icon_;          // share target icon
};


//**********************************************************
// The registry of share targets

class ShareTargets : public std::vector<ShareTarget *>
{
public:
   ShareTargets() {};
   ~ShareTargets();

   static ShareTargets *instance();

private:
   static ShareTargets * instance_;
};


//**********************************************************
#ifdef MV_SHARE_GLOBE_BUILD
class GlobeShareTarget : public ShareTarget
{
public:
   GlobeShareTarget();
   ~GlobeShareTarget() {};

   bool dialog(Presentable* pres=0);
   void edited(MvRequest&);
   //   bool requirementsMet(std::string &msg);
   void customisePlotRequest(MvRequest&,MvRequest&);
   bool upload();

private:
   std::string class_;       // class name ("GLOBE")
   std::string format_;      // format name ("GLOBEOUTPUT")
   std::string temp_fname_; // temporary file name (PNG prefix name)
};
#endif

#endif
