/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQRequestPanelLine.h"

#include <QApplication>
#include <QDebug>
#include <QFrame>
#include <QLabel>
#include <QStyle>
#include <QToolButton>

#include "MvQRequestPanelHelp.h"

#include "LineFactory.h"
#include "Parameter.h"
#include "RequestPanel.h"

MvQRequestPanelLine::MvQRequestPanelLine(RequestPanel& owner,const Parameter& param, bool buildLine) : 
	RequestPanelItem(owner,param),
	defaultTb_(0),
	helpTb_(0),
    gray_(false),
    helper_(0),
    parentWidget_(owner.parentWidget())
{	
	if(!buildLine)
	  	return;
  
  	RequestPanel *parentLayout=&owner_;
		
	//Toggle to indicate default/non-default settings
	defaultTb_ = new QToolButton(parentWidget_);
	defaultTb_->setObjectName(QString::fromUtf8("guiItemDefaultTb"));
	defaultTb_->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum));
	defaultTb_->setMaximumSize(QSize(20,20));
	defaultTb_->setToolTip(tr("Reset parameter"));
	//defaultTb_->setIconSize(QSize(10,10));
	defaultTb_->setAutoRaise(true);
	defaultTb_->setIcon(QPixmap(":/desktop/reset_lineEditor.svg"));
	//defaultTb_->setIcon(QPixmap(":/desktop/link.svg"));
	
	connect(defaultTb_,SIGNAL(clicked(bool)),
		this,SLOT(slotChangeToDefault(bool)));	
		
	//name label
	name_=QString::fromStdString(param.beautifiedName());	
	nameLabel_=new QLabel(name_,parentWidget_);
	const char* help_text=param.help_text();
	if(help_text)
	  	nameLabel_->setToolTip("<font>" + QString(help_text) + "</font>");
	
	row_=parentLayout->rowCount();
	parentLayout->addWidget(defaultTb_,row_,DefaultColumn);
	parentLayout->addWidget(nameLabel_,row_,NameColumn);
	
	defaultTb_->setVisible(false);
	//defaultTb_->setEnabled(false);
}

MvQRequestPanelLine::~MvQRequestPanelLine()
{
 	if(helper_) delete helper_;	  
}


MvQRequestPanelLine* MvQRequestPanelLine::build(RequestPanel& owner,const Parameter& param)
{
	MvQRequestPanelLine* p = LineFactory::create(owner,param);
	p->buildHelper();
	//p->init(w);
	return p;
}

void MvQRequestPanelLine::buildHelper()
{	
	if(helper_) return;
	
	helper_ = MvQRequestPanelHelp::build(owner_,param_);
	
	if(!helper_)
		return;
	
	MvRequest helpReq=param_.interfaceRequest();
	
	//Toolbuton to show/hide help widget or launch dialog helper
	helpTb_ = new QToolButton(parentWidget_);
	//helpTb_->setObjectName(QString::fromUtf8("guiItemDefaultTb"));
	
	//Set helper icon
	if(helper_->dialog())
	{
		helpTb_->setIcon(helper_->dialogIcon());
		if(helper_->useLargeDialogIcon())
			helpTb_->setMaximumSize(QSize(20,20));
		else
		  	helpTb_->setMaximumSize(QSize(16,16));			
	}
	else
	{
		QIcon ic;
		ic.addPixmap(QPixmap(":/desktop/expand_left.svg"),QIcon::Normal,QIcon::On);
		ic.addPixmap(QPixmap(":/desktop/expand_right.svg"),QIcon::Normal,QIcon::Off);
	  	helpTb_->setIcon(ic);
		helpTb_->setMaximumSize(QSize(16,16));		
		helpTb_->setCheckable(true);
		helpTb_->setChecked(false);
	}
	
	if(const char* ttip=helpReq("help_tooltip"))
	{
	  	helpTb_->setToolTip(QString(ttip));
	}	
	
	helpTb_->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum));
	
	RequestPanel *parentLayout=&owner_;
	parentLayout->addWidget(helpTb_,row_,ExpandColumn);
			
	if(helper_->dialog())
	{
		connect(helpTb_,SIGNAL(clicked(bool)),
			this,SLOT(slotStarHelpDialog(bool)));
	}
	else
	{  	
	  	parentLayout->addWidget(helper_->widget(),row_+1,WidgetColumn);	
		helper_->widget()->setVisible(false);
		
		connect(helpTb_,SIGNAL(toggled(bool)),          
            this,SLOT(slotHelpTbToggled(bool)));

		connect(helpTb_,SIGNAL(toggled(bool)),
			this,SLOT(slotHelperOpened(bool)));
			
		connect(helper_,SIGNAL(edited(const vector<string>&)),
                	this,SLOT(slotHelperEdited(const vector<string>&)));
		
		connect(helper_,SIGNAL(edited(const vector<string>&,const vector<string>&)),
                	this,SLOT(slotHelperEdited(const vector<string>&,const vector<string>&)));
			
		connect(helper_,SIGNAL(editConfirmed()),
                	this,SLOT(slotHelperEditConfirmed()));	
	}
}

void MvQRequestPanelLine::gray(bool g)
{
	//g = g && param_.hasDefaults();
	if(gray_ != g)
	{
		gray_ = g;
		if(gray_)
			setEnabled(false);
		else
			setEnabled(true);
	}
}

void MvQRequestPanelLine::mark(bool g)
{
	if(g == false)
	{  
		int cntPrev=owner_.defaultCnt();
		defaultTb_->hide();
		int cntAct=owner_.defaultCnt();		
		if(cntPrev != 0 && cntAct == 0)
			owner_.updateParentWidget();
	}	
	else 
	{  	
	  	int cntPrev=owner_.defaultCnt();
		defaultTb_->show();
		int cntAct=owner_.defaultCnt();		
		if(cntPrev == 0 && cntAct != 0)
			owner_.updateParentWidget();
	}
}

void MvQRequestPanelLine::setEnabled(bool s)
{		
  	if(s == false && 
	  helper_ && !helper_->dialog())
	{
		helpTb_->setChecked(false);
        helper_->widget()->setEnabled(s);
	}
	
  	for(int i=0; i < owner_.columnCount(); i++)
	{
	  	QLayoutItem *item=owner_.itemAtPosition(row_,i);
		if(item) 
		{
		  	QWidget *w=item->widget();
            if(w)
            {
                w->setEnabled(s);
            }
		}
	}
	
	if(s == true && 
	   helper_ && !helper_->dialog())
	{
	  	helper_->widget()->setEnabled(s);
	}	
}

void MvQRequestPanelLine::slotChangeToDefault(bool)
{	
    //This will reset the request and call update on all the items
    owner_.setToDefault(this);
}  


void MvQRequestPanelLine::slotStarHelpDialog(bool)
{
	if(helper_)
	  	helper_->start();
  
}  

void MvQRequestPanelLine::slotHelpTbToggled(bool b)
{
    helper_->widget()->setVisible(b);

    //We need to immediately repaint the background of the main gridlayout.
    //This was the only method to make it work!!
    owner_.updateParentWidget();
    qApp->processEvents();
}

bool MvQRequestPanelLine::hasDefaultTb() 
{
  	if(defaultTb_)
		return defaultTb_->isVisible();
	
	return false;
}
