/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef NcExaminer_H
#define NcExaminer_H

#include "MvQMainWindow.h"

class QPlainTextEdit;
class QSplitter;
class QTreeWidget;

class MvNetCDF;
class MvNcVar;
class MvQFileInfoLabel;
class MvQLogBrowser;

using namespace std;

class NcExaminer : public MvQMainWindow
{
    Q_OBJECT

public:
    	NcExaminer(QWidget *parent = 0);
	~NcExaminer();
    	bool initMetaData(const string&);
	void updateFileInfoLabel();

public slots:
	void slotTabIndexChanged(int);
	void slotShowAboutBox();
	void slotUpdateLogOutput();
	void slotClearLog(bool);
	void slotStatusMessage(QString);

signals:
	void statusMessage(QString);

private:
	void setupViewActions();
	void setupHelpActions();
	void setupParamBox();
	void setupDumpBox();
	void setupLogArea();

	void showDumpBox();
	void showVariables();
	void getDataValues( MvNcVar*, QStringList&, long& );
	long getNumberValues( MvNcVar* );

	void readSettings();
	void writeSettings();

	template <class T>
	void print_data( vector<T>&, QStringList&, long );

	MvNetCDF *data_;
	MvQMainWindow::MenuItemMap menuItems_;
	MvQFileInfoLabel*  fileInfoLabel_;

	QAction *actionFileInfo_;
	QSplitter*   mainSplitter_;
	QTabWidget* metaTab_;
	MvQLogBrowser* logBrowser_;
	QTreeWidget* treeParam_;
	QWidget* logPanel_;
	QAction* actionLog_;
	QLabel* statusMessageLabel_;
	QPlainTextEdit* dumpText_;

	bool initDump_;
};

#endif
