/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef HOVLINE_H
#define HOVLINE_H

#include "Hovmoeller.h"
#include "HovToolkit.h"

class HovLineToolkit : public HovToolkit
{

public:

   // Initialize variables
   bool GetInputInfo(MvRequest&);  //from user interface
   bool GetInputInfo(MvNetCDF*);   //from the netCDF file

   // Common functions
   string GetTitle(ParamInfo*);
   const char* GetSecondCoordName();
   const char* GetSecondAuxiliaryCoordName();
   bool SecondAuxiliaryCoord() { return true; }
   const char* ApplicationType() { return "LINE_HOVM"; }
   bool NcWriteSecondCoord();
   void NcWriteGlobalAttributesApp();

   // Calculate diagram values
   bool ComputeValues( MvField&, int=0);

   // Compute coordinates
   bool ComputeSecondCoord();

   // Check if parameters between two requests are consistent
   bool consistencyCheck( MvRequest&, MvRequest& );

private:

   // Compute number of points
   bool EvaluateNPoints();

   // Create View request
   MvRequest CreateViewRequest();
};

//---------------------------------------------------------------------

class LineHovmoeller : public HovLineToolkit, public Hovmoeller
{

public:

   LineHovmoeller() : Hovmoeller("LINE_HOVM") {};
   LineHovmoeller(const char* kw) : Hovmoeller(kw) {};

   ~LineHovmoeller() {};

   // Entry point
   void serve (MvRequest&, MvRequest&);
};

static SimpleObjectMaker <HovLineToolkit,HovToolkit> line ("LINE");

//---------------------------------------------------------------------

class LineHovmoellerM3 : public LineHovmoeller
{

public:

   LineHovmoellerM3() : LineHovmoeller("LINE_HOV") {};

   ~LineHovmoellerM3() {};

   // Entry point
   void serve (MvRequest&, MvRequest&);
};

#endif
