#!/usr/bin/env ruby

$:.unshift(File.join(File.dirname(__FILE__), '..', '..'))

require 'test/unit'
require 'msf/core'

module Msf

class Exploit::UnitTest < Test::Unit::TestCase

	class StubExploit < Msf::Exploit
	end

	class Stub2Exploit < Msf::Exploit
		def check
		end
	end

	def test_support
		assert_equal(false, Exploit.new.supports_check?, "auto target support check failed")
		assert_equal(false, StubExploit.new.supports_check?, "auto target deriv enabled support check failed")
		assert_equal(true, Stub2Exploit.new.supports_check?, "auto target deriv disabled support check failed")
		assert_equal(false, Exploit.new.capabilities['check'], "auto target capabilities check failed")
		assert_equal(false, StubExploit.new.capabilities['check'], "auto target deriv enabled capabilities check failed")
		assert_equal(true, Stub2Exploit.new.capabilities['check'], "auto target deriv disabled capabilities check failed")
	end

	def test_defaults
		e = Exploit.new

		assert_equal(Msf::Exploit::CheckCode::Unsupported, e.check, "invalid default check")
	end

end

end
