#!/usr/bin/env ruby

$:.unshift(File.dirname(__FILE__))
require "Lorcon"

$stdout.puts "Drivers: " + Lorcon.drivers.join(", ")

# Beacon frame from tx.c
packet = [
	0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, # dur ffff
	0xff, 0xff, 0x00, 0x0f, 0x66, 0xe3, 0xe4, 0x03, 
	0x00, 0x0f, 0x66, 0xe3, 0xe4, 0x03, 0x00, 0x00, # 0x0000 - seq no.
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, # BSS timestamp 
	0x64, 0x00, 0x11, 0x00, 0x00, 0x0f, 0x73, 0x6f, 
	0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x63, 
	0x6c, 0x65, 0x76, 0x65, 0x72, 0x01, 0x08, 0x82, 
	0x84, 0x8b, 0x96, 0x24, 0x30, 0x48, 0x6c, 0x03, 
	0x01, 0x01, 0x05, 0x04, 0x00, 0x01, 0x00, 0x00, 
	0x2a, 0x01, 0x05, 0x2f, 0x01, 0x05, 0x32, 0x04, 
	0x0c, 0x12, 0x18, 0x60, 0xdd, 0x05, 0x00, 0x10, 
	0x18, 0x01, 0x01, 0xdd, 0x16, 0x00, 0x50, 0xf2, 
	0x01, 0x01, 0x00, 0x00, 0x50, 0xf2, 0x02, 0x01, 
	0x00, 0x00, 0x50, 0xf2, 0x02, 0x01, 0x00, 0x00, 
	0x50, 0xf2, 0x02
].pack('C*')

tx = Lorcon::Device.new('ath0', 'madwifi', 1)

sa = Time.now.to_f
tx.write(packet, 500, 0)
ea = Time.now.to_f - sa

sb = Time.now.to_f
1.upto(500) { |i| tx.write(packet, 11, 0) }
eb = Time.now.to_f - sb

$stdout.puts "Sent 500 packets (C) in #{ea.to_s} seconds"
$stdout.puts "Sent 500 packets (Ruby) in #{eb.to_s} seconds"
