// Code generated by protoc-gen-go. DO NOT EDIT.
// source: csi.proto

/*
Package csi is a generated protocol buffer package.

It is generated from these files:
	csi.proto

It has these top-level messages:
	GetPluginInfoRequest
	GetPluginInfoResponse
	GetPluginCapabilitiesRequest
	GetPluginCapabilitiesResponse
	PluginCapability
	ProbeRequest
	ProbeResponse
	CreateVolumeRequest
	CreateVolumeResponse
	VolumeCapability
	CapacityRange
	Volume
	DeleteVolumeRequest
	DeleteVolumeResponse
	ControllerPublishVolumeRequest
	ControllerPublishVolumeResponse
	ControllerUnpublishVolumeRequest
	ControllerUnpublishVolumeResponse
	ValidateVolumeCapabilitiesRequest
	ValidateVolumeCapabilitiesResponse
	ListVolumesRequest
	ListVolumesResponse
	GetCapacityRequest
	GetCapacityResponse
	ControllerGetCapabilitiesRequest
	ControllerGetCapabilitiesResponse
	ControllerServiceCapability
	NodeStageVolumeRequest
	NodeStageVolumeResponse
	NodeUnstageVolumeRequest
	NodeUnstageVolumeResponse
	NodePublishVolumeRequest
	NodePublishVolumeResponse
	NodeUnpublishVolumeRequest
	NodeUnpublishVolumeResponse
	NodeGetIdRequest
	NodeGetIdResponse
	NodeGetCapabilitiesRequest
	NodeGetCapabilitiesResponse
	NodeServiceCapability
*/
package csi

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type PluginCapability_Service_Type int32

const (
	PluginCapability_Service_UNKNOWN PluginCapability_Service_Type = 0
	// CONTROLLER_SERVICE indicates that the Plugin provides RPCs for
	// the ControllerService. Plugins SHOULD provide this capability.
	// In rare cases certain plugins may wish to omit the
	// ControllerService entirely from their implementation, but such
	// SHOULD NOT be the common case.
	// The presence of this capability determines whether the CO will
	// attempt to invoke the REQUIRED ControllerService RPCs, as well
	// as specific RPCs as indicated by ControllerGetCapabilities.
	PluginCapability_Service_CONTROLLER_SERVICE PluginCapability_Service_Type = 1
)

var PluginCapability_Service_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CONTROLLER_SERVICE",
}
var PluginCapability_Service_Type_value = map[string]int32{
	"UNKNOWN":            0,
	"CONTROLLER_SERVICE": 1,
}

func (x PluginCapability_Service_Type) String() string {
	return proto.EnumName(PluginCapability_Service_Type_name, int32(x))
}
func (PluginCapability_Service_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{4, 0, 0}
}

type VolumeCapability_AccessMode_Mode int32

const (
	VolumeCapability_AccessMode_UNKNOWN VolumeCapability_AccessMode_Mode = 0
	// Can only be published once as read/write on a single node, at
	// any given time.
	VolumeCapability_AccessMode_SINGLE_NODE_WRITER VolumeCapability_AccessMode_Mode = 1
	// Can only be published once as readonly on a single node, at
	// any given time.
	VolumeCapability_AccessMode_SINGLE_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 2
	// Can be published as readonly at multiple nodes simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_READER_ONLY VolumeCapability_AccessMode_Mode = 3
	// Can be published at multiple nodes simultaneously. Only one of
	// the node can be used as read/write. The rest will be readonly.
	VolumeCapability_AccessMode_MULTI_NODE_SINGLE_WRITER VolumeCapability_AccessMode_Mode = 4
	// Can be published as read/write at multiple nodes
	// simultaneously.
	VolumeCapability_AccessMode_MULTI_NODE_MULTI_WRITER VolumeCapability_AccessMode_Mode = 5
)

var VolumeCapability_AccessMode_Mode_name = map[int32]string{
	0: "UNKNOWN",
	1: "SINGLE_NODE_WRITER",
	2: "SINGLE_NODE_READER_ONLY",
	3: "MULTI_NODE_READER_ONLY",
	4: "MULTI_NODE_SINGLE_WRITER",
	5: "MULTI_NODE_MULTI_WRITER",
}
var VolumeCapability_AccessMode_Mode_value = map[string]int32{
	"UNKNOWN":                  0,
	"SINGLE_NODE_WRITER":       1,
	"SINGLE_NODE_READER_ONLY":  2,
	"MULTI_NODE_READER_ONLY":   3,
	"MULTI_NODE_SINGLE_WRITER": 4,
	"MULTI_NODE_MULTI_WRITER":  5,
}

func (x VolumeCapability_AccessMode_Mode) String() string {
	return proto.EnumName(VolumeCapability_AccessMode_Mode_name, int32(x))
}
func (VolumeCapability_AccessMode_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{9, 2, 0}
}

type ControllerServiceCapability_RPC_Type int32

const (
	ControllerServiceCapability_RPC_UNKNOWN                  ControllerServiceCapability_RPC_Type = 0
	ControllerServiceCapability_RPC_CREATE_DELETE_VOLUME     ControllerServiceCapability_RPC_Type = 1
	ControllerServiceCapability_RPC_PUBLISH_UNPUBLISH_VOLUME ControllerServiceCapability_RPC_Type = 2
	ControllerServiceCapability_RPC_LIST_VOLUMES             ControllerServiceCapability_RPC_Type = 3
	ControllerServiceCapability_RPC_GET_CAPACITY             ControllerServiceCapability_RPC_Type = 4
)

var ControllerServiceCapability_RPC_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATE_DELETE_VOLUME",
	2: "PUBLISH_UNPUBLISH_VOLUME",
	3: "LIST_VOLUMES",
	4: "GET_CAPACITY",
}
var ControllerServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN":                  0,
	"CREATE_DELETE_VOLUME":     1,
	"PUBLISH_UNPUBLISH_VOLUME": 2,
	"LIST_VOLUMES":             3,
	"GET_CAPACITY":             4,
}

func (x ControllerServiceCapability_RPC_Type) String() string {
	return proto.EnumName(ControllerServiceCapability_RPC_Type_name, int32(x))
}
func (ControllerServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26, 0, 0}
}

type NodeServiceCapability_RPC_Type int32

const (
	NodeServiceCapability_RPC_UNKNOWN              NodeServiceCapability_RPC_Type = 0
	NodeServiceCapability_RPC_STAGE_UNSTAGE_VOLUME NodeServiceCapability_RPC_Type = 1
)

var NodeServiceCapability_RPC_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "STAGE_UNSTAGE_VOLUME",
}
var NodeServiceCapability_RPC_Type_value = map[string]int32{
	"UNKNOWN":              0,
	"STAGE_UNSTAGE_VOLUME": 1,
}

func (x NodeServiceCapability_RPC_Type) String() string {
	return proto.EnumName(NodeServiceCapability_RPC_Type_name, int32(x))
}
func (NodeServiceCapability_RPC_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{39, 0, 0}
}

type GetPluginInfoRequest struct {
}

func (m *GetPluginInfoRequest) Reset()                    { *m = GetPluginInfoRequest{} }
func (m *GetPluginInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPluginInfoRequest) ProtoMessage()               {}
func (*GetPluginInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GetPluginInfoResponse struct {
	// The name MUST follow reverse domain name notation format
	// (https://en.wikipedia.org/wiki/Reverse_domain_name_notation).
	// It SHOULD include the plugin's host company name and the plugin
	// name, to minimize the possibility of collisions. It MUST be 63
	// characters or less, beginning and ending with an alphanumeric
	// character ([a-z0-9A-Z]) with dashes (-), underscores (_),
	// dots (.), and alphanumerics between. This field is REQUIRED.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field is REQUIRED. Value of this field is opaque to the CO.
	VendorVersion string `protobuf:"bytes,2,opt,name=vendor_version,json=vendorVersion" json:"vendor_version,omitempty"`
	// This field is OPTIONAL. Values are opaque to the CO.
	Manifest map[string]string `protobuf:"bytes,3,rep,name=manifest" json:"manifest,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetPluginInfoResponse) Reset()                    { *m = GetPluginInfoResponse{} }
func (m *GetPluginInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPluginInfoResponse) ProtoMessage()               {}
func (*GetPluginInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetPluginInfoResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetPluginInfoResponse) GetVendorVersion() string {
	if m != nil {
		return m.VendorVersion
	}
	return ""
}

func (m *GetPluginInfoResponse) GetManifest() map[string]string {
	if m != nil {
		return m.Manifest
	}
	return nil
}

type GetPluginCapabilitiesRequest struct {
}

func (m *GetPluginCapabilitiesRequest) Reset()                    { *m = GetPluginCapabilitiesRequest{} }
func (m *GetPluginCapabilitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*GetPluginCapabilitiesRequest) ProtoMessage()               {}
func (*GetPluginCapabilitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type GetPluginCapabilitiesResponse struct {
	// All the capabilities that the controller service supports. This
	// field is OPTIONAL.
	Capabilities []*PluginCapability `protobuf:"bytes,2,rep,name=capabilities" json:"capabilities,omitempty"`
}

func (m *GetPluginCapabilitiesResponse) Reset()                    { *m = GetPluginCapabilitiesResponse{} }
func (m *GetPluginCapabilitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*GetPluginCapabilitiesResponse) ProtoMessage()               {}
func (*GetPluginCapabilitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GetPluginCapabilitiesResponse) GetCapabilities() []*PluginCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the plugin.
type PluginCapability struct {
	// Types that are valid to be assigned to Type:
	//	*PluginCapability_Service_
	Type isPluginCapability_Type `protobuf_oneof:"type"`
}

func (m *PluginCapability) Reset()                    { *m = PluginCapability{} }
func (m *PluginCapability) String() string            { return proto.CompactTextString(m) }
func (*PluginCapability) ProtoMessage()               {}
func (*PluginCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type isPluginCapability_Type interface {
	isPluginCapability_Type()
}

type PluginCapability_Service_ struct {
	Service *PluginCapability_Service `protobuf:"bytes,1,opt,name=service,oneof"`
}

func (*PluginCapability_Service_) isPluginCapability_Type() {}

func (m *PluginCapability) GetType() isPluginCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *PluginCapability) GetService() *PluginCapability_Service {
	if x, ok := m.GetType().(*PluginCapability_Service_); ok {
		return x.Service
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PluginCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PluginCapability_OneofMarshaler, _PluginCapability_OneofUnmarshaler, _PluginCapability_OneofSizer, []interface{}{
		(*PluginCapability_Service_)(nil),
	}
}

func _PluginCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PluginCapability)
	// type
	switch x := m.Type.(type) {
	case *PluginCapability_Service_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Service); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PluginCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _PluginCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PluginCapability)
	switch tag {
	case 1: // type.service
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PluginCapability_Service)
		err := b.DecodeMessage(msg)
		m.Type = &PluginCapability_Service_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PluginCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PluginCapability)
	// type
	switch x := m.Type.(type) {
	case *PluginCapability_Service_:
		s := proto.Size(x.Service)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type PluginCapability_Service struct {
	Type PluginCapability_Service_Type `protobuf:"varint,1,opt,name=type,enum=csi.v0.PluginCapability_Service_Type" json:"type,omitempty"`
}

func (m *PluginCapability_Service) Reset()                    { *m = PluginCapability_Service{} }
func (m *PluginCapability_Service) String() string            { return proto.CompactTextString(m) }
func (*PluginCapability_Service) ProtoMessage()               {}
func (*PluginCapability_Service) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4, 0} }

func (m *PluginCapability_Service) GetType() PluginCapability_Service_Type {
	if m != nil {
		return m.Type
	}
	return PluginCapability_Service_UNKNOWN
}

type ProbeRequest struct {
}

func (m *ProbeRequest) Reset()                    { *m = ProbeRequest{} }
func (m *ProbeRequest) String() string            { return proto.CompactTextString(m) }
func (*ProbeRequest) ProtoMessage()               {}
func (*ProbeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type ProbeResponse struct {
}

func (m *ProbeResponse) Reset()                    { *m = ProbeResponse{} }
func (m *ProbeResponse) String() string            { return proto.CompactTextString(m) }
func (*ProbeResponse) ProtoMessage()               {}
func (*ProbeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type CreateVolumeRequest struct {
	// The suggested name for the storage space. This field is REQUIRED.
	// It serves two purposes:
	// 1) Idempotency - This name is generated by the CO to achieve
	//    idempotency. If `CreateVolume` fails, the volume may or may not
	//    be provisioned. In this case, the CO may call `CreateVolume`
	//    again, with the same name, to ensure the volume exists. The
	//    Plugin should ensure that multiple `CreateVolume` calls for the
	//    same name do not result in more than one piece of storage
	//    provisioned corresponding to that name. If a Plugin is unable to
	//    enforce idempotency, the CO's error recovery logic could result
	//    in multiple (unused) volumes being provisioned.
	// 2) Suggested name - Some storage systems allow callers to specify
	//    an identifier by which to refer to the newly provisioned
	//    storage. If a storage system supports this, it can optionally
	//    use this name as the identifier for the new volume.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// This field is OPTIONAL. This allows the CO to specify the capacity
	// requirement of the volume to be provisioned. If not specified, the
	// Plugin MAY choose an implementation-defined capacity range.
	CapacityRange *CapacityRange `protobuf:"bytes,2,opt,name=capacity_range,json=capacityRange" json:"capacity_range,omitempty"`
	// The capabilities that the provisioned volume MUST have: the Plugin
	// MUST provision a volume that could satisfy ALL of the
	// capabilities specified in this list. The Plugin MUST assume that
	// the CO MAY use the  provisioned volume later with ANY of the
	// capabilities specified in this list. This also enables the CO to do
	// early validation: if ANY of the specified volume capabilities are
	// not supported by the Plugin, the call SHALL fail. This field is
	// REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,3,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// Plugin specific parameters passed in as opaque key-value pairs.
	// This field is OPTIONAL. The Plugin is responsible for parsing and
	// validating these parameters. COs will treat these as opaque.
	Parameters map[string]string `protobuf:"bytes,4,rep,name=parameters" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Secrets required by plugin to complete volume creation request.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	ControllerCreateSecrets map[string]string `protobuf:"bytes,5,rep,name=controller_create_secrets,json=controllerCreateSecrets" json:"controller_create_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CreateVolumeRequest) Reset()                    { *m = CreateVolumeRequest{} }
func (m *CreateVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVolumeRequest) ProtoMessage()               {}
func (*CreateVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *CreateVolumeRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateVolumeRequest) GetCapacityRange() *CapacityRange {
	if m != nil {
		return m.CapacityRange
	}
	return nil
}

func (m *CreateVolumeRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *CreateVolumeRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *CreateVolumeRequest) GetControllerCreateSecrets() map[string]string {
	if m != nil {
		return m.ControllerCreateSecrets
	}
	return nil
}

type CreateVolumeResponse struct {
	// Contains all attributes of the newly created volume that are
	// relevant to the CO along with information required by the Plugin
	// to uniquely identify the volume. This field is REQUIRED.
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
}

func (m *CreateVolumeResponse) Reset()                    { *m = CreateVolumeResponse{} }
func (m *CreateVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateVolumeResponse) ProtoMessage()               {}
func (*CreateVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CreateVolumeResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

// Specify a capability of a volume.
type VolumeCapability struct {
	// Specifies what API the volume will be accessed using. One of the
	// following fields MUST be specified.
	//
	// Types that are valid to be assigned to AccessType:
	//	*VolumeCapability_Block
	//	*VolumeCapability_Mount
	AccessType isVolumeCapability_AccessType `protobuf_oneof:"access_type"`
	// This is a REQUIRED field.
	AccessMode *VolumeCapability_AccessMode `protobuf:"bytes,3,opt,name=access_mode,json=accessMode" json:"access_mode,omitempty"`
}

func (m *VolumeCapability) Reset()                    { *m = VolumeCapability{} }
func (m *VolumeCapability) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability) ProtoMessage()               {}
func (*VolumeCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type isVolumeCapability_AccessType interface {
	isVolumeCapability_AccessType()
}

type VolumeCapability_Block struct {
	Block *VolumeCapability_BlockVolume `protobuf:"bytes,1,opt,name=block,oneof"`
}
type VolumeCapability_Mount struct {
	Mount *VolumeCapability_MountVolume `protobuf:"bytes,2,opt,name=mount,oneof"`
}

func (*VolumeCapability_Block) isVolumeCapability_AccessType() {}
func (*VolumeCapability_Mount) isVolumeCapability_AccessType() {}

func (m *VolumeCapability) GetAccessType() isVolumeCapability_AccessType {
	if m != nil {
		return m.AccessType
	}
	return nil
}

func (m *VolumeCapability) GetBlock() *VolumeCapability_BlockVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Block); ok {
		return x.Block
	}
	return nil
}

func (m *VolumeCapability) GetMount() *VolumeCapability_MountVolume {
	if x, ok := m.GetAccessType().(*VolumeCapability_Mount); ok {
		return x.Mount
	}
	return nil
}

func (m *VolumeCapability) GetAccessMode() *VolumeCapability_AccessMode {
	if m != nil {
		return m.AccessMode
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VolumeCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VolumeCapability_OneofMarshaler, _VolumeCapability_OneofUnmarshaler, _VolumeCapability_OneofSizer, []interface{}{
		(*VolumeCapability_Block)(nil),
		(*VolumeCapability_Mount)(nil),
	}
}

func _VolumeCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VolumeCapability)
	// access_type
	switch x := m.AccessType.(type) {
	case *VolumeCapability_Block:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Block); err != nil {
			return err
		}
	case *VolumeCapability_Mount:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mount); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VolumeCapability.AccessType has unexpected type %T", x)
	}
	return nil
}

func _VolumeCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VolumeCapability)
	switch tag {
	case 1: // access_type.block
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VolumeCapability_BlockVolume)
		err := b.DecodeMessage(msg)
		m.AccessType = &VolumeCapability_Block{msg}
		return true, err
	case 2: // access_type.mount
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VolumeCapability_MountVolume)
		err := b.DecodeMessage(msg)
		m.AccessType = &VolumeCapability_Mount{msg}
		return true, err
	default:
		return false, nil
	}
}

func _VolumeCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VolumeCapability)
	// access_type
	switch x := m.AccessType.(type) {
	case *VolumeCapability_Block:
		s := proto.Size(x.Block)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *VolumeCapability_Mount:
		s := proto.Size(x.Mount)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Indicate that the volume will be accessed via the block device API.
type VolumeCapability_BlockVolume struct {
}

func (m *VolumeCapability_BlockVolume) Reset()                    { *m = VolumeCapability_BlockVolume{} }
func (m *VolumeCapability_BlockVolume) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_BlockVolume) ProtoMessage()               {}
func (*VolumeCapability_BlockVolume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 0} }

// Indicate that the volume will be accessed via the filesystem API.
type VolumeCapability_MountVolume struct {
	// The filesystem type. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	FsType string `protobuf:"bytes,1,opt,name=fs_type,json=fsType" json:"fs_type,omitempty"`
	// The mount options that can be used for the volume. This field is
	// OPTIONAL. `mount_flags` MAY contain sensitive information.
	// Therefore, the CO and the Plugin MUST NOT leak this information
	// to untrusted entities. The total size of this repeated field
	// SHALL NOT exceed 4 KiB.
	MountFlags []string `protobuf:"bytes,2,rep,name=mount_flags,json=mountFlags" json:"mount_flags,omitempty"`
}

func (m *VolumeCapability_MountVolume) Reset()                    { *m = VolumeCapability_MountVolume{} }
func (m *VolumeCapability_MountVolume) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_MountVolume) ProtoMessage()               {}
func (*VolumeCapability_MountVolume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 1} }

func (m *VolumeCapability_MountVolume) GetFsType() string {
	if m != nil {
		return m.FsType
	}
	return ""
}

func (m *VolumeCapability_MountVolume) GetMountFlags() []string {
	if m != nil {
		return m.MountFlags
	}
	return nil
}

// Specify how a volume can be accessed.
type VolumeCapability_AccessMode struct {
	// This field is REQUIRED.
	Mode VolumeCapability_AccessMode_Mode `protobuf:"varint,1,opt,name=mode,enum=csi.v0.VolumeCapability_AccessMode_Mode" json:"mode,omitempty"`
}

func (m *VolumeCapability_AccessMode) Reset()                    { *m = VolumeCapability_AccessMode{} }
func (m *VolumeCapability_AccessMode) String() string            { return proto.CompactTextString(m) }
func (*VolumeCapability_AccessMode) ProtoMessage()               {}
func (*VolumeCapability_AccessMode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 2} }

func (m *VolumeCapability_AccessMode) GetMode() VolumeCapability_AccessMode_Mode {
	if m != nil {
		return m.Mode
	}
	return VolumeCapability_AccessMode_UNKNOWN
}

// The capacity of the storage space in bytes. To specify an exact size,
// `required_bytes` and `limit_bytes` can be set to the same value. At
// least one of the these fields MUST be specified.
type CapacityRange struct {
	// Volume must be at least this big. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	// The value of this field MUST NOT be negative.
	RequiredBytes int64 `protobuf:"varint,1,opt,name=required_bytes,json=requiredBytes" json:"required_bytes,omitempty"`
	// Volume must not be bigger than this. This field is OPTIONAL.
	// A value of 0 is equal to an unspecified field value.
	// The value of this field MUST NOT be negative.
	LimitBytes int64 `protobuf:"varint,2,opt,name=limit_bytes,json=limitBytes" json:"limit_bytes,omitempty"`
}

func (m *CapacityRange) Reset()                    { *m = CapacityRange{} }
func (m *CapacityRange) String() string            { return proto.CompactTextString(m) }
func (*CapacityRange) ProtoMessage()               {}
func (*CapacityRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CapacityRange) GetRequiredBytes() int64 {
	if m != nil {
		return m.RequiredBytes
	}
	return 0
}

func (m *CapacityRange) GetLimitBytes() int64 {
	if m != nil {
		return m.LimitBytes
	}
	return 0
}

// The information about a provisioned volume.
type Volume struct {
	// The capacity of the volume in bytes. This field is OPTIONAL. If not
	// set (value of 0), it indicates that the capacity of the volume is
	// unknown (e.g., NFS share).
	// The value of this field MUST NOT be negative.
	CapacityBytes int64 `protobuf:"varint,1,opt,name=capacity_bytes,json=capacityBytes" json:"capacity_bytes,omitempty"`
	// Contains identity information for the created volume. This field is
	// REQUIRED. The identity information will be used by the CO in
	// subsequent calls to refer to the provisioned volume.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Attributes reflect static properties of a volume and MUST be passed
	// to volume validation and publishing calls.
	// Attributes SHALL be opaque to a CO. Attributes SHALL NOT be mutable
	// and SHALL be safe for the CO to cache. Attributes SHOULD NOT
	// contain sensitive information. Attributes MAY NOT uniquely identify
	// a volume. A volume uniquely identified by `id` SHALL always report
	// the same attributes. This field is OPTIONAL and when present MUST
	// be passed to volume validation and publishing calls.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (m *Volume) String() string            { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Volume) GetCapacityBytes() int64 {
	if m != nil {
		return m.CapacityBytes
	}
	return 0
}

func (m *Volume) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Volume) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

type DeleteVolumeRequest struct {
	// The ID of the volume to be deprovisioned.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// Secrets required by plugin to complete volume deletion request.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	ControllerDeleteSecrets map[string]string `protobuf:"bytes,2,rep,name=controller_delete_secrets,json=controllerDeleteSecrets" json:"controller_delete_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DeleteVolumeRequest) Reset()                    { *m = DeleteVolumeRequest{} }
func (m *DeleteVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVolumeRequest) ProtoMessage()               {}
func (*DeleteVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *DeleteVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *DeleteVolumeRequest) GetControllerDeleteSecrets() map[string]string {
	if m != nil {
		return m.ControllerDeleteSecrets
	}
	return nil
}

type DeleteVolumeResponse struct {
}

func (m *DeleteVolumeResponse) Reset()                    { *m = DeleteVolumeResponse{} }
func (m *DeleteVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteVolumeResponse) ProtoMessage()               {}
func (*DeleteVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type ControllerPublishVolumeRequest struct {
	// The ID of the volume to be used on a node.
	// This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The ID of the node. This field is REQUIRED. The CO SHALL set this
	// field to match the node ID returned by `NodeGetId`.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// The capability of the volume the CO expects the volume to have.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,3,opt,name=volume_capability,json=volumeCapability" json:"volume_capability,omitempty"`
	// Whether to publish the volume in readonly mode. This field is
	// REQUIRED.
	Readonly bool `protobuf:"varint,4,opt,name=readonly" json:"readonly,omitempty"`
	// Secrets required by plugin to complete controller publish volume
	// request.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	ControllerPublishSecrets map[string]string `protobuf:"bytes,5,rep,name=controller_publish_secrets,json=controllerPublishSecrets" json:"controller_publish_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Attributes of the volume to be used on a node. This field is
	// OPTIONAL and MUST match the attributes of the Volume identified
	// by `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,6,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerPublishVolumeRequest) Reset()                    { *m = ControllerPublishVolumeRequest{} }
func (m *ControllerPublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeRequest) ProtoMessage()               {}
func (*ControllerPublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ControllerPublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerPublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *ControllerPublishVolumeRequest) GetControllerPublishSecrets() map[string]string {
	if m != nil {
		return m.ControllerPublishSecrets
	}
	return nil
}

func (m *ControllerPublishVolumeRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type ControllerPublishVolumeResponse struct {
	// The SP specific information that will be passed to the Plugin in
	// the subsequent `NodeStageVolume` or `NodePublishVolume` calls
	// for the given volume.
	// This information is opaque to the CO. This field is OPTIONAL.
	PublishInfo map[string]string `protobuf:"bytes,1,rep,name=publish_info,json=publishInfo" json:"publish_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerPublishVolumeResponse) Reset()         { *m = ControllerPublishVolumeResponse{} }
func (m *ControllerPublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerPublishVolumeResponse) ProtoMessage()    {}
func (*ControllerPublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{15}
}

func (m *ControllerPublishVolumeResponse) GetPublishInfo() map[string]string {
	if m != nil {
		return m.PublishInfo
	}
	return nil
}

type ControllerUnpublishVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The ID of the node. This field is OPTIONAL. The CO SHOULD set this
	// field to match the node ID returned by `NodeGetId` or leave it
	// unset. If the value is set, the SP MUST unpublish the volume from
	// the specified node. If the value is unset, the SP MUST unpublish
	// the volume from all nodes it is published to.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
	// Secrets required by plugin to complete controller unpublish volume
	// request. This SHOULD be the same secrets passed to the
	// ControllerPublishVolume.
	// call for the specified volume.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	ControllerUnpublishSecrets map[string]string `protobuf:"bytes,3,rep,name=controller_unpublish_secrets,json=controllerUnpublishSecrets" json:"controller_unpublish_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ControllerUnpublishVolumeRequest) Reset()         { *m = ControllerUnpublishVolumeRequest{} }
func (m *ControllerUnpublishVolumeRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeRequest) ProtoMessage()    {}
func (*ControllerUnpublishVolumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{16}
}

func (m *ControllerUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *ControllerUnpublishVolumeRequest) GetControllerUnpublishSecrets() map[string]string {
	if m != nil {
		return m.ControllerUnpublishSecrets
	}
	return nil
}

type ControllerUnpublishVolumeResponse struct {
}

func (m *ControllerUnpublishVolumeResponse) Reset()         { *m = ControllerUnpublishVolumeResponse{} }
func (m *ControllerUnpublishVolumeResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerUnpublishVolumeResponse) ProtoMessage()    {}
func (*ControllerUnpublishVolumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{17}
}

type ValidateVolumeCapabilitiesRequest struct {
	// The ID of the volume to check. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The capabilities that the CO wants to check for the volume. This
	// call SHALL return "supported" only if all the volume capabilities
	// specified below are supported. This field is REQUIRED.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,2,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// Attributes of the volume to check. This field is OPTIONAL and MUST
	// match the attributes of the Volume identified by `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,3,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ValidateVolumeCapabilitiesRequest) Reset()         { *m = ValidateVolumeCapabilitiesRequest{} }
func (m *ValidateVolumeCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesRequest) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18}
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *ValidateVolumeCapabilitiesRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type ValidateVolumeCapabilitiesResponse struct {
	// True if the Plugin supports the specified capabilities for the
	// given volume. This field is REQUIRED.
	Supported bool `protobuf:"varint,1,opt,name=supported" json:"supported,omitempty"`
	// Message to the CO if `supported` above is false. This field is
	// OPTIONAL.
	// An empty string is equal to an unspecified field value.
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ValidateVolumeCapabilitiesResponse) Reset()         { *m = ValidateVolumeCapabilitiesResponse{} }
func (m *ValidateVolumeCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ValidateVolumeCapabilitiesResponse) ProtoMessage()    {}
func (*ValidateVolumeCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{19}
}

func (m *ValidateVolumeCapabilitiesResponse) GetSupported() bool {
	if m != nil {
		return m.Supported
	}
	return false
}

func (m *ValidateVolumeCapabilitiesResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type ListVolumesRequest struct {
	// If specified (non-zero value), the Plugin MUST NOT return more
	// entries than this number in the response. If the actual number of
	// entries is more than this number, the Plugin MUST set `next_token`
	// in the response which can be used to get the next page of entries
	// in the subsequent `ListVolumes` call. This field is OPTIONAL. If
	// not specified (zero value), it means there is no restriction on the
	// number of entries that can be returned.
	// The value of this field MUST NOT be negative.
	MaxEntries int32 `protobuf:"varint,1,opt,name=max_entries,json=maxEntries" json:"max_entries,omitempty"`
	// A token to specify where to start paginating. Set this field to
	// `next_token` returned by a previous `ListVolumes` call to get the
	// next page of entries. This field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	StartingToken string `protobuf:"bytes,2,opt,name=starting_token,json=startingToken" json:"starting_token,omitempty"`
}

func (m *ListVolumesRequest) Reset()                    { *m = ListVolumesRequest{} }
func (m *ListVolumesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesRequest) ProtoMessage()               {}
func (*ListVolumesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ListVolumesRequest) GetMaxEntries() int32 {
	if m != nil {
		return m.MaxEntries
	}
	return 0
}

func (m *ListVolumesRequest) GetStartingToken() string {
	if m != nil {
		return m.StartingToken
	}
	return ""
}

type ListVolumesResponse struct {
	Entries []*ListVolumesResponse_Entry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	// This token allows you to get the next page of entries for
	// `ListVolumes` request. If the number of entries is larger than
	// `max_entries`, use the `next_token` as a value for the
	// `starting_token` field in the next `ListVolumes` request. This
	// field is OPTIONAL.
	// An empty string is equal to an unspecified field value.
	NextToken string `protobuf:"bytes,2,opt,name=next_token,json=nextToken" json:"next_token,omitempty"`
}

func (m *ListVolumesResponse) Reset()                    { *m = ListVolumesResponse{} }
func (m *ListVolumesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesResponse) ProtoMessage()               {}
func (*ListVolumesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ListVolumesResponse) GetEntries() []*ListVolumesResponse_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListVolumesResponse) GetNextToken() string {
	if m != nil {
		return m.NextToken
	}
	return ""
}

type ListVolumesResponse_Entry struct {
	Volume *Volume `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
}

func (m *ListVolumesResponse_Entry) Reset()                    { *m = ListVolumesResponse_Entry{} }
func (m *ListVolumesResponse_Entry) String() string            { return proto.CompactTextString(m) }
func (*ListVolumesResponse_Entry) ProtoMessage()               {}
func (*ListVolumesResponse_Entry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21, 0} }

func (m *ListVolumesResponse_Entry) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

type GetCapacityRequest struct {
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes that satisfy ALL of the
	// specified `volume_capabilities`. These are the same
	// `volume_capabilities` the CO will use in `CreateVolumeRequest`.
	// This field is OPTIONAL.
	VolumeCapabilities []*VolumeCapability `protobuf:"bytes,1,rep,name=volume_capabilities,json=volumeCapabilities" json:"volume_capabilities,omitempty"`
	// If specified, the Plugin SHALL report the capacity of the storage
	// that can be used to provision volumes with the given Plugin
	// specific `parameters`. These are the same `parameters` the CO will
	// use in `CreateVolumeRequest`. This field is OPTIONAL.
	Parameters map[string]string `protobuf:"bytes,2,rep,name=parameters" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetCapacityRequest) Reset()                    { *m = GetCapacityRequest{} }
func (m *GetCapacityRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCapacityRequest) ProtoMessage()               {}
func (*GetCapacityRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *GetCapacityRequest) GetVolumeCapabilities() []*VolumeCapability {
	if m != nil {
		return m.VolumeCapabilities
	}
	return nil
}

func (m *GetCapacityRequest) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

type GetCapacityResponse struct {
	// The available capacity of the storage that can be used to
	// provision volumes. If `volume_capabilities` or `parameters` is
	// specified in the request, the Plugin SHALL take those into
	// consideration when calculating the available capacity of the
	// storage. This field is REQUIRED.
	// The value of this field MUST NOT be negative.
	AvailableCapacity int64 `protobuf:"varint,1,opt,name=available_capacity,json=availableCapacity" json:"available_capacity,omitempty"`
}

func (m *GetCapacityResponse) Reset()                    { *m = GetCapacityResponse{} }
func (m *GetCapacityResponse) String() string            { return proto.CompactTextString(m) }
func (*GetCapacityResponse) ProtoMessage()               {}
func (*GetCapacityResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *GetCapacityResponse) GetAvailableCapacity() int64 {
	if m != nil {
		return m.AvailableCapacity
	}
	return 0
}

type ControllerGetCapabilitiesRequest struct {
}

func (m *ControllerGetCapabilitiesRequest) Reset()         { *m = ControllerGetCapabilitiesRequest{} }
func (m *ControllerGetCapabilitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesRequest) ProtoMessage()    {}
func (*ControllerGetCapabilitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{24}
}

type ControllerGetCapabilitiesResponse struct {
	// All the capabilities that the controller service supports. This
	// field is OPTIONAL.
	Capabilities []*ControllerServiceCapability `protobuf:"bytes,2,rep,name=capabilities" json:"capabilities,omitempty"`
}

func (m *ControllerGetCapabilitiesResponse) Reset()         { *m = ControllerGetCapabilitiesResponse{} }
func (m *ControllerGetCapabilitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ControllerGetCapabilitiesResponse) ProtoMessage()    {}
func (*ControllerGetCapabilitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{25}
}

func (m *ControllerGetCapabilitiesResponse) GetCapabilities() []*ControllerServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the controller service.
type ControllerServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*ControllerServiceCapability_Rpc
	Type isControllerServiceCapability_Type `protobuf_oneof:"type"`
}

func (m *ControllerServiceCapability) Reset()                    { *m = ControllerServiceCapability{} }
func (m *ControllerServiceCapability) String() string            { return proto.CompactTextString(m) }
func (*ControllerServiceCapability) ProtoMessage()               {}
func (*ControllerServiceCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

type isControllerServiceCapability_Type interface {
	isControllerServiceCapability_Type()
}

type ControllerServiceCapability_Rpc struct {
	Rpc *ControllerServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,oneof"`
}

func (*ControllerServiceCapability_Rpc) isControllerServiceCapability_Type() {}

func (m *ControllerServiceCapability) GetType() isControllerServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ControllerServiceCapability) GetRpc() *ControllerServiceCapability_RPC {
	if x, ok := m.GetType().(*ControllerServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ControllerServiceCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ControllerServiceCapability_OneofMarshaler, _ControllerServiceCapability_OneofUnmarshaler, _ControllerServiceCapability_OneofSizer, []interface{}{
		(*ControllerServiceCapability_Rpc)(nil),
	}
}

func _ControllerServiceCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ControllerServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *ControllerServiceCapability_Rpc:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Rpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ControllerServiceCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _ControllerServiceCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ControllerServiceCapability)
	switch tag {
	case 1: // type.rpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ControllerServiceCapability_RPC)
		err := b.DecodeMessage(msg)
		m.Type = &ControllerServiceCapability_Rpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ControllerServiceCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ControllerServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *ControllerServiceCapability_Rpc:
		s := proto.Size(x.Rpc)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ControllerServiceCapability_RPC struct {
	Type ControllerServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,enum=csi.v0.ControllerServiceCapability_RPC_Type" json:"type,omitempty"`
}

func (m *ControllerServiceCapability_RPC) Reset()         { *m = ControllerServiceCapability_RPC{} }
func (m *ControllerServiceCapability_RPC) String() string { return proto.CompactTextString(m) }
func (*ControllerServiceCapability_RPC) ProtoMessage()    {}
func (*ControllerServiceCapability_RPC) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{26, 0}
}

func (m *ControllerServiceCapability_RPC) GetType() ControllerServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return ControllerServiceCapability_RPC_UNKNOWN
}

type NodeStageVolumeRequest struct {
	// The ID of the volume to publish. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The CO SHALL set this field to the value returned by
	// `ControllerPublishVolume` if the corresponding Controller Plugin
	// has `PUBLISH_UNPUBLISH_VOLUME` controller capability, and SHALL be
	// left unset if the corresponding Controller Plugin does not have
	// this capability. This is an OPTIONAL field.
	PublishInfo map[string]string `protobuf:"bytes,2,rep,name=publish_info,json=publishInfo" json:"publish_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The path to which the volume will be published. It MUST be an
	// absolute path in the root filesystem of the process serving this
	// request. The CO SHALL ensure that there is only one
	// staging_target_path per volume.
	// This is a REQUIRED field.
	StagingTargetPath string `protobuf:"bytes,3,opt,name=staging_target_path,json=stagingTargetPath" json:"staging_target_path,omitempty"`
	// The capability of the volume the CO expects the volume to have.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,4,opt,name=volume_capability,json=volumeCapability" json:"volume_capability,omitempty"`
	// Secrets required by plugin to complete node stage volume request.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	NodeStageSecrets map[string]string `protobuf:"bytes,5,rep,name=node_stage_secrets,json=nodeStageSecrets" json:"node_stage_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Attributes of the volume to publish. This field is OPTIONAL and
	// MUST match the attributes of the VolumeInfo identified by
	// `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,6,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodeStageVolumeRequest) Reset()                    { *m = NodeStageVolumeRequest{} }
func (m *NodeStageVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeStageVolumeRequest) ProtoMessage()               {}
func (*NodeStageVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *NodeStageVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeStageVolumeRequest) GetPublishInfo() map[string]string {
	if m != nil {
		return m.PublishInfo
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

func (m *NodeStageVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetNodeStageSecrets() map[string]string {
	if m != nil {
		return m.NodeStageSecrets
	}
	return nil
}

func (m *NodeStageVolumeRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type NodeStageVolumeResponse struct {
}

func (m *NodeStageVolumeResponse) Reset()                    { *m = NodeStageVolumeResponse{} }
func (m *NodeStageVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeStageVolumeResponse) ProtoMessage()               {}
func (*NodeStageVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type NodeUnstageVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The path at which the volume was published. It MUST be an absolute
	// path in the root filesystem of the process serving this request.
	// This is a REQUIRED field.
	StagingTargetPath string `protobuf:"bytes,2,opt,name=staging_target_path,json=stagingTargetPath" json:"staging_target_path,omitempty"`
}

func (m *NodeUnstageVolumeRequest) Reset()                    { *m = NodeUnstageVolumeRequest{} }
func (m *NodeUnstageVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeUnstageVolumeRequest) ProtoMessage()               {}
func (*NodeUnstageVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *NodeUnstageVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeUnstageVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

type NodeUnstageVolumeResponse struct {
}

func (m *NodeUnstageVolumeResponse) Reset()                    { *m = NodeUnstageVolumeResponse{} }
func (m *NodeUnstageVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeUnstageVolumeResponse) ProtoMessage()               {}
func (*NodeUnstageVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type NodePublishVolumeRequest struct {
	// The ID of the volume to publish. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The CO SHALL set this field to the value returned by
	// `ControllerPublishVolume` if the corresponding Controller Plugin
	// has `PUBLISH_UNPUBLISH_VOLUME` controller capability, and SHALL be
	// left unset if the corresponding Controller Plugin does not have
	// this capability. This is an OPTIONAL field.
	PublishInfo map[string]string `protobuf:"bytes,2,rep,name=publish_info,json=publishInfo" json:"publish_info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The path to which the device was mounted by `NodeStageVolume`.
	// It MUST be an absolute path in the root filesystem of the process
	// serving this request.
	// It MUST be set if the Node Plugin implements the
	// `STAGE_UNSTAGE_VOLUME` node capability.
	// This is an OPTIONAL field.
	StagingTargetPath string `protobuf:"bytes,3,opt,name=staging_target_path,json=stagingTargetPath" json:"staging_target_path,omitempty"`
	// The path to which the volume will be published. It MUST be an
	// absolute path in the root filesystem of the process serving this
	// request. The CO SHALL ensure uniqueness of target_path per volume.
	// The CO SHALL ensure that the path exists, and that the process
	// serving the request has `read` and `write` permissions to the path.
	// This is a REQUIRED field.
	TargetPath string `protobuf:"bytes,4,opt,name=target_path,json=targetPath" json:"target_path,omitempty"`
	// The capability of the volume the CO expects the volume to have.
	// This is a REQUIRED field.
	VolumeCapability *VolumeCapability `protobuf:"bytes,5,opt,name=volume_capability,json=volumeCapability" json:"volume_capability,omitempty"`
	// Whether to publish the volume in readonly mode. This field is
	// REQUIRED.
	Readonly bool `protobuf:"varint,6,opt,name=readonly" json:"readonly,omitempty"`
	// Secrets required by plugin to complete node publish volume request.
	// A secret is a string to string map where the key identifies the
	// name of the secret (e.g. "username" or "password"), and the value
	// contains the secret data (e.g. "bob" or "abc123").
	// Each key MUST consist of alphanumeric characters, '-', '_' or '.'.
	// Each value MUST contain a valid string. An SP MAY choose to accept
	// binary (non-string) data by using a binary-to-text encoding scheme,
	// like base64.
	// An SP SHALL advertise the requirements for required secret keys and
	// values in documentation.
	// CO SHALL permit passing through the required secrets.
	// A CO MAY pass the same secrets to all RPCs, therefore the keys for
	// all unique secrets that an SP expects must be unique across all CSI
	// operations.
	// This information is sensitive and MUST be treated as such (not
	// logged, etc.) by the CO.
	// This field is OPTIONAL.
	NodePublishSecrets map[string]string `protobuf:"bytes,7,rep,name=node_publish_secrets,json=nodePublishSecrets" json:"node_publish_secrets,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Attributes of the volume to publish. This field is OPTIONAL and
	// MUST match the attributes of the Volume identified by
	// `volume_id`.
	VolumeAttributes map[string]string `protobuf:"bytes,8,rep,name=volume_attributes,json=volumeAttributes" json:"volume_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *NodePublishVolumeRequest) Reset()                    { *m = NodePublishVolumeRequest{} }
func (m *NodePublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodePublishVolumeRequest) ProtoMessage()               {}
func (*NodePublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *NodePublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetPublishInfo() map[string]string {
	if m != nil {
		return m.PublishInfo
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetStagingTargetPath() string {
	if m != nil {
		return m.StagingTargetPath
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

func (m *NodePublishVolumeRequest) GetVolumeCapability() *VolumeCapability {
	if m != nil {
		return m.VolumeCapability
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *NodePublishVolumeRequest) GetNodePublishSecrets() map[string]string {
	if m != nil {
		return m.NodePublishSecrets
	}
	return nil
}

func (m *NodePublishVolumeRequest) GetVolumeAttributes() map[string]string {
	if m != nil {
		return m.VolumeAttributes
	}
	return nil
}

type NodePublishVolumeResponse struct {
}

func (m *NodePublishVolumeResponse) Reset()                    { *m = NodePublishVolumeResponse{} }
func (m *NodePublishVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodePublishVolumeResponse) ProtoMessage()               {}
func (*NodePublishVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type NodeUnpublishVolumeRequest struct {
	// The ID of the volume. This field is REQUIRED.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	// The path at which the volume was published. It MUST be an absolute
	// path in the root filesystem of the process serving this request.
	// This is a REQUIRED field.
	TargetPath string `protobuf:"bytes,2,opt,name=target_path,json=targetPath" json:"target_path,omitempty"`
}

func (m *NodeUnpublishVolumeRequest) Reset()                    { *m = NodeUnpublishVolumeRequest{} }
func (m *NodeUnpublishVolumeRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeRequest) ProtoMessage()               {}
func (*NodeUnpublishVolumeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *NodeUnpublishVolumeRequest) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *NodeUnpublishVolumeRequest) GetTargetPath() string {
	if m != nil {
		return m.TargetPath
	}
	return ""
}

type NodeUnpublishVolumeResponse struct {
}

func (m *NodeUnpublishVolumeResponse) Reset()                    { *m = NodeUnpublishVolumeResponse{} }
func (m *NodeUnpublishVolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeUnpublishVolumeResponse) ProtoMessage()               {}
func (*NodeUnpublishVolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

type NodeGetIdRequest struct {
}

func (m *NodeGetIdRequest) Reset()                    { *m = NodeGetIdRequest{} }
func (m *NodeGetIdRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeGetIdRequest) ProtoMessage()               {}
func (*NodeGetIdRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

type NodeGetIdResponse struct {
	// The ID of the node as understood by the SP which SHALL be used by
	// CO in subsequent `ControllerPublishVolume`.
	// This is a REQUIRED field.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId" json:"node_id,omitempty"`
}

func (m *NodeGetIdResponse) Reset()                    { *m = NodeGetIdResponse{} }
func (m *NodeGetIdResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeGetIdResponse) ProtoMessage()               {}
func (*NodeGetIdResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *NodeGetIdResponse) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

type NodeGetCapabilitiesRequest struct {
}

func (m *NodeGetCapabilitiesRequest) Reset()                    { *m = NodeGetCapabilitiesRequest{} }
func (m *NodeGetCapabilitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesRequest) ProtoMessage()               {}
func (*NodeGetCapabilitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

type NodeGetCapabilitiesResponse struct {
	// All the capabilities that the node service supports. This field
	// is OPTIONAL.
	Capabilities []*NodeServiceCapability `protobuf:"bytes,1,rep,name=capabilities" json:"capabilities,omitempty"`
}

func (m *NodeGetCapabilitiesResponse) Reset()                    { *m = NodeGetCapabilitiesResponse{} }
func (m *NodeGetCapabilitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*NodeGetCapabilitiesResponse) ProtoMessage()               {}
func (*NodeGetCapabilitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *NodeGetCapabilitiesResponse) GetCapabilities() []*NodeServiceCapability {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

// Specifies a capability of the node service.
type NodeServiceCapability struct {
	// Types that are valid to be assigned to Type:
	//	*NodeServiceCapability_Rpc
	Type isNodeServiceCapability_Type `protobuf_oneof:"type"`
}

func (m *NodeServiceCapability) Reset()                    { *m = NodeServiceCapability{} }
func (m *NodeServiceCapability) String() string            { return proto.CompactTextString(m) }
func (*NodeServiceCapability) ProtoMessage()               {}
func (*NodeServiceCapability) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

type isNodeServiceCapability_Type interface {
	isNodeServiceCapability_Type()
}

type NodeServiceCapability_Rpc struct {
	Rpc *NodeServiceCapability_RPC `protobuf:"bytes,1,opt,name=rpc,oneof"`
}

func (*NodeServiceCapability_Rpc) isNodeServiceCapability_Type() {}

func (m *NodeServiceCapability) GetType() isNodeServiceCapability_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *NodeServiceCapability) GetRpc() *NodeServiceCapability_RPC {
	if x, ok := m.GetType().(*NodeServiceCapability_Rpc); ok {
		return x.Rpc
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*NodeServiceCapability) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _NodeServiceCapability_OneofMarshaler, _NodeServiceCapability_OneofUnmarshaler, _NodeServiceCapability_OneofSizer, []interface{}{
		(*NodeServiceCapability_Rpc)(nil),
	}
}

func _NodeServiceCapability_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*NodeServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *NodeServiceCapability_Rpc:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Rpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("NodeServiceCapability.Type has unexpected type %T", x)
	}
	return nil
}

func _NodeServiceCapability_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*NodeServiceCapability)
	switch tag {
	case 1: // type.rpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeServiceCapability_RPC)
		err := b.DecodeMessage(msg)
		m.Type = &NodeServiceCapability_Rpc{msg}
		return true, err
	default:
		return false, nil
	}
}

func _NodeServiceCapability_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*NodeServiceCapability)
	// type
	switch x := m.Type.(type) {
	case *NodeServiceCapability_Rpc:
		s := proto.Size(x.Rpc)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type NodeServiceCapability_RPC struct {
	Type NodeServiceCapability_RPC_Type `protobuf:"varint,1,opt,name=type,enum=csi.v0.NodeServiceCapability_RPC_Type" json:"type,omitempty"`
}

func (m *NodeServiceCapability_RPC) Reset()                    { *m = NodeServiceCapability_RPC{} }
func (m *NodeServiceCapability_RPC) String() string            { return proto.CompactTextString(m) }
func (*NodeServiceCapability_RPC) ProtoMessage()               {}
func (*NodeServiceCapability_RPC) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39, 0} }

func (m *NodeServiceCapability_RPC) GetType() NodeServiceCapability_RPC_Type {
	if m != nil {
		return m.Type
	}
	return NodeServiceCapability_RPC_UNKNOWN
}

func init() {
	proto.RegisterType((*GetPluginInfoRequest)(nil), "csi.v0.GetPluginInfoRequest")
	proto.RegisterType((*GetPluginInfoResponse)(nil), "csi.v0.GetPluginInfoResponse")
	proto.RegisterType((*GetPluginCapabilitiesRequest)(nil), "csi.v0.GetPluginCapabilitiesRequest")
	proto.RegisterType((*GetPluginCapabilitiesResponse)(nil), "csi.v0.GetPluginCapabilitiesResponse")
	proto.RegisterType((*PluginCapability)(nil), "csi.v0.PluginCapability")
	proto.RegisterType((*PluginCapability_Service)(nil), "csi.v0.PluginCapability.Service")
	proto.RegisterType((*ProbeRequest)(nil), "csi.v0.ProbeRequest")
	proto.RegisterType((*ProbeResponse)(nil), "csi.v0.ProbeResponse")
	proto.RegisterType((*CreateVolumeRequest)(nil), "csi.v0.CreateVolumeRequest")
	proto.RegisterType((*CreateVolumeResponse)(nil), "csi.v0.CreateVolumeResponse")
	proto.RegisterType((*VolumeCapability)(nil), "csi.v0.VolumeCapability")
	proto.RegisterType((*VolumeCapability_BlockVolume)(nil), "csi.v0.VolumeCapability.BlockVolume")
	proto.RegisterType((*VolumeCapability_MountVolume)(nil), "csi.v0.VolumeCapability.MountVolume")
	proto.RegisterType((*VolumeCapability_AccessMode)(nil), "csi.v0.VolumeCapability.AccessMode")
	proto.RegisterType((*CapacityRange)(nil), "csi.v0.CapacityRange")
	proto.RegisterType((*Volume)(nil), "csi.v0.Volume")
	proto.RegisterType((*DeleteVolumeRequest)(nil), "csi.v0.DeleteVolumeRequest")
	proto.RegisterType((*DeleteVolumeResponse)(nil), "csi.v0.DeleteVolumeResponse")
	proto.RegisterType((*ControllerPublishVolumeRequest)(nil), "csi.v0.ControllerPublishVolumeRequest")
	proto.RegisterType((*ControllerPublishVolumeResponse)(nil), "csi.v0.ControllerPublishVolumeResponse")
	proto.RegisterType((*ControllerUnpublishVolumeRequest)(nil), "csi.v0.ControllerUnpublishVolumeRequest")
	proto.RegisterType((*ControllerUnpublishVolumeResponse)(nil), "csi.v0.ControllerUnpublishVolumeResponse")
	proto.RegisterType((*ValidateVolumeCapabilitiesRequest)(nil), "csi.v0.ValidateVolumeCapabilitiesRequest")
	proto.RegisterType((*ValidateVolumeCapabilitiesResponse)(nil), "csi.v0.ValidateVolumeCapabilitiesResponse")
	proto.RegisterType((*ListVolumesRequest)(nil), "csi.v0.ListVolumesRequest")
	proto.RegisterType((*ListVolumesResponse)(nil), "csi.v0.ListVolumesResponse")
	proto.RegisterType((*ListVolumesResponse_Entry)(nil), "csi.v0.ListVolumesResponse.Entry")
	proto.RegisterType((*GetCapacityRequest)(nil), "csi.v0.GetCapacityRequest")
	proto.RegisterType((*GetCapacityResponse)(nil), "csi.v0.GetCapacityResponse")
	proto.RegisterType((*ControllerGetCapabilitiesRequest)(nil), "csi.v0.ControllerGetCapabilitiesRequest")
	proto.RegisterType((*ControllerGetCapabilitiesResponse)(nil), "csi.v0.ControllerGetCapabilitiesResponse")
	proto.RegisterType((*ControllerServiceCapability)(nil), "csi.v0.ControllerServiceCapability")
	proto.RegisterType((*ControllerServiceCapability_RPC)(nil), "csi.v0.ControllerServiceCapability.RPC")
	proto.RegisterType((*NodeStageVolumeRequest)(nil), "csi.v0.NodeStageVolumeRequest")
	proto.RegisterType((*NodeStageVolumeResponse)(nil), "csi.v0.NodeStageVolumeResponse")
	proto.RegisterType((*NodeUnstageVolumeRequest)(nil), "csi.v0.NodeUnstageVolumeRequest")
	proto.RegisterType((*NodeUnstageVolumeResponse)(nil), "csi.v0.NodeUnstageVolumeResponse")
	proto.RegisterType((*NodePublishVolumeRequest)(nil), "csi.v0.NodePublishVolumeRequest")
	proto.RegisterType((*NodePublishVolumeResponse)(nil), "csi.v0.NodePublishVolumeResponse")
	proto.RegisterType((*NodeUnpublishVolumeRequest)(nil), "csi.v0.NodeUnpublishVolumeRequest")
	proto.RegisterType((*NodeUnpublishVolumeResponse)(nil), "csi.v0.NodeUnpublishVolumeResponse")
	proto.RegisterType((*NodeGetIdRequest)(nil), "csi.v0.NodeGetIdRequest")
	proto.RegisterType((*NodeGetIdResponse)(nil), "csi.v0.NodeGetIdResponse")
	proto.RegisterType((*NodeGetCapabilitiesRequest)(nil), "csi.v0.NodeGetCapabilitiesRequest")
	proto.RegisterType((*NodeGetCapabilitiesResponse)(nil), "csi.v0.NodeGetCapabilitiesResponse")
	proto.RegisterType((*NodeServiceCapability)(nil), "csi.v0.NodeServiceCapability")
	proto.RegisterType((*NodeServiceCapability_RPC)(nil), "csi.v0.NodeServiceCapability.RPC")
	proto.RegisterEnum("csi.v0.PluginCapability_Service_Type", PluginCapability_Service_Type_name, PluginCapability_Service_Type_value)
	proto.RegisterEnum("csi.v0.VolumeCapability_AccessMode_Mode", VolumeCapability_AccessMode_Mode_name, VolumeCapability_AccessMode_Mode_value)
	proto.RegisterEnum("csi.v0.ControllerServiceCapability_RPC_Type", ControllerServiceCapability_RPC_Type_name, ControllerServiceCapability_RPC_Type_value)
	proto.RegisterEnum("csi.v0.NodeServiceCapability_RPC_Type", NodeServiceCapability_RPC_Type_name, NodeServiceCapability_RPC_Type_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Identity service

type IdentityClient interface {
	GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error)
	GetPluginCapabilities(ctx context.Context, in *GetPluginCapabilitiesRequest, opts ...grpc.CallOption) (*GetPluginCapabilitiesResponse, error)
	Probe(ctx context.Context, in *ProbeRequest, opts ...grpc.CallOption) (*ProbeResponse, error)
}

type identityClient struct {
	cc *grpc.ClientConn
}

func NewIdentityClient(cc *grpc.ClientConn) IdentityClient {
	return &identityClient{cc}
}

func (c *identityClient) GetPluginInfo(ctx context.Context, in *GetPluginInfoRequest, opts ...grpc.CallOption) (*GetPluginInfoResponse, error) {
	out := new(GetPluginInfoResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Identity/GetPluginInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityClient) GetPluginCapabilities(ctx context.Context, in *GetPluginCapabilitiesRequest, opts ...grpc.CallOption) (*GetPluginCapabilitiesResponse, error) {
	out := new(GetPluginCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Identity/GetPluginCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *identityClient) Probe(ctx context.Context, in *ProbeRequest, opts ...grpc.CallOption) (*ProbeResponse, error) {
	out := new(ProbeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Identity/Probe", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Identity service

type IdentityServer interface {
	GetPluginInfo(context.Context, *GetPluginInfoRequest) (*GetPluginInfoResponse, error)
	GetPluginCapabilities(context.Context, *GetPluginCapabilitiesRequest) (*GetPluginCapabilitiesResponse, error)
	Probe(context.Context, *ProbeRequest) (*ProbeResponse, error)
}

func RegisterIdentityServer(s *grpc.Server, srv IdentityServer) {
	s.RegisterService(&_Identity_serviceDesc, srv)
}

func _Identity_GetPluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetPluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Identity/GetPluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetPluginInfo(ctx, req.(*GetPluginInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Identity_GetPluginCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPluginCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).GetPluginCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Identity/GetPluginCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).GetPluginCapabilities(ctx, req.(*GetPluginCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Identity_Probe_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProbeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IdentityServer).Probe(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Identity/Probe",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IdentityServer).Probe(ctx, req.(*ProbeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Identity_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v0.Identity",
	HandlerType: (*IdentityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPluginInfo",
			Handler:    _Identity_GetPluginInfo_Handler,
		},
		{
			MethodName: "GetPluginCapabilities",
			Handler:    _Identity_GetPluginCapabilities_Handler,
		},
		{
			MethodName: "Probe",
			Handler:    _Identity_Probe_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

// Client API for Controller service

type ControllerClient interface {
	CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error)
	DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error)
	ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error)
}

type controllerClient struct {
	cc *grpc.ClientConn
}

func NewControllerClient(cc *grpc.ClientConn) ControllerClient {
	return &controllerClient{cc}
}

func (c *controllerClient) CreateVolume(ctx context.Context, in *CreateVolumeRequest, opts ...grpc.CallOption) (*CreateVolumeResponse, error) {
	out := new(CreateVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/CreateVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) DeleteVolume(ctx context.Context, in *DeleteVolumeRequest, opts ...grpc.CallOption) (*DeleteVolumeResponse, error) {
	out := new(DeleteVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/DeleteVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerPublishVolume(ctx context.Context, in *ControllerPublishVolumeRequest, opts ...grpc.CallOption) (*ControllerPublishVolumeResponse, error) {
	out := new(ControllerPublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/ControllerPublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerUnpublishVolume(ctx context.Context, in *ControllerUnpublishVolumeRequest, opts ...grpc.CallOption) (*ControllerUnpublishVolumeResponse, error) {
	out := new(ControllerUnpublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/ControllerUnpublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ValidateVolumeCapabilities(ctx context.Context, in *ValidateVolumeCapabilitiesRequest, opts ...grpc.CallOption) (*ValidateVolumeCapabilitiesResponse, error) {
	out := new(ValidateVolumeCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/ValidateVolumeCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/ListVolumes", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) GetCapacity(ctx context.Context, in *GetCapacityRequest, opts ...grpc.CallOption) (*GetCapacityResponse, error) {
	out := new(GetCapacityResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/GetCapacity", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *controllerClient) ControllerGetCapabilities(ctx context.Context, in *ControllerGetCapabilitiesRequest, opts ...grpc.CallOption) (*ControllerGetCapabilitiesResponse, error) {
	out := new(ControllerGetCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Controller/ControllerGetCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Controller service

type ControllerServer interface {
	CreateVolume(context.Context, *CreateVolumeRequest) (*CreateVolumeResponse, error)
	DeleteVolume(context.Context, *DeleteVolumeRequest) (*DeleteVolumeResponse, error)
	ControllerPublishVolume(context.Context, *ControllerPublishVolumeRequest) (*ControllerPublishVolumeResponse, error)
	ControllerUnpublishVolume(context.Context, *ControllerUnpublishVolumeRequest) (*ControllerUnpublishVolumeResponse, error)
	ValidateVolumeCapabilities(context.Context, *ValidateVolumeCapabilitiesRequest) (*ValidateVolumeCapabilitiesResponse, error)
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	GetCapacity(context.Context, *GetCapacityRequest) (*GetCapacityResponse, error)
	ControllerGetCapabilities(context.Context, *ControllerGetCapabilitiesRequest) (*ControllerGetCapabilitiesResponse, error)
}

func RegisterControllerServer(s *grpc.Server, srv ControllerServer) {
	s.RegisterService(&_Controller_serviceDesc, srv)
}

func _Controller_CreateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).CreateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/CreateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).CreateVolume(ctx, req.(*CreateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_DeleteVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).DeleteVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/DeleteVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).DeleteVolume(ctx, req.(*DeleteVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerPublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerPublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/ControllerPublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerPublishVolume(ctx, req.(*ControllerPublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/ControllerUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerUnpublishVolume(ctx, req.(*ControllerUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ValidateVolumeCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateVolumeCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/ValidateVolumeCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ValidateVolumeCapabilities(ctx, req.(*ValidateVolumeCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/ListVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_GetCapacity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).GetCapacity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/GetCapacity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).GetCapacity(ctx, req.(*GetCapacityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Controller_ControllerGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControllerGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Controller/ControllerGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ControllerServer).ControllerGetCapabilities(ctx, req.(*ControllerGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Controller_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v0.Controller",
	HandlerType: (*ControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateVolume",
			Handler:    _Controller_CreateVolume_Handler,
		},
		{
			MethodName: "DeleteVolume",
			Handler:    _Controller_DeleteVolume_Handler,
		},
		{
			MethodName: "ControllerPublishVolume",
			Handler:    _Controller_ControllerPublishVolume_Handler,
		},
		{
			MethodName: "ControllerUnpublishVolume",
			Handler:    _Controller_ControllerUnpublishVolume_Handler,
		},
		{
			MethodName: "ValidateVolumeCapabilities",
			Handler:    _Controller_ValidateVolumeCapabilities_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _Controller_ListVolumes_Handler,
		},
		{
			MethodName: "GetCapacity",
			Handler:    _Controller_GetCapacity_Handler,
		},
		{
			MethodName: "ControllerGetCapabilities",
			Handler:    _Controller_ControllerGetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

// Client API for Node service

type NodeClient interface {
	NodeStageVolume(ctx context.Context, in *NodeStageVolumeRequest, opts ...grpc.CallOption) (*NodeStageVolumeResponse, error)
	NodeUnstageVolume(ctx context.Context, in *NodeUnstageVolumeRequest, opts ...grpc.CallOption) (*NodeUnstageVolumeResponse, error)
	NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error)
	NodeGetId(ctx context.Context, in *NodeGetIdRequest, opts ...grpc.CallOption) (*NodeGetIdResponse, error)
	NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error)
}

type nodeClient struct {
	cc *grpc.ClientConn
}

func NewNodeClient(cc *grpc.ClientConn) NodeClient {
	return &nodeClient{cc}
}

func (c *nodeClient) NodeStageVolume(ctx context.Context, in *NodeStageVolumeRequest, opts ...grpc.CallOption) (*NodeStageVolumeResponse, error) {
	out := new(NodeStageVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodeStageVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeUnstageVolume(ctx context.Context, in *NodeUnstageVolumeRequest, opts ...grpc.CallOption) (*NodeUnstageVolumeResponse, error) {
	out := new(NodeUnstageVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodeUnstageVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodePublishVolume(ctx context.Context, in *NodePublishVolumeRequest, opts ...grpc.CallOption) (*NodePublishVolumeResponse, error) {
	out := new(NodePublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodePublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeUnpublishVolume(ctx context.Context, in *NodeUnpublishVolumeRequest, opts ...grpc.CallOption) (*NodeUnpublishVolumeResponse, error) {
	out := new(NodeUnpublishVolumeResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodeUnpublishVolume", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetId(ctx context.Context, in *NodeGetIdRequest, opts ...grpc.CallOption) (*NodeGetIdResponse, error) {
	out := new(NodeGetIdResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodeGetId", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeClient) NodeGetCapabilities(ctx context.Context, in *NodeGetCapabilitiesRequest, opts ...grpc.CallOption) (*NodeGetCapabilitiesResponse, error) {
	out := new(NodeGetCapabilitiesResponse)
	err := grpc.Invoke(ctx, "/csi.v0.Node/NodeGetCapabilities", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Node service

type NodeServer interface {
	NodeStageVolume(context.Context, *NodeStageVolumeRequest) (*NodeStageVolumeResponse, error)
	NodeUnstageVolume(context.Context, *NodeUnstageVolumeRequest) (*NodeUnstageVolumeResponse, error)
	NodePublishVolume(context.Context, *NodePublishVolumeRequest) (*NodePublishVolumeResponse, error)
	NodeUnpublishVolume(context.Context, *NodeUnpublishVolumeRequest) (*NodeUnpublishVolumeResponse, error)
	NodeGetId(context.Context, *NodeGetIdRequest) (*NodeGetIdResponse, error)
	NodeGetCapabilities(context.Context, *NodeGetCapabilitiesRequest) (*NodeGetCapabilitiesResponse, error)
}

func RegisterNodeServer(s *grpc.Server, srv NodeServer) {
	s.RegisterService(&_Node_serviceDesc, srv)
}

func _Node_NodeStageVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeStageVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeStageVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodeStageVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeStageVolume(ctx, req.(*NodeStageVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeUnstageVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnstageVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeUnstageVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodeUnstageVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeUnstageVolume(ctx, req.(*NodeUnstageVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodePublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodePublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodePublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodePublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodePublishVolume(ctx, req.(*NodePublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeUnpublishVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeUnpublishVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodeUnpublishVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeUnpublishVolume(ctx, req.(*NodeUnpublishVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetId_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetIdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetId(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodeGetId",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetId(ctx, req.(*NodeGetIdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Node_NodeGetCapabilities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeGetCapabilitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeServer).NodeGetCapabilities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/csi.v0.Node/NodeGetCapabilities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeServer).NodeGetCapabilities(ctx, req.(*NodeGetCapabilitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Node_serviceDesc = grpc.ServiceDesc{
	ServiceName: "csi.v0.Node",
	HandlerType: (*NodeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NodeStageVolume",
			Handler:    _Node_NodeStageVolume_Handler,
		},
		{
			MethodName: "NodeUnstageVolume",
			Handler:    _Node_NodeUnstageVolume_Handler,
		},
		{
			MethodName: "NodePublishVolume",
			Handler:    _Node_NodePublishVolume_Handler,
		},
		{
			MethodName: "NodeUnpublishVolume",
			Handler:    _Node_NodeUnpublishVolume_Handler,
		},
		{
			MethodName: "NodeGetId",
			Handler:    _Node_NodeGetId_Handler,
		},
		{
			MethodName: "NodeGetCapabilities",
			Handler:    _Node_NodeGetCapabilities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "csi.proto",
}

func init() { proto.RegisterFile("csi.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2173 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x1a, 0x4d, 0x53, 0xe3, 0xc8,
	0x15, 0xf9, 0x0b, 0x78, 0x06, 0xd6, 0xd3, 0x30, 0x83, 0x11, 0x30, 0x03, 0x62, 0x67, 0x96, 0xfd,
	0xf2, 0x26, 0x24, 0xd9, 0xda, 0xec, 0x90, 0x49, 0xc0, 0x28, 0xe0, 0xc5, 0x18, 0x4a, 0x18, 0xa6,
	0x76, 0xb2, 0x29, 0xad, 0xb0, 0x1b, 0x46, 0x19, 0x23, 0x79, 0x24, 0x99, 0x1a, 0x6e, 0xa9, 0x5c,
	0x52, 0x95, 0x5b, 0xee, 0x49, 0xa5, 0x2a, 0xc7, 0x9c, 0x73, 0x48, 0x55, 0xaa, 0xe6, 0x9c, 0xaa,
	0xfc, 0x81, 0x9c, 0xf2, 0x03, 0x52, 0x39, 0xe6, 0x94, 0x53, 0x4a, 0xdd, 0x2d, 0xb9, 0x25, 0xb7,
	0x64, 0x7b, 0x67, 0x6a, 0x2b, 0x27, 0xac, 0xf7, 0xdd, 0xaf, 0xdf, 0x7b, 0xfd, 0x5e, 0x37, 0x30,
	0xdd, 0x72, 0xcd, 0x4a, 0xd7, 0xb1, 0x3d, 0x1b, 0x15, 0xfc, 0x9f, 0x37, 0xdf, 0x51, 0xee, 0xc1,
	0xc2, 0x3e, 0xf6, 0x4e, 0x3a, 0xbd, 0x2b, 0xd3, 0xaa, 0x59, 0x97, 0xb6, 0x86, 0x5f, 0xf6, 0xb0,
	0xeb, 0x29, 0xff, 0x90, 0xe0, 0x6e, 0x0c, 0xe1, 0x76, 0x6d, 0xcb, 0xc5, 0x08, 0x41, 0xce, 0x32,
	0xae, 0x71, 0x59, 0x5a, 0x93, 0x36, 0xa7, 0x35, 0xf2, 0x1b, 0x3d, 0x84, 0xb9, 0x1b, 0x6c, 0xb5,
	0x6d, 0x47, 0xbf, 0xc1, 0x8e, 0x6b, 0xda, 0x56, 0x39, 0x43, 0xb0, 0xb3, 0x14, 0x7a, 0x4e, 0x81,
	0x68, 0x1f, 0xa6, 0xae, 0x0d, 0xcb, 0xbc, 0xc4, 0xae, 0x57, 0xce, 0xae, 0x65, 0x37, 0x8b, 0x5b,
	0x1f, 0x56, 0xa8, 0x1d, 0x15, 0xa1, 0xae, 0xca, 0x11, 0xa3, 0x56, 0x2d, 0xcf, 0xb9, 0xd5, 0x42,
	0x66, 0xf9, 0x31, 0xcc, 0x46, 0x50, 0xa8, 0x04, 0xd9, 0x17, 0xf8, 0x96, 0xd9, 0xe4, 0xff, 0x44,
	0x0b, 0x90, 0xbf, 0x31, 0x3a, 0x3d, 0xcc, 0x2c, 0xa1, 0x1f, 0x9f, 0x67, 0x3e, 0x93, 0x94, 0xfb,
	0xb0, 0x12, 0x6a, 0xab, 0x1a, 0x5d, 0xe3, 0xc2, 0xec, 0x98, 0x9e, 0x89, 0xdd, 0x60, 0xe9, 0x3f,
	0x87, 0xd5, 0x04, 0x3c, 0xf3, 0xc0, 0x36, 0xcc, 0xb4, 0x38, 0x78, 0x39, 0x43, 0x96, 0x52, 0x0e,
	0x96, 0x12, 0xe3, 0xbc, 0xd5, 0x22, 0xd4, 0xca, 0xdf, 0x25, 0x28, 0xc5, 0x49, 0xd0, 0x36, 0x4c,
	0xba, 0xd8, 0xb9, 0x31, 0x5b, 0xd4, 0xaf, 0xc5, 0xad, 0xb5, 0x24, 0x69, 0x95, 0x53, 0x4a, 0x77,
	0x30, 0xa1, 0x05, 0x2c, 0xf2, 0x4b, 0x98, 0x64, 0x50, 0xf4, 0x43, 0xc8, 0x79, 0xb7, 0x5d, 0x2a,
	0x65, 0x6e, 0xeb, 0xe1, 0x30, 0x29, 0x95, 0xe6, 0x6d, 0x17, 0x6b, 0x84, 0x45, 0xf9, 0x10, 0x72,
	0xfe, 0x17, 0x2a, 0xc2, 0xe4, 0x59, 0xe3, 0xb0, 0x71, 0xfc, 0xb4, 0x51, 0x9a, 0x40, 0xf7, 0x00,
	0x55, 0x8f, 0x1b, 0x4d, 0xed, 0xb8, 0x5e, 0x57, 0x35, 0xfd, 0x54, 0xd5, 0xce, 0x6b, 0x55, 0xb5,
	0x24, 0xed, 0x16, 0xa8, 0x1e, 0x65, 0x0e, 0x66, 0x4e, 0x1c, 0xfb, 0x02, 0x07, 0xce, 0x7b, 0x07,
	0x66, 0xd9, 0x37, 0x75, 0x96, 0xf2, 0xcb, 0x1c, 0xcc, 0x57, 0x1d, 0x6c, 0x78, 0xf8, 0xdc, 0xee,
	0xf4, 0xae, 0x03, 0x42, 0x61, 0x18, 0x6d, 0xc3, 0x9c, 0xef, 0xaa, 0x96, 0xe9, 0xdd, 0xea, 0x8e,
	0x61, 0x5d, 0xd1, 0xcd, 0x2b, 0x6e, 0xdd, 0x0d, 0x96, 0x51, 0x65, 0x58, 0xcd, 0x47, 0x6a, 0xb3,
	0x2d, 0xfe, 0x13, 0xd5, 0x60, 0xfe, 0x86, 0xa8, 0xd0, 0x23, 0xbb, 0x93, 0x8d, 0xee, 0x0e, 0xb5,
	0x82, 0xdb, 0x1d, 0x74, 0x13, 0x85, 0x98, 0xd8, 0x45, 0x87, 0x00, 0x5d, 0xc3, 0x31, 0xae, 0xb1,
	0x87, 0x1d, 0xb7, 0x9c, 0x8b, 0x86, 0xaa, 0x60, 0x35, 0x95, 0x93, 0x90, 0x9a, 0x86, 0x2a, 0xc7,
	0x8e, 0x3c, 0x58, 0x6a, 0xd9, 0x96, 0xe7, 0xd8, 0x9d, 0x0e, 0x76, 0xf4, 0x16, 0xe1, 0xd6, 0x5d,
	0xdc, 0x72, 0xb0, 0xe7, 0x96, 0xf3, 0x44, 0xf6, 0x67, 0x69, 0xb2, 0xab, 0x21, 0x33, 0xc5, 0x9e,
	0x52, 0x56, 0xaa, 0x68, 0xb1, 0x25, 0xc6, 0xca, 0x3f, 0x82, 0x77, 0x62, 0x46, 0x8d, 0x93, 0x24,
	0xf2, 0x17, 0xb0, 0x92, 0xa6, 0x77, 0xac, 0x84, 0x7b, 0x02, 0x0b, 0xd1, 0x75, 0xb1, 0x3c, 0x7a,
	0x04, 0x05, 0xea, 0x7b, 0x16, 0xf3, 0x73, 0xd1, 0x3d, 0xd2, 0x18, 0x56, 0xf9, 0x53, 0x0e, 0x4a,
	0xf1, 0x6d, 0x43, 0xdb, 0x90, 0xbf, 0xe8, 0xd8, 0xad, 0x17, 0x8c, 0xf7, 0xdd, 0xa4, 0xfd, 0xad,
	0xec, 0xfa, 0x54, 0x14, 0x7a, 0x30, 0xa1, 0x51, 0x26, 0x9f, 0xfb, 0xda, 0xee, 0x59, 0x1e, 0x0b,
	0xb0, 0x64, 0xee, 0x23, 0x9f, 0xaa, 0xcf, 0x4d, 0x98, 0xd0, 0x1e, 0x14, 0x8d, 0x56, 0x0b, 0xbb,
	0xae, 0x7e, 0x6d, 0xb7, 0x71, 0x39, 0x4b, 0x64, 0x6c, 0x24, 0xca, 0xd8, 0x21, 0xb4, 0x47, 0x76,
	0x1b, 0x6b, 0x60, 0x84, 0xbf, 0xe5, 0x59, 0x28, 0x72, 0xb6, 0xc9, 0xfb, 0x50, 0xe4, 0x94, 0xa1,
	0x45, 0x98, 0xbc, 0x74, 0xf5, 0x30, 0x97, 0xa7, 0xb5, 0xc2, 0xa5, 0x4b, 0xd2, 0xf3, 0x01, 0x14,
	0x89, 0x15, 0xfa, 0x65, 0xc7, 0xb8, 0xa2, 0xc5, 0x67, 0x5a, 0x03, 0x02, 0xfa, 0xa9, 0x0f, 0x91,
	0xff, 0x2d, 0x01, 0xf4, 0x55, 0xa2, 0x6d, 0xc8, 0x11, 0x2b, 0x69, 0x45, 0xd8, 0x1c, 0xc1, 0xca,
	0x0a, 0x31, 0x95, 0x70, 0x29, 0x7f, 0x90, 0x20, 0x47, 0xc4, 0xc4, 0xab, 0xc2, 0x69, 0xad, 0xb1,
	0x5f, 0x57, 0xf5, 0xc6, 0xf1, 0x9e, 0xaa, 0x3f, 0xd5, 0x6a, 0x4d, 0x55, 0x2b, 0x49, 0x68, 0x19,
	0x16, 0x79, 0xb8, 0xa6, 0xee, 0xec, 0xa9, 0x9a, 0x7e, 0xdc, 0xa8, 0x7f, 0x59, 0xca, 0x20, 0x19,
	0xee, 0x1d, 0x9d, 0xd5, 0x9b, 0xb5, 0x41, 0x5c, 0x16, 0xad, 0x40, 0x99, 0xc3, 0x31, 0x19, 0x4c,
	0x6c, 0xce, 0x17, 0xcb, 0x61, 0xe9, 0x4f, 0x86, 0xcc, 0xef, 0xce, 0x86, 0x9b, 0x41, 0x0a, 0xd2,
	0x53, 0x98, 0x8d, 0x54, 0x09, 0xff, 0x6c, 0x72, 0xf0, 0xcb, 0x9e, 0xe9, 0xe0, 0xb6, 0x7e, 0x71,
	0xeb, 0x61, 0x97, 0x78, 0x22, 0xab, 0xcd, 0x06, 0xd0, 0x5d, 0x1f, 0xe8, 0xbb, 0xb5, 0x63, 0x5e,
	0x9b, 0x1e, 0xa3, 0xc9, 0x10, 0x1a, 0x20, 0x20, 0x42, 0xa0, 0xbc, 0x96, 0xa0, 0xc0, 0xf6, 0xe6,
	0x21, 0x57, 0xa7, 0x22, 0x22, 0x03, 0x28, 0x15, 0x39, 0x07, 0x19, 0xb3, 0xcd, 0xd2, 0x21, 0x63,
	0xb6, 0xd1, 0x13, 0x00, 0xc3, 0xf3, 0x1c, 0xf3, 0xa2, 0xe7, 0x85, 0x75, 0xe9, 0x7e, 0x74, 0x3f,
	0x2a, 0x3b, 0x21, 0x01, 0x2b, 0x24, 0x7d, 0x0e, 0x3f, 0xa5, 0x63, 0xe8, 0xb1, 0xd2, 0xf0, 0x3f,
	0x12, 0xcc, 0xef, 0xe1, 0x0e, 0x8e, 0x57, 0xe2, 0x65, 0x98, 0x66, 0x75, 0xd3, 0x6c, 0x33, 0x49,
	0x53, 0x14, 0x50, 0x6b, 0xc7, 0x8a, 0x57, 0x9b, 0xb0, 0x87, 0xc5, 0x2b, 0x13, 0x2d, 0x5e, 0x02,
	0xe1, 0x5c, 0xf1, 0xa2, 0xd8, 0xa4, 0xe2, 0x15, 0xc1, 0x46, 0xab, 0xcf, 0x20, 0xe3, 0x58, 0xcb,
	0xbe, 0x07, 0x0b, 0x51, 0xc3, 0xd8, 0xc1, 0xf4, 0xd7, 0x1c, 0xdc, 0xef, 0x2b, 0x39, 0xe9, 0x5d,
	0x74, 0x4c, 0xf7, 0xf9, 0x18, 0x9e, 0x59, 0x84, 0x49, 0xcb, 0x6e, 0x13, 0x14, 0xd5, 0x59, 0xf0,
	0x3f, 0x6b, 0x6d, 0xa4, 0xc2, 0x9d, 0xf8, 0x39, 0x74, 0xcb, 0x6a, 0x44, 0xf2, 0x29, 0x54, 0xba,
	0x89, 0x17, 0x38, 0x19, 0xa6, 0x1c, 0x6c, 0xb4, 0x6d, 0xab, 0x73, 0x5b, 0xce, 0xad, 0x49, 0x9b,
	0x53, 0x5a, 0xf8, 0x8d, 0x7e, 0x25, 0x81, 0xcc, 0x6d, 0x4b, 0x97, 0x1a, 0x1f, 0x3b, 0x54, 0xf6,
	0xc2, 0x43, 0x25, 0x75, 0x95, 0x83, 0xe8, 0xc8, 0x1e, 0x95, 0x5b, 0x09, 0x68, 0x64, 0x86, 0xeb,
	0xe4, 0xa2, 0xba, 0x40, 0x54, 0x6f, 0x8f, 0xa8, 0x9a, 0x7e, 0xc5, 0x63, 0x9e, 0xf9, 0xa2, 0x0f,
	0x96, 0x0f, 0x61, 0x35, 0xd5, 0xca, 0xb1, 0x8e, 0xb6, 0x2a, 0xdc, 0x15, 0xea, 0x1d, 0x2b, 0xaa,
	0x5e, 0x4b, 0xf0, 0x20, 0x71, 0x71, 0xec, 0x7c, 0xfb, 0x19, 0xcc, 0x04, 0x3b, 0x63, 0x5a, 0x97,
	0x76, 0x59, 0x8a, 0x9d, 0xf5, 0xe9, 0xec, 0x15, 0x06, 0xf5, 0x1b, 0x62, 0xea, 0x97, 0x62, 0xb7,
	0x0f, 0x91, 0x9f, 0x40, 0x29, 0x4e, 0x30, 0xd6, 0x02, 0xfe, 0x9c, 0x81, 0xb5, 0xbe, 0x05, 0x67,
	0x56, 0xf7, 0xed, 0x25, 0xc0, 0x6f, 0x24, 0x58, 0xe1, 0xa2, 0xb3, 0x67, 0xc5, 0xe3, 0x93, 0x96,
	0xbe, 0x83, 0x41, 0x47, 0x88, 0xcd, 0x10, 0x11, 0x44, 0x62, 0x94, 0xcb, 0x85, 0x38, 0x81, 0x7c,
	0xc4, 0xef, 0x93, 0x90, 0x7d, 0x2c, 0xb7, 0x6d, 0xc0, 0x7a, 0x8a, 0xb9, 0xac, 0xb4, 0xbc, 0xce,
	0xc0, 0xfa, 0xb9, 0xd1, 0x31, 0xdb, 0x61, 0xcf, 0x23, 0x98, 0x33, 0xd2, 0x9d, 0x9b, 0xd0, 0xcc,
	0x66, 0xbe, 0x41, 0x33, 0xdb, 0x11, 0xe5, 0x29, 0xdd, 0x82, 0x1f, 0x87, 0x82, 0x86, 0x59, 0x3b,
	0x72, 0xaa, 0xbe, 0x95, 0xec, 0xfa, 0x0a, 0x94, 0x34, 0x8b, 0x58, 0x7e, 0xad, 0xc0, 0xb4, 0xdb,
	0xeb, 0x76, 0x6d, 0xc7, 0xc3, 0xd4, 0x81, 0x53, 0x5a, 0x1f, 0x80, 0xca, 0x30, 0x79, 0x8d, 0x5d,
	0xd7, 0xb8, 0x0a, 0xe4, 0x07, 0x9f, 0xca, 0x57, 0x80, 0xea, 0xa6, 0xcb, 0x1a, 0xad, 0x70, 0x3b,
	0xfc, 0xbe, 0xca, 0x78, 0xa5, 0x63, 0xcb, 0x73, 0x4c, 0x76, 0xa2, 0xe7, 0x35, 0xb8, 0x36, 0x5e,
	0xa9, 0x14, 0xe2, 0x9f, 0xfa, 0xae, 0x67, 0x38, 0x9e, 0x69, 0x5d, 0xe9, 0x9e, 0xfd, 0x02, 0x87,
	0x43, 0x6e, 0x00, 0x6d, 0xfa, 0x40, 0xe5, 0x8f, 0x12, 0xcc, 0x47, 0xc4, 0x33, 0x6b, 0x1f, 0xc3,
	0x64, 0x5f, 0xb6, 0xef, 0xfc, 0xf5, 0xc0, 0xf9, 0x02, 0xea, 0x0a, 0x75, 0x6f, 0xc0, 0x81, 0x56,
	0x01, 0x2c, 0xfc, 0xca, 0x8b, 0xe8, 0x9d, 0xf6, 0x21, 0x44, 0xa7, 0xfc, 0x09, 0xe4, 0xa9, 0x93,
	0x47, 0x6d, 0xa9, 0xff, 0x25, 0x01, 0xda, 0xc7, 0x5e, 0xd8, 0x29, 0x31, 0x1f, 0x24, 0x44, 0x9d,
	0xf4, 0x0d, 0xa2, 0xee, 0x8b, 0xc8, 0x08, 0x45, 0xe3, 0xf6, 0x03, 0x6e, 0xda, 0x8f, 0xa9, 0x4e,
	0x9b, 0xa0, 0xde, 0x70, 0x96, 0x51, 0xf6, 0x60, 0x3e, 0xa2, 0x90, 0x6d, 0xc8, 0xc7, 0x80, 0x8c,
	0x1b, 0xc3, 0xec, 0x18, 0x17, 0x1d, 0xba, 0x5e, 0x1f, 0xcb, 0x3a, 0xb9, 0x3b, 0x21, 0x26, 0x60,
	0x53, 0x14, 0xbe, 0x5e, 0x32, 0x79, 0xf1, 0xab, 0x83, 0x0e, 0x5f, 0x1d, 0x06, 0x68, 0x98, 0xde,
	0x7d, 0xe1, 0xf5, 0xc1, 0xc6, 0x60, 0x35, 0x64, 0x33, 0x7a, 0xe2, 0x4d, 0xc2, 0xef, 0x33, 0xb0,
	0x9c, 0x42, 0x8d, 0x1e, 0x43, 0xd6, 0xe9, 0xb6, 0x58, 0x24, 0xbc, 0x37, 0x82, 0xfc, 0x8a, 0x76,
	0x52, 0x3d, 0x98, 0xd0, 0x7c, 0x2e, 0xf9, 0x2f, 0x12, 0x64, 0xb5, 0x93, 0x2a, 0xfa, 0x49, 0xe4,
	0x42, 0xe1, 0xa3, 0x11, 0xa5, 0xf0, 0xf7, 0x0a, 0xb6, 0xe8, 0x5e, 0xa1, 0x0c, 0x0b, 0x55, 0x4d,
	0xdd, 0x69, 0xaa, 0xfa, 0x9e, 0x5a, 0x57, 0x9b, 0xaa, 0x7e, 0x7e, 0x5c, 0x3f, 0x3b, 0x52, 0x4b,
	0x92, 0x3f, 0x0a, 0x9c, 0x9c, 0xed, 0xd6, 0x6b, 0xa7, 0x07, 0xfa, 0x59, 0x23, 0xf8, 0xc5, 0xb0,
	0x19, 0x54, 0x82, 0x99, 0x7a, 0xed, 0xb4, 0xc9, 0x00, 0xa7, 0xa5, 0xac, 0x0f, 0xd9, 0x57, 0x9b,
	0x7a, 0x75, 0xe7, 0x64, 0xa7, 0x5a, 0x6b, 0x7e, 0x59, 0xca, 0x85, 0x77, 0x13, 0xbf, 0xcd, 0xc3,
	0xbd, 0x86, 0xdd, 0xc6, 0xa7, 0x9e, 0x71, 0x35, 0x4e, 0xcf, 0xab, 0xc5, 0xce, 0x6d, 0xba, 0x41,
	0x9f, 0x04, 0x4b, 0x17, 0x8b, 0x4c, 0x3f, 0xae, 0x51, 0x05, 0xe6, 0x5d, 0xcf, 0xb8, 0x22, 0xb5,
	0xc3, 0x70, 0xae, 0xb0, 0xa7, 0x77, 0x0d, 0xef, 0x39, 0x69, 0x0b, 0xa7, 0xb5, 0x3b, 0x0c, 0xd5,
	0x24, 0x98, 0x13, 0xc3, 0x7b, 0x2e, 0x6e, 0x22, 0x73, 0x63, 0x37, 0x91, 0x17, 0x80, 0xc8, 0x19,
	0xed, 0x2b, 0x88, 0x5f, 0x3a, 0x7c, 0x7f, 0xc8, 0x82, 0x42, 0x70, 0xe4, 0xac, 0x2d, 0x59, 0x31,
	0x30, 0x32, 0x92, 0xfb, 0xc0, 0x61, 0x2a, 0x46, 0x3d, 0x54, 0xde, 0xb0, 0xd9, 0xf1, 0x0f, 0x25,
	0xe1, 0x6a, 0xbe, 0xfd, 0xbe, 0x71, 0x09, 0x16, 0x07, 0x7c, 0xc1, 0xba, 0x86, 0x2b, 0x28, 0xfb,
	0xa8, 0x33, 0xcb, 0x1d, 0x33, 0x5e, 0x13, 0x62, 0x2b, 0x93, 0x10, 0x5b, 0xca, 0x32, 0x2c, 0x09,
	0x14, 0x31, 0x2b, 0xfe, 0x99, 0xa7, 0x66, 0x8c, 0x3f, 0x10, 0x35, 0x85, 0x69, 0xf3, 0x5d, 0x3e,
	0x04, 0x84, 0x43, 0xc0, 0xdb, 0x4d, 0x9c, 0x07, 0x50, 0xe4, 0xe9, 0x72, 0x84, 0x0e, 0xbc, 0x21,
	0x99, 0x95, 0x7f, 0xa3, 0xf1, 0xac, 0x10, 0x1b, 0xcf, 0x7e, 0x01, 0x0b, 0x24, 0xeb, 0xe2, 0x7d,
	0xef, 0x64, 0x74, 0x00, 0x48, 0xf4, 0x08, 0x87, 0x88, 0xe4, 0x1e, 0xc9, 0xe5, 0xd8, 0x14, 0xd6,
	0x12, 0x65, 0xdf, 0x14, 0x51, 0xf4, 0xe9, 0x50, 0x45, 0xdf, 0x56, 0xfe, 0xa9, 0x34, 0xea, 0xff,
	0x2f, 0x26, 0x37, 0x16, 0xfd, 0xc2, 0x99, 0x4b, 0x79, 0x06, 0x32, 0x4d, 0x8d, 0xf1, 0xc7, 0xa1,
	0x58, 0xe0, 0x65, 0xe2, 0x81, 0xa7, 0xac, 0xc2, 0xb2, 0x50, 0x36, 0x53, 0x8d, 0xa0, 0xe4, 0xa3,
	0xf7, 0xb1, 0x57, 0x6b, 0x07, 0xfd, 0xc4, 0x47, 0x70, 0x87, 0x83, 0xb1, 0xfe, 0x81, 0x9b, 0xbb,
	0x24, 0x7e, 0xee, 0x52, 0x56, 0xa8, 0xf1, 0x09, 0xbd, 0xc9, 0xd7, 0x54, 0x7d, 0x52, 0x57, 0xb2,
	0x13, 0xeb, 0x4a, 0x68, 0xcf, 0xb7, 0x1a, 0x29, 0xe0, 0x43, 0xfa, 0x91, 0xbf, 0x49, 0xac, 0xcc,
	0x0e, 0x74, 0x22, 0x3f, 0xe0, 0x3b, 0x91, 0xf5, 0x54, 0x99, 0x7c, 0x0f, 0xd2, 0xa5, 0x2d, 0xc8,
	0xe7, 0x91, 0x16, 0xe4, 0xd1, 0x50, 0x76, 0xbe, 0xf9, 0xf8, 0x38, 0xa1, 0xf9, 0x38, 0x6d, 0xee,
	0xec, 0xab, 0xfa, 0x59, 0x83, 0xfe, 0x0d, 0x9a, 0x8f, 0xa0, 0x75, 0xd8, 0xfa, 0xaf, 0x04, 0x53,
	0xb5, 0x36, 0xb6, 0x3c, 0xdf, 0xfa, 0x06, 0xcc, 0x46, 0x9e, 0xa7, 0xd0, 0x4a, 0xc2, 0xab, 0x15,
	0x71, 0xb4, 0xbc, 0x9a, 0xfa, 0xa6, 0xa5, 0x4c, 0xa0, 0x4b, 0xee, 0x69, 0x2d, 0xd2, 0x33, 0xbf,
	0x3b, 0xc0, 0x29, 0xd8, 0x48, 0xf9, 0xe1, 0x10, 0xaa, 0x50, 0xcf, 0xa7, 0x90, 0x27, 0x6f, 0x31,
	0x68, 0x21, 0x7c, 0x06, 0xe2, 0x9e, 0x6a, 0xe4, 0xbb, 0x31, 0x68, 0xc0, 0xb7, 0xf5, 0xeb, 0x02,
	0x40, 0xbf, 0xbf, 0x43, 0x87, 0x30, 0xc3, 0x5f, 0xdf, 0xa3, 0xe5, 0x94, 0xc7, 0x0a, 0x79, 0x45,
	0x8c, 0x0c, 0x6d, 0x3a, 0x84, 0x19, 0xfe, 0x36, 0xae, 0x2f, 0x4c, 0x70, 0x79, 0xd8, 0x17, 0x26,
	0xbc, 0xc0, 0x9b, 0x40, 0x1d, 0x58, 0x4c, 0xb8, 0x44, 0x41, 0x8f, 0x46, 0xbb, 0x81, 0x92, 0xdf,
	0x1b, 0xf1, 0x36, 0x46, 0x99, 0x40, 0x0e, 0x2c, 0x25, 0x8e, 0xfe, 0x68, 0x73, 0xd4, 0xcb, 0x0c,
	0xf9, 0xfd, 0x11, 0x28, 0x43, 0x9d, 0x3d, 0x90, 0x93, 0x07, 0x61, 0xf4, 0xfe, 0xc8, 0xe3, 0xbb,
	0xfc, 0xc1, 0x28, 0xa4, 0xa1, 0xda, 0x03, 0x28, 0x72, 0x43, 0x29, 0x92, 0x85, 0x93, 0x2a, 0x15,
	0xbc, 0x9c, 0x32, 0xc5, 0x52, 0x49, 0xdc, 0xec, 0xd5, 0x97, 0x34, 0x38, 0x01, 0xf6, 0x25, 0x09,
	0x86, 0xb5, 0xb8, 0xfb, 0x63, 0x55, 0x4c, 0xe4, 0x7e, 0x71, 0x19, 0x14, 0xb9, 0x3f, 0xa1, 0x24,
	0x2a, 0x13, 0x5b, 0xbf, 0xcb, 0x41, 0xce, 0x2f, 0x33, 0xa8, 0x09, 0xef, 0xc4, 0xda, 0x36, 0x74,
	0x3f, 0xbd, 0xb7, 0x95, 0x1f, 0x24, 0xe2, 0xc3, 0x25, 0x3d, 0xa3, 0xe5, 0x3d, 0xd2, 0x88, 0xa1,
	0x35, 0x9e, 0x4f, 0xd4, 0x0c, 0xca, 0xeb, 0x29, 0x14, 0x71, 0xd9, 0xd1, 0xac, 0x58, 0x1b, 0xd6,
	0x11, 0x44, 0x65, 0x27, 0x65, 0xc2, 0xd7, 0x30, 0x2f, 0x38, 0xc9, 0x90, 0x12, 0xb5, 0x4b, 0x18,
	0xfd, 0x1b, 0xa9, 0x34, 0xa1, 0x86, 0x5d, 0x98, 0x0e, 0x0f, 0x3e, 0x54, 0xe6, 0x79, 0xf8, 0xf3,
	0x51, 0x5e, 0x12, 0x60, 0xe2, 0x56, 0xc6, 0x43, 0x45, 0x89, 0xf1, 0x88, 0x82, 0x64, 0x23, 0x95,
	0x26, 0xd0, 0xb0, 0x9b, 0x7f, 0x96, 0x6d, 0xb9, 0xe6, 0x45, 0x81, 0xfc, 0x4b, 0xc5, 0xf7, 0xfe,
	0x17, 0x00, 0x00, 0xff, 0xff, 0x69, 0xaa, 0xdb, 0x41, 0x5f, 0x21, 0x00, 0x00,
}
