---
title: Users
...

# List of projects using Meson

If you have a project that uses Meson that you want to add to this list, please [file a pull-request](https://github.com/mesonbuild/meson/edit/master/docs/markdown/Users.md) for it. All the software on this list is tested for regressions before release, so it's highly recommended that projects add themselves here. Some additional projects are
listed in the [`meson` GitHub topic](https://github.com/topics/meson).

 - [AQEMU](https://github.com/tobimensch/aqemu), a Qt GUI for QEMU virtual machines, since version 0.9.3
 - [Arduino sample project](https://github.com/jpakkane/mesonarduino)
 - [bolt](https://gitlab.freedesktop.org/bolt/bolt) Userpsace daemon to enable security levels for Thunderbolt™ 3 on Linux
 - [Budgie Desktop](https://github.com/budgie-desktop/budgie-desktop), a desktop environment built on GNOME technologies
 - [casync](https://github.com/systemd/casync), Content-Addressable Data Synchronization Tool
 - [cinnamon-desktop](https://github.com/linuxmint/cinnamon-desktop), the cinnamon desktop library
 - [dbus-broker](https://github.com/bus1/dbus-broker), Linux D-Bus Message Broker
 - [Dpdk](http://dpdk.org/browse/dpdk), Data plane development kit, a set of libraries and drivers for fast packet processing
 - [DXVK](https://github.com/doitsujin/dxvk), a Vulkan-based Direct3D 11 implementation for Linux using Wine
 - [Emeus](https://github.com/ebassi/emeus), Constraint based layout manager for GTK+
 - [Fractal](https://wiki.gnome.org/Apps/Fractal/), a Matrix messaging client for GNOME
 - [Frida](https://github.com/frida/frida-core), a dynamic binary instrumentation toolkit
 - [fwupd](https://github.com/hughsie/fwupd), a simple daemon to allow session software to update firmware
 - [Geary](https://wiki.gnome.org/Apps/Geary), an email application built around conversations, for the GNOME 3 desktop.
 - [GLib](https://gitlab.gnome.org/GNOME/glib), cross-platform C library used by GTK+ and GStreamer (not the default yet)
 - [GNOME Boxes](https://gitlab.gnome.org/GNOME/gnome-boxes), a GNOME hypervisor
 - [GNOME Builder](https://gitlab.gnome.org/GNOME/gnome-builder), an IDE for the GNOME platform
 - [GNOME MPV](https://github.com/gnome-mpv/gnome-mpv), GNOME frontend to the mpv video player
 - [GNOME Recipes](https://gitlab.gnome.org/GNOME/recipes), application for cooking recipes
 - [GNOME Software](https://gitlab.gnome.org/GNOME/gnome-software), an app store for GNOME
 - [GNOME Twitch](https://github.com/vinszent/gnome-twitch), an app for viewing Twitch streams on GNOME desktop
 - [GNOME Usage](https://gitlab.gnome.org/GNOME/gnome-usage), a GNOME application for visualizing system resources
 - [Graphene](https://ebassi.github.io/graphene/), a thin type library for graphics
 - [Grilo](https://git.gnome.org/browse/grilo) and [Grilo plugins](https://git.gnome.org/browse/grilo-plugins), the Grilo multimedia framework
 - [GStreamer](https://cgit.freedesktop.org/gstreamer/gstreamer/), multimedia framework (not the default yet)
 - [GTK+](https://gitlab.gnome.org/GNOME/gtk), the multi-platform toolkit used by GNOME
 - [GtkDApp](https://gitlab.com/csoriano/GtkDApp), an application template for developing Flatpak apps with Gtk+ and D
 - [GVfs](https://git.gnome.org/browse/gvfs/), a userspace virtual filesystem designed to work with the I/O abstraction of GIO
 - [Hardcode-Tray](https://github.com/bil-elmoussaoui/Hardcode-Tray), fixes hardcoded tray icons in Linux
 - [HexChat](https://github.com/hexchat/hexchat), a cross-platform IRC client in C
 - [IGT](https://cgit.freedesktop.org/xorg/app/intel-gpu-tools/), Linux kernel graphics driver test suite.
 - [JsonCpp](https://github.com/open-source-parsers/jsoncpp), a C++ library for interacting with JSON
 - [Json-glib](https://gitlab.gnome.org/GNOME/json-glib), GLib-based JSON manipulation library
 - [Ksh](https://github.com/att/ast), a Korn Shell
 - [Libdrm](https://cgit.freedesktop.org/drm/libdrm/), a library for abstracting DRM kernel interfaces
 - [Libepoxy](https://github.com/anholt/libepoxy/), a library for handling OpenGL function pointer management
 - [libfuse](https://github.com/libfuse/libfuse), the reference implementation of the Linux FUSE (Filesystem in Userspace) interface
 - [Libgit2-glib](https://git.gnome.org/browse/libgit2-glib), a GLib wrapper for libgit2
 - [Libhttpseverywhere](https://git.gnome.org/browse/libhttpseverywhere), a library to enable httpseverywhere on any desktop app
 - [Libosmscout](https://github.com/Framstag/libosmscout), a C++ library for offline map rendering, routing and location  
lookup based on OpenStreetMap data
 - [libspng](https://gitlab.com/randy408/libspng), a C library for reading and writing Portable Network Graphics (PNG) 
format files
 - [Libva](https://github.com/intel/libva), an implementation for the VA (VIdeo Acceleration) API
 - [Libzim](https://github.com/openzim/libzim), the reference implementation for the ZIM file format
 - [Kiwix libraries](https://github.com/kiwix/kiwix-lib)
 - [Mesa](https://cgit.freedesktop.org/mesa/mesa/), An open source graphics driver project
 - [MiracleCast](https://github.com/albfan/miraclecast), connect external monitors to your system via Wifi-Display specification aka Miracast
 - [Nautilus](https://gitlab.gnome.org/GNOME/nautilus), the GNOME file manager
 - [Nemo](https://github.com/linuxmint/nemo), the file manager for the Cinnamon desktop environment
 - [Orc](http://cgit.freedesktop.org/gstreamer/orc/), the Optimized Inner Loop Runtime Compiler (not the default yet)
 - [Outlier](https://github.com/kerolasa/outlier), a small Hello World style meson example project
 - [Pango](https://git.gnome.org/browse/pango/), an Internationalized text layout and rendering library (not the default yet)
 - [Parzip](https://github.com/jpakkane/parzip), a multithreaded reimplementation of Zip
 - [PipeWire](https://github.com/PipeWire/pipewire), a framework for video and audio for containerized applications
 - [Pithos](https://github.com/pithos/pithos), a Pandora Radio client
 - [Pitivi](https://github.com/pitivi/pitivi/), a nonlinear video editor
 - [Polari](https://gitlab.gnome.org/GNOME/polari), an IRC client
 - [radare2](https://github.com/radare/radare2), unix-like reverse engineering framework and commandline tools (not the default)
 - [SSHFS](https://github.com/libfuse/sshfs), allows you to mount a remote filesystem using SFTP
 - [Sysprof](https://git.gnome.org/browse/sysprof), a profiling tool
 - [systemd](https://github.com/systemd/systemd), the init system
 - [szl](https://github.com/dimkr/szl), a lightweight, embeddable scripting language
 - [Taisei Project](https://taisei-project.org/), an open-source Touhou Project clone and fangame
 - [xi-gtk](https://github.com/eyelash/xi-gtk), a GTK+ front-end for the Xi editor
 - [Xorg](https://cgit.freedesktop.org/xorg/xserver/), the X.org display server (not the default yet)
 - [Valum](https://github.com/valum-framework/valum), a micro web framework written in Vala
 - [Wayland and Weston](https://lists.freedesktop.org/archives/wayland-devel/2016-November/031984.html), a next generation display server (not merged yet)
 - [wlroots](https://github.com/swaywm/wlroots), a modular Wayland compositor library
 - [ZStandard](https://github.com/facebook/zstd/commit/4dca56ed832c6a88108a2484a8f8ff63d8d76d91), a compression algorithm developed at Facebook (not used by default)

Note that a more up-to-date list of GNOME projects that use Meson can be found [here](https://wiki.gnome.org/Initiatives/GnomeGoals/MesonPorting).
