/**************************************************************************
 * FILE: gendb.c
 * AUTHOR: Timothy L. Bailey
 * CREATE DATE: 10/29/02
 * PROJECT: MHMM
 * COPYRIGHT: 2002, TLB
 * DESCRIPTION: Generate sequences using a Markov model.
 **************************************************************************/

#ifdef MAIN
#define DEFINE_GLOBALS
#endif

#include <assert.h>
#include <errno.h>
#include <getopt.h>
#include <inttypes.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
// PRNG library
#include "mtwist.h"

#include "utils.h"
#include "alphabet.h"
#include "seq.h"
#include "string-builder.h"

#define LINE 50

// List of symbols used to produce codons in partnership with fcodon.
// If you update fcodon then you must update this to
// match the utilized symbols and their ordering.
char* dna = "ABCDGHKMNRSTUVWY";
// DNA coding frame codon frequencies.
// shuffle_db -nostop < est > tmp1; getsize -codons tmp1
// est is the 11/11/97 EST database from ncbi
double fcodon[] = {
  /* {{{ codon frequencies for alphabet ABCDGHKMNRSTUVWY */
  0.02347060 /* AAA */,
  0.00000016 /* AAB */,
  0.01672442 /* AAC */,
  0.00000023 /* AAD */,
  0.02840403 /* AAG */,
  0.00000029 /* AAH */,
  0.00000029 /* AAK */,
  0.00000212 /* AAM */,
  0.00066017 /* AAN */,
  0.00000173 /* AAR */,
  0.00000124 /* AAS */,
  0.01543921 /* AAT */,
  0.00000000 /* AAU */,
  0.00000036 /* AAV */,
  0.00000101 /* AAW */,
  0.00000085 /* AAY */,
  0.00000013 /* ABA */,
  0.00000003 /* ABB */,
  0.00000007 /* ABC */,
  0.00000000 /* ABD */,
  0.00000023 /* ABG */,
  0.00000000 /* ABH */,
  0.00000000 /* ABK */,
  0.00000000 /* ABM */,
  0.00000000 /* ABN */,
  0.00000000 /* ABR */,
  0.00000003 /* ABS */,
  0.00000029 /* ABT */,
  0.00000000 /* ABU */,
  0.00000003 /* ABV */,
  0.00000000 /* ABW */,
  0.00000003 /* ABY */,
  0.01493833 /* ACA */,
  0.00000010 /* ACB */,
  0.01647846 /* ACC */,
  0.00000007 /* ACD */,
  0.00754367 /* ACG */,
  0.00000016 /* ACH */,
  0.00000023 /* ACK */,
  0.00000075 /* ACM */,
  0.00027275 /* ACN */,
  0.00000049 /* ACR */,
  0.00000075 /* ACS */,
  0.01307695 /* ACT */,
  0.00000000 /* ACU */,
  0.00000010 /* ACV */,
  0.00000029 /* ACW */,
  0.00000068 /* ACY */,
  0.00000016 /* ADA */,
  0.00000000 /* ADB */,
  0.00000010 /* ADC */,
  0.00000007 /* ADD */,
  0.00000010 /* ADG */,
  0.00000000 /* ADH */,
  0.00000000 /* ADK */,
  0.00000000 /* ADM */,
  0.00000007 /* ADN */,
  0.00000000 /* ADR */,
  0.00000000 /* ADS */,
  0.00000026 /* ADT */,
  0.00000000 /* ADU */,
  0.00000000 /* ADV */,
  0.00000000 /* ADW */,
  0.00000003 /* ADY */,
  0.01478685 /* AGA */,
  0.00000036 /* AGB */,
  0.01659420 /* AGC */,
  0.00000026 /* AGD */,
  0.01502035 /* AGG */,
  0.00000013 /* AGH */,
  0.00000065 /* AGK */,
  0.00000137 /* AGM */,
  0.00052295 /* AGN */,
  0.00000176 /* AGR */,
  0.00000163 /* AGS */,
  0.01131338 /* AGT */,
  0.00000000 /* AGU */,
  0.00000072 /* AGV */,
  0.00000042 /* AGW */,
  0.00000065 /* AGY */,
  0.00000016 /* AHA */,
  0.00000003 /* AHB */,
  0.00000023 /* AHC */,
  0.00000000 /* AHD */,
  0.00000010 /* AHG */,
  0.00000003 /* AHH */,
  0.00000003 /* AHK */,
  0.00000000 /* AHM */,
  0.00000000 /* AHN */,
  0.00000003 /* AHR */,
  0.00000000 /* AHS */,
  0.00000023 /* AHT */,
  0.00000000 /* AHU */,
  0.00000000 /* AHV */,
  0.00000003 /* AHW */,
  0.00000007 /* AHY */,
  0.00000052 /* AKA */,
  0.00000000 /* AKB */,
  0.00000049 /* AKC */,
  0.00000003 /* AKD */,
  0.00000039 /* AKG */,
  0.00000000 /* AKH */,
  0.00000013 /* AKK */,
  0.00000000 /* AKM */,
  0.00000003 /* AKN */,
  0.00000000 /* AKR */,
  0.00000000 /* AKS */,
  0.00000068 /* AKT */,
  0.00000000 /* AKU */,
  0.00000003 /* AKV */,
  0.00000000 /* AKW */,
  0.00000000 /* AKY */,
  0.00000426 /* AMA */,
  0.00000000 /* AMB */,
  0.00000215 /* AMC */,
  0.00000000 /* AMD */,
  0.00000260 /* AMG */,
  0.00000000 /* AMH */,
  0.00000000 /* AMK */,
  0.00000026 /* AMM */,
  0.00000003 /* AMN */,
  0.00000007 /* AMR */,
  0.00000000 /* AMS */,
  0.00000055 /* AMT */,
  0.00000000 /* AMU */,
  0.00000010 /* AMV */,
  0.00000003 /* AMW */,
  0.00000003 /* AMY */,
  0.00058342 /* ANA */,
  0.00000010 /* ANB */,
  0.00062925 /* ANC */,
  0.00000007 /* AND */,
  0.00054322 /* ANG */,
  0.00000003 /* ANH */,
  0.00000000 /* ANK */,
  0.00000000 /* ANM */,
  0.00016212 /* ANN */,
  0.00000007 /* ANR */,
  0.00000000 /* ANS */,
  0.00057346 /* ANT */,
  0.00000000 /* ANU */,
  0.00000003 /* ANV */,
  0.00000000 /* ANW */,
  0.00000003 /* ANY */,
  0.00000215 /* ARA */,
  0.00000000 /* ARB */,
  0.00000163 /* ARC */,
  0.00000003 /* ARD */,
  0.00000215 /* ARG */,
  0.00000000 /* ARH */,
  0.00000000 /* ARK */,
  0.00000007 /* ARM */,
  0.00000000 /* ARN */,
  0.00000013 /* ARR */,
  0.00000000 /* ARS */,
  0.00000055 /* ART */,
  0.00000000 /* ARU */,
  0.00000003 /* ARV */,
  0.00000000 /* ARW */,
  0.00000000 /* ARY */,
  0.00000130 /* ASA */,
  0.00000000 /* ASB */,
  0.00000163 /* ASC */,
  0.00000000 /* ASD */,
  0.00000101 /* ASG */,
  0.00000000 /* ASH */,
  0.00000000 /* ASK */,
  0.00000000 /* ASM */,
  0.00000007 /* ASN */,
  0.00000007 /* ASR */,
  0.00000003 /* ASS */,
  0.00000052 /* AST */,
  0.00000000 /* ASU */,
  0.00000000 /* ASV */,
  0.00000000 /* ASW */,
  0.00000010 /* ASY */,
  0.00724097 /* ATA */,
  0.00000062 /* ATB */,
  0.01775612 /* ATC */,
  0.00000016 /* ATD */,
  0.01747826 /* ATG */,
  0.00000020 /* ATH */,
  0.00000150 /* ATK */,
  0.00000078 /* ATM */,
  0.00050592 /* ATN */,
  0.00000055 /* ATR */,
  0.00000091 /* ATS */,
  0.01592739 /* ATT */,
  0.00000000 /* ATU */,
  0.00000023 /* ATV */,
  0.00000072 /* ATW */,
  0.00000143 /* ATY */,
  0.00000000 /* AUA */,
  0.00000000 /* AUB */,
  0.00000000 /* AUC */,
  0.00000000 /* AUD */,
  0.00000000 /* AUG */,
  0.00000000 /* AUH */,
  0.00000000 /* AUK */,
  0.00000000 /* AUM */,
  0.00000000 /* AUN */,
  0.00000000 /* AUR */,
  0.00000000 /* AUS */,
  0.00000000 /* AUT */,
  0.00000000 /* AUU */,
  0.00000000 /* AUV */,
  0.00000000 /* AUW */,
  0.00000000 /* AUY */,
  0.00000065 /* AVA */,
  0.00000000 /* AVB */,
  0.00000046 /* AVC */,
  0.00000000 /* AVD */,
  0.00000059 /* AVG */,
  0.00000000 /* AVH */,
  0.00000003 /* AVK */,
  0.00000003 /* AVM */,
  0.00000010 /* AVN */,
  0.00000010 /* AVR */,
  0.00000003 /* AVS */,
  0.00000023 /* AVT */,
  0.00000000 /* AVU */,
  0.00000016 /* AVV */,
  0.00000000 /* AVW */,
  0.00000000 /* AVY */,
  0.00000068 /* AWA */,
  0.00000000 /* AWB */,
  0.00000072 /* AWC */,
  0.00000000 /* AWD */,
  0.00000042 /* AWG */,
  0.00000000 /* AWH */,
  0.00000003 /* AWK */,
  0.00000003 /* AWM */,
  0.00000010 /* AWN */,
  0.00000007 /* AWR */,
  0.00000000 /* AWS */,
  0.00000107 /* AWT */,
  0.00000000 /* AWU */,
  0.00000000 /* AWV */,
  0.00000007 /* AWW */,
  0.00000000 /* AWY */,
  0.00000013 /* AYA */,
  0.00000000 /* AYB */,
  0.00000146 /* AYC */,
  0.00000000 /* AYD */,
  0.00000042 /* AYG */,
  0.00000000 /* AYH */,
  0.00000000 /* AYK */,
  0.00000007 /* AYM */,
  0.00000000 /* AYN */,
  0.00000000 /* AYR */,
  0.00000003 /* AYS */,
  0.00000072 /* AYT */,
  0.00000000 /* AYU */,
  0.00000000 /* AYV */,
  0.00000000 /* AYW */,
  0.00000003 /* AYY */,
  0.00000033 /* BAA */,
  0.00000007 /* BAB */,
  0.00000016 /* BAC */,
  0.00000000 /* BAD */,
  0.00000033 /* BAG */,
  0.00000000 /* BAH */,
  0.00000007 /* BAK */,
  0.00000000 /* BAM */,
  0.00000000 /* BAN */,
  0.00000003 /* BAR */,
  0.00000003 /* BAS */,
  0.00000049 /* BAT */,
  0.00000000 /* BAU */,
  0.00000000 /* BAV */,
  0.00000000 /* BAW */,
  0.00000003 /* BAY */,
  0.00000010 /* BBA */,
  0.00000013 /* BBB */,
  0.00000000 /* BBC */,
  0.00000000 /* BBD */,
  0.00000007 /* BBG */,
  0.00000000 /* BBH */,
  0.00000003 /* BBK */,
  0.00000000 /* BBM */,
  0.00000000 /* BBN */,
  0.00000000 /* BBR */,
  0.00000000 /* BBS */,
  0.00000010 /* BBT */,
  0.00000000 /* BBU */,
  0.00000000 /* BBV */,
  0.00000000 /* BBW */,
  0.00000000 /* BBY */,
  0.00000042 /* BCA */,
  0.00000000 /* BCB */,
  0.00000111 /* BCC */,
  0.00000000 /* BCD */,
  0.00000023 /* BCG */,
  0.00000000 /* BCH */,
  0.00000003 /* BCK */,
  0.00000000 /* BCM */,
  0.00000000 /* BCN */,
  0.00000000 /* BCR */,
  0.00000003 /* BCS */,
  0.00000072 /* BCT */,
  0.00000000 /* BCU */,
  0.00000003 /* BCV */,
  0.00000003 /* BCW */,
  0.00000000 /* BCY */,
  0.00000003 /* BDA */,
  0.00000000 /* BDB */,
  0.00000003 /* BDC */,
  0.00000000 /* BDD */,
  0.00000003 /* BDG */,
  0.00000000 /* BDH */,
  0.00000000 /* BDK */,
  0.00000000 /* BDM */,
  0.00000000 /* BDN */,
  0.00000000 /* BDR */,
  0.00000000 /* BDS */,
  0.00000000 /* BDT */,
  0.00000000 /* BDU */,
  0.00000000 /* BDV */,
  0.00000000 /* BDW */,
  0.00000000 /* BDY */,
  0.00000026 /* BGA */,
  0.00000003 /* BGB */,
  0.00000039 /* BGC */,
  0.00000000 /* BGD */,
  0.00000062 /* BGG */,
  0.00000003 /* BGH */,
  0.00000010 /* BGK */,
  0.00000000 /* BGM */,
  0.00000007 /* BGN */,
  0.00000000 /* BGR */,
  0.00000000 /* BGS */,
  0.00000052 /* BGT */,
  0.00000000 /* BGU */,
  0.00000000 /* BGV */,
  0.00000000 /* BGW */,
  0.00000000 /* BGY */,
  0.00000000 /* BHA */,
  0.00000000 /* BHB */,
  0.00000007 /* BHC */,
  0.00000000 /* BHD */,
  0.00000000 /* BHG */,
  0.00000000 /* BHH */,
  0.00000000 /* BHK */,
  0.00000000 /* BHM */,
  0.00000000 /* BHN */,
  0.00000000 /* BHR */,
  0.00000000 /* BHS */,
  0.00000000 /* BHT */,
  0.00000000 /* BHU */,
  0.00000000 /* BHV */,
  0.00000000 /* BHW */,
  0.00000000 /* BHY */,
  0.00000003 /* BKA */,
  0.00000000 /* BKB */,
  0.00000003 /* BKC */,
  0.00000000 /* BKD */,
  0.00000010 /* BKG */,
  0.00000000 /* BKH */,
  0.00000007 /* BKK */,
  0.00000000 /* BKM */,
  0.00000003 /* BKN */,
  0.00000000 /* BKR */,
  0.00000000 /* BKS */,
  0.00000000 /* BKT */,
  0.00000000 /* BKU */,
  0.00000000 /* BKV */,
  0.00000000 /* BKW */,
  0.00000000 /* BKY */,
  0.00000003 /* BMA */,
  0.00000000 /* BMB */,
  0.00000003 /* BMC */,
  0.00000000 /* BMD */,
  0.00000000 /* BMG */,
  0.00000000 /* BMH */,
  0.00000000 /* BMK */,
  0.00000000 /* BMM */,
  0.00000000 /* BMN */,
  0.00000000 /* BMR */,
  0.00000000 /* BMS */,
  0.00000000 /* BMT */,
  0.00000000 /* BMU */,
  0.00000000 /* BMV */,
  0.00000000 /* BMW */,
  0.00000000 /* BMY */,
  0.00000000 /* BNA */,
  0.00000000 /* BNB */,
  0.00000007 /* BNC */,
  0.00000000 /* BND */,
  0.00000007 /* BNG */,
  0.00000000 /* BNH */,
  0.00000000 /* BNK */,
  0.00000000 /* BNM */,
  0.00000000 /* BNN */,
  0.00000000 /* BNR */,
  0.00000000 /* BNS */,
  0.00000003 /* BNT */,
  0.00000000 /* BNU */,
  0.00000000 /* BNV */,
  0.00000000 /* BNW */,
  0.00000000 /* BNY */,
  0.00000000 /* BRA */,
  0.00000000 /* BRB */,
  0.00000000 /* BRC */,
  0.00000000 /* BRD */,
  0.00000000 /* BRG */,
  0.00000000 /* BRH */,
  0.00000000 /* BRK */,
  0.00000000 /* BRM */,
  0.00000000 /* BRN */,
  0.00000003 /* BRR */,
  0.00000000 /* BRS */,
  0.00000000 /* BRT */,
  0.00000000 /* BRU */,
  0.00000000 /* BRV */,
  0.00000000 /* BRW */,
  0.00000000 /* BRY */,
  0.00000003 /* BSA */,
  0.00000000 /* BSB */,
  0.00000003 /* BSC */,
  0.00000000 /* BSD */,
  0.00000003 /* BSG */,
  0.00000000 /* BSH */,
  0.00000003 /* BSK */,
  0.00000000 /* BSM */,
  0.00000000 /* BSN */,
  0.00000000 /* BSR */,
  0.00000003 /* BSS */,
  0.00000000 /* BST */,
  0.00000000 /* BSU */,
  0.00000000 /* BSV */,
  0.00000000 /* BSW */,
  0.00000007 /* BSY */,
  0.00000023 /* BTA */,
  0.00000003 /* BTB */,
  0.00000094 /* BTC */,
  0.00000000 /* BTD */,
  0.00000036 /* BTG */,
  0.00000000 /* BTH */,
  0.00000000 /* BTK */,
  0.00000000 /* BTM */,
  0.00000000 /* BTN */,
  0.00000000 /* BTR */,
  0.00000000 /* BTS */,
  0.00000068 /* BTT */,
  0.00000000 /* BTU */,
  0.00000000 /* BTV */,
  0.00000000 /* BTW */,
  0.00000003 /* BTY */,
  0.00000000 /* BUA */,
  0.00000000 /* BUB */,
  0.00000000 /* BUC */,
  0.00000000 /* BUD */,
  0.00000000 /* BUG */,
  0.00000000 /* BUH */,
  0.00000000 /* BUK */,
  0.00000000 /* BUM */,
  0.00000000 /* BUN */,
  0.00000000 /* BUR */,
  0.00000000 /* BUS */,
  0.00000000 /* BUT */,
  0.00000000 /* BUU */,
  0.00000000 /* BUV */,
  0.00000000 /* BUW */,
  0.00000000 /* BUY */,
  0.00000003 /* BVA */,
  0.00000000 /* BVB */,
  0.00000000 /* BVC */,
  0.00000000 /* BVD */,
  0.00000000 /* BVG */,
  0.00000000 /* BVH */,
  0.00000000 /* BVK */,
  0.00000000 /* BVM */,
  0.00000000 /* BVN */,
  0.00000000 /* BVR */,
  0.00000000 /* BVS */,
  0.00000003 /* BVT */,
  0.00000000 /* BVU */,
  0.00000000 /* BVV */,
  0.00000000 /* BVW */,
  0.00000000 /* BVY */,
  0.00000000 /* BWA */,
  0.00000000 /* BWB */,
  0.00000000 /* BWC */,
  0.00000000 /* BWD */,
  0.00000000 /* BWG */,
  0.00000000 /* BWH */,
  0.00000000 /* BWK */,
  0.00000000 /* BWM */,
  0.00000000 /* BWN */,
  0.00000000 /* BWR */,
  0.00000000 /* BWS */,
  0.00000000 /* BWT */,
  0.00000000 /* BWU */,
  0.00000000 /* BWV */,
  0.00000000 /* BWW */,
  0.00000000 /* BWY */,
  0.00000007 /* BYA */,
  0.00000000 /* BYB */,
  0.00000010 /* BYC */,
  0.00000000 /* BYD */,
  0.00000000 /* BYG */,
  0.00000000 /* BYH */,
  0.00000000 /* BYK */,
  0.00000000 /* BYM */,
  0.00000007 /* BYN */,
  0.00000000 /* BYR */,
  0.00000000 /* BYS */,
  0.00000010 /* BYT */,
  0.00000000 /* BYU */,
  0.00000000 /* BYV */,
  0.00000000 /* BYW */,
  0.00000000 /* BYY */,
  0.01552259 /* CAA */,
  0.00000010 /* CAB */,
  0.01601260 /* CAC */,
  0.00000020 /* CAD */,
  0.02627566 /* CAG */,
  0.00000023 /* CAH */,
  0.00000049 /* CAK */,
  0.00000208 /* CAM */,
  0.00070476 /* CAN */,
  0.00000231 /* CAR */,
  0.00000137 /* CAS */,
  0.01310533 /* CAT */,
  0.00000000 /* CAU */,
  0.00000046 /* CAV */,
  0.00000068 /* CAW */,
  0.00000068 /* CAY */,
  0.00000029 /* CBA */,
  0.00000023 /* CBB */,
  0.00000049 /* CBC */,
  0.00000000 /* CBD */,
  0.00000033 /* CBG */,
  0.00000000 /* CBH */,
  0.00000003 /* CBK */,
  0.00000000 /* CBM */,
  0.00000000 /* CBN */,
  0.00000000 /* CBR */,
  0.00000007 /* CBS */,
  0.00000013 /* CBT */,
  0.00000000 /* CBU */,
  0.00000000 /* CBV */,
  0.00000000 /* CBW */,
  0.00000007 /* CBY */,
  0.02002812 /* CCA */,
  0.00000036 /* CCB */,
  0.01728519 /* CCC */,
  0.00000003 /* CCD */,
  0.00979434 /* CCG */,
  0.00000039 /* CCH */,
  0.00000072 /* CCK */,
  0.00000208 /* CCM */,
  0.00057460 /* CCN */,
  0.00000091 /* CCR */,
  0.00000254 /* CCS */,
  0.01736717 /* CCT */,
  0.00000000 /* CCU */,
  0.00000065 /* CCV */,
  0.00000033 /* CCW */,
  0.00000273 /* CCY */,
  0.00000016 /* CDA */,
  0.00000000 /* CDB */,
  0.00000013 /* CDC */,
  0.00000000 /* CDD */,
  0.00000013 /* CDG */,
  0.00000000 /* CDH */,
  0.00000000 /* CDK */,
  0.00000000 /* CDM */,
  0.00000000 /* CDN */,
  0.00000000 /* CDR */,
  0.00000000 /* CDS */,
  0.00000010 /* CDT */,
  0.00000000 /* CDU */,
  0.00000000 /* CDV */,
  0.00000000 /* CDW */,
  0.00000000 /* CDY */,
  0.00814808 /* CGA */,
  0.00000033 /* CGB */,
  0.01033135 /* CGC */,
  0.00000010 /* CGD */,
  0.01050887 /* CGG */,
  0.00000010 /* CGH */,
  0.00000101 /* CGK */,
  0.00000094 /* CGM */,
  0.00050722 /* CGN */,
  0.00000107 /* CGR */,
  0.00000391 /* CGS */,
  0.00817415 /* CGT */,
  0.00000000 /* CGU */,
  0.00000039 /* CGV */,
  0.00000023 /* CGW */,
  0.00000091 /* CGY */,
  0.00000016 /* CHA */,
  0.00000000 /* CHB */,
  0.00000007 /* CHC */,
  0.00000000 /* CHD */,
  0.00000016 /* CHG */,
  0.00000007 /* CHH */,
  0.00000000 /* CHK */,
  0.00000007 /* CHM */,
  0.00000000 /* CHN */,
  0.00000000 /* CHR */,
  0.00000000 /* CHS */,
  0.00000010 /* CHT */,
  0.00000000 /* CHU */,
  0.00000000 /* CHV */,
  0.00000000 /* CHW */,
  0.00000000 /* CHY */,
  0.00000029 /* CKA */,
  0.00000003 /* CKB */,
  0.00000065 /* CKC */,
  0.00000000 /* CKD */,
  0.00000046 /* CKG */,
  0.00000000 /* CKH */,
  0.00000010 /* CKK */,
  0.00000000 /* CKM */,
  0.00000000 /* CKN */,
  0.00000003 /* CKR */,
  0.00000003 /* CKS */,
  0.00000124 /* CKT */,
  0.00000000 /* CKU */,
  0.00000000 /* CKV */,
  0.00000000 /* CKW */,
  0.00000000 /* CKY */,
  0.00000153 /* CMA */,
  0.00000003 /* CMB */,
  0.00000091 /* CMC */,
  0.00000000 /* CMD */,
  0.00000062 /* CMG */,
  0.00000007 /* CMH */,
  0.00000003 /* CMK */,
  0.00000010 /* CMM */,
  0.00000000 /* CMN */,
  0.00000010 /* CMR */,
  0.00000016 /* CMS */,
  0.00000046 /* CMT */,
  0.00000000 /* CMU */,
  0.00000003 /* CMV */,
  0.00000000 /* CMW */,
  0.00000000 /* CMY */,
  0.00040037 /* CNA */,
  0.00000003 /* CNB */,
  0.00041267 /* CNC */,
  0.00000000 /* CND */,
  0.00035676 /* CNG */,
  0.00000003 /* CNH */,
  0.00000003 /* CNK */,
  0.00000000 /* CNM */,
  0.00016066 /* CNN */,
  0.00000000 /* CNR */,
  0.00000003 /* CNS */,
  0.00043227 /* CNT */,
  0.00000000 /* CNU */,
  0.00000003 /* CNV */,
  0.00000000 /* CNW */,
  0.00000003 /* CNY */,
  0.00000094 /* CRA */,
  0.00000000 /* CRB */,
  0.00000033 /* CRC */,
  0.00000000 /* CRD */,
  0.00000081 /* CRG */,
  0.00000000 /* CRH */,
  0.00000000 /* CRK */,
  0.00000003 /* CRM */,
  0.00000010 /* CRN */,
  0.00000010 /* CRR */,
  0.00000000 /* CRS */,
  0.00000020 /* CRT */,
  0.00000000 /* CRU */,
  0.00000000 /* CRV */,
  0.00000000 /* CRW */,
  0.00000000 /* CRY */,
  0.00000182 /* CSA */,
  0.00000007 /* CSB */,
  0.00000202 /* CSC */,
  0.00000000 /* CSD */,
  0.00000352 /* CSG */,
  0.00000000 /* CSH */,
  0.00000007 /* CSK */,
  0.00000007 /* CSM */,
  0.00000010 /* CSN */,
  0.00000003 /* CSR */,
  0.00000007 /* CSS */,
  0.00000104 /* CST */,
  0.00000000 /* CSU */,
  0.00000000 /* CSV */,
  0.00000000 /* CSW */,
  0.00000010 /* CSY */,
  0.00707898 /* CTA */,
  0.00000137 /* CTB */,
  0.02018451 /* CTC */,
  0.00000026 /* CTD */,
  0.02594563 /* CTG */,
  0.00000026 /* CTH */,
  0.00000348 /* CTK */,
  0.00000091 /* CTM */,
  0.00084842 /* CTN */,
  0.00000046 /* CTR */,
  0.00000286 /* CTS */,
  0.01905813 /* CTT */,
  0.00000000 /* CTU */,
  0.00000029 /* CTV */,
  0.00000039 /* CTW */,
  0.00000241 /* CTY */,
  0.00000000 /* CUA */,
  0.00000000 /* CUB */,
  0.00000000 /* CUC */,
  0.00000000 /* CUD */,
  0.00000000 /* CUG */,
  0.00000000 /* CUH */,
  0.00000000 /* CUK */,
  0.00000000 /* CUM */,
  0.00000000 /* CUN */,
  0.00000000 /* CUR */,
  0.00000000 /* CUS */,
  0.00000000 /* CUT */,
  0.00000000 /* CUU */,
  0.00000000 /* CUV */,
  0.00000000 /* CUW */,
  0.00000000 /* CUY */,
  0.00000046 /* CVA */,
  0.00000000 /* CVB */,
  0.00000020 /* CVC */,
  0.00000000 /* CVD */,
  0.00000029 /* CVG */,
  0.00000000 /* CVH */,
  0.00000000 /* CVK */,
  0.00000003 /* CVM */,
  0.00000003 /* CVN */,
  0.00000003 /* CVR */,
  0.00000000 /* CVS */,
  0.00000003 /* CVT */,
  0.00000000 /* CVU */,
  0.00000007 /* CVV */,
  0.00000000 /* CVW */,
  0.00000000 /* CVY */,
  0.00000026 /* CWA */,
  0.00000000 /* CWB */,
  0.00000020 /* CWC */,
  0.00000000 /* CWD */,
  0.00000020 /* CWG */,
  0.00000000 /* CWH */,
  0.00000000 /* CWK */,
  0.00000000 /* CWM */,
  0.00000000 /* CWN */,
  0.00000003 /* CWR */,
  0.00000000 /* CWS */,
  0.00000042 /* CWT */,
  0.00000000 /* CWU */,
  0.00000000 /* CWV */,
  0.00000010 /* CWW */,
  0.00000000 /* CWY */,
  0.00000039 /* CYA */,
  0.00000007 /* CYB */,
  0.00000195 /* CYC */,
  0.00000000 /* CYD */,
  0.00000156 /* CYG */,
  0.00000007 /* CYH */,
  0.00000003 /* CYK */,
  0.00000010 /* CYM */,
  0.00000000 /* CYN */,
  0.00000000 /* CYR */,
  0.00000023 /* CYS */,
  0.00000156 /* CYT */,
  0.00000000 /* CYU */,
  0.00000000 /* CYV */,
  0.00000003 /* CYW */,
  0.00000020 /* CYY */,
  0.00000029 /* DAA */,
  0.00000000 /* DAB */,
  0.00000010 /* DAC */,
  0.00000007 /* DAD */,
  0.00000046 /* DAG */,
  0.00000000 /* DAH */,
  0.00000000 /* DAK */,
  0.00000000 /* DAM */,
  0.00000000 /* DAN */,
  0.00000003 /* DAR */,
  0.00000000 /* DAS */,
  0.00000020 /* DAT */,
  0.00000000 /* DAU */,
  0.00000000 /* DAV */,
  0.00000000 /* DAW */,
  0.00000000 /* DAY */,
  0.00000000 /* DBA */,
  0.00000000 /* DBB */,
  0.00000000 /* DBC */,
  0.00000000 /* DBD */,
  0.00000000 /* DBG */,
  0.00000000 /* DBH */,
  0.00000000 /* DBK */,
  0.00000000 /* DBM */,
  0.00000000 /* DBN */,
  0.00000000 /* DBR */,
  0.00000000 /* DBS */,
  0.00000000 /* DBT */,
  0.00000000 /* DBU */,
  0.00000000 /* DBV */,
  0.00000000 /* DBW */,
  0.00000000 /* DBY */,
  0.00000029 /* DCA */,
  0.00000000 /* DCB */,
  0.00000026 /* DCC */,
  0.00000003 /* DCD */,
  0.00000010 /* DCG */,
  0.00000000 /* DCH */,
  0.00000000 /* DCK */,
  0.00000000 /* DCM */,
  0.00000000 /* DCN */,
  0.00000000 /* DCR */,
  0.00000000 /* DCS */,
  0.00000016 /* DCT */,
  0.00000000 /* DCU */,
  0.00000000 /* DCV */,
  0.00000000 /* DCW */,
  0.00000000 /* DCY */,
  0.00000003 /* DDA */,
  0.00000000 /* DDB */,
  0.00000000 /* DDC */,
  0.00000007 /* DDD */,
  0.00000000 /* DDG */,
  0.00000000 /* DDH */,
  0.00000000 /* DDK */,
  0.00000000 /* DDM */,
  0.00000000 /* DDN */,
  0.00000000 /* DDR */,
  0.00000000 /* DDS */,
  0.00000000 /* DDT */,
  0.00000000 /* DDU */,
  0.00000000 /* DDV */,
  0.00000000 /* DDW */,
  0.00000000 /* DDY */,
  0.00000010 /* DGA */,
  0.00000000 /* DGB */,
  0.00000000 /* DGC */,
  0.00000000 /* DGD */,
  0.00000013 /* DGG */,
  0.00000000 /* DGH */,
  0.00000000 /* DGK */,
  0.00000003 /* DGM */,
  0.00000000 /* DGN */,
  0.00000000 /* DGR */,
  0.00000000 /* DGS */,
  0.00000007 /* DGT */,
  0.00000000 /* DGU */,
  0.00000000 /* DGV */,
  0.00000000 /* DGW */,
  0.00000000 /* DGY */,
  0.00000000 /* DHA */,
  0.00000000 /* DHB */,
  0.00000000 /* DHC */,
  0.00000000 /* DHD */,
  0.00000000 /* DHG */,
  0.00000000 /* DHH */,
  0.00000000 /* DHK */,
  0.00000000 /* DHM */,
  0.00000000 /* DHN */,
  0.00000000 /* DHR */,
  0.00000000 /* DHS */,
  0.00000000 /* DHT */,
  0.00000000 /* DHU */,
  0.00000000 /* DHV */,
  0.00000000 /* DHW */,
  0.00000000 /* DHY */,
  0.00000000 /* DKA */,
  0.00000000 /* DKB */,
  0.00000000 /* DKC */,
  0.00000000 /* DKD */,
  0.00000003 /* DKG */,
  0.00000000 /* DKH */,
  0.00000003 /* DKK */,
  0.00000000 /* DKM */,
  0.00000000 /* DKN */,
  0.00000003 /* DKR */,
  0.00000000 /* DKS */,
  0.00000000 /* DKT */,
  0.00000000 /* DKU */,
  0.00000000 /* DKV */,
  0.00000000 /* DKW */,
  0.00000000 /* DKY */,
  0.00000000 /* DMA */,
  0.00000000 /* DMB */,
  0.00000000 /* DMC */,
  0.00000000 /* DMD */,
  0.00000000 /* DMG */,
  0.00000000 /* DMH */,
  0.00000000 /* DMK */,
  0.00000000 /* DMM */,
  0.00000000 /* DMN */,
  0.00000000 /* DMR */,
  0.00000000 /* DMS */,
  0.00000003 /* DMT */,
  0.00000000 /* DMU */,
  0.00000000 /* DMV */,
  0.00000000 /* DMW */,
  0.00000000 /* DMY */,
  0.00000000 /* DNA */,
  0.00000000 /* DNB */,
  0.00000007 /* DNC */,
  0.00000000 /* DND */,
  0.00000000 /* DNG */,
  0.00000000 /* DNH */,
  0.00000000 /* DNK */,
  0.00000000 /* DNM */,
  0.00000007 /* DNN */,
  0.00000000 /* DNR */,
  0.00000000 /* DNS */,
  0.00000000 /* DNT */,
  0.00000000 /* DNU */,
  0.00000000 /* DNV */,
  0.00000000 /* DNW */,
  0.00000000 /* DNY */,
  0.00000000 /* DRA */,
  0.00000000 /* DRB */,
  0.00000000 /* DRC */,
  0.00000000 /* DRD */,
  0.00000000 /* DRG */,
  0.00000000 /* DRH */,
  0.00000000 /* DRK */,
  0.00000000 /* DRM */,
  0.00000000 /* DRN */,
  0.00000000 /* DRR */,
  0.00000000 /* DRS */,
  0.00000000 /* DRT */,
  0.00000000 /* DRU */,
  0.00000000 /* DRV */,
  0.00000000 /* DRW */,
  0.00000000 /* DRY */,
  0.00000000 /* DSA */,
  0.00000000 /* DSB */,
  0.00000003 /* DSC */,
  0.00000000 /* DSD */,
  0.00000003 /* DSG */,
  0.00000000 /* DSH */,
  0.00000000 /* DSK */,
  0.00000000 /* DSM */,
  0.00000000 /* DSN */,
  0.00000000 /* DSR */,
  0.00000000 /* DSS */,
  0.00000003 /* DST */,
  0.00000000 /* DSU */,
  0.00000000 /* DSV */,
  0.00000000 /* DSW */,
  0.00000000 /* DSY */,
  0.00000007 /* DTA */,
  0.00000000 /* DTB */,
  0.00000013 /* DTC */,
  0.00000003 /* DTD */,
  0.00000023 /* DTG */,
  0.00000000 /* DTH */,
  0.00000000 /* DTK */,
  0.00000000 /* DTM */,
  0.00000000 /* DTN */,
  0.00000000 /* DTR */,
  0.00000000 /* DTS */,
  0.00000016 /* DTT */,
  0.00000000 /* DTU */,
  0.00000000 /* DTV */,
  0.00000000 /* DTW */,
  0.00000000 /* DTY */,
  0.00000000 /* DUA */,
  0.00000000 /* DUB */,
  0.00000000 /* DUC */,
  0.00000000 /* DUD */,
  0.00000000 /* DUG */,
  0.00000000 /* DUH */,
  0.00000000 /* DUK */,
  0.00000000 /* DUM */,
  0.00000000 /* DUN */,
  0.00000000 /* DUR */,
  0.00000000 /* DUS */,
  0.00000000 /* DUT */,
  0.00000000 /* DUU */,
  0.00000000 /* DUV */,
  0.00000000 /* DUW */,
  0.00000000 /* DUY */,
  0.00000000 /* DVA */,
  0.00000000 /* DVB */,
  0.00000000 /* DVC */,
  0.00000000 /* DVD */,
  0.00000000 /* DVG */,
  0.00000000 /* DVH */,
  0.00000000 /* DVK */,
  0.00000000 /* DVM */,
  0.00000000 /* DVN */,
  0.00000000 /* DVR */,
  0.00000000 /* DVS */,
  0.00000003 /* DVT */,
  0.00000000 /* DVU */,
  0.00000000 /* DVV */,
  0.00000000 /* DVW */,
  0.00000000 /* DVY */,
  0.00000000 /* DWA */,
  0.00000000 /* DWB */,
  0.00000007 /* DWC */,
  0.00000000 /* DWD */,
  0.00000000 /* DWG */,
  0.00000000 /* DWH */,
  0.00000000 /* DWK */,
  0.00000000 /* DWM */,
  0.00000000 /* DWN */,
  0.00000000 /* DWR */,
  0.00000000 /* DWS */,
  0.00000000 /* DWT */,
  0.00000000 /* DWU */,
  0.00000000 /* DWV */,
  0.00000000 /* DWW */,
  0.00000000 /* DWY */,
  0.00000000 /* DYA */,
  0.00000000 /* DYB */,
  0.00000003 /* DYC */,
  0.00000000 /* DYD */,
  0.00000000 /* DYG */,
  0.00000000 /* DYH */,
  0.00000000 /* DYK */,
  0.00000000 /* DYM */,
  0.00000000 /* DYN */,
  0.00000000 /* DYR */,
  0.00000000 /* DYS */,
  0.00000000 /* DYT */,
  0.00000000 /* DYU */,
  0.00000000 /* DYV */,
  0.00000000 /* DYW */,
  0.00000000 /* DYY */,
  0.02445722 /* GAA */,
  0.00000033 /* GAB */,
  0.01925019 /* GAC */,
  0.00000023 /* GAD */,
  0.02753634 /* GAG */,
  0.00000036 /* GAH */,
  0.00000072 /* GAK */,
  0.00000244 /* GAM */,
  0.00085031 /* GAN */,
  0.00000208 /* GAR */,
  0.00000176 /* GAS */,
  0.02025872 /* GAT */,
  0.00000000 /* GAU */,
  0.00000078 /* GAV */,
  0.00000104 /* GAW */,
  0.00000107 /* GAY */,
  0.00000013 /* GBA */,
  0.00000000 /* GBB */,
  0.00000078 /* GBC */,
  0.00000000 /* GBD */,
  0.00000055 /* GBG */,
  0.00000000 /* GBH */,
  0.00000003 /* GBK */,
  0.00000000 /* GBM */,
  0.00000010 /* GBN */,
  0.00000000 /* GBR */,
  0.00000003 /* GBS */,
  0.00000088 /* GBT */,
  0.00000000 /* GBU */,
  0.00000000 /* GBV */,
  0.00000000 /* GBW */,
  0.00000000 /* GBY */,
  0.01664471 /* GCA */,
  0.00000036 /* GCB */,
  0.02260154 /* GCC */,
  0.00000013 /* GCD */,
  0.00941503 /* GCG */,
  0.00000016 /* GCH */,
  0.00000059 /* GCK */,
  0.00000078 /* GCM */,
  0.00044958 /* GCN */,
  0.00000068 /* GCR */,
  0.00000218 /* GCS */,
  0.02083745 /* GCT */,
  0.00000000 /* GCU */,
  0.00000033 /* GCV */,
  0.00000016 /* GCW */,
  0.00000094 /* GCY */,
  0.00000029 /* GDA */,
  0.00000000 /* GDB */,
  0.00000026 /* GDC */,
  0.00000007 /* GDD */,
  0.00000026 /* GDG */,
  0.00000000 /* GDH */,
  0.00000000 /* GDK */,
  0.00000000 /* GDM */,
  0.00000010 /* GDN */,
  0.00000007 /* GDR */,
  0.00000000 /* GDS */,
  0.00000046 /* GDT */,
  0.00000000 /* GDU */,
  0.00000000 /* GDV */,
  0.00000000 /* GDW */,
  0.00000000 /* GDY */,
  0.02053459 /* GGA */,
  0.00000072 /* GGB */,
  0.02018776 /* GGC */,
  0.00000046 /* GGD */,
  0.01686909 /* GGG */,
  0.00000029 /* GGH */,
  0.00000166 /* GGK */,
  0.00000212 /* GGM */,
  0.00111310 /* GGN */,
  0.00000365 /* GGR */,
  0.00000338 /* GGS */,
  0.01491414 /* GGT */,
  0.00000000 /* GGU */,
  0.00000124 /* GGV */,
  0.00000062 /* GGW */,
  0.00000124 /* GGY */,
  0.00000016 /* GHA */,
  0.00000000 /* GHB */,
  0.00000010 /* GHC */,
  0.00000000 /* GHD */,
  0.00000029 /* GHG */,
  0.00000003 /* GHH */,
  0.00000000 /* GHK */,
  0.00000000 /* GHM */,
  0.00000003 /* GHN */,
  0.00000000 /* GHR */,
  0.00000000 /* GHS */,
  0.00000016 /* GHT */,
  0.00000000 /* GHU */,
  0.00000000 /* GHV */,
  0.00000003 /* GHW */,
  0.00000003 /* GHY */,
  0.00000046 /* GKA */,
  0.00000000 /* GKB */,
  0.00000179 /* GKC */,
  0.00000000 /* GKD */,
  0.00000182 /* GKG */,
  0.00000000 /* GKH */,
  0.00000007 /* GKK */,
  0.00000000 /* GKM */,
  0.00000003 /* GKN */,
  0.00000000 /* GKR */,
  0.00000007 /* GKS */,
  0.00000130 /* GKT */,
  0.00000000 /* GKU */,
  0.00000007 /* GKV */,
  0.00000000 /* GKW */,
  0.00000000 /* GKY */,
  0.00000273 /* GMA */,
  0.00000007 /* GMB */,
  0.00000286 /* GMC */,
  0.00000000 /* GMD */,
  0.00000085 /* GMG */,
  0.00000003 /* GMH */,
  0.00000000 /* GMK */,
  0.00000016 /* GMM */,
  0.00000003 /* GMN */,
  0.00000007 /* GMR */,
  0.00000010 /* GMS */,
  0.00000062 /* GMT */,
  0.00000000 /* GMU */,
  0.00000000 /* GMV */,
  0.00000003 /* GMW */,
  0.00000020 /* GMY */,
  0.00071563 /* GNA */,
  0.00000003 /* GNB */,
  0.00091020 /* GNC */,
  0.00000003 /* GND */,
  0.00056959 /* GNG */,
  0.00000000 /* GNH */,
  0.00000000 /* GNK */,
  0.00000000 /* GNM */,
  0.00020059 /* GNN */,
  0.00000003 /* GNR */,
  0.00000000 /* GNS */,
  0.00077913 /* GNT */,
  0.00000000 /* GNU */,
  0.00000003 /* GNV */,
  0.00000000 /* GNW */,
  0.00000000 /* GNY */,
  0.00000368 /* GRA */,
  0.00000000 /* GRB */,
  0.00000176 /* GRC */,
  0.00000000 /* GRD */,
  0.00000518 /* GRG */,
  0.00000000 /* GRH */,
  0.00000000 /* GRK */,
  0.00000010 /* GRM */,
  0.00000000 /* GRN */,
  0.00000049 /* GRR */,
  0.00000007 /* GRS */,
  0.00000130 /* GRT */,
  0.00000000 /* GRU */,
  0.00000003 /* GRV */,
  0.00000013 /* GRW */,
  0.00000000 /* GRY */,
  0.00000225 /* GSA */,
  0.00000013 /* GSB */,
  0.00000430 /* GSC */,
  0.00000000 /* GSD */,
  0.00000293 /* GSG */,
  0.00000000 /* GSH */,
  0.00000000 /* GSK */,
  0.00000007 /* GSM */,
  0.00000007 /* GSN */,
  0.00000010 /* GSR */,
  0.00000016 /* GSS */,
  0.00000159 /* GST */,
  0.00000000 /* GSU */,
  0.00000000 /* GSV */,
  0.00000000 /* GSW */,
  0.00000000 /* GSY */,
  0.00829741 /* GTA */,
  0.00000107 /* GTB */,
  0.01542215 /* GTC */,
  0.00000020 /* GTD */,
  0.01995960 /* GTG */,
  0.00000016 /* GTH */,
  0.00000176 /* GTK */,
  0.00000042 /* GTM */,
  0.00089200 /* GTN */,
  0.00000065 /* GTR */,
  0.00000410 /* GTS */,
  0.01468917 /* GTT */,
  0.00000000 /* GTU */,
  0.00000039 /* GTV */,
  0.00000059 /* GTW */,
  0.00000107 /* GTY */,
  0.00000000 /* GUA */,
  0.00000000 /* GUB */,
  0.00000000 /* GUC */,
  0.00000000 /* GUD */,
  0.00000000 /* GUG */,
  0.00000000 /* GUH */,
  0.00000000 /* GUK */,
  0.00000000 /* GUM */,
  0.00000000 /* GUN */,
  0.00000000 /* GUR */,
  0.00000000 /* GUS */,
  0.00000000 /* GUT */,
  0.00000000 /* GUU */,
  0.00000000 /* GUV */,
  0.00000000 /* GUW */,
  0.00000000 /* GUY */,
  0.00000091 /* GVA */,
  0.00000000 /* GVB */,
  0.00000094 /* GVC */,
  0.00000000 /* GVD */,
  0.00000068 /* GVG */,
  0.00000000 /* GVH */,
  0.00000000 /* GVK */,
  0.00000007 /* GVM */,
  0.00000000 /* GVN */,
  0.00000003 /* GVR */,
  0.00000007 /* GVS */,
  0.00000039 /* GVT */,
  0.00000000 /* GVU */,
  0.00000003 /* GVV */,
  0.00000000 /* GVW */,
  0.00000003 /* GVY */,
  0.00000049 /* GWA */,
  0.00000003 /* GWB */,
  0.00000026 /* GWC */,
  0.00000000 /* GWD */,
  0.00000020 /* GWG */,
  0.00000000 /* GWH */,
  0.00000000 /* GWK */,
  0.00000003 /* GWM */,
  0.00000000 /* GWN */,
  0.00000000 /* GWR */,
  0.00000000 /* GWS */,
  0.00000094 /* GWT */,
  0.00000000 /* GWU */,
  0.00000000 /* GWV */,
  0.00000007 /* GWW */,
  0.00000003 /* GWY */,
  0.00000059 /* GYA */,
  0.00000000 /* GYB */,
  0.00000146 /* GYC */,
  0.00000000 /* GYD */,
  0.00000062 /* GYG */,
  0.00000000 /* GYH */,
  0.00000003 /* GYK */,
  0.00000000 /* GYM */,
  0.00000000 /* GYN */,
  0.00000003 /* GYR */,
  0.00000013 /* GYS */,
  0.00000247 /* GYT */,
  0.00000000 /* GYU */,
  0.00000000 /* GYV */,
  0.00000000 /* GYW */,
  0.00000023 /* GYY */,
  0.00000010 /* HAA */,
  0.00000003 /* HAB */,
  0.00000026 /* HAC */,
  0.00000000 /* HAD */,
  0.00000013 /* HAG */,
  0.00000007 /* HAH */,
  0.00000000 /* HAK */,
  0.00000000 /* HAM */,
  0.00000000 /* HAN */,
  0.00000000 /* HAR */,
  0.00000000 /* HAS */,
  0.00000016 /* HAT */,
  0.00000000 /* HAU */,
  0.00000000 /* HAV */,
  0.00000003 /* HAW */,
  0.00000000 /* HAY */,
  0.00000000 /* HBA */,
  0.00000000 /* HBB */,
  0.00000003 /* HBC */,
  0.00000000 /* HBD */,
  0.00000003 /* HBG */,
  0.00000000 /* HBH */,
  0.00000000 /* HBK */,
  0.00000000 /* HBM */,
  0.00000000 /* HBN */,
  0.00000000 /* HBR */,
  0.00000000 /* HBS */,
  0.00000003 /* HBT */,
  0.00000000 /* HBU */,
  0.00000000 /* HBV */,
  0.00000000 /* HBW */,
  0.00000000 /* HBY */,
  0.00000007 /* HCA */,
  0.00000000 /* HCB */,
  0.00000049 /* HCC */,
  0.00000000 /* HCD */,
  0.00000023 /* HCG */,
  0.00000000 /* HCH */,
  0.00000000 /* HCK */,
  0.00000000 /* HCM */,
  0.00000000 /* HCN */,
  0.00000000 /* HCR */,
  0.00000000 /* HCS */,
  0.00000020 /* HCT */,
  0.00000000 /* HCU */,
  0.00000000 /* HCV */,
  0.00000000 /* HCW */,
  0.00000000 /* HCY */,
  0.00000000 /* HDA */,
  0.00000000 /* HDB */,
  0.00000000 /* HDC */,
  0.00000000 /* HDD */,
  0.00000000 /* HDG */,
  0.00000000 /* HDH */,
  0.00000000 /* HDK */,
  0.00000000 /* HDM */,
  0.00000000 /* HDN */,
  0.00000000 /* HDR */,
  0.00000000 /* HDS */,
  0.00000000 /* HDT */,
  0.00000000 /* HDU */,
  0.00000000 /* HDV */,
  0.00000000 /* HDW */,
  0.00000000 /* HDY */,
  0.00000013 /* HGA */,
  0.00000000 /* HGB */,
  0.00000016 /* HGC */,
  0.00000000 /* HGD */,
  0.00000049 /* HGG */,
  0.00000000 /* HGH */,
  0.00000000 /* HGK */,
  0.00000000 /* HGM */,
  0.00000000 /* HGN */,
  0.00000000 /* HGR */,
  0.00000003 /* HGS */,
  0.00000007 /* HGT */,
  0.00000000 /* HGU */,
  0.00000000 /* HGV */,
  0.00000003 /* HGW */,
  0.00000000 /* HGY */,
  0.00000000 /* HHA */,
  0.00000000 /* HHB */,
  0.00000000 /* HHC */,
  0.00000000 /* HHD */,
  0.00000000 /* HHG */,
  0.00000003 /* HHH */,
  0.00000000 /* HHK */,
  0.00000000 /* HHM */,
  0.00000000 /* HHN */,
  0.00000000 /* HHR */,
  0.00000000 /* HHS */,
  0.00000003 /* HHT */,
  0.00000000 /* HHU */,
  0.00000000 /* HHV */,
  0.00000000 /* HHW */,
  0.00000000 /* HHY */,
  0.00000000 /* HKA */,
  0.00000000 /* HKB */,
  0.00000000 /* HKC */,
  0.00000000 /* HKD */,
  0.00000000 /* HKG */,
  0.00000000 /* HKH */,
  0.00000000 /* HKK */,
  0.00000000 /* HKM */,
  0.00000000 /* HKN */,
  0.00000000 /* HKR */,
  0.00000000 /* HKS */,
  0.00000000 /* HKT */,
  0.00000000 /* HKU */,
  0.00000000 /* HKV */,
  0.00000003 /* HKW */,
  0.00000000 /* HKY */,
  0.00000003 /* HMA */,
  0.00000000 /* HMB */,
  0.00000000 /* HMC */,
  0.00000000 /* HMD */,
  0.00000000 /* HMG */,
  0.00000000 /* HMH */,
  0.00000000 /* HMK */,
  0.00000000 /* HMM */,
  0.00000000 /* HMN */,
  0.00000000 /* HMR */,
  0.00000000 /* HMS */,
  0.00000000 /* HMT */,
  0.00000000 /* HMU */,
  0.00000000 /* HMV */,
  0.00000000 /* HMW */,
  0.00000000 /* HMY */,
  0.00000003 /* HNA */,
  0.00000000 /* HNB */,
  0.00000000 /* HNC */,
  0.00000000 /* HND */,
  0.00000010 /* HNG */,
  0.00000007 /* HNH */,
  0.00000000 /* HNK */,
  0.00000000 /* HNM */,
  0.00000000 /* HNN */,
  0.00000000 /* HNR */,
  0.00000000 /* HNS */,
  0.00000000 /* HNT */,
  0.00000000 /* HNU */,
  0.00000000 /* HNV */,
  0.00000000 /* HNW */,
  0.00000000 /* HNY */,
  0.00000003 /* HRA */,
  0.00000000 /* HRB */,
  0.00000000 /* HRC */,
  0.00000000 /* HRD */,
  0.00000000 /* HRG */,
  0.00000000 /* HRH */,
  0.00000000 /* HRK */,
  0.00000000 /* HRM */,
  0.00000000 /* HRN */,
  0.00000000 /* HRR */,
  0.00000000 /* HRS */,
  0.00000000 /* HRT */,
  0.00000000 /* HRU */,
  0.00000000 /* HRV */,
  0.00000000 /* HRW */,
  0.00000000 /* HRY */,
  0.00000000 /* HSA */,
  0.00000000 /* HSB */,
  0.00000000 /* HSC */,
  0.00000000 /* HSD */,
  0.00000000 /* HSG */,
  0.00000000 /* HSH */,
  0.00000000 /* HSK */,
  0.00000000 /* HSM */,
  0.00000000 /* HSN */,
  0.00000000 /* HSR */,
  0.00000000 /* HSS */,
  0.00000000 /* HST */,
  0.00000000 /* HSU */,
  0.00000000 /* HSV */,
  0.00000000 /* HSW */,
  0.00000000 /* HSY */,
  0.00000016 /* HTA */,
  0.00000000 /* HTB */,
  0.00000033 /* HTC */,
  0.00000000 /* HTD */,
  0.00000013 /* HTG */,
  0.00000007 /* HTH */,
  0.00000000 /* HTK */,
  0.00000000 /* HTM */,
  0.00000000 /* HTN */,
  0.00000000 /* HTR */,
  0.00000000 /* HTS */,
  0.00000026 /* HTT */,
  0.00000000 /* HTU */,
  0.00000000 /* HTV */,
  0.00000000 /* HTW */,
  0.00000000 /* HTY */,
  0.00000000 /* HUA */,
  0.00000000 /* HUB */,
  0.00000000 /* HUC */,
  0.00000000 /* HUD */,
  0.00000000 /* HUG */,
  0.00000000 /* HUH */,
  0.00000000 /* HUK */,
  0.00000000 /* HUM */,
  0.00000000 /* HUN */,
  0.00000000 /* HUR */,
  0.00000000 /* HUS */,
  0.00000000 /* HUT */,
  0.00000000 /* HUU */,
  0.00000000 /* HUV */,
  0.00000000 /* HUW */,
  0.00000000 /* HUY */,
  0.00000000 /* HVA */,
  0.00000000 /* HVB */,
  0.00000000 /* HVC */,
  0.00000000 /* HVD */,
  0.00000000 /* HVG */,
  0.00000000 /* HVH */,
  0.00000000 /* HVK */,
  0.00000000 /* HVM */,
  0.00000000 /* HVN */,
  0.00000000 /* HVR */,
  0.00000000 /* HVS */,
  0.00000000 /* HVT */,
  0.00000000 /* HVU */,
  0.00000000 /* HVV */,
  0.00000000 /* HVW */,
  0.00000000 /* HVY */,
  0.00000000 /* HWA */,
  0.00000000 /* HWB */,
  0.00000007 /* HWC */,
  0.00000000 /* HWD */,
  0.00000003 /* HWG */,
  0.00000000 /* HWH */,
  0.00000000 /* HWK */,
  0.00000000 /* HWM */,
  0.00000000 /* HWN */,
  0.00000000 /* HWR */,
  0.00000000 /* HWS */,
  0.00000000 /* HWT */,
  0.00000000 /* HWU */,
  0.00000000 /* HWV */,
  0.00000000 /* HWW */,
  0.00000000 /* HWY */,
  0.00000000 /* HYA */,
  0.00000000 /* HYB */,
  0.00000000 /* HYC */,
  0.00000000 /* HYD */,
  0.00000000 /* HYG */,
  0.00000000 /* HYH */,
  0.00000000 /* HYK */,
  0.00000000 /* HYM */,
  0.00000000 /* HYN */,
  0.00000000 /* HYR */,
  0.00000000 /* HYS */,
  0.00000007 /* HYT */,
  0.00000000 /* HYU */,
  0.00000000 /* HYV */,
  0.00000000 /* HYW */,
  0.00000007 /* HYY */,
  0.00000062 /* KAA */,
  0.00000003 /* KAB */,
  0.00000088 /* KAC */,
  0.00000000 /* KAD */,
  0.00000107 /* KAG */,
  0.00000000 /* KAH */,
  0.00000010 /* KAK */,
  0.00000000 /* KAM */,
  0.00000003 /* KAN */,
  0.00000000 /* KAR */,
  0.00000010 /* KAS */,
  0.00000072 /* KAT */,
  0.00000000 /* KAU */,
  0.00000000 /* KAV */,
  0.00000003 /* KAW */,
  0.00000007 /* KAY */,
  0.00000000 /* KBA */,
  0.00000003 /* KBB */,
  0.00000000 /* KBC */,
  0.00000000 /* KBD */,
  0.00000000 /* KBG */,
  0.00000000 /* KBH */,
  0.00000000 /* KBK */,
  0.00000000 /* KBM */,
  0.00000000 /* KBN */,
  0.00000000 /* KBR */,
  0.00000000 /* KBS */,
  0.00000010 /* KBT */,
  0.00000000 /* KBU */,
  0.00000000 /* KBV */,
  0.00000000 /* KBW */,
  0.00000000 /* KBY */,
  0.00000107 /* KCA */,
  0.00000000 /* KCB */,
  0.00000234 /* KCC */,
  0.00000000 /* KCD */,
  0.00000049 /* KCG */,
  0.00000000 /* KCH */,
  0.00000003 /* KCK */,
  0.00000000 /* KCM */,
  0.00000000 /* KCN */,
  0.00000000 /* KCR */,
  0.00000000 /* KCS */,
  0.00000133 /* KCT */,
  0.00000000 /* KCU */,
  0.00000000 /* KCV */,
  0.00000000 /* KCW */,
  0.00000000 /* KCY */,
  0.00000000 /* KDA */,
  0.00000000 /* KDB */,
  0.00000000 /* KDC */,
  0.00000003 /* KDD */,
  0.00000000 /* KDG */,
  0.00000000 /* KDH */,
  0.00000003 /* KDK */,
  0.00000000 /* KDM */,
  0.00000000 /* KDN */,
  0.00000000 /* KDR */,
  0.00000000 /* KDS */,
  0.00000000 /* KDT */,
  0.00000000 /* KDU */,
  0.00000000 /* KDV */,
  0.00000000 /* KDW */,
  0.00000000 /* KDY */,
  0.00000059 /* KGA */,
  0.00000003 /* KGB */,
  0.00000101 /* KGC */,
  0.00000000 /* KGD */,
  0.00000192 /* KGG */,
  0.00000000 /* KGH */,
  0.00000007 /* KGK */,
  0.00000000 /* KGM */,
  0.00000000 /* KGN */,
  0.00000003 /* KGR */,
  0.00000000 /* KGS */,
  0.00000085 /* KGT */,
  0.00000000 /* KGU */,
  0.00000000 /* KGV */,
  0.00000003 /* KGW */,
  0.00000003 /* KGY */,
  0.00000000 /* KHA */,
  0.00000000 /* KHB */,
  0.00000003 /* KHC */,
  0.00000000 /* KHD */,
  0.00000000 /* KHG */,
  0.00000000 /* KHH */,
  0.00000000 /* KHK */,
  0.00000000 /* KHM */,
  0.00000000 /* KHN */,
  0.00000000 /* KHR */,
  0.00000000 /* KHS */,
  0.00000000 /* KHT */,
  0.00000000 /* KHU */,
  0.00000000 /* KHV */,
  0.00000000 /* KHW */,
  0.00000000 /* KHY */,
  0.00000013 /* KKA */,
  0.00000000 /* KKB */,
  0.00000020 /* KKC */,
  0.00000000 /* KKD */,
  0.00000007 /* KKG */,
  0.00000003 /* KKH */,
  0.00000010 /* KKK */,
  0.00000000 /* KKM */,
  0.00000000 /* KKN */,
  0.00000000 /* KKR */,
  0.00000003 /* KKS */,
  0.00000033 /* KKT */,
  0.00000000 /* KKU */,
  0.00000000 /* KKV */,
  0.00000003 /* KKW */,
  0.00000000 /* KKY */,
  0.00000000 /* KMA */,
  0.00000000 /* KMB */,
  0.00000003 /* KMC */,
  0.00000000 /* KMD */,
  0.00000000 /* KMG */,
  0.00000000 /* KMH */,
  0.00000000 /* KMK */,
  0.00000000 /* KMM */,
  0.00000000 /* KMN */,
  0.00000000 /* KMR */,
  0.00000000 /* KMS */,
  0.00000000 /* KMT */,
  0.00000000 /* KMU */,
  0.00000000 /* KMV */,
  0.00000000 /* KMW */,
  0.00000000 /* KMY */,
  0.00000000 /* KNA */,
  0.00000000 /* KNB */,
  0.00000007 /* KNC */,
  0.00000000 /* KND */,
  0.00000003 /* KNG */,
  0.00000000 /* KNH */,
  0.00000000 /* KNK */,
  0.00000000 /* KNM */,
  0.00000007 /* KNN */,
  0.00000003 /* KNR */,
  0.00000000 /* KNS */,
  0.00000000 /* KNT */,
  0.00000000 /* KNU */,
  0.00000000 /* KNV */,
  0.00000000 /* KNW */,
  0.00000000 /* KNY */,
  0.00000000 /* KRA */,
  0.00000000 /* KRB */,
  0.00000000 /* KRC */,
  0.00000000 /* KRD */,
  0.00000003 /* KRG */,
  0.00000000 /* KRH */,
  0.00000000 /* KRK */,
  0.00000000 /* KRM */,
  0.00000000 /* KRN */,
  0.00000000 /* KRR */,
  0.00000000 /* KRS */,
  0.00000000 /* KRT */,
  0.00000000 /* KRU */,
  0.00000000 /* KRV */,
  0.00000000 /* KRW */,
  0.00000000 /* KRY */,
  0.00000003 /* KSA */,
  0.00000000 /* KSB */,
  0.00000007 /* KSC */,
  0.00000000 /* KSD */,
  0.00000003 /* KSG */,
  0.00000000 /* KSH */,
  0.00000000 /* KSK */,
  0.00000000 /* KSM */,
  0.00000000 /* KSN */,
  0.00000000 /* KSR */,
  0.00000000 /* KSS */,
  0.00000003 /* KST */,
  0.00000000 /* KSU */,
  0.00000000 /* KSV */,
  0.00000000 /* KSW */,
  0.00000000 /* KSY */,
  0.00000094 /* KTA */,
  0.00000003 /* KTB */,
  0.00000153 /* KTC */,
  0.00000000 /* KTD */,
  0.00000133 /* KTG */,
  0.00000000 /* KTH */,
  0.00000016 /* KTK */,
  0.00000000 /* KTM */,
  0.00000003 /* KTN */,
  0.00000000 /* KTR */,
  0.00000003 /* KTS */,
  0.00000192 /* KTT */,
  0.00000000 /* KTU */,
  0.00000000 /* KTV */,
  0.00000003 /* KTW */,
  0.00000003 /* KTY */,
  0.00000000 /* KUA */,
  0.00000000 /* KUB */,
  0.00000000 /* KUC */,
  0.00000000 /* KUD */,
  0.00000000 /* KUG */,
  0.00000000 /* KUH */,
  0.00000000 /* KUK */,
  0.00000000 /* KUM */,
  0.00000000 /* KUN */,
  0.00000000 /* KUR */,
  0.00000000 /* KUS */,
  0.00000000 /* KUT */,
  0.00000000 /* KUU */,
  0.00000000 /* KUV */,
  0.00000000 /* KUW */,
  0.00000000 /* KUY */,
  0.00000003 /* KVA */,
  0.00000000 /* KVB */,
  0.00000000 /* KVC */,
  0.00000000 /* KVD */,
  0.00000000 /* KVG */,
  0.00000000 /* KVH */,
  0.00000000 /* KVK */,
  0.00000000 /* KVM */,
  0.00000000 /* KVN */,
  0.00000000 /* KVR */,
  0.00000000 /* KVS */,
  0.00000000 /* KVT */,
  0.00000000 /* KVU */,
  0.00000000 /* KVV */,
  0.00000000 /* KVW */,
  0.00000000 /* KVY */,
  0.00000000 /* KWA */,
  0.00000000 /* KWB */,
  0.00000000 /* KWC */,
  0.00000000 /* KWD */,
  0.00000000 /* KWG */,
  0.00000000 /* KWH */,
  0.00000000 /* KWK */,
  0.00000000 /* KWM */,
  0.00000000 /* KWN */,
  0.00000000 /* KWR */,
  0.00000000 /* KWS */,
  0.00000007 /* KWT */,
  0.00000000 /* KWU */,
  0.00000000 /* KWV */,
  0.00000000 /* KWW */,
  0.00000000 /* KWY */,
  0.00000000 /* KYA */,
  0.00000000 /* KYB */,
  0.00000000 /* KYC */,
  0.00000000 /* KYD */,
  0.00000000 /* KYG */,
  0.00000000 /* KYH */,
  0.00000000 /* KYK */,
  0.00000000 /* KYM */,
  0.00000000 /* KYN */,
  0.00000000 /* KYR */,
  0.00000000 /* KYS */,
  0.00000010 /* KYT */,
  0.00000000 /* KYU */,
  0.00000000 /* KYV */,
  0.00000000 /* KYW */,
  0.00000003 /* KYY */,
  0.00000208 /* MAA */,
  0.00000003 /* MAB */,
  0.00000179 /* MAC */,
  0.00000000 /* MAD */,
  0.00000286 /* MAG */,
  0.00000000 /* MAH */,
  0.00000000 /* MAK */,
  0.00000010 /* MAM */,
  0.00000000 /* MAN */,
  0.00000010 /* MAR */,
  0.00000010 /* MAS */,
  0.00000104 /* MAT */,
  0.00000000 /* MAU */,
  0.00000003 /* MAV */,
  0.00000007 /* MAW */,
  0.00000003 /* MAY */,
  0.00000000 /* MBA */,
  0.00000000 /* MBB */,
  0.00000000 /* MBC */,
  0.00000000 /* MBD */,
  0.00000000 /* MBG */,
  0.00000000 /* MBH */,
  0.00000000 /* MBK */,
  0.00000000 /* MBM */,
  0.00000000 /* MBN */,
  0.00000000 /* MBR */,
  0.00000000 /* MBS */,
  0.00000000 /* MBT */,
  0.00000000 /* MBU */,
  0.00000000 /* MBV */,
  0.00000000 /* MBW */,
  0.00000000 /* MBY */,
  0.00000146 /* MCA */,
  0.00000003 /* MCB */,
  0.00000277 /* MCC */,
  0.00000000 /* MCD */,
  0.00000088 /* MCG */,
  0.00000000 /* MCH */,
  0.00000000 /* MCK */,
  0.00000013 /* MCM */,
  0.00000000 /* MCN */,
  0.00000000 /* MCR */,
  0.00000007 /* MCS */,
  0.00000117 /* MCT */,
  0.00000000 /* MCU */,
  0.00000000 /* MCV */,
  0.00000003 /* MCW */,
  0.00000003 /* MCY */,
  0.00000000 /* MDA */,
  0.00000000 /* MDB */,
  0.00000000 /* MDC */,
  0.00000000 /* MDD */,
  0.00000003 /* MDG */,
  0.00000000 /* MDH */,
  0.00000000 /* MDK */,
  0.00000000 /* MDM */,
  0.00000000 /* MDN */,
  0.00000000 /* MDR */,
  0.00000000 /* MDS */,
  0.00000000 /* MDT */,
  0.00000000 /* MDU */,
  0.00000000 /* MDV */,
  0.00000000 /* MDW */,
  0.00000000 /* MDY */,
  0.00000042 /* MGA */,
  0.00000000 /* MGB */,
  0.00000078 /* MGC */,
  0.00000000 /* MGD */,
  0.00000133 /* MGG */,
  0.00000000 /* MGH */,
  0.00000000 /* MGK */,
  0.00000010 /* MGM */,
  0.00000003 /* MGN */,
  0.00000003 /* MGR */,
  0.00000003 /* MGS */,
  0.00000049 /* MGT */,
  0.00000000 /* MGU */,
  0.00000000 /* MGV */,
  0.00000000 /* MGW */,
  0.00000000 /* MGY */,
  0.00000003 /* MHA */,
  0.00000000 /* MHB */,
  0.00000003 /* MHC */,
  0.00000000 /* MHD */,
  0.00000000 /* MHG */,
  0.00000000 /* MHH */,
  0.00000000 /* MHK */,
  0.00000000 /* MHM */,
  0.00000000 /* MHN */,
  0.00000000 /* MHR */,
  0.00000000 /* MHS */,
  0.00000003 /* MHT */,
  0.00000000 /* MHU */,
  0.00000000 /* MHV */,
  0.00000000 /* MHW */,
  0.00000000 /* MHY */,
  0.00000000 /* MKA */,
  0.00000000 /* MKB */,
  0.00000007 /* MKC */,
  0.00000000 /* MKD */,
  0.00000003 /* MKG */,
  0.00000000 /* MKH */,
  0.00000000 /* MKK */,
  0.00000000 /* MKM */,
  0.00000003 /* MKN */,
  0.00000000 /* MKR */,
  0.00000000 /* MKS */,
  0.00000000 /* MKT */,
  0.00000000 /* MKU */,
  0.00000000 /* MKV */,
  0.00000000 /* MKW */,
  0.00000000 /* MKY */,
  0.00000007 /* MMA */,
  0.00000000 /* MMB */,
  0.00000026 /* MMC */,
  0.00000000 /* MMD */,
  0.00000013 /* MMG */,
  0.00000000 /* MMH */,
  0.00000000 /* MMK */,
  0.00000000 /* MMM */,
  0.00000000 /* MMN */,
  0.00000000 /* MMR */,
  0.00000000 /* MMS */,
  0.00000003 /* MMT */,
  0.00000000 /* MMU */,
  0.00000000 /* MMV */,
  0.00000003 /* MMW */,
  0.00000000 /* MMY */,
  0.00000000 /* MNA */,
  0.00000000 /* MNB */,
  0.00000003 /* MNC */,
  0.00000000 /* MND */,
  0.00000003 /* MNG */,
  0.00000000 /* MNH */,
  0.00000000 /* MNK */,
  0.00000000 /* MNM */,
  0.00000000 /* MNN */,
  0.00000000 /* MNR */,
  0.00000000 /* MNS */,
  0.00000000 /* MNT */,
  0.00000000 /* MNU */,
  0.00000000 /* MNV */,
  0.00000000 /* MNW */,
  0.00000000 /* MNY */,
  0.00000003 /* MRA */,
  0.00000000 /* MRB */,
  0.00000003 /* MRC */,
  0.00000000 /* MRD */,
  0.00000003 /* MRG */,
  0.00000000 /* MRH */,
  0.00000000 /* MRK */,
  0.00000000 /* MRM */,
  0.00000000 /* MRN */,
  0.00000000 /* MRR */,
  0.00000000 /* MRS */,
  0.00000000 /* MRT */,
  0.00000000 /* MRU */,
  0.00000000 /* MRV */,
  0.00000000 /* MRW */,
  0.00000000 /* MRY */,
  0.00000003 /* MSA */,
  0.00000000 /* MSB */,
  0.00000003 /* MSC */,
  0.00000000 /* MSD */,
  0.00000010 /* MSG */,
  0.00000000 /* MSH */,
  0.00000000 /* MSK */,
  0.00000000 /* MSM */,
  0.00000000 /* MSN */,
  0.00000000 /* MSR */,
  0.00000000 /* MSS */,
  0.00000007 /* MST */,
  0.00000000 /* MSU */,
  0.00000000 /* MSV */,
  0.00000000 /* MSW */,
  0.00000000 /* MSY */,
  0.00000042 /* MTA */,
  0.00000000 /* MTB */,
  0.00000094 /* MTC */,
  0.00000000 /* MTD */,
  0.00000049 /* MTG */,
  0.00000000 /* MTH */,
  0.00000000 /* MTK */,
  0.00000007 /* MTM */,
  0.00000000 /* MTN */,
  0.00000003 /* MTR */,
  0.00000000 /* MTS */,
  0.00000062 /* MTT */,
  0.00000000 /* MTU */,
  0.00000000 /* MTV */,
  0.00000000 /* MTW */,
  0.00000003 /* MTY */,
  0.00000000 /* MUA */,
  0.00000000 /* MUB */,
  0.00000000 /* MUC */,
  0.00000000 /* MUD */,
  0.00000000 /* MUG */,
  0.00000000 /* MUH */,
  0.00000000 /* MUK */,
  0.00000000 /* MUM */,
  0.00000000 /* MUN */,
  0.00000000 /* MUR */,
  0.00000000 /* MUS */,
  0.00000000 /* MUT */,
  0.00000000 /* MUU */,
  0.00000000 /* MUV */,
  0.00000000 /* MUW */,
  0.00000000 /* MUY */,
  0.00000007 /* MVA */,
  0.00000000 /* MVB */,
  0.00000000 /* MVC */,
  0.00000000 /* MVD */,
  0.00000003 /* MVG */,
  0.00000000 /* MVH */,
  0.00000000 /* MVK */,
  0.00000000 /* MVM */,
  0.00000000 /* MVN */,
  0.00000000 /* MVR */,
  0.00000000 /* MVS */,
  0.00000003 /* MVT */,
  0.00000000 /* MVU */,
  0.00000000 /* MVV */,
  0.00000000 /* MVW */,
  0.00000000 /* MVY */,
  0.00000003 /* MWA */,
  0.00000000 /* MWB */,
  0.00000003 /* MWC */,
  0.00000000 /* MWD */,
  0.00000003 /* MWG */,
  0.00000000 /* MWH */,
  0.00000000 /* MWK */,
  0.00000000 /* MWM */,
  0.00000000 /* MWN */,
  0.00000000 /* MWR */,
  0.00000000 /* MWS */,
  0.00000000 /* MWT */,
  0.00000000 /* MWU */,
  0.00000000 /* MWV */,
  0.00000003 /* MWW */,
  0.00000000 /* MWY */,
  0.00000000 /* MYA */,
  0.00000000 /* MYB */,
  0.00000003 /* MYC */,
  0.00000000 /* MYD */,
  0.00000003 /* MYG */,
  0.00000000 /* MYH */,
  0.00000000 /* MYK */,
  0.00000000 /* MYM */,
  0.00000000 /* MYN */,
  0.00000000 /* MYR */,
  0.00000003 /* MYS */,
  0.00000003 /* MYT */,
  0.00000000 /* MYU */,
  0.00000000 /* MYV */,
  0.00000000 /* MYW */,
  0.00000000 /* MYY */,
  0.00077028 /* NAA */,
  0.00000000 /* NAB */,
  0.00063751 /* NAC */,
  0.00000000 /* NAD */,
  0.00080136 /* NAG */,
  0.00000000 /* NAH */,
  0.00000000 /* NAK */,
  0.00000003 /* NAM */,
  0.00019441 /* NAN */,
  0.00000003 /* NAR */,
  0.00000000 /* NAS */,
  0.00052584 /* NAT */,
  0.00000000 /* NAU */,
  0.00000000 /* NAV */,
  0.00000003 /* NAW */,
  0.00000000 /* NAY */,
  0.00000000 /* NBA */,
  0.00000000 /* NBB */,
  0.00000000 /* NBC */,
  0.00000000 /* NBD */,
  0.00000003 /* NBG */,
  0.00000000 /* NBH */,
  0.00000000 /* NBK */,
  0.00000000 /* NBM */,
  0.00000000 /* NBN */,
  0.00000000 /* NBR */,
  0.00000000 /* NBS */,
  0.00000003 /* NBT */,
  0.00000000 /* NBU */,
  0.00000000 /* NBV */,
  0.00000000 /* NBW */,
  0.00000000 /* NBY */,
  0.00060721 /* NCA */,
  0.00000000 /* NCB */,
  0.00089148 /* NCC */,
  0.00000000 /* NCD */,
  0.00037703 /* NCG */,
  0.00000000 /* NCH */,
  0.00000000 /* NCK */,
  0.00000000 /* NCM */,
  0.00014835 /* NCN */,
  0.00000000 /* NCR */,
  0.00000003 /* NCS */,
  0.00065720 /* NCT */,
  0.00000000 /* NCU */,
  0.00000000 /* NCV */,
  0.00000000 /* NCW */,
  0.00000000 /* NCY */,
  0.00000000 /* NDA */,
  0.00000000 /* NDB */,
  0.00000000 /* NDC */,
  0.00000000 /* NDD */,
  0.00000007 /* NDG */,
  0.00000000 /* NDH */,
  0.00000000 /* NDK */,
  0.00000000 /* NDM */,
  0.00000000 /* NDN */,
  0.00000000 /* NDR */,
  0.00000000 /* NDS */,
  0.00000003 /* NDT */,
  0.00000000 /* NDU */,
  0.00000000 /* NDV */,
  0.00000000 /* NDW */,
  0.00000000 /* NDY */,
  0.00039132 /* NGA */,
  0.00000003 /* NGB */,
  0.00046348 /* NGC */,
  0.00000000 /* NGD */,
  0.00065743 /* NGG */,
  0.00000000 /* NGH */,
  0.00000007 /* NGK */,
  0.00000003 /* NGM */,
  0.00015174 /* NGN */,
  0.00000007 /* NGR */,
  0.00000000 /* NGS */,
  0.00034038 /* NGT */,
  0.00000000 /* NGU */,
  0.00000007 /* NGV */,
  0.00000000 /* NGW */,
  0.00000000 /* NGY */,
  0.00000000 /* NHA */,
  0.00000000 /* NHB */,
  0.00000007 /* NHC */,
  0.00000000 /* NHD */,
  0.00000000 /* NHG */,
  0.00000003 /* NHH */,
  0.00000000 /* NHK */,
  0.00000000 /* NHM */,
  0.00000003 /* NHN */,
  0.00000000 /* NHR */,
  0.00000000 /* NHS */,
  0.00000000 /* NHT */,
  0.00000000 /* NHU */,
  0.00000000 /* NHV */,
  0.00000000 /* NHW */,
  0.00000000 /* NHY */,
  0.00000003 /* NKA */,
  0.00000000 /* NKB */,
  0.00000000 /* NKC */,
  0.00000000 /* NKD */,
  0.00000000 /* NKG */,
  0.00000000 /* NKH */,
  0.00000003 /* NKK */,
  0.00000000 /* NKM */,
  0.00000000 /* NKN */,
  0.00000000 /* NKR */,
  0.00000000 /* NKS */,
  0.00000000 /* NKT */,
  0.00000000 /* NKU */,
  0.00000000 /* NKV */,
  0.00000000 /* NKW */,
  0.00000000 /* NKY */,
  0.00000007 /* NMA */,
  0.00000000 /* NMB */,
  0.00000000 /* NMC */,
  0.00000000 /* NMD */,
  0.00000003 /* NMG */,
  0.00000000 /* NMH */,
  0.00000000 /* NMK */,
  0.00000000 /* NMM */,
  0.00000000 /* NMN */,
  0.00000000 /* NMR */,
  0.00000000 /* NMS */,
  0.00000000 /* NMT */,
  0.00000000 /* NMU */,
  0.00000000 /* NMV */,
  0.00000000 /* NMW */,
  0.00000000 /* NMY */,
  0.00015229 /* NNA */,
  0.00000010 /* NNB */,
  0.00019506 /* NNC */,
  0.00000003 /* NND */,
  0.00015939 /* NNG */,
  0.00000003 /* NNH */,
  0.00000003 /* NNK */,
  0.00000007 /* NNM */,
  0.00061522 /* NNN */,
  0.00000000 /* NNR */,
  0.00000000 /* NNS */,
  0.00017263 /* NNT */,
  0.00000000 /* NNU */,
  0.00000000 /* NNV */,
  0.00000000 /* NNW */,
  0.00000007 /* NNY */,
  0.00000000 /* NRA */,
  0.00000000 /* NRB */,
  0.00000003 /* NRC */,
  0.00000000 /* NRD */,
  0.00000007 /* NRG */,
  0.00000000 /* NRH */,
  0.00000000 /* NRK */,
  0.00000000 /* NRM */,
  0.00000000 /* NRN */,
  0.00000000 /* NRR */,
  0.00000000 /* NRS */,
  0.00000003 /* NRT */,
  0.00000000 /* NRU */,
  0.00000000 /* NRV */,
  0.00000000 /* NRW */,
  0.00000000 /* NRY */,
  0.00000007 /* NSA */,
  0.00000000 /* NSB */,
  0.00000000 /* NSC */,
  0.00000000 /* NSD */,
  0.00000000 /* NSG */,
  0.00000000 /* NSH */,
  0.00000000 /* NSK */,
  0.00000000 /* NSM */,
  0.00000000 /* NSN */,
  0.00000000 /* NSR */,
  0.00000003 /* NSS */,
  0.00000003 /* NST */,
  0.00000000 /* NSU */,
  0.00000000 /* NSV */,
  0.00000000 /* NSW */,
  0.00000000 /* NSY */,
  0.00028199 /* NTA */,
  0.00000003 /* NTB */,
  0.00074629 /* NTC */,
  0.00000000 /* NTD */,
  0.00075296 /* NTG */,
  0.00000000 /* NTH */,
  0.00000000 /* NTK */,
  0.00000000 /* NTM */,
  0.00022061 /* NTN */,
  0.00000000 /* NTR */,
  0.00000000 /* NTS */,
  0.00083563 /* NTT */,
  0.00000000 /* NTU */,
  0.00000000 /* NTV */,
  0.00000000 /* NTW */,
  0.00000007 /* NTY */,
  0.00000000 /* NUA */,
  0.00000000 /* NUB */,
  0.00000000 /* NUC */,
  0.00000000 /* NUD */,
  0.00000000 /* NUG */,
  0.00000000 /* NUH */,
  0.00000000 /* NUK */,
  0.00000000 /* NUM */,
  0.00000000 /* NUN */,
  0.00000000 /* NUR */,
  0.00000000 /* NUS */,
  0.00000000 /* NUT */,
  0.00000000 /* NUU */,
  0.00000000 /* NUV */,
  0.00000000 /* NUW */,
  0.00000000 /* NUY */,
  0.00000003 /* NVA */,
  0.00000000 /* NVB */,
  0.00000007 /* NVC */,
  0.00000000 /* NVD */,
  0.00000000 /* NVG */,
  0.00000000 /* NVH */,
  0.00000000 /* NVK */,
  0.00000003 /* NVM */,
  0.00000000 /* NVN */,
  0.00000000 /* NVR */,
  0.00000000 /* NVS */,
  0.00000007 /* NVT */,
  0.00000000 /* NVU */,
  0.00000003 /* NVV */,
  0.00000000 /* NVW */,
  0.00000000 /* NVY */,
  0.00000007 /* NWA */,
  0.00000000 /* NWB */,
  0.00000000 /* NWC */,
  0.00000000 /* NWD */,
  0.00000003 /* NWG */,
  0.00000000 /* NWH */,
  0.00000000 /* NWK */,
  0.00000000 /* NWM */,
  0.00000000 /* NWN */,
  0.00000000 /* NWR */,
  0.00000000 /* NWS */,
  0.00000003 /* NWT */,
  0.00000000 /* NWU */,
  0.00000000 /* NWV */,
  0.00000000 /* NWW */,
  0.00000000 /* NWY */,
  0.00000000 /* NYA */,
  0.00000000 /* NYB */,
  0.00000000 /* NYC */,
  0.00000000 /* NYD */,
  0.00000007 /* NYG */,
  0.00000000 /* NYH */,
  0.00000000 /* NYK */,
  0.00000000 /* NYM */,
  0.00000000 /* NYN */,
  0.00000000 /* NYR */,
  0.00000000 /* NYS */,
  0.00000003 /* NYT */,
  0.00000000 /* NYU */,
  0.00000000 /* NYV */,
  0.00000000 /* NYW */,
  0.00000000 /* NYY */,
  0.00000316 /* RAA */,
  0.00000000 /* RAB */,
  0.00000150 /* RAC */,
  0.00000000 /* RAD */,
  0.00000218 /* RAG */,
  0.00000000 /* RAH */,
  0.00000000 /* RAK */,
  0.00000007 /* RAM */,
  0.00000000 /* RAN */,
  0.00000016 /* RAR */,
  0.00000010 /* RAS */,
  0.00000078 /* RAT */,
  0.00000000 /* RAU */,
  0.00000000 /* RAV */,
  0.00000000 /* RAW */,
  0.00000000 /* RAY */,
  0.00000000 /* RBA */,
  0.00000000 /* RBB */,
  0.00000003 /* RBC */,
  0.00000003 /* RBD */,
  0.00000000 /* RBG */,
  0.00000000 /* RBH */,
  0.00000000 /* RBK */,
  0.00000000 /* RBM */,
  0.00000000 /* RBN */,
  0.00000000 /* RBR */,
  0.00000000 /* RBS */,
  0.00000003 /* RBT */,
  0.00000000 /* RBU */,
  0.00000000 /* RBV */,
  0.00000000 /* RBW */,
  0.00000000 /* RBY */,
  0.00000091 /* RCA */,
  0.00000000 /* RCB */,
  0.00000143 /* RCC */,
  0.00000000 /* RCD */,
  0.00000078 /* RCG */,
  0.00000000 /* RCH */,
  0.00000000 /* RCK */,
  0.00000003 /* RCM */,
  0.00000000 /* RCN */,
  0.00000007 /* RCR */,
  0.00000000 /* RCS */,
  0.00000085 /* RCT */,
  0.00000000 /* RCU */,
  0.00000000 /* RCV */,
  0.00000003 /* RCW */,
  0.00000000 /* RCY */,
  0.00000007 /* RDA */,
  0.00000000 /* RDB */,
  0.00000000 /* RDC */,
  0.00000000 /* RDD */,
  0.00000000 /* RDG */,
  0.00000000 /* RDH */,
  0.00000000 /* RDK */,
  0.00000000 /* RDM */,
  0.00000000 /* RDN */,
  0.00000000 /* RDR */,
  0.00000003 /* RDS */,
  0.00000000 /* RDT */,
  0.00000000 /* RDU */,
  0.00000000 /* RDV */,
  0.00000000 /* RDW */,
  0.00000000 /* RDY */,
  0.00000107 /* RGA */,
  0.00000000 /* RGB */,
  0.00000143 /* RGC */,
  0.00000000 /* RGD */,
  0.00000260 /* RGG */,
  0.00000000 /* RGH */,
  0.00000003 /* RGK */,
  0.00000000 /* RGM */,
  0.00000000 /* RGN */,
  0.00000016 /* RGR */,
  0.00000010 /* RGS */,
  0.00000098 /* RGT */,
  0.00000000 /* RGU */,
  0.00000003 /* RGV */,
  0.00000003 /* RGW */,
  0.00000000 /* RGY */,
  0.00000000 /* RHA */,
  0.00000000 /* RHB */,
  0.00000000 /* RHC */,
  0.00000000 /* RHD */,
  0.00000000 /* RHG */,
  0.00000000 /* RHH */,
  0.00000000 /* RHK */,
  0.00000000 /* RHM */,
  0.00000000 /* RHN */,
  0.00000000 /* RHR */,
  0.00000000 /* RHS */,
  0.00000003 /* RHT */,
  0.00000000 /* RHU */,
  0.00000000 /* RHV */,
  0.00000000 /* RHW */,
  0.00000000 /* RHY */,
  0.00000000 /* RKA */,
  0.00000000 /* RKB */,
  0.00000003 /* RKC */,
  0.00000000 /* RKD */,
  0.00000000 /* RKG */,
  0.00000000 /* RKH */,
  0.00000000 /* RKK */,
  0.00000000 /* RKM */,
  0.00000000 /* RKN */,
  0.00000000 /* RKR */,
  0.00000000 /* RKS */,
  0.00000000 /* RKT */,
  0.00000000 /* RKU */,
  0.00000000 /* RKV */,
  0.00000000 /* RKW */,
  0.00000000 /* RKY */,
  0.00000003 /* RMA */,
  0.00000000 /* RMB */,
  0.00000000 /* RMC */,
  0.00000000 /* RMD */,
  0.00000000 /* RMG */,
  0.00000000 /* RMH */,
  0.00000000 /* RMK */,
  0.00000003 /* RMM */,
  0.00000000 /* RMN */,
  0.00000000 /* RMR */,
  0.00000000 /* RMS */,
  0.00000003 /* RMT */,
  0.00000000 /* RMU */,
  0.00000000 /* RMV */,
  0.00000000 /* RMW */,
  0.00000000 /* RMY */,
  0.00000000 /* RNA */,
  0.00000000 /* RNB */,
  0.00000000 /* RNC */,
  0.00000000 /* RND */,
  0.00000007 /* RNG */,
  0.00000000 /* RNH */,
  0.00000000 /* RNK */,
  0.00000000 /* RNM */,
  0.00000000 /* RNN */,
  0.00000003 /* RNR */,
  0.00000000 /* RNS */,
  0.00000007 /* RNT */,
  0.00000000 /* RNU */,
  0.00000000 /* RNV */,
  0.00000000 /* RNW */,
  0.00000000 /* RNY */,
  0.00000026 /* RRA */,
  0.00000000 /* RRB */,
  0.00000010 /* RRC */,
  0.00000000 /* RRD */,
  0.00000026 /* RRG */,
  0.00000000 /* RRH */,
  0.00000000 /* RRK */,
  0.00000003 /* RRM */,
  0.00000000 /* RRN */,
  0.00000010 /* RRR */,
  0.00000000 /* RRS */,
  0.00000003 /* RRT */,
  0.00000000 /* RRU */,
  0.00000000 /* RRV */,
  0.00000000 /* RRW */,
  0.00000000 /* RRY */,
  0.00000007 /* RSA */,
  0.00000000 /* RSB */,
  0.00000010 /* RSC */,
  0.00000000 /* RSD */,
  0.00000010 /* RSG */,
  0.00000000 /* RSH */,
  0.00000000 /* RSK */,
  0.00000000 /* RSM */,
  0.00000000 /* RSN */,
  0.00000000 /* RSR */,
  0.00000000 /* RSS */,
  0.00000000 /* RST */,
  0.00000000 /* RSU */,
  0.00000000 /* RSV */,
  0.00000000 /* RSW */,
  0.00000000 /* RSY */,
  0.00000016 /* RTA */,
  0.00000000 /* RTB */,
  0.00000062 /* RTC */,
  0.00000000 /* RTD */,
  0.00000049 /* RTG */,
  0.00000000 /* RTH */,
  0.00000000 /* RTK */,
  0.00000003 /* RTM */,
  0.00000000 /* RTN */,
  0.00000000 /* RTR */,
  0.00000000 /* RTS */,
  0.00000042 /* RTT */,
  0.00000000 /* RTU */,
  0.00000000 /* RTV */,
  0.00000000 /* RTW */,
  0.00000000 /* RTY */,
  0.00000000 /* RUA */,
  0.00000000 /* RUB */,
  0.00000000 /* RUC */,
  0.00000000 /* RUD */,
  0.00000000 /* RUG */,
  0.00000000 /* RUH */,
  0.00000000 /* RUK */,
  0.00000000 /* RUM */,
  0.00000000 /* RUN */,
  0.00000000 /* RUR */,
  0.00000000 /* RUS */,
  0.00000000 /* RUT */,
  0.00000000 /* RUU */,
  0.00000000 /* RUV */,
  0.00000000 /* RUW */,
  0.00000000 /* RUY */,
  0.00000003 /* RVA */,
  0.00000000 /* RVB */,
  0.00000000 /* RVC */,
  0.00000000 /* RVD */,
  0.00000000 /* RVG */,
  0.00000000 /* RVH */,
  0.00000000 /* RVK */,
  0.00000000 /* RVM */,
  0.00000000 /* RVN */,
  0.00000000 /* RVR */,
  0.00000000 /* RVS */,
  0.00000000 /* RVT */,
  0.00000000 /* RVU */,
  0.00000000 /* RVV */,
  0.00000000 /* RVW */,
  0.00000000 /* RVY */,
  0.00000000 /* RWA */,
  0.00000000 /* RWB */,
  0.00000003 /* RWC */,
  0.00000000 /* RWD */,
  0.00000000 /* RWG */,
  0.00000000 /* RWH */,
  0.00000000 /* RWK */,
  0.00000003 /* RWM */,
  0.00000000 /* RWN */,
  0.00000000 /* RWR */,
  0.00000000 /* RWS */,
  0.00000000 /* RWT */,
  0.00000000 /* RWU */,
  0.00000000 /* RWV */,
  0.00000000 /* RWW */,
  0.00000000 /* RWY */,
  0.00000000 /* RYA */,
  0.00000000 /* RYB */,
  0.00000000 /* RYC */,
  0.00000000 /* RYD */,
  0.00000000 /* RYG */,
  0.00000000 /* RYH */,
  0.00000000 /* RYK */,
  0.00000000 /* RYM */,
  0.00000000 /* RYN */,
  0.00000000 /* RYR */,
  0.00000000 /* RYS */,
  0.00000000 /* RYT */,
  0.00000000 /* RYU */,
  0.00000000 /* RYV */,
  0.00000000 /* RYW */,
  0.00000000 /* RYY */,
  0.00000166 /* SAA */,
  0.00000000 /* SAB */,
  0.00000260 /* SAC */,
  0.00000000 /* SAD */,
  0.00000244 /* SAG */,
  0.00000000 /* SAH */,
  0.00000003 /* SAK */,
  0.00000020 /* SAM */,
  0.00000000 /* SAN */,
  0.00000003 /* SAR */,
  0.00000020 /* SAS */,
  0.00000120 /* SAT */,
  0.00000000 /* SAU */,
  0.00000000 /* SAV */,
  0.00000000 /* SAW */,
  0.00000000 /* SAY */,
  0.00000000 /* SBA */,
  0.00000000 /* SBB */,
  0.00000003 /* SBC */,
  0.00000000 /* SBD */,
  0.00000003 /* SBG */,
  0.00000000 /* SBH */,
  0.00000000 /* SBK */,
  0.00000000 /* SBM */,
  0.00000000 /* SBN */,
  0.00000000 /* SBR */,
  0.00000000 /* SBS */,
  0.00000000 /* SBT */,
  0.00000000 /* SBU */,
  0.00000003 /* SBV */,
  0.00000000 /* SBW */,
  0.00000000 /* SBY */,
  0.00000143 /* SCA */,
  0.00000003 /* SCB */,
  0.00000410 /* SCC */,
  0.00000000 /* SCD */,
  0.00000267 /* SCG */,
  0.00000000 /* SCH */,
  0.00000003 /* SCK */,
  0.00000010 /* SCM */,
  0.00000007 /* SCN */,
  0.00000000 /* SCR */,
  0.00000020 /* SCS */,
  0.00000182 /* SCT */,
  0.00000000 /* SCU */,
  0.00000000 /* SCV */,
  0.00000003 /* SCW */,
  0.00000010 /* SCY */,
  0.00000007 /* SDA */,
  0.00000000 /* SDB */,
  0.00000000 /* SDC */,
  0.00000000 /* SDD */,
  0.00000000 /* SDG */,
  0.00000000 /* SDH */,
  0.00000000 /* SDK */,
  0.00000000 /* SDM */,
  0.00000000 /* SDN */,
  0.00000000 /* SDR */,
  0.00000000 /* SDS */,
  0.00000000 /* SDT */,
  0.00000000 /* SDU */,
  0.00000000 /* SDV */,
  0.00000000 /* SDW */,
  0.00000000 /* SDY */,
  0.00000107 /* SGA */,
  0.00000003 /* SGB */,
  0.00000283 /* SGC */,
  0.00000000 /* SGD */,
  0.00000296 /* SGG */,
  0.00000000 /* SGH */,
  0.00000010 /* SGK */,
  0.00000007 /* SGM */,
  0.00000000 /* SGN */,
  0.00000007 /* SGR */,
  0.00000026 /* SGS */,
  0.00000140 /* SGT */,
  0.00000000 /* SGU */,
  0.00000007 /* SGV */,
  0.00000000 /* SGW */,
  0.00000013 /* SGY */,
  0.00000000 /* SHA */,
  0.00000000 /* SHB */,
  0.00000000 /* SHC */,
  0.00000000 /* SHD */,
  0.00000000 /* SHG */,
  0.00000000 /* SHH */,
  0.00000000 /* SHK */,
  0.00000000 /* SHM */,
  0.00000000 /* SHN */,
  0.00000000 /* SHR */,
  0.00000000 /* SHS */,
  0.00000000 /* SHT */,
  0.00000000 /* SHU */,
  0.00000000 /* SHV */,
  0.00000000 /* SHW */,
  0.00000000 /* SHY */,
  0.00000003 /* SKA */,
  0.00000000 /* SKB */,
  0.00000016 /* SKC */,
  0.00000000 /* SKD */,
  0.00000003 /* SKG */,
  0.00000000 /* SKH */,
  0.00000000 /* SKK */,
  0.00000000 /* SKM */,
  0.00000000 /* SKN */,
  0.00000000 /* SKR */,
  0.00000000 /* SKS */,
  0.00000003 /* SKT */,
  0.00000000 /* SKU */,
  0.00000000 /* SKV */,
  0.00000000 /* SKW */,
  0.00000000 /* SKY */,
  0.00000003 /* SMA */,
  0.00000000 /* SMB */,
  0.00000013 /* SMC */,
  0.00000000 /* SMD */,
  0.00000000 /* SMG */,
  0.00000000 /* SMH */,
  0.00000000 /* SMK */,
  0.00000000 /* SMM */,
  0.00000000 /* SMN */,
  0.00000000 /* SMR */,
  0.00000003 /* SMS */,
  0.00000000 /* SMT */,
  0.00000000 /* SMU */,
  0.00000000 /* SMV */,
  0.00000000 /* SMW */,
  0.00000000 /* SMY */,
  0.00000003 /* SNA */,
  0.00000000 /* SNB */,
  0.00000003 /* SNC */,
  0.00000000 /* SND */,
  0.00000000 /* SNG */,
  0.00000000 /* SNH */,
  0.00000000 /* SNK */,
  0.00000000 /* SNM */,
  0.00000000 /* SNN */,
  0.00000000 /* SNR */,
  0.00000003 /* SNS */,
  0.00000007 /* SNT */,
  0.00000000 /* SNU */,
  0.00000000 /* SNV */,
  0.00000000 /* SNW */,
  0.00000000 /* SNY */,
  0.00000016 /* SRA */,
  0.00000003 /* SRB */,
  0.00000007 /* SRC */,
  0.00000000 /* SRD */,
  0.00000016 /* SRG */,
  0.00000000 /* SRH */,
  0.00000000 /* SRK */,
  0.00000000 /* SRM */,
  0.00000000 /* SRN */,
  0.00000003 /* SRR */,
  0.00000000 /* SRS */,
  0.00000003 /* SRT */,
  0.00000000 /* SRU */,
  0.00000000 /* SRV */,
  0.00000000 /* SRW */,
  0.00000000 /* SRY */,
  0.00000010 /* SSA */,
  0.00000000 /* SSB */,
  0.00000029 /* SSC */,
  0.00000000 /* SSD */,
  0.00000020 /* SSG */,
  0.00000000 /* SSH */,
  0.00000000 /* SSK */,
  0.00000000 /* SSM */,
  0.00000000 /* SSN */,
  0.00000000 /* SSR */,
  0.00000007 /* SSS */,
  0.00000010 /* SST */,
  0.00000000 /* SSU */,
  0.00000000 /* SSV */,
  0.00000000 /* SSW */,
  0.00000000 /* SSY */,
  0.00000052 /* STA */,
  0.00000007 /* STB */,
  0.00000098 /* STC */,
  0.00000000 /* STD */,
  0.00000159 /* STG */,
  0.00000000 /* STH */,
  0.00000003 /* STK */,
  0.00000000 /* STM */,
  0.00000000 /* STN */,
  0.00000000 /* STR */,
  0.00000010 /* STS */,
  0.00000156 /* STT */,
  0.00000000 /* STU */,
  0.00000007 /* STV */,
  0.00000000 /* STW */,
  0.00000003 /* STY */,
  0.00000000 /* SUA */,
  0.00000000 /* SUB */,
  0.00000000 /* SUC */,
  0.00000000 /* SUD */,
  0.00000000 /* SUG */,
  0.00000000 /* SUH */,
  0.00000000 /* SUK */,
  0.00000000 /* SUM */,
  0.00000000 /* SUN */,
  0.00000000 /* SUR */,
  0.00000000 /* SUS */,
  0.00000000 /* SUT */,
  0.00000000 /* SUU */,
  0.00000000 /* SUV */,
  0.00000000 /* SUW */,
  0.00000000 /* SUY */,
  0.00000000 /* SVA */,
  0.00000000 /* SVB */,
  0.00000000 /* SVC */,
  0.00000000 /* SVD */,
  0.00000007 /* SVG */,
  0.00000000 /* SVH */,
  0.00000000 /* SVK */,
  0.00000000 /* SVM */,
  0.00000000 /* SVN */,
  0.00000000 /* SVR */,
  0.00000003 /* SVS */,
  0.00000000 /* SVT */,
  0.00000000 /* SVU */,
  0.00000003 /* SVV */,
  0.00000000 /* SVW */,
  0.00000000 /* SVY */,
  0.00000000 /* SWA */,
  0.00000000 /* SWB */,
  0.00000000 /* SWC */,
  0.00000000 /* SWD */,
  0.00000000 /* SWG */,
  0.00000000 /* SWH */,
  0.00000000 /* SWK */,
  0.00000000 /* SWM */,
  0.00000000 /* SWN */,
  0.00000000 /* SWR */,
  0.00000000 /* SWS */,
  0.00000000 /* SWT */,
  0.00000000 /* SWU */,
  0.00000000 /* SWV */,
  0.00000000 /* SWW */,
  0.00000000 /* SWY */,
  0.00000003 /* SYA */,
  0.00000000 /* SYB */,
  0.00000000 /* SYC */,
  0.00000000 /* SYD */,
  0.00000000 /* SYG */,
  0.00000000 /* SYH */,
  0.00000000 /* SYK */,
  0.00000000 /* SYM */,
  0.00000000 /* SYN */,
  0.00000000 /* SYR */,
  0.00000000 /* SYS */,
  0.00000003 /* SYT */,
  0.00000000 /* SYU */,
  0.00000000 /* SYV */,
  0.00000000 /* SYW */,
  0.00000000 /* SYY */,
  0.00000000 /* TAA */,
  0.00000013 /* TAB */,
  0.01161429 /* TAC */,
  0.00000010 /* TAD */,
  0.00000000 /* TAG */,
  0.00000013 /* TAH */,
  0.00000029 /* TAK */,
  0.00000094 /* TAM */,
  0.00022217 /* TAN */,
  0.00000000 /* TAR */,
  0.00000042 /* TAS */,
  0.00997329 /* TAT */,
  0.00000000 /* TAU */,
  0.00000007 /* TAV */,
  0.00000033 /* TAW */,
  0.00000029 /* TAY */,
  0.00000062 /* TBA */,
  0.00000007 /* TBB */,
  0.00000114 /* TBC */,
  0.00000000 /* TBD */,
  0.00000088 /* TBG */,
  0.00000000 /* TBH */,
  0.00000003 /* TBK */,
  0.00000003 /* TBM */,
  0.00000000 /* TBN */,
  0.00000000 /* TBR */,
  0.00000007 /* TBS */,
  0.00000062 /* TBT */,
  0.00000000 /* TBU */,
  0.00000003 /* TBV */,
  0.00000000 /* TBW */,
  0.00000010 /* TBY */,
  0.01375740 /* TCA */,
  0.00000029 /* TCB */,
  0.01789962 /* TCC */,
  0.00000016 /* TCD */,
  0.00760036 /* TCG */,
  0.00000010 /* TCH */,
  0.00000039 /* TCK */,
  0.00000065 /* TCM */,
  0.00030253 /* TCN */,
  0.00000026 /* TCR */,
  0.00000088 /* TCS */,
  0.01606178 /* TCT */,
  0.00000000 /* TCU */,
  0.00000013 /* TCV */,
  0.00000026 /* TCW */,
  0.00000098 /* TCY */,
  0.00000023 /* TDA */,
  0.00000000 /* TDB */,
  0.00000023 /* TDC */,
  0.00000007 /* TDD */,
  0.00000000 /* TDG */,
  0.00000000 /* TDH */,
  0.00000000 /* TDK */,
  0.00000000 /* TDM */,
  0.00000003 /* TDN */,
  0.00000000 /* TDR */,
  0.00000000 /* TDS */,
  0.00000016 /* TDT */,
  0.00000000 /* TDU */,
  0.00000000 /* TDV */,
  0.00000000 /* TDW */,
  0.00000000 /* TDY */,
  0.00000000 /* TGA */,
  0.00000023 /* TGB */,
  0.01280274 /* TGC */,
  0.00000010 /* TGD */,
  0.01585647 /* TGG */,
  0.00000020 /* TGH */,
  0.00000094 /* TGK */,
  0.00000081 /* TGM */,
  0.00043546 /* TGN */,
  0.00000117 /* TGR */,
  0.00000114 /* TGS */,
  0.01118456 /* TGT */,
  0.00000000 /* TGU */,
  0.00000026 /* TGV */,
  0.00000026 /* TGW */,
  0.00000124 /* TGY */,
  0.00000033 /* THA */,
  0.00000000 /* THB */,
  0.00000033 /* THC */,
  0.00000000 /* THD */,
  0.00000039 /* THG */,
  0.00000000 /* THH */,
  0.00000000 /* THK */,
  0.00000000 /* THM */,
  0.00000007 /* THN */,
  0.00000000 /* THR */,
  0.00000000 /* THS */,
  0.00000013 /* THT */,
  0.00000000 /* THU */,
  0.00000003 /* THV */,
  0.00000000 /* THW */,
  0.00000003 /* THY */,
  0.00000146 /* TKA */,
  0.00000000 /* TKB */,
  0.00000146 /* TKC */,
  0.00000000 /* TKD */,
  0.00000176 /* TKG */,
  0.00000000 /* TKH */,
  0.00000039 /* TKK */,
  0.00000000 /* TKM */,
  0.00000003 /* TKN */,
  0.00000000 /* TKR */,
  0.00000013 /* TKS */,
  0.00000215 /* TKT */,
  0.00000000 /* TKU */,
  0.00000010 /* TKV */,
  0.00000000 /* TKW */,
  0.00000000 /* TKY */,
  0.00000114 /* TMA */,
  0.00000003 /* TMB */,
  0.00000046 /* TMC */,
  0.00000000 /* TMD */,
  0.00000036 /* TMG */,
  0.00000000 /* TMH */,
  0.00000000 /* TMK */,
  0.00000007 /* TMM */,
  0.00000000 /* TMN */,
  0.00000000 /* TMR */,
  0.00000000 /* TMS */,
  0.00000049 /* TMT */,
  0.00000000 /* TMU */,
  0.00000000 /* TMV */,
  0.00000000 /* TMW */,
  0.00000003 /* TMY */,
  0.00057893 /* TNA */,
  0.00000003 /* TNB */,
  0.00076445 /* TNC */,
  0.00000007 /* TND */,
  0.00051064 /* TNG */,
  0.00000003 /* TNH */,
  0.00000003 /* TNK */,
  0.00000003 /* TNM */,
  0.00016420 /* TNN */,
  0.00000003 /* TNR */,
  0.00000000 /* TNS */,
  0.00080741 /* TNT */,
  0.00000000 /* TNU */,
  0.00000003 /* TNV */,
  0.00000000 /* TNW */,
  0.00000000 /* TNY */,
  0.00000000 /* TRA */,
  0.00000000 /* TRB */,
  0.00000026 /* TRC */,
  0.00000000 /* TRD */,
  0.00000036 /* TRG */,
  0.00000000 /* TRH */,
  0.00000000 /* TRK */,
  0.00000000 /* TRM */,
  0.00000003 /* TRN */,
  0.00000003 /* TRR */,
  0.00000000 /* TRS */,
  0.00000033 /* TRT */,
  0.00000000 /* TRU */,
  0.00000007 /* TRV */,
  0.00000000 /* TRW */,
  0.00000000 /* TRY */,
  0.00000133 /* TSA */,
  0.00000007 /* TSB */,
  0.00000234 /* TSC */,
  0.00000000 /* TSD */,
  0.00000189 /* TSG */,
  0.00000000 /* TSH */,
  0.00000003 /* TSK */,
  0.00000000 /* TSM */,
  0.00000000 /* TSN */,
  0.00000000 /* TSR */,
  0.00000003 /* TSS */,
  0.00000098 /* TST */,
  0.00000000 /* TSU */,
  0.00000000 /* TSV */,
  0.00000000 /* TSW */,
  0.00000000 /* TSY */,
  0.00802785 /* TTA */,
  0.00000081 /* TTB */,
  0.01977047 /* TTC */,
  0.00000007 /* TTD */,
  0.01450765 /* TTG */,
  0.00000062 /* TTH */,
  0.00000247 /* TTK */,
  0.00000101 /* TTM */,
  0.00095710 /* TTN */,
  0.00000059 /* TTR */,
  0.00000186 /* TTS */,
  0.01978180 /* TTT */,
  0.00000000 /* TTU */,
  0.00000013 /* TTV */,
  0.00000075 /* TTW */,
  0.00000322 /* TTY */,
  0.00000000 /* TUA */,
  0.00000000 /* TUB */,
  0.00000000 /* TUC */,
  0.00000000 /* TUD */,
  0.00000000 /* TUG */,
  0.00000000 /* TUH */,
  0.00000000 /* TUK */,
  0.00000000 /* TUM */,
  0.00000000 /* TUN */,
  0.00000000 /* TUR */,
  0.00000000 /* TUS */,
  0.00000000 /* TUT */,
  0.00000000 /* TUU */,
  0.00000000 /* TUV */,
  0.00000000 /* TUW */,
  0.00000000 /* TUY */,
  0.00000033 /* TVA */,
  0.00000000 /* TVB */,
  0.00000020 /* TVC */,
  0.00000000 /* TVD */,
  0.00000033 /* TVG */,
  0.00000000 /* TVH */,
  0.00000000 /* TVK */,
  0.00000003 /* TVM */,
  0.00000003 /* TVN */,
  0.00000000 /* TVR */,
  0.00000003 /* TVS */,
  0.00000020 /* TVT */,
  0.00000000 /* TVU */,
  0.00000000 /* TVV */,
  0.00000000 /* TVW */,
  0.00000003 /* TVY */,
  0.00000085 /* TWA */,
  0.00000000 /* TWB */,
  0.00000052 /* TWC */,
  0.00000000 /* TWD */,
  0.00000023 /* TWG */,
  0.00000000 /* TWH */,
  0.00000003 /* TWK */,
  0.00000000 /* TWM */,
  0.00000000 /* TWN */,
  0.00000003 /* TWR */,
  0.00000000 /* TWS */,
  0.00000072 /* TWT */,
  0.00000000 /* TWU */,
  0.00000000 /* TWV */,
  0.00000020 /* TWW */,
  0.00000000 /* TWY */,
  0.00000101 /* TYA */,
  0.00000007 /* TYB */,
  0.00000273 /* TYC */,
  0.00000000 /* TYD */,
  0.00000140 /* TYG */,
  0.00000003 /* TYH */,
  0.00000000 /* TYK */,
  0.00000003 /* TYM */,
  0.00000003 /* TYN */,
  0.00000003 /* TYR */,
  0.00000013 /* TYS */,
  0.00000264 /* TYT */,
  0.00000000 /* TYU */,
  0.00000000 /* TYV */,
  0.00000003 /* TYW */,
  0.00000039 /* TYY */,
  0.00000000 /* UAA */,
  0.00000000 /* UAB */,
  0.00000000 /* UAC */,
  0.00000000 /* UAD */,
  0.00000000 /* UAG */,
  0.00000000 /* UAH */,
  0.00000000 /* UAK */,
  0.00000000 /* UAM */,
  0.00000000 /* UAN */,
  0.00000000 /* UAR */,
  0.00000000 /* UAS */,
  0.00000000 /* UAT */,
  0.00000000 /* UAU */,
  0.00000000 /* UAV */,
  0.00000000 /* UAW */,
  0.00000000 /* UAY */,
  0.00000000 /* UBA */,
  0.00000000 /* UBB */,
  0.00000000 /* UBC */,
  0.00000000 /* UBD */,
  0.00000000 /* UBG */,
  0.00000000 /* UBH */,
  0.00000000 /* UBK */,
  0.00000000 /* UBM */,
  0.00000000 /* UBN */,
  0.00000000 /* UBR */,
  0.00000000 /* UBS */,
  0.00000000 /* UBT */,
  0.00000000 /* UBU */,
  0.00000000 /* UBV */,
  0.00000000 /* UBW */,
  0.00000000 /* UBY */,
  0.00000000 /* UCA */,
  0.00000000 /* UCB */,
  0.00000000 /* UCC */,
  0.00000000 /* UCD */,
  0.00000000 /* UCG */,
  0.00000000 /* UCH */,
  0.00000000 /* UCK */,
  0.00000000 /* UCM */,
  0.00000000 /* UCN */,
  0.00000000 /* UCR */,
  0.00000000 /* UCS */,
  0.00000000 /* UCT */,
  0.00000000 /* UCU */,
  0.00000000 /* UCV */,
  0.00000000 /* UCW */,
  0.00000000 /* UCY */,
  0.00000000 /* UDA */,
  0.00000000 /* UDB */,
  0.00000000 /* UDC */,
  0.00000000 /* UDD */,
  0.00000000 /* UDG */,
  0.00000000 /* UDH */,
  0.00000000 /* UDK */,
  0.00000000 /* UDM */,
  0.00000000 /* UDN */,
  0.00000000 /* UDR */,
  0.00000000 /* UDS */,
  0.00000000 /* UDT */,
  0.00000000 /* UDU */,
  0.00000000 /* UDV */,
  0.00000000 /* UDW */,
  0.00000000 /* UDY */,
  0.00000000 /* UGA */,
  0.00000000 /* UGB */,
  0.00000000 /* UGC */,
  0.00000000 /* UGD */,
  0.00000000 /* UGG */,
  0.00000000 /* UGH */,
  0.00000000 /* UGK */,
  0.00000000 /* UGM */,
  0.00000000 /* UGN */,
  0.00000000 /* UGR */,
  0.00000000 /* UGS */,
  0.00000000 /* UGT */,
  0.00000000 /* UGU */,
  0.00000000 /* UGV */,
  0.00000000 /* UGW */,
  0.00000000 /* UGY */,
  0.00000000 /* UHA */,
  0.00000000 /* UHB */,
  0.00000000 /* UHC */,
  0.00000000 /* UHD */,
  0.00000000 /* UHG */,
  0.00000000 /* UHH */,
  0.00000000 /* UHK */,
  0.00000000 /* UHM */,
  0.00000000 /* UHN */,
  0.00000000 /* UHR */,
  0.00000000 /* UHS */,
  0.00000000 /* UHT */,
  0.00000000 /* UHU */,
  0.00000000 /* UHV */,
  0.00000000 /* UHW */,
  0.00000000 /* UHY */,
  0.00000000 /* UKA */,
  0.00000000 /* UKB */,
  0.00000000 /* UKC */,
  0.00000000 /* UKD */,
  0.00000000 /* UKG */,
  0.00000000 /* UKH */,
  0.00000000 /* UKK */,
  0.00000000 /* UKM */,
  0.00000000 /* UKN */,
  0.00000000 /* UKR */,
  0.00000000 /* UKS */,
  0.00000000 /* UKT */,
  0.00000000 /* UKU */,
  0.00000000 /* UKV */,
  0.00000000 /* UKW */,
  0.00000000 /* UKY */,
  0.00000000 /* UMA */,
  0.00000000 /* UMB */,
  0.00000000 /* UMC */,
  0.00000000 /* UMD */,
  0.00000000 /* UMG */,
  0.00000000 /* UMH */,
  0.00000000 /* UMK */,
  0.00000000 /* UMM */,
  0.00000000 /* UMN */,
  0.00000000 /* UMR */,
  0.00000000 /* UMS */,
  0.00000000 /* UMT */,
  0.00000000 /* UMU */,
  0.00000000 /* UMV */,
  0.00000000 /* UMW */,
  0.00000000 /* UMY */,
  0.00000000 /* UNA */,
  0.00000000 /* UNB */,
  0.00000000 /* UNC */,
  0.00000000 /* UND */,
  0.00000000 /* UNG */,
  0.00000000 /* UNH */,
  0.00000000 /* UNK */,
  0.00000000 /* UNM */,
  0.00000000 /* UNN */,
  0.00000000 /* UNR */,
  0.00000000 /* UNS */,
  0.00000000 /* UNT */,
  0.00000000 /* UNU */,
  0.00000000 /* UNV */,
  0.00000000 /* UNW */,
  0.00000000 /* UNY */,
  0.00000000 /* URA */,
  0.00000000 /* URB */,
  0.00000000 /* URC */,
  0.00000000 /* URD */,
  0.00000000 /* URG */,
  0.00000000 /* URH */,
  0.00000000 /* URK */,
  0.00000000 /* URM */,
  0.00000000 /* URN */,
  0.00000000 /* URR */,
  0.00000000 /* URS */,
  0.00000000 /* URT */,
  0.00000000 /* URU */,
  0.00000000 /* URV */,
  0.00000000 /* URW */,
  0.00000000 /* URY */,
  0.00000000 /* USA */,
  0.00000000 /* USB */,
  0.00000000 /* USC */,
  0.00000000 /* USD */,
  0.00000000 /* USG */,
  0.00000000 /* USH */,
  0.00000000 /* USK */,
  0.00000000 /* USM */,
  0.00000000 /* USN */,
  0.00000000 /* USR */,
  0.00000000 /* USS */,
  0.00000000 /* UST */,
  0.00000000 /* USU */,
  0.00000000 /* USV */,
  0.00000000 /* USW */,
  0.00000000 /* USY */,
  0.00000000 /* UTA */,
  0.00000000 /* UTB */,
  0.00000000 /* UTC */,
  0.00000000 /* UTD */,
  0.00000000 /* UTG */,
  0.00000000 /* UTH */,
  0.00000000 /* UTK */,
  0.00000000 /* UTM */,
  0.00000000 /* UTN */,
  0.00000000 /* UTR */,
  0.00000000 /* UTS */,
  0.00000000 /* UTT */,
  0.00000000 /* UTU */,
  0.00000000 /* UTV */,
  0.00000000 /* UTW */,
  0.00000000 /* UTY */,
  0.00000000 /* UUA */,
  0.00000000 /* UUB */,
  0.00000000 /* UUC */,
  0.00000000 /* UUD */,
  0.00000000 /* UUG */,
  0.00000000 /* UUH */,
  0.00000000 /* UUK */,
  0.00000000 /* UUM */,
  0.00000000 /* UUN */,
  0.00000000 /* UUR */,
  0.00000000 /* UUS */,
  0.00000000 /* UUT */,
  0.00000000 /* UUU */,
  0.00000000 /* UUV */,
  0.00000000 /* UUW */,
  0.00000000 /* UUY */,
  0.00000000 /* UVA */,
  0.00000000 /* UVB */,
  0.00000000 /* UVC */,
  0.00000000 /* UVD */,
  0.00000000 /* UVG */,
  0.00000000 /* UVH */,
  0.00000000 /* UVK */,
  0.00000000 /* UVM */,
  0.00000000 /* UVN */,
  0.00000000 /* UVR */,
  0.00000000 /* UVS */,
  0.00000000 /* UVT */,
  0.00000000 /* UVU */,
  0.00000000 /* UVV */,
  0.00000000 /* UVW */,
  0.00000000 /* UVY */,
  0.00000000 /* UWA */,
  0.00000000 /* UWB */,
  0.00000000 /* UWC */,
  0.00000000 /* UWD */,
  0.00000000 /* UWG */,
  0.00000000 /* UWH */,
  0.00000000 /* UWK */,
  0.00000000 /* UWM */,
  0.00000000 /* UWN */,
  0.00000000 /* UWR */,
  0.00000000 /* UWS */,
  0.00000000 /* UWT */,
  0.00000000 /* UWU */,
  0.00000000 /* UWV */,
  0.00000000 /* UWW */,
  0.00000000 /* UWY */,
  0.00000000 /* UYA */,
  0.00000000 /* UYB */,
  0.00000000 /* UYC */,
  0.00000000 /* UYD */,
  0.00000000 /* UYG */,
  0.00000000 /* UYH */,
  0.00000000 /* UYK */,
  0.00000000 /* UYM */,
  0.00000000 /* UYN */,
  0.00000000 /* UYR */,
  0.00000000 /* UYS */,
  0.00000000 /* UYT */,
  0.00000000 /* UYU */,
  0.00000000 /* UYV */,
  0.00000000 /* UYW */,
  0.00000000 /* UYY */,
  0.00000052 /* VAA */,
  0.00000000 /* VAB */,
  0.00000107 /* VAC */,
  0.00000003 /* VAD */,
  0.00000107 /* VAG */,
  0.00000000 /* VAH */,
  0.00000000 /* VAK */,
  0.00000000 /* VAM */,
  0.00000003 /* VAN */,
  0.00000010 /* VAR */,
  0.00000003 /* VAS */,
  0.00000033 /* VAT */,
  0.00000000 /* VAU */,
  0.00000003 /* VAV */,
  0.00000000 /* VAW */,
  0.00000000 /* VAY */,
  0.00000000 /* VBA */,
  0.00000000 /* VBB */,
  0.00000000 /* VBC */,
  0.00000000 /* VBD */,
  0.00000000 /* VBG */,
  0.00000000 /* VBH */,
  0.00000000 /* VBK */,
  0.00000000 /* VBM */,
  0.00000000 /* VBN */,
  0.00000000 /* VBR */,
  0.00000000 /* VBS */,
  0.00000000 /* VBT */,
  0.00000000 /* VBU */,
  0.00000000 /* VBV */,
  0.00000000 /* VBW */,
  0.00000000 /* VBY */,
  0.00000049 /* VCA */,
  0.00000003 /* VCB */,
  0.00000078 /* VCC */,
  0.00000000 /* VCD */,
  0.00000029 /* VCG */,
  0.00000000 /* VCH */,
  0.00000000 /* VCK */,
  0.00000003 /* VCM */,
  0.00000003 /* VCN */,
  0.00000000 /* VCR */,
  0.00000003 /* VCS */,
  0.00000039 /* VCT */,
  0.00000000 /* VCU */,
  0.00000003 /* VCV */,
  0.00000000 /* VCW */,
  0.00000000 /* VCY */,
  0.00000003 /* VDA */,
  0.00000000 /* VDB */,
  0.00000000 /* VDC */,
  0.00000000 /* VDD */,
  0.00000000 /* VDG */,
  0.00000000 /* VDH */,
  0.00000000 /* VDK */,
  0.00000000 /* VDM */,
  0.00000000 /* VDN */,
  0.00000000 /* VDR */,
  0.00000000 /* VDS */,
  0.00000000 /* VDT */,
  0.00000000 /* VDU */,
  0.00000000 /* VDV */,
  0.00000000 /* VDW */,
  0.00000000 /* VDY */,
  0.00000036 /* VGA */,
  0.00000000 /* VGB */,
  0.00000065 /* VGC */,
  0.00000000 /* VGD */,
  0.00000072 /* VGG */,
  0.00000000 /* VGH */,
  0.00000003 /* VGK */,
  0.00000000 /* VGM */,
  0.00000000 /* VGN */,
  0.00000007 /* VGR */,
  0.00000007 /* VGS */,
  0.00000046 /* VGT */,
  0.00000000 /* VGU */,
  0.00000000 /* VGV */,
  0.00000000 /* VGW */,
  0.00000000 /* VGY */,
  0.00000000 /* VHA */,
  0.00000000 /* VHB */,
  0.00000000 /* VHC */,
  0.00000000 /* VHD */,
  0.00000000 /* VHG */,
  0.00000000 /* VHH */,
  0.00000000 /* VHK */,
  0.00000000 /* VHM */,
  0.00000000 /* VHN */,
  0.00000000 /* VHR */,
  0.00000000 /* VHS */,
  0.00000000 /* VHT */,
  0.00000000 /* VHU */,
  0.00000000 /* VHV */,
  0.00000000 /* VHW */,
  0.00000000 /* VHY */,
  0.00000000 /* VKA */,
  0.00000000 /* VKB */,
  0.00000000 /* VKC */,
  0.00000000 /* VKD */,
  0.00000000 /* VKG */,
  0.00000000 /* VKH */,
  0.00000000 /* VKK */,
  0.00000000 /* VKM */,
  0.00000000 /* VKN */,
  0.00000000 /* VKR */,
  0.00000000 /* VKS */,
  0.00000000 /* VKT */,
  0.00000000 /* VKU */,
  0.00000000 /* VKV */,
  0.00000000 /* VKW */,
  0.00000000 /* VKY */,
  0.00000003 /* VMA */,
  0.00000000 /* VMB */,
  0.00000000 /* VMC */,
  0.00000000 /* VMD */,
  0.00000000 /* VMG */,
  0.00000000 /* VMH */,
  0.00000000 /* VMK */,
  0.00000000 /* VMM */,
  0.00000000 /* VMN */,
  0.00000000 /* VMR */,
  0.00000000 /* VMS */,
  0.00000000 /* VMT */,
  0.00000000 /* VMU */,
  0.00000000 /* VMV */,
  0.00000000 /* VMW */,
  0.00000000 /* VMY */,
  0.00000003 /* VNA */,
  0.00000000 /* VNB */,
  0.00000000 /* VNC */,
  0.00000000 /* VND */,
  0.00000007 /* VNG */,
  0.00000000 /* VNH */,
  0.00000000 /* VNK */,
  0.00000000 /* VNM */,
  0.00000000 /* VNN */,
  0.00000000 /* VNR */,
  0.00000000 /* VNS */,
  0.00000003 /* VNT */,
  0.00000000 /* VNU */,
  0.00000003 /* VNV */,
  0.00000000 /* VNW */,
  0.00000000 /* VNY */,
  0.00000013 /* VRA */,
  0.00000000 /* VRB */,
  0.00000000 /* VRC */,
  0.00000000 /* VRD */,
  0.00000000 /* VRG */,
  0.00000000 /* VRH */,
  0.00000000 /* VRK */,
  0.00000000 /* VRM */,
  0.00000000 /* VRN */,
  0.00000000 /* VRR */,
  0.00000000 /* VRS */,
  0.00000003 /* VRT */,
  0.00000000 /* VRU */,
  0.00000000 /* VRV */,
  0.00000000 /* VRW */,
  0.00000000 /* VRY */,
  0.00000007 /* VSA */,
  0.00000000 /* VSB */,
  0.00000007 /* VSC */,
  0.00000000 /* VSD */,
  0.00000000 /* VSG */,
  0.00000000 /* VSH */,
  0.00000000 /* VSK */,
  0.00000000 /* VSM */,
  0.00000000 /* VSN */,
  0.00000000 /* VSR */,
  0.00000000 /* VSS */,
  0.00000000 /* VST */,
  0.00000000 /* VSU */,
  0.00000003 /* VSV */,
  0.00000000 /* VSW */,
  0.00000000 /* VSY */,
  0.00000020 /* VTA */,
  0.00000003 /* VTB */,
  0.00000039 /* VTC */,
  0.00000000 /* VTD */,
  0.00000016 /* VTG */,
  0.00000000 /* VTH */,
  0.00000000 /* VTK */,
  0.00000003 /* VTM */,
  0.00000000 /* VTN */,
  0.00000000 /* VTR */,
  0.00000000 /* VTS */,
  0.00000010 /* VTT */,
  0.00000000 /* VTU */,
  0.00000000 /* VTV */,
  0.00000000 /* VTW */,
  0.00000000 /* VTY */,
  0.00000000 /* VUA */,
  0.00000000 /* VUB */,
  0.00000000 /* VUC */,
  0.00000000 /* VUD */,
  0.00000000 /* VUG */,
  0.00000000 /* VUH */,
  0.00000000 /* VUK */,
  0.00000000 /* VUM */,
  0.00000000 /* VUN */,
  0.00000000 /* VUR */,
  0.00000000 /* VUS */,
  0.00000000 /* VUT */,
  0.00000000 /* VUU */,
  0.00000000 /* VUV */,
  0.00000000 /* VUW */,
  0.00000000 /* VUY */,
  0.00000007 /* VVA */,
  0.00000000 /* VVB */,
  0.00000003 /* VVC */,
  0.00000000 /* VVD */,
  0.00000010 /* VVG */,
  0.00000000 /* VVH */,
  0.00000000 /* VVK */,
  0.00000003 /* VVM */,
  0.00000000 /* VVN */,
  0.00000003 /* VVR */,
  0.00000003 /* VVS */,
  0.00000003 /* VVT */,
  0.00000000 /* VVU */,
  0.00000013 /* VVV */,
  0.00000000 /* VVW */,
  0.00000000 /* VVY */,
  0.00000000 /* VWA */,
  0.00000000 /* VWB */,
  0.00000000 /* VWC */,
  0.00000000 /* VWD */,
  0.00000000 /* VWG */,
  0.00000000 /* VWH */,
  0.00000000 /* VWK */,
  0.00000000 /* VWM */,
  0.00000000 /* VWN */,
  0.00000000 /* VWR */,
  0.00000000 /* VWS */,
  0.00000003 /* VWT */,
  0.00000000 /* VWU */,
  0.00000000 /* VWV */,
  0.00000000 /* VWW */,
  0.00000000 /* VWY */,
  0.00000000 /* VYA */,
  0.00000000 /* VYB */,
  0.00000003 /* VYC */,
  0.00000000 /* VYD */,
  0.00000000 /* VYG */,
  0.00000000 /* VYH */,
  0.00000000 /* VYK */,
  0.00000000 /* VYM */,
  0.00000000 /* VYN */,
  0.00000000 /* VYR */,
  0.00000000 /* VYS */,
  0.00000003 /* VYT */,
  0.00000000 /* VYU */,
  0.00000000 /* VYV */,
  0.00000000 /* VYW */,
  0.00000000 /* VYY */,
  0.00000065 /* WAA */,
  0.00000000 /* WAB */,
  0.00000049 /* WAC */,
  0.00000000 /* WAD */,
  0.00000055 /* WAG */,
  0.00000000 /* WAH */,
  0.00000003 /* WAK */,
  0.00000003 /* WAM */,
  0.00000000 /* WAN */,
  0.00000000 /* WAR */,
  0.00000000 /* WAS */,
  0.00000078 /* WAT */,
  0.00000000 /* WAU */,
  0.00000000 /* WAV */,
  0.00000000 /* WAW */,
  0.00000000 /* WAY */,
  0.00000000 /* WBA */,
  0.00000000 /* WBB */,
  0.00000003 /* WBC */,
  0.00000000 /* WBD */,
  0.00000000 /* WBG */,
  0.00000000 /* WBH */,
  0.00000000 /* WBK */,
  0.00000000 /* WBM */,
  0.00000000 /* WBN */,
  0.00000000 /* WBR */,
  0.00000000 /* WBS */,
  0.00000000 /* WBT */,
  0.00000000 /* WBU */,
  0.00000000 /* WBV */,
  0.00000000 /* WBW */,
  0.00000000 /* WBY */,
  0.00000029 /* WCA */,
  0.00000000 /* WCB */,
  0.00000026 /* WCC */,
  0.00000000 /* WCD */,
  0.00000020 /* WCG */,
  0.00000000 /* WCH */,
  0.00000000 /* WCK */,
  0.00000000 /* WCM */,
  0.00000003 /* WCN */,
  0.00000000 /* WCR */,
  0.00000003 /* WCS */,
  0.00000062 /* WCT */,
  0.00000000 /* WCU */,
  0.00000000 /* WCV */,
  0.00000000 /* WCW */,
  0.00000003 /* WCY */,
  0.00000000 /* WDA */,
  0.00000000 /* WDB */,
  0.00000000 /* WDC */,
  0.00000000 /* WDD */,
  0.00000000 /* WDG */,
  0.00000000 /* WDH */,
  0.00000003 /* WDK */,
  0.00000000 /* WDM */,
  0.00000000 /* WDN */,
  0.00000000 /* WDR */,
  0.00000000 /* WDS */,
  0.00000000 /* WDT */,
  0.00000000 /* WDU */,
  0.00000000 /* WDV */,
  0.00000000 /* WDW */,
  0.00000000 /* WDY */,
  0.00000020 /* WGA */,
  0.00000000 /* WGB */,
  0.00000033 /* WGC */,
  0.00000000 /* WGD */,
  0.00000029 /* WGG */,
  0.00000000 /* WGH */,
  0.00000003 /* WGK */,
  0.00000000 /* WGM */,
  0.00000000 /* WGN */,
  0.00000003 /* WGR */,
  0.00000000 /* WGS */,
  0.00000016 /* WGT */,
  0.00000000 /* WGU */,
  0.00000000 /* WGV */,
  0.00000000 /* WGW */,
  0.00000000 /* WGY */,
  0.00000000 /* WHA */,
  0.00000000 /* WHB */,
  0.00000003 /* WHC */,
  0.00000000 /* WHD */,
  0.00000000 /* WHG */,
  0.00000000 /* WHH */,
  0.00000003 /* WHK */,
  0.00000000 /* WHM */,
  0.00000000 /* WHN */,
  0.00000000 /* WHR */,
  0.00000000 /* WHS */,
  0.00000000 /* WHT */,
  0.00000000 /* WHU */,
  0.00000000 /* WHV */,
  0.00000000 /* WHW */,
  0.00000000 /* WHY */,
  0.00000000 /* WKA */,
  0.00000000 /* WKB */,
  0.00000000 /* WKC */,
  0.00000000 /* WKD */,
  0.00000000 /* WKG */,
  0.00000000 /* WKH */,
  0.00000000 /* WKK */,
  0.00000000 /* WKM */,
  0.00000000 /* WKN */,
  0.00000000 /* WKR */,
  0.00000000 /* WKS */,
  0.00000000 /* WKT */,
  0.00000000 /* WKU */,
  0.00000000 /* WKV */,
  0.00000000 /* WKW */,
  0.00000000 /* WKY */,
  0.00000007 /* WMA */,
  0.00000000 /* WMB */,
  0.00000000 /* WMC */,
  0.00000000 /* WMD */,
  0.00000000 /* WMG */,
  0.00000000 /* WMH */,
  0.00000000 /* WMK */,
  0.00000000 /* WMM */,
  0.00000000 /* WMN */,
  0.00000000 /* WMR */,
  0.00000000 /* WMS */,
  0.00000003 /* WMT */,
  0.00000000 /* WMU */,
  0.00000000 /* WMV */,
  0.00000000 /* WMW */,
  0.00000000 /* WMY */,
  0.00000000 /* WNA */,
  0.00000000 /* WNB */,
  0.00000003 /* WNC */,
  0.00000000 /* WND */,
  0.00000003 /* WNG */,
  0.00000000 /* WNH */,
  0.00000000 /* WNK */,
  0.00000000 /* WNM */,
  0.00000000 /* WNN */,
  0.00000003 /* WNR */,
  0.00000000 /* WNS */,
  0.00000007 /* WNT */,
  0.00000000 /* WNU */,
  0.00000000 /* WNV */,
  0.00000000 /* WNW */,
  0.00000000 /* WNY */,
  0.00000000 /* WRA */,
  0.00000000 /* WRB */,
  0.00000007 /* WRC */,
  0.00000000 /* WRD */,
  0.00000000 /* WRG */,
  0.00000000 /* WRH */,
  0.00000000 /* WRK */,
  0.00000000 /* WRM */,
  0.00000003 /* WRN */,
  0.00000000 /* WRR */,
  0.00000000 /* WRS */,
  0.00000000 /* WRT */,
  0.00000000 /* WRU */,
  0.00000000 /* WRV */,
  0.00000000 /* WRW */,
  0.00000000 /* WRY */,
  0.00000000 /* WSA */,
  0.00000000 /* WSB */,
  0.00000000 /* WSC */,
  0.00000000 /* WSD */,
  0.00000003 /* WSG */,
  0.00000000 /* WSH */,
  0.00000000 /* WSK */,
  0.00000000 /* WSM */,
  0.00000000 /* WSN */,
  0.00000000 /* WSR */,
  0.00000000 /* WSS */,
  0.00000000 /* WST */,
  0.00000000 /* WSU */,
  0.00000000 /* WSV */,
  0.00000000 /* WSW */,
  0.00000000 /* WSY */,
  0.00000055 /* WTA */,
  0.00000000 /* WTB */,
  0.00000049 /* WTC */,
  0.00000000 /* WTD */,
  0.00000059 /* WTG */,
  0.00000000 /* WTH */,
  0.00000003 /* WTK */,
  0.00000000 /* WTM */,
  0.00000000 /* WTN */,
  0.00000003 /* WTR */,
  0.00000003 /* WTS */,
  0.00000094 /* WTT */,
  0.00000000 /* WTU */,
  0.00000000 /* WTV */,
  0.00000000 /* WTW */,
  0.00000003 /* WTY */,
  0.00000000 /* WUA */,
  0.00000000 /* WUB */,
  0.00000000 /* WUC */,
  0.00000000 /* WUD */,
  0.00000000 /* WUG */,
  0.00000000 /* WUH */,
  0.00000000 /* WUK */,
  0.00000000 /* WUM */,
  0.00000000 /* WUN */,
  0.00000000 /* WUR */,
  0.00000000 /* WUS */,
  0.00000000 /* WUT */,
  0.00000000 /* WUU */,
  0.00000000 /* WUV */,
  0.00000000 /* WUW */,
  0.00000000 /* WUY */,
  0.00000000 /* WVA */,
  0.00000000 /* WVB */,
  0.00000000 /* WVC */,
  0.00000000 /* WVD */,
  0.00000000 /* WVG */,
  0.00000000 /* WVH */,
  0.00000000 /* WVK */,
  0.00000000 /* WVM */,
  0.00000000 /* WVN */,
  0.00000000 /* WVR */,
  0.00000000 /* WVS */,
  0.00000000 /* WVT */,
  0.00000000 /* WVU */,
  0.00000000 /* WVV */,
  0.00000000 /* WVW */,
  0.00000000 /* WVY */,
  0.00000003 /* WWA */,
  0.00000000 /* WWB */,
  0.00000000 /* WWC */,
  0.00000003 /* WWD */,
  0.00000010 /* WWG */,
  0.00000000 /* WWH */,
  0.00000003 /* WWK */,
  0.00000000 /* WWM */,
  0.00000000 /* WWN */,
  0.00000000 /* WWR */,
  0.00000000 /* WWS */,
  0.00000007 /* WWT */,
  0.00000000 /* WWU */,
  0.00000000 /* WWV */,
  0.00000000 /* WWW */,
  0.00000000 /* WWY */,
  0.00000000 /* WYA */,
  0.00000000 /* WYB */,
  0.00000000 /* WYC */,
  0.00000000 /* WYD */,
  0.00000000 /* WYG */,
  0.00000000 /* WYH */,
  0.00000000 /* WYK */,
  0.00000000 /* WYM */,
  0.00000000 /* WYN */,
  0.00000000 /* WYR */,
  0.00000000 /* WYS */,
  0.00000003 /* WYT */,
  0.00000000 /* WYU */,
  0.00000000 /* WYV */,
  0.00000000 /* WYW */,
  0.00000000 /* WYY */,
  0.00000062 /* YAA */,
  0.00000000 /* YAB */,
  0.00000072 /* YAC */,
  0.00000000 /* YAD */,
  0.00000052 /* YAG */,
  0.00000000 /* YAH */,
  0.00000000 /* YAK */,
  0.00000000 /* YAM */,
  0.00000000 /* YAN */,
  0.00000000 /* YAR */,
  0.00000003 /* YAS */,
  0.00000042 /* YAT */,
  0.00000000 /* YAU */,
  0.00000000 /* YAV */,
  0.00000000 /* YAW */,
  0.00000003 /* YAY */,
  0.00000000 /* YBA */,
  0.00000003 /* YBB */,
  0.00000007 /* YBC */,
  0.00000000 /* YBD */,
  0.00000003 /* YBG */,
  0.00000000 /* YBH */,
  0.00000003 /* YBK */,
  0.00000003 /* YBM */,
  0.00000000 /* YBN */,
  0.00000000 /* YBR */,
  0.00000000 /* YBS */,
  0.00000000 /* YBT */,
  0.00000000 /* YBU */,
  0.00000000 /* YBV */,
  0.00000000 /* YBW */,
  0.00000000 /* YBY */,
  0.00000111 /* YCA */,
  0.00000000 /* YCB */,
  0.00000348 /* YCC */,
  0.00000000 /* YCD */,
  0.00000062 /* YCG */,
  0.00000000 /* YCH */,
  0.00000000 /* YCK */,
  0.00000003 /* YCM */,
  0.00000000 /* YCN */,
  0.00000000 /* YCR */,
  0.00000003 /* YCS */,
  0.00000189 /* YCT */,
  0.00000000 /* YCU */,
  0.00000000 /* YCV */,
  0.00000000 /* YCW */,
  0.00000013 /* YCY */,
  0.00000000 /* YDA */,
  0.00000000 /* YDB */,
  0.00000003 /* YDC */,
  0.00000000 /* YDD */,
  0.00000000 /* YDG */,
  0.00000000 /* YDH */,
  0.00000000 /* YDK */,
  0.00000000 /* YDM */,
  0.00000000 /* YDN */,
  0.00000000 /* YDR */,
  0.00000000 /* YDS */,
  0.00000000 /* YDT */,
  0.00000000 /* YDU */,
  0.00000000 /* YDV */,
  0.00000000 /* YDW */,
  0.00000000 /* YDY */,
  0.00000046 /* YGA */,
  0.00000003 /* YGB */,
  0.00000059 /* YGC */,
  0.00000000 /* YGD */,
  0.00000088 /* YGG */,
  0.00000000 /* YGH */,
  0.00000003 /* YGK */,
  0.00000003 /* YGM */,
  0.00000003 /* YGN */,
  0.00000000 /* YGR */,
  0.00000000 /* YGS */,
  0.00000088 /* YGT */,
  0.00000000 /* YGU */,
  0.00000000 /* YGV */,
  0.00000000 /* YGW */,
  0.00000000 /* YGY */,
  0.00000000 /* YHA */,
  0.00000000 /* YHB */,
  0.00000007 /* YHC */,
  0.00000000 /* YHD */,
  0.00000003 /* YHG */,
  0.00000000 /* YHH */,
  0.00000000 /* YHK */,
  0.00000000 /* YHM */,
  0.00000000 /* YHN */,
  0.00000000 /* YHR */,
  0.00000000 /* YHS */,
  0.00000000 /* YHT */,
  0.00000000 /* YHU */,
  0.00000000 /* YHV */,
  0.00000000 /* YHW */,
  0.00000000 /* YHY */,
  0.00000003 /* YKA */,
  0.00000000 /* YKB */,
  0.00000007 /* YKC */,
  0.00000000 /* YKD */,
  0.00000007 /* YKG */,
  0.00000000 /* YKH */,
  0.00000000 /* YKK */,
  0.00000000 /* YKM */,
  0.00000000 /* YKN */,
  0.00000000 /* YKR */,
  0.00000003 /* YKS */,
  0.00000016 /* YKT */,
  0.00000000 /* YKU */,
  0.00000000 /* YKV */,
  0.00000000 /* YKW */,
  0.00000000 /* YKY */,
  0.00000000 /* YMA */,
  0.00000003 /* YMB */,
  0.00000010 /* YMC */,
  0.00000000 /* YMD */,
  0.00000000 /* YMG */,
  0.00000000 /* YMH */,
  0.00000000 /* YMK */,
  0.00000000 /* YMM */,
  0.00000000 /* YMN */,
  0.00000000 /* YMR */,
  0.00000000 /* YMS */,
  0.00000003 /* YMT */,
  0.00000000 /* YMU */,
  0.00000000 /* YMV */,
  0.00000000 /* YMW */,
  0.00000000 /* YMY */,
  0.00000003 /* YNA */,
  0.00000000 /* YNB */,
  0.00000000 /* YNC */,
  0.00000000 /* YND */,
  0.00000000 /* YNG */,
  0.00000000 /* YNH */,
  0.00000000 /* YNK */,
  0.00000000 /* YNM */,
  0.00000003 /* YNN */,
  0.00000000 /* YNR */,
  0.00000000 /* YNS */,
  0.00000007 /* YNT */,
  0.00000000 /* YNU */,
  0.00000000 /* YNV */,
  0.00000000 /* YNW */,
  0.00000003 /* YNY */,
  0.00000000 /* YRA */,
  0.00000000 /* YRB */,
  0.00000003 /* YRC */,
  0.00000000 /* YRD */,
  0.00000000 /* YRG */,
  0.00000000 /* YRH */,
  0.00000000 /* YRK */,
  0.00000000 /* YRM */,
  0.00000000 /* YRN */,
  0.00000000 /* YRR */,
  0.00000000 /* YRS */,
  0.00000000 /* YRT */,
  0.00000000 /* YRU */,
  0.00000000 /* YRV */,
  0.00000000 /* YRW */,
  0.00000000 /* YRY */,
  0.00000000 /* YSA */,
  0.00000000 /* YSB */,
  0.00000010 /* YSC */,
  0.00000000 /* YSD */,
  0.00000029 /* YSG */,
  0.00000000 /* YSH */,
  0.00000000 /* YSK */,
  0.00000000 /* YSM */,
  0.00000000 /* YSN */,
  0.00000000 /* YSR */,
  0.00000000 /* YSS */,
  0.00000007 /* YST */,
  0.00000000 /* YSU */,
  0.00000000 /* YSV */,
  0.00000000 /* YSW */,
  0.00000000 /* YSY */,
  0.00000104 /* YTA */,
  0.00000000 /* YTB */,
  0.00000264 /* YTC */,
  0.00000000 /* YTD */,
  0.00000182 /* YTG */,
  0.00000000 /* YTH */,
  0.00000016 /* YTK */,
  0.00000000 /* YTM */,
  0.00000000 /* YTN */,
  0.00000000 /* YTR */,
  0.00000003 /* YTS */,
  0.00000218 /* YTT */,
  0.00000000 /* YTU */,
  0.00000000 /* YTV */,
  0.00000003 /* YTW */,
  0.00000013 /* YTY */,
  0.00000000 /* YUA */,
  0.00000000 /* YUB */,
  0.00000000 /* YUC */,
  0.00000000 /* YUD */,
  0.00000000 /* YUG */,
  0.00000000 /* YUH */,
  0.00000000 /* YUK */,
  0.00000000 /* YUM */,
  0.00000000 /* YUN */,
  0.00000000 /* YUR */,
  0.00000000 /* YUS */,
  0.00000000 /* YUT */,
  0.00000000 /* YUU */,
  0.00000000 /* YUV */,
  0.00000000 /* YUW */,
  0.00000000 /* YUY */,
  0.00000003 /* YVA */,
  0.00000000 /* YVB */,
  0.00000000 /* YVC */,
  0.00000000 /* YVD */,
  0.00000000 /* YVG */,
  0.00000000 /* YVH */,
  0.00000000 /* YVK */,
  0.00000000 /* YVM */,
  0.00000000 /* YVN */,
  0.00000000 /* YVR */,
  0.00000000 /* YVS */,
  0.00000000 /* YVT */,
  0.00000000 /* YVU */,
  0.00000000 /* YVV */,
  0.00000000 /* YVW */,
  0.00000000 /* YVY */,
  0.00000000 /* YWA */,
  0.00000000 /* YWB */,
  0.00000003 /* YWC */,
  0.00000000 /* YWD */,
  0.00000000 /* YWG */,
  0.00000000 /* YWH */,
  0.00000000 /* YWK */,
  0.00000000 /* YWM */,
  0.00000000 /* YWN */,
  0.00000000 /* YWR */,
  0.00000000 /* YWS */,
  0.00000007 /* YWT */,
  0.00000000 /* YWU */,
  0.00000000 /* YWV */,
  0.00000003 /* YWW */,
  0.00000000 /* YWY */,
  0.00000007 /* YYA */,
  0.00000000 /* YYB */,
  0.00000042 /* YYC */,
  0.00000000 /* YYD */,
  0.00000010 /* YYG */,
  0.00000000 /* YYH */,
  0.00000000 /* YYK */,
  0.00000000 /* YYM */,
  0.00000000 /* YYN */,
  0.00000000 /* YYR */,
  0.00000000 /* YYS */,
  0.00000026 /* YYT */,
  0.00000000 /* YYU */,
  0.00000000 /* YYV */,
  0.00000000 /* YYW */,
  0.00000003 /* YYY */,
  /* }}} */
};

/*
 * Produce sequences by chaining together the products based on the cumulative
 * probabilities for each prefix up to order.
 *
 * out        write the sequences to this file or return them if this is null.
 * prng       the state for the pseudo-random number generator
 * psize      size of the products array; the number of different productions.
 * plen       length of an individual product string
 * products   the strings chained together to produce the sequences
 * order      the history that can be used; aka markov model order
 * cbg        the cumulative probabilites of each possible chain up to (order + 1) length
 * nseqs      the number of sequences to produce
 * min        the minimum number of products to chain together
 * max        the maximum number of products to chain together
 */
static SEQ_T** gen_symbols(FILE *out, mt_state* prng,
    int psize, int plen, char **products,
    int order, ARRAY_T *cbg,
    int nseqs, int min, int max) {
  int i, j, buffer_i, chain_i, chain_len, seq_len, buffer_len, end, offset;
  int low, high, mid;
  double x;
  int *history;
  SEQ_T **seqs;
  char *buffer, *p;
  STR_T *id, *desc;
  
  seqs = NULL;
  id = NULL;
  desc = NULL;
  if (out != NULL) {
    // create buffer so it is large enough to hold one line
    // plus a little extra if the product length doesn't divide
    // exactly into the line.
    buffer_len = LINE + (2 * plen) - 1;
    buffer = mm_malloc(sizeof(char) * (buffer_len + 1));
  } else {
    // create array to hold the seqs
    seqs = mm_malloc(sizeof(SEQ_T*) * nseqs);
    // create string buffer to hold id
    id = str_create(30);
    // create string buffer to hold description
    desc = str_create(30);
    // we will set these later - this stops the compiler complaining
    buffer_len = 0;
    buffer = NULL;
  }
  // now generate sequences
  history = mm_malloc(sizeof(int) * (order + 1));
  for (i = 0; i <= order; i++) history[order] = 0;
  for (i = 0; i < nseqs; i++) {
    // decide length of the sequence
    seq_len = min + (int)floor(mts_ldrand(prng) * (max - min + 1));
    chain_len = (seq_len / plen) + (seq_len % plen > 1 ? 1 : 0);
    if (out != NULL) {
      // print sequence header
      fprintf(out, ">SEQ_%d %d\n", (i+1), nseqs);
    } else {
      // create buffer that holds the entire sequence
      buffer_len = seq_len + (plen - 1);
      buffer = mm_malloc(sizeof(char) * (buffer_len + 1));
      str_setf(id, "SEQ_%d", (i+1));
      str_setf(desc, "%d", nseqs);
    }
    buffer_i = 0; chain_i = 0; end = 0;
    while (chain_i < chain_len || buffer_i) {
      if (chain_i < chain_len) {
        // produce next chunk
        j = (buffer_len - buffer_i) / plen;
        end = end + ((chain_len - end) < j ? (chain_len - end) : j);
        for (; chain_i < end; chain_i++) {
          // get offset into cbg
          // note that: history[0] == 0; this is intended!
          offset = (chain_i < order ? history[chain_i] : history[order]);
          // calculate a random number in the range 0 (inclusive) to 1 (exclusive)
          x = mts_ldrand(prng);
          // perform a binary search
          low = offset;
          high = offset + psize - 1;
          while (low < high) {
            mid = low + (high - low) / 2;
            if (x < get_array_item(mid, cbg)) {
              high = mid;
            } else {
              low = mid + 1;
            }
          }
          // low is now the index of the choosen symbol
          // copy the symbol(s) to the buffer
          for (p = products[low]; *p != '\0'; p++, buffer_i++) buffer[buffer_i] = *p;
          // update history
          for (j = order; j > 0; j--) {
            history[j] = (history[j-1] + (low + 1)) * psize;
          }
        }
        // on last production, truncate to sequence length if needed
        if (chain_i == chain_len && seq_len % plen != 0) {
          buffer_i -= (plen - (seq_len % plen));
        }
      }
      buffer[buffer_i] = '\0';
      // buffer is full
      if (out != NULL) {
        // print out the sequence up to LINE
        fprintf(out, "%.*s\n", (buffer_i < LINE ? buffer_i : LINE), buffer);
        // move remaining symbols to the start of the buffer
        for (j = LINE; j < buffer_i; j++) {
          buffer[j - LINE] = buffer[j];
        }
        if (buffer_i > LINE) {
          buffer_i -= LINE;
        } else {
          buffer_i = 0;
        }
      } else {
        // create the seq object
        seqs[i] = allocate_seq(str_internal(id), str_internal(desc), 0, buffer);
        free(buffer);
        buffer = NULL;
        buffer_i = 0;
        assert(chain_i == chain_len);
        break; // should exit loop anyway so just to make the intent clear
      }
    }
  }
  if (id) str_destroy(id, false);
  if (desc) str_destroy(desc, false);

  return seqs;
}

/*
 * generate sequences from codons.
 */
static void gen_codons(FILE *out, mt_state *prng, int nseqs, int min, int max) {
  int dna_asize, codon_asize, i, j, k, index;
  double sum;
  ARRAY_T *cbg;
  char **codons;
  // calculate the alphabet size
  dna_asize = strlen(dna);
  codon_asize = dna_asize * dna_asize * dna_asize;
  // setup the codon cumulative background
  cbg = allocate_array(codon_asize);
  sum = 0;
  for (i = 0; i < codon_asize; i++) {
    sum += fcodon[i];
    set_array_item(i, sum, cbg);
  }
  set_array_item(codon_asize - 1, 1.0, cbg);
  // setup the codons
  codons = mm_malloc(sizeof(char*) * codon_asize);
  for (i = 0, index = 0; i < dna_asize; i++) {
    for (j = 0; j < dna_asize; j++) {
      for (k = 0; k < dna_asize; k++) {
        codons[index] = mm_malloc(sizeof(char) * 4);
        codons[index][0] = dna[i];
        codons[index][1] = dna[j];
        codons[index][2] = dna[i];
        codons[index][3] = '\0';
        index++;
      }
    }
  }
  // output
  gen_symbols(out, prng, codon_asize, 3, codons, 0, cbg, nseqs, min, max);
  // cleanup
  for (i = 0; i < codon_asize; i++) free(codons[i]);
  free(codons);
  free_array(cbg);
}

/*
 * Generate sequences given an alphabet, a background and the frequency
 * of ambiguous characters.
 */
SEQ_T** gendb(
  FILE *out, // Output stream; return output if null.
  mt_state *prng, // pseudo-random number generator state
  ALPH_T *alph, // alphabet
  ARRAY_T *bg, // background model
  double ambig, // frequency of ambiguous characters
  int nseqs, // Number of sequences to generate
  int min, // Shortest possible sequence
  int max // Longest possible sequence
) {
  ARRAY_T *cbg; // cumulative background
  int asize, i, ntuples, order;
  double sum;
  char **symbols;
  SEQ_T **seqs;

  assert(ambig >= 0 && ambig < 1.0);
  // calculate the background model order
  i = 0; ntuples = 0;
  while (ntuples < get_array_length(bg)) ntuples += pow(alph_size_core(alph), ++i);
  if (ntuples != get_array_length(bg)) die("Background is not correct size");
  order = i - 1;
  // copy the background before we do anything with it
  cbg = allocate_array(get_array_length(bg));
  copy_array(bg, cbg);
  // work out what alphabet size we want to use
  if (ambig != 0) {
    // everything but the gap symbol
    asize = alph_size_all(alph);
    // extrapolate the background to cover the ambiguous symbols
    extrapolate_markov_model(alph_size_core(alph), asize, ambig, cbg);
  } else {
    // just the base alphabet
    asize = alph_size_core(alph);
  }
  // convert into a cumulative background for each possible prefix
  for (i = 0, sum = 0; i < get_array_length(cbg); i++) {
    if (i % asize == 0) {
      // scale probabilities for this prefix up to 1.0
      normalize_subarray(i, asize, 0.0, cbg);
      // start sum for cumulative bg
      sum = get_array_item(i, cbg);
    } else if ((i % asize) == (asize - 1)) {
      // make exactly 1, instead of just very close so the binary search doesn't break
      set_array_item(i, 1.0, cbg);
    } else {
      sum += get_array_item(i, cbg);
      set_array_item(i, sum, cbg);
    }
  }
  // create list of symbols
  symbols = mm_malloc(sizeof(char*) * asize);
  for (i = 0; i < asize; i++) {
    symbols[i] = mm_malloc(sizeof(char) * 2);
    symbols[i][0] = alph_char(alph, i);
    symbols[i][1] = '\0';
  }
  // make output
  seqs = gen_symbols(out, prng, asize, 1, symbols, order, cbg, nseqs, min, max);
  // clean up
  for (i = 0; i < asize; i++) free(symbols[i]);
  free(symbols);
  free_array(cbg);
  return seqs;
}

#ifdef MAIN

#define LOWEST 50     // shortest sequence
#define HIGHEST 2000  // longest sequence
#define MAX_ORDER 10  // largest Markov model order

#define STRINGIZER(arg) #arg
#define STR_VALUE(arg) STRINGIZER(arg)

typedef struct {
  mt_state prng;
  uint32_t seed;
  char *alph_file;
  char *bg_file;
  int bg_order;
  double ambig;
  long min;
  long max;
  long nseqs;
  int type;
  bool report;
} GENDB_T;

static void usage(char *format, ...) {
  va_list argp;
  char *usage = 
    "Usage:\n" 
    "  gendb [options] <sequence count>\n"
    "Options:\n"
    "  -alph <alphabet file>    Set the alphabet (overrides -type)\n"
    "  -ambig <ambig fraction>  Set the fraction of symbols that\n"
    "                             will be ambiguous (overrides -type)\n"
    "  -bfile <background file> Set the background\n"
    "  -minseq <min seq length> Set the minimum sequence length\n"
    "                             (default: " STR_VALUE(LOWEST) ")\n"
    "  -maxseq <max seq length> Set the maximum sequence length\n"
    "                             (default: " STR_VALUE(HIGHEST) ")\n"
    "  -order <bg model order>  Set the highest background order to load\n"
    "                             (default: load highest available)\n"
    "  -type 0|1|2|3|4          Set the alphabet type\n\n"
    "                             0 = Protein with 1\% ambiguous symbols (default)\n"
    "                             1 = DNA with 1\% ambiguous symbols\n"
    "                             2 = codons (ignores -bfile)\n"
    "                             3 = DNA without ambiguous symbols\n"
    "                             4 = Protein without ambiguous symbols\n"
    "  -dummy                   Add dummy sequence showing the configuration\n"
    "  -seed <seed>             Set the pseudo-random number generator seed\n"
    ;
  if (format) {
    va_start(argp, format);
    vfprintf(stderr, format, argp);
    va_end(argp);
    fprintf(stderr, "\n");
    fputs(usage, stderr);
    fflush(stderr);
  } else {
    fputs(usage, stderr);
  }
  exit(1);
}

/*
 * Processes the command line arguments passed to the program.
 */
static void process_arguments(int argc, char** argv, GENDB_T *config) {
  char *endptr;
  struct option gendb_options[] = {
    {"alph", required_argument, NULL, 'a'},
    {"bfile", required_argument, NULL, 'b'},
    {"ambig", required_argument, NULL, 'f'},
    {"seed", required_argument, NULL, 's'},
    {"minseq", required_argument, NULL, 'm'},
    {"maxseq", required_argument, NULL, 'x'},
    {"order", required_argument, NULL, 'o'},
    {"type", required_argument, NULL, 't'},
    {"dummy", no_argument, NULL, 'r'},
    {NULL, 0, NULL, 0} //boundary indicator
  };

  // initilize
  config->seed = mts_seed(&(config->prng));
  config->alph_file = NULL;
  config->bg_file = NULL;
  config->bg_order = -1; // load what ever background was specified to the fullest
  config->ambig = -1; // will be set to default dependent on type
  config->min = -1; // will be filled with default LOWEST if not specified
  config->max = -1; // will be filled with default HIGHEST if not specified
  config->nseqs = 0; // must be specified
  config->type = 0; // default to protein w/ ambigs
  config->report = false;

  while (1) {
    int opt = getopt_long_only(argc, argv, "", gendb_options, NULL);
    if (opt == -1) break;
    switch (opt) {
      case 's': // pseudo-random number generator seed
        if (sscanf(optarg, "%" SCNu32, &(config->seed)) == 1) {
          mts_seed32new(&(config->prng), config->seed);
        } else {
          usage("Seed \"%s\" could not be interpreted as an unsigned 32bit integer", optarg);
        }
        break;
      case 'a': // alphabet file
        config->alph_file = optarg;
        break;
      case 'b': // background file
        config->bg_file = optarg;
        break;
      case 'o': // background file order
        config->bg_order = (int)strtol(optarg, &endptr, 10);
        if (*endptr != '\0') {
          usage("Background model order \"%s\" was not a number", optarg);
        } else if (config->bg_order < 0) {
          usage("Background model order \"%s\" cannot be negative", optarg);
        } else if (config->bg_order > MAX_ORDER) {
          usage("Background model order \"%s\" cannot exceed %d", optarg, MAX_ORDER);
        }
        break;
      case 'f': // ambiguous character frequency
        config->ambig = strtod(optarg, &endptr);
        if (*endptr != '\0') {
          usage("Ambiguous character frequency \"%s\" was not a number", optarg);
        } else if (config->ambig < 0) {
          usage("Ambiguous character frequency \"%s\" cannot be negative", optarg);
        }
        break;
      case 'm': // minimum sequence length
        errno = 0;
        config->min = strtol(optarg, &endptr, 10);
        if ((errno != 0 && config->min == 0) || *endptr != '\0') {
          usage("Minimum sequence length \"%s\" was not a number", optarg);
        } else if (config->min < 0) {
          usage("Minimum sequence length \"%s\" cannot be negative", optarg);
        } else if (config->max != -1 && config->max < config->min) {
          usage("Minimum sequence length (%d) must be smaller than or equal to "
              "the maximum sequence length (%d)", config->min, config->max);
        }
        break;
      case 'x': // maximum sequence length
        errno = 0;
        config->max = strtol(optarg, &endptr, 10);
        if ((errno != 0 && config->max == 0) || *endptr != '\0') {
          usage("Maximum sequence length \"%s\" was not a number", optarg);
        } else if (config->max < 0) {
          usage("Maximum sequence length \"%s\" cannot be negative", optarg);
        } else if (config->min != -1 && config->min > config->max) {
          usage("Maximum sequence length (%d) must be larger than or equal to "
              "the minimum sequence length (%d)", config->max, config->min);
        }
        break;
      case 't': // alphabet type
        errno = 0;
        config->type = (int)strtol(optarg, &endptr, 10);
        if ((errno != 0 && config->type == 0) || *endptr != '\0') {
          usage("Sequence type \"%s\" was not a number", optarg);
        } else if (!(config->type == 0 || config->type == 1 || config->type == 2
              || config->type == 3 || config->type == 4)) {
          usage("Sequence type \"%s\" was not one of the allowed "
              "options 0|1|2|3|4", optarg);
        }
        break;
      case 'r': // report the parameters in a dummy sequence
        config->report = true;
        break;
      case '?':
        usage(NULL);
    }
  }
  // sequence count
  if (optind >= argc) usage("Sequence count was not specified");
  config->nseqs = (int)strtol(argv[optind], &endptr, 10);
  if (*endptr != '\0') {
    usage("Sequence count \"%s\" was not a number", argv[optind]);
  } else if (config->nseqs < 1) {
    usage("Sequence count \"%s\" must be at least 1", optarg);
  }

  // if the sequence length was not set then fill in the defaults
  if (config->min == -1 && config->max == -1) {
    config->min = LOWEST;
    config->max = HIGHEST;
  } else if (config->min == -1) {
    config->min = (config->max < LOWEST ? config->max : LOWEST);
  } else if (config->max == -1) {
    config->max = (config->min > HIGHEST ? config->min : HIGHEST);
  }

  // set ambiguous character frequency
  if (config->ambig == -1) {
    switch (config->type) {
      case 0: // protein w/ ambigs
      case 1: // DNA w/ ambigs
        config->ambig = 0.01;
        break;
      case 3: // DNA (core only)
      case 4: // protein (core only)
        config->ambig = 0.0;
        break;
    }
  }
}

int main(int argc, char **argv) {
  GENDB_T config;
  ALPH_T *alph;
  ARRAY_T *bg;
  // process command line arguments
  process_arguments(argc, argv, &config);
  // load alphabet
  if (config.alph_file != NULL) {
    alph = alph_load(config.alph_file, true);
    if (alph == NULL) exit(EXIT_FAILURE);
  } else {
    switch (config.type) {
      case 0: case 4: default:
        alph = alph_protein();
        break;
      case 1: case 3:
        alph = alph_dna();
        break;
      case 2:
        gen_codons(stdout, &(config.prng), config.nseqs, config.min, config.max);
        return 0;
    }
  }
  // load frequency table
  if (config.bg_file != NULL) {
    int bg_order = config.bg_order;
    bg = load_markov_model(alph, &bg_order, config.bg_file);
  } else {
    // Note: get_nrdb_frequencies returns NULL if alph is not standard DNA or protein.
    bg = get_nrdb_frequencies(alph, NULL);
    if (! bg) bg = get_uniform_frequencies(alph, NULL);
  }

  // generate sequences
  gendb(stdout, &(config.prng), alph, bg, config.ambig, config.nseqs, config.min, config.max);

  // clean up
  alph_release(alph);
  free_array(bg);
  return 0;
}

#endif
