/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import org.globus.gram.GramJob;
import org.globus.tools.JobListener;

class InteractiveJobListener
extends JobListener {
    private boolean quiet;
    private boolean finished = false;

    public InteractiveJobListener(boolean quiet) {
        this.quiet = quiet;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.finished) {
            this.wait();
        }
    }

    public synchronized void statusChanged(GramJob job) {
        if (!this.quiet) {
            System.out.println("Job: " + job.getStatusAsString());
        }
        this.status = job.getStatus();
        if (this.status == 8) {
            this.finished = true;
            this.error = 0;
            this.notify();
        } else if (job.getStatus() == 4) {
            this.finished = true;
            this.error = job.getError();
            this.notify();
        }
    }
}

