/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.globus.rsl.NameValue;
import org.globus.rsl.RslEvaluationException;
import org.globus.rsl.Value;

public class NameOpValue
extends NameValue {
    public static final int EQ = 1;
    public static final int NEQ = 2;
    public static final int GT = 3;
    public static final int GTEQ = 4;
    public static final int LT = 5;
    public static final int LTEQ = 6;
    protected int operator;

    public NameOpValue(String attribute) {
        super(attribute);
    }

    public NameOpValue(String attribute, int op) {
        super(attribute);
        this.setOperator(op);
    }

    public NameOpValue(String attribute, int op, String strValue) {
        this(attribute, op);
        this.add(strValue);
    }

    public NameOpValue(String attribute, int op, String[] strValues) {
        this(attribute, op);
        this.add(strValues);
    }

    public NameOpValue(String attribute, int op, Value value) {
        this(attribute, op);
        this.add(value);
    }

    public void setOperator(int oper) {
        this.operator = oper;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getOperatorAsString() {
        return NameOpValue.getOperatorAsString(this.operator);
    }

    public static String getOperatorAsString(int op) {
        switch (op) {
            case 1: {
                return "=";
            }
            case 2: {
                return "!=";
            }
            case 3: {
                return ">";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return "<";
            }
            case 6: {
                return "<=";
            }
        }
        return "??";
    }

    public void add(Value value) {
        if (this.values == null) {
            this.values = new LinkedList();
        }
        this.values.add(value);
    }

    public void add(String strValue) {
        this.add(new Value(strValue));
    }

    public void add(String[] strValues) {
        if (strValues == null) {
            return;
        }
        if (this.values == null) {
            this.values = new LinkedList();
        }
        for (int i = 0; i < strValues.length; ++i) {
            this.values.add(new Value(strValues[i]));
        }
    }

    public void add(List list) {
        if (this.values == null) {
            this.values = new LinkedList();
        }
        this.values.add(list);
    }

    public List getValuesAsStrings(boolean includeNested) {
        return NameOpValue.getValuesAsString(this.getValues(), includeNested);
    }

    public static List getValuesAsString(List values, boolean includeNested) {
        if (values == null) {
            return null;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Value) {
                list.add(((Value)obj).getCompleteValue());
                continue;
            }
            if (!includeNested || !(obj instanceof List)) continue;
            list.add(NameOpValue.getValuesAsString((List)obj, includeNested));
        }
        return list;
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        buf.append("( ");
        buf.append(this.getAttribute());
        buf.append(" ");
        buf.append(NameOpValue.getOperatorAsString(this.operator));
        buf.append(" ");
        this.toRSLSub(this.getValues(), buf, explicitConcat);
        buf.append(" )");
    }

    private void toRSLSub(List values, StringBuffer buf, boolean explicitConcat) {
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Value) {
                ((Value)obj).toRSL(buf, explicitConcat);
            } else if (obj instanceof List) {
                buf.append("( ");
                this.toRSLSub((List)obj, buf, explicitConcat);
                buf.append(" )");
            } else {
                throw new RuntimeException("Invalid object in relation values");
            }
            if (!iter.hasNext()) continue;
            buf.append(" ");
        }
    }

    public NameOpValue evaluate(Map symbolTable) throws RslEvaluationException {
        List list = this.evaluateSub(this.values, symbolTable);
        NameOpValue newNV = new NameOpValue(this.getAttribute(), this.getOperator());
        newNV.setValues(list);
        return newNV;
    }

    private List evaluateSub(List values, Map symbolTable) throws RslEvaluationException {
        LinkedList<Object> newValues = new LinkedList<Object>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof Value) {
                String str = ((Value)obj).evaluate(symbolTable);
                newValues.add(new Value(str));
                continue;
            }
            if (obj instanceof List) {
                newValues.add(this.evaluateSub((List)obj, symbolTable));
                continue;
            }
            throw new RslEvaluationException("Invalid object in relation values");
        }
        return newValues;
    }
}

