/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.dashboard.servlet;

import edu.sdsc.nbcr.opal.dashboard.persistence.DBManager;
import edu.sdsc.nbcr.opal.dashboard.servlet.PlotterServlet;
import edu.sdsc.nbcr.opal.dashboard.util.DateHelper;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpalInfoServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((String)OpalInfoServlet.class.getName());
    private static final String SERVERINFO_JSP = "/dashboard-jsp/serverInfo.jsp";
    private static final String STATISTICS_JSP = "/dashboard-jsp/statistics.jsp";
    private static final String SYSINFO_JSP = "/dashboard-jsp/sysinfo.jsp";
    private static final String DOC_JSP = "/dashboard-jsp/documentation.jsp";
    private static final String HOME_JSP = "/dashboard-jsp/home.jsp";
    private static final String SERVICELIST_JSP = "/dashboard-jsp/serviceList.jsp";
    private static final String ERROR_JSP = "/dashboard-jsp/statistics_noDB.jsp";
    private String opalVersion = null;
    private String opalDataLifetime = null;
    private String opalUptimeCommand = "uptime";
    private String opalBuildDateCommand = "uname -a";
    private String opalWebsite = null;
    private String opalDocumentation = null;
    private String opalJobManager = null;
    private static String tomcatUrl = null;
    private String opalUrl = null;
    private Boolean dbUsed = Boolean.FALSE;
    private DBManager dbManager = null;

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        log.info((Object)"Loading OpalInfoServlet (init method).");
        try {
            this.opalVersion = config.getServletContext().getInitParameter("OPAL_VERSION");
            this.opalBuildDateCommand = config.getServletContext().getInitParameter("OPAL_BUILDDATE_COMMAND");
            this.opalUptimeCommand = config.getServletContext().getInitParameter("OPAL_UPTIME_COMMAND");
            this.opalWebsite = config.getServletContext().getInitParameter("OPAL_WEB_SITE");
            this.opalDocumentation = config.getServletContext().getInitParameter("OPAL_DOC");
            this.opalUrl = config.getServletContext().getInitParameter("OPAL_URL");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("An error occurred while initializing the OpalInfoServlet, impossible to load web.xml: " + e.getMessage()));
            this.dbManager = new DBManager();
            return;
        }
        Properties props = new Properties();
        String propsFileName = "opal.properties";
        Object databaseUrl = null;
        boolean initialized = false;
        try {
            props.load(PlotterServlet.class.getClassLoader().getResourceAsStream(propsFileName));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Impossible to load opal.properties: " + e.getMessage()));
            this.dbManager = new DBManager();
            return;
        }
        if (props.getProperty("opal.jobmanager") != null) {
            this.opalJobManager = props.getProperty("opal.jobmanager");
        }
        this.opalDataLifetime = props.getProperty("opal.datalifetime") != null ? props.getProperty("opal.datalifetime") : null;
        if (props.getProperty("tomcat.url") != null) {
            tomcatUrl = props.getProperty("tomcat.url");
        }
        this.dbManager = new DBManager();
        config.getServletContext().setAttribute("dbManager", (Object)this.dbManager);
        initialized = true;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.processRequest(req, res);
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String command = req.getParameter("command");
        if (this.dbManager == null) {
            String errorMsg = "There is a problem conecting to the Data base.<br/>";
            log.error((Object)("We had an error: " + errorMsg));
            req.setAttribute("error", (Object)errorMsg);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(ERROR_JSP);
            try {
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
            }
            catch (Exception e) {
                log.error((Object)"Impossible to forward to the error page...Don't know what else I can do....", (Throwable)e);
            }
            return;
        }
        if ("statistics".equals(command)) {
            if (this.dbManager == null || !this.dbManager.isConnected()) {
                String errorMsg = "The connection to the Data Base is not present.<br/> Either you are not using a DB or there are some problem in your configuration file. <br/>Please have a look at the opal WEB_INF/web.xml and WEB-INF/classes/opal.properties. <br/>";
                log.error((Object)("We had an error: " + errorMsg));
                req.setAttribute("error", (Object)errorMsg);
                RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(ERROR_JSP);
                try {
                    dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                }
                catch (Exception e) {
                    log.error((Object)"Impossible to forward to the error page...Don't know what else I can do....", (Throwable)e);
                }
                return;
            }
            String startDateStr = req.getParameter("startDate");
            String endDateStr = req.getParameter("endDate");
            try {
                DateHelper.parseDate(startDateStr);
                DateHelper.parseDate(endDateStr);
            }
            catch (ParseException e) {
                endDateStr = DateHelper.formatDate(DateHelper.getEndDate());
                startDateStr = DateHelper.formatDate(DateHelper.getStartDate());
            }
            req.setAttribute("startDate", (Object)startDateStr);
            req.setAttribute("endDate", (Object)endDateStr);
            String[] servicesName = this.dbManager.getServicesList();
            String[] servicesNameSelected = req.getParameterValues("servicesName");
            if (servicesNameSelected == null) {
                log.info((Object)"there was no service name selected in the request parameters, selecting all of them");
                servicesNameSelected = this.dbManager.getServicesList();
            }
            req.setAttribute("servicesNameSelected", (Object)servicesNameSelected);
            req.setAttribute("servicesName", (Object)servicesName);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(STATISTICS_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else if ("sysinfo".equals(command)) {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(SYSINFO_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else if ("docs".equals(command)) {
            req.setAttribute("opalDocumentation", (Object)this.opalDocumentation);
            req.setAttribute("opalWebsite", (Object)this.opalWebsite);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(DOC_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else if ("home".equals(command)) {
            req.setAttribute("opalWebsite", (Object)this.opalWebsite);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(HOME_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else if ("serviceList".equals(command)) {
            req.setAttribute("tomcatUrl", (Object)tomcatUrl);
            req.setAttribute("opalUrl", (Object)this.opalUrl);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(SERVICELIST_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else if ("serverInfo".equals(command)) {
            req.setAttribute("systemIPAddress", (Object)req.getLocalAddr());
            req.setAttribute("systemUptime", (Object)this.getUptime());
            req.setAttribute("systemBuildDate", (Object)this.getBuildDate());
            req.setAttribute("opalVersion", (Object)this.opalVersion);
            req.setAttribute("opalWebsite", (Object)this.opalWebsite);
            req.setAttribute("opalDocumentation", (Object)this.opalDocumentation);
            req.setAttribute("dbDriver", (Object)this.dbManager.getDriver());
            req.setAttribute("submissionSystem", (Object)this.opalJobManager);
            req.setAttribute("opalDataLifetime", (Object)this.opalDataLifetime);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(SERVERINFO_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        } else {
            req.setAttribute("opalWebsite", (Object)this.opalWebsite);
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(HOME_JSP);
            dispatcher.forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    public String exec(String command, String error) {
        String r = new String();
        try {
            Process child = Runtime.getRuntime().exec(command);
            child.waitFor();
            if (child.exitValue() != 0) {
                r = new String(error);
            } else {
                int c;
                InputStream in = child.getInputStream();
                while ((c = in.read()) != -1) {
                    r = r.concat(Character.toString((char)c));
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            r = new String(error);
        }
        log.debug((Object)("Exec: command = " + command + " result = " + r));
        return r;
    }

    public String getUptime() {
        return this.exec(this.opalUptimeCommand, "error, unable to determine uptime");
    }

    public String getBuildDate() {
        return this.exec(this.opalBuildDateCommand, "error, unable to determine build date");
    }

    public static String getTomcatUrl() {
        return tomcatUrl;
    }

    public void destroy() {
    }
}

