/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.common.TypeDeserializer;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.ArgumentsType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.FlagsType;
import edu.sdsc.nbcr.opal.GroupsType;
import edu.sdsc.nbcr.opal.IOType;
import edu.sdsc.nbcr.opal.ImplicitParamsType;
import edu.sdsc.nbcr.opal.ParamType;
import edu.sdsc.nbcr.opal.ParamsType;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.axis.types.IDRefs;
import org.apache.axis.types.Id;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class ArgValidator {
    private static Logger logger = Logger.getLogger((String)ArgValidator.class.getName());
    private ArgumentsType argDesc;

    public ArgValidator(ArgumentsType argDesc_) {
        logger.debug((Object)"called");
        this.argDesc = argDesc_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateParamType(String current, ParamsType param, String workingDir) throws FaultType {
        ParamType type = param.getParamType();
        Id id = param.getId();
        String[] values = param.getValue();
        if (values != null) {
            boolean found = false;
            for (int j = 0; j < values.length; ++j) {
                logger.debug((Object)("Comparing with value: " + values[j]));
                if (!current.equals(values[j])) continue;
                logger.debug((Object)("Value matches acceptable value: " + values[j]));
                found = true;
                break;
            }
            if (!found) {
                String msg = "Value: " + current + " not found on the list " + "of acceptable values for id: " + id;
                logger.error((Object)msg);
                throw new FaultType(msg);
            }
        }
        if (type.getValue().equals("INT")) {
            try {
                Integer.parseInt(current);
                logger.debug((Object)("Value: " + current + " is of valid type INT"));
                return true;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new FaultType("Parameter " + id + " expects integer value");
            }
        }
        if (type.getValue().equals("BOOL")) {
            try {
                Boolean.valueOf(current);
                logger.debug((Object)("Value: " + current + " is of valid type BOOL"));
                return true;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new FaultType("Parameter " + id + " expects boolean value");
            }
        }
        if (type.getValue().equals("FLOAT")) {
            try {
                Float.parseFloat(current);
                logger.debug((Object)("Value: " + current + " is of valid type FLOAT"));
                return true;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new FaultType("Parameter " + id + " expects float value");
            }
        }
        if (type.getValue().equals("STRING")) {
            return true;
        }
        if (type.getValue().equals("FILE")) {
            IOType ioType = param.getIoType();
            if (ioType == null) {
                ioType = IOType.INPUT;
            }
            if (!ioType.getValue().equals("INPUT") && !ioType.getValue().equals("INOUT")) {
                logger.debug((Object)("Not checking existence of OUTPUT file: " + current));
                return true;
            }
            String filePath = workingDir + File.separator + current;
            File test = new File(filePath);
            if (test.exists()) {
                logger.debug((Object)("Value: " + filePath + " is a valid FILE"));
                return true;
            }
            logger.error((Object)("File parameter: " + filePath + " for tag " + id + " doesn't exist"));
            throw new FaultType("File parameter: " + filePath + " for tag " + id + " doesn't exist");
        }
        try {
            new URL(current);
            logger.debug((Object)("Value: " + current + " is a valid URL"));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new FaultType("Parameter " + id + " expects a valid URL");
        }
    }

    public boolean validateArgList(String workingDir, String args) throws FaultType {
        boolean required;
        logger.info((Object)"called");
        if (args == null) {
            return true;
        }
        FlagsType[] flags = new FlagsType[]{};
        if (this.argDesc.getFlags() != null) {
            flags = this.argDesc.getFlags().getFlag();
        }
        Hashtable<String, FlagsType> flagsTable = new Hashtable<String, FlagsType>();
        for (int i = 0; i < flags.length; ++i) {
            flagsTable.put(flags[i].getTag(), flags[i]);
        }
        ParamsType[] taggedParams = new ParamsType[]{};
        if (this.argDesc.getTaggedParams() != null) {
            taggedParams = this.argDesc.getTaggedParams().getParam();
        }
        Hashtable<String, ParamsType> taggedParamsTable = new Hashtable<String, ParamsType>();
        for (int i = 0; i < taggedParams.length; ++i) {
            taggedParamsTable.put(taggedParams[i].getTag(), taggedParams[i]);
        }
        ParamsType[] untaggedParams = new ParamsType[]{};
        if (this.argDesc.getUntaggedParams() != null) {
            untaggedParams = this.argDesc.getUntaggedParams().getParam();
        }
        Hashtable<String, ParamsType> untaggedParamsTable = new Hashtable<String, ParamsType>();
        for (int i = 0; i < untaggedParams.length; ++i) {
            untaggedParamsTable.put(untaggedParams[i].getId().toString(), untaggedParams[i]);
        }
        GroupsType[] groups = new GroupsType[]{};
        if (this.argDesc.getGroups() != null) {
            groups = this.argDesc.getGroups().getGroup();
        }
        Hashtable<String, GroupsType> groupTable = new Hashtable<String, GroupsType>();
        for (int i = 0; i < groups.length; ++i) {
            groupTable.put(groups[i].getName(), groups[i]);
        }
        Hashtable<String, String> groupMap = new Hashtable<String, String>();
        for (int i = 0; i < groups.length; ++i) {
            IDRefs elements = groups[i].getElements();
            String elemString = elements.toString();
            String[] elemIDs = elemString.split("[\\s]+");
            for (int j = 0; j < elemIDs.length; ++j) {
                groupMap.put(elemIDs[j], groups[i].getName());
            }
        }
        String separator = null;
        if (this.argDesc.getTaggedParams() != null) {
            separator = this.argDesc.getTaggedParams().getSeparator();
        }
        logger.debug((Object)("Separator used is: " + separator));
        if (separator != null) {
            args = args.replaceAll(separator, " ");
        }
        logger.debug((Object)("Separated arguments: " + args));
        args = args.trim();
        HashSet<Id> present = new HashSet<Id>();
        if (!args.equals("")) {
            String[] argList = args.split("[\\s]+");
            int index = 0;
            int untaggedIndex = 0;
            boolean untagged = false;
            while (index < argList.length) {
                String msg;
                Id id;
                String current = argList[index];
                logger.debug((Object)("args[" + index + "]: " + current));
                if (flags != null && !untagged && flagsTable.containsKey(current)) {
                    logger.debug((Object)("Argument " + current + " matches flag"));
                    id = ((FlagsType)flagsTable.get(current)).getId();
                    present.add(id);
                    ++index;
                    continue;
                }
                if (taggedParams != null && !untagged && taggedParamsTable.containsKey(current)) {
                    logger.debug((Object)("Tag " + current + " matches tagged parameter"));
                    if (++index == argList.length) {
                        msg = "Too few arguments, can't find value for tag: " + current;
                        logger.error((Object)msg);
                        throw new FaultType(msg);
                    }
                    String tag = current;
                    ParamsType taggedParam = (ParamsType)taggedParamsTable.get(tag);
                    current = argList[index];
                    logger.debug((Object)("Received value: " + current + " for tag: " + tag));
                    this.validateParamType(current, taggedParam, workingDir);
                    present.add(taggedParam.getId());
                    ++index;
                    continue;
                }
                if (untaggedParams != null) {
                    if (untaggedIndex < untaggedParams.length) {
                        untagged = true;
                        id = untaggedParams[untaggedIndex].getId();
                        GroupsType group = null;
                        if (groupMap.containsKey(id.toString())) {
                            String groupName = (String)groupMap.get(id.toString());
                            logger.debug((Object)("Found group: " + groupName + " for param: " + id));
                            group = (GroupsType)groupTable.get(groupName);
                            if (group == null) {
                                logger.error((Object)("Can't find group in hash table: " + groupName));
                                throw new FaultType("Can't find group in hash table: " + groupName);
                            }
                        }
                        if (group != null && group.getExclusive() != null && group.getExclusive().booleanValue()) {
                            String elemString = group.getElements().toString();
                            String[] elemIDs = elemString.split("[\\s]+");
                            int size = 0;
                            for (int i = 0; i < elemIDs.length; ++i) {
                                if (!untaggedParamsTable.containsKey(elemIDs[i])) continue;
                                ++size;
                            }
                            if (size > 1) {
                                logger.debug((Object)("Skipping validation of untagged param: " + current));
                                logger.debug((Object)("Number of params to skip in exclusive group: " + size));
                                untaggedIndex += size;
                                ++index;
                                continue;
                            }
                        }
                        logger.debug((Object)("Checking if " + current + " is a valid untagged parameter" + " for id: " + id));
                        this.validateParamType(current, untaggedParams[untaggedIndex], workingDir);
                        logger.debug((Object)(current + " is a valid untagged parameter for id: " + id));
                        present.add(id);
                        ++untaggedIndex;
                        ++index;
                        continue;
                    }
                    msg = "Ran out of untagged paramters to check against";
                    logger.error((Object)msg);
                    throw new FaultType(msg);
                }
                logger.error((Object)("No match found for argument: " + current));
                throw new FaultType("No match found for argument: " + current);
            }
        }
        if (taggedParams != null) {
            for (int i = 0; i < taggedParams.length; ++i) {
                Id id = taggedParams[i].getId();
                required = false;
                if (taggedParams[i].getRequired() != null) {
                    required = taggedParams[i].getRequired();
                }
                if (!required || present.contains(id)) continue;
                logger.error((Object)("Required parameter " + id + " not found"));
                throw new FaultType("Required parameter " + id + " not found");
            }
        }
        if (untaggedParams != null) {
            for (int i = 0; i < untaggedParams.length; ++i) {
                Id id = untaggedParams[i].getId();
                required = false;
                if (untaggedParams[i].getRequired() != null) {
                    required = untaggedParams[i].getRequired();
                }
                if (!required || present.contains(id)) continue;
                logger.error((Object)"Required untagged parameter not found");
                throw new FaultType("Required untagged parameter not found");
            }
        }
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i].getExclusive() == null || !groups[i].getExclusive().booleanValue()) continue;
                String elemString = groups[i].getElements().toString();
                String[] elemIDs = elemString.split("[\\s]+");
                boolean exclusive = false;
                for (int j = 0; j < elemIDs.length; ++j) {
                    if (!present.contains(new Id(elemIDs[j]))) continue;
                    if (exclusive) {
                        logger.error((Object)("Found multiple parameters inside exclusive group: " + groups[i].getName()));
                        throw new FaultType("Found multiple parameters inside exclusive group: " + groups[i].getName());
                    }
                    exclusive = true;
                }
            }
        }
        return true;
    }

    public boolean validateImplicitParams(String workingDir) throws FaultType {
        int i;
        logger.info((Object)"called");
        File dir = new File(workingDir);
        if (!dir.exists()) {
            logger.error((Object)("Working directory " + workingDir + " does not exist"));
            throw new FaultType("Working directory " + workingDir + " does not exist");
        }
        if (!dir.isDirectory()) {
            logger.error((Object)("Specified working directory " + workingDir + " is not a valid directory"));
            throw new FaultType("Specified working directory " + workingDir + " is not a valid directory");
        }
        ImplicitParamsType[] params = null;
        if (this.argDesc.getImplicitParams() != null) {
            params = this.argDesc.getImplicitParams().getParam();
        }
        if (params == null) {
            logger.error((Object)"No implicit parameters to verify against");
            return true;
        }
        Hashtable<Id, Integer> present = new Hashtable<Id, Integer>();
        File[] files = dir.listFiles();
        for (i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            logger.debug((Object)("Trying to find a match for file: " + fileName));
            boolean match = false;
            for (int j = 0; j < params.length; ++j) {
                String ext = params[j].getExtension();
                if (ext != null && fileName.indexOf(ext) != -1) {
                    if (present.containsKey(params[j].getId())) {
                        Integer val = (Integer)present.get(params[j].getId());
                        present.remove(params[j].getId());
                        present.put(params[j].getId(), new Integer(val + 1));
                    } else {
                        present.put(params[j].getId(), new Integer(1));
                    }
                    logger.debug((Object)("File " + fileName + " matches implicit parameter: " + params[j].getId()));
                    match = true;
                    break;
                }
                String regex = params[j].getName();
                if (regex == null || !fileName.matches(regex)) continue;
                if (present.containsKey(params[j].getId())) {
                    Integer val = (Integer)present.get(params[j].getId());
                    present.remove(params[j].getId());
                    present.put(params[j].getId(), new Integer(val + 1));
                } else {
                    present.put(params[j].getId(), new Integer(1));
                }
                logger.debug((Object)("File " + fileName + " matches implicit parameter: " + params[j].getId()));
                match = true;
                break;
            }
            if (match) continue;
            logger.debug((Object)("Unable to find a match for file: " + fileName));
        }
        for (i = 0; i < params.length; ++i) {
            int num;
            if (params[i].getRequired().booleanValue()) {
                if (present.containsKey(params[i].getId())) {
                    logger.debug((Object)("Implicit parameter " + params[i].getId() + " present"));
                } else {
                    logger.error((Object)("Required implicit parameter " + params[i].getId() + " missing from working directory"));
                    throw new FaultType("Required implicit parameter " + params[i].getId() + " missing from working directory");
                }
            }
            if (params[i].getMin() != null) {
                int min = params[i].getMin();
                num = 0;
                if (present.containsKey(params[i].getId())) {
                    num = (Integer)present.get(params[i].getId());
                }
                if (num < min) {
                    logger.error((Object)("Number of implicit parameters " + params[i].getId() + " less than minimum (" + min + ")"));
                    throw new FaultType("Number of implicit parameters " + params[i].getId() + " less than minimum (" + min + ")");
                }
                logger.debug((Object)("Number of implicit parameters " + params[i].getId() + " greater than required minimum"));
            }
            if (params[i].getMax() == null) continue;
            int max = params[i].getMax();
            num = 0;
            if (present.containsKey(params[i].getId())) {
                num = (Integer)present.get(params[i].getId());
            }
            if (num > max) {
                logger.error((Object)("Number of implicit parameters " + params[i].getId() + " greater than maximum (" + max + ")"));
                throw new FaultType("Number of implicit parameters " + params[i].getId() + " greater than maximum (" + max + ")");
            }
            logger.debug((Object)("Number of implicit parameters " + params[i].getId() + " less than required maximum"));
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String configFile = null;
        String workingDir = null;
        String cmdArgs = null;
        Options options = new Options();
        OptionBuilder.withArgName((String)"config");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"application configuration XML");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"working directory for execution");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"command line arguments");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"a"));
        System.out.println("Reading command line arguments");
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java edu.sdsc.nbcr.opal.ArgValidator", options);
            System.exit(1);
        }
        configFile = line.getOptionValue("d");
        workingDir = line.getOptionValue("w");
        cmdArgs = line.getOptionValue("a");
        System.out.println("Parsing argument description");
        AppConfigType appConfig = (AppConfigType)TypeDeserializer.getValue(configFile, new AppConfigType());
        ArgumentsType argsDesc_ = appConfig.getMetadata().getTypes();
        if (argsDesc_ == null) {
            System.err.println("Opal configuration file: " + configFile + " does not include argument description");
            System.exit(1);
        }
        ArgValidator av = new ArgValidator(argsDesc_);
        System.out.println("Validating arguments");
        boolean success = av.validateArgList(workingDir, cmdArgs);
        if (success) {
            System.out.println("Argument validation successful");
        } else {
            System.err.println("Argument validation unsuccessful");
        }
    }
}

