/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.pbsTorque;

import edu.sdsc.nbcr.opal.manager.pbsTorque.Core;
import edu.sdsc.nbcr.opal.manager.pbsTorque.Job;
import edu.sdsc.nbcr.opal.manager.pbsTorque.Machine;
import java.io.BufferedInputStream;
import java.util.ArrayList;

public class Cluster {
    private Machine[] Nodes;

    public Machine[] getNodes() {
        return this.Nodes;
    }

    public void setNodes(Machine[] Nodes) {
        this.Nodes = Nodes;
    }

    public static Cluster getCluster() throws Exception {
        Process p = Runtime.getRuntime().exec("qnodes");
        BufferedInputStream errStream = new BufferedInputStream(p.getErrorStream());
        p.waitFor();
        if (errStream.available() > 0) {
            byte[] errdata = new byte[errStream.available()];
            errStream.read(errdata, 0, errStream.available());
            throw new Exception(new String(errdata));
        }
        BufferedInputStream out = new BufferedInputStream(p.getInputStream());
        byte[] data = new byte[out.available()];
        out.read(data, 0, out.available());
        p.getErrorStream().close();
        p.getOutputStream().close();
        String Result = new String(data);
        out.close();
        String[] Nodes = Result.split("\n");
        Core[] Cores = null;
        ArrayList<Machine> Machines = new ArrayList<Machine>();
        int i = 0;
        while (i < Nodes.length) {
            Machine Node2 = new Machine();
            Node2.setName(Nodes[i]);
            ++i;
            while (i < Nodes.length) {
                if (!Nodes[i].startsWith(" ")) {
                    ++i;
                    break;
                }
                String[] line = Nodes[i].split("=");
                String header = line[0].trim();
                String value = line[1].trim();
                if ("state".equals(header)) {
                    Node2.setState(value);
                } else if ("np".equals(header)) {
                    Node2.setNp(value);
                    int np = Integer.parseInt(Node2.getNp());
                    Cores = new Core[np];
                    for (int n = 0; n < np; ++n) {
                        Cores[n] = new Core("" + n);
                    }
                } else if ("ntype".equals(header)) {
                    Node2.setNtype(value);
                } else if ("jobs".equals(header)) {
                    String[] jobs = value.split(", ");
                    for (int j = 0; j < jobs.length; ++j) {
                        String[] c = jobs[j].split("/");
                        String Jid = c[1];
                        Job jo = Job.getJobById(Jid);
                        int core = Integer.parseInt(c[0]);
                        Cores[core].setJob(jo);
                    }
                }
                ++i;
            }
            Node2.setCores(Cores);
            Machines.add(Node2);
        }
        Cluster c = new Cluster();
        c.setNodes(Machines.toArray(new Machine[Machines.size()]));
        return c;
    }
}

