/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.gui.common;

import edu.sdsc.nbcr.opal.AppMetadataInputType;
import edu.sdsc.nbcr.opal.AppMetadataType;
import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.gui.common.OPALService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GetServiceListHelper {
    protected static Log log = LogFactory.getLog((String)GetServiceListHelper.class.getName());
    protected Call call;
    private String baseURL;
    private String basePrivateURL;
    private String basePublicURL;

    public GetServiceListHelper() {
        Service service = new Service();
        try {
            this.call = (Call)service.createCall();
        }
        catch (ServiceException e) {
            log.error((Object)"Unable to instantiate the Call", (Throwable)e);
            this.call = null;
        }
    }

    public SOAPBodyElement getServiceList() {
        if (this.call == null) {
            return null;
        }
        this.call.setTargetEndpointAddress(this.basePrivateURL + "/AdminService");
        log.debug((Object)"Getting the list of services.");
        this.call.setUseSOAPAction(true);
        this.call.setSOAPActionURI("AdminService");
        String str = "<m:list xmlns:m=\"http://xml.apache.org/axis/wsdd/\"/>";
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        Vector result = null;
        Object[] params = new Object[]{new SOAPBodyElement((InputStream)input)};
        try {
            result = (Vector)this.call.invoke(params);
        }
        catch (Exception e) {
            log.error((Object)"Unable to invoke the service, maybe the target server is down", (Throwable)e);
            return null;
        }
        if (result == null || result.isEmpty()) {
            log.error((Object)"The server returned an empty message (maybe you're not ivoking the right axis server???)!!");
            return null;
        }
        SOAPBodyElement body = (SOAPBodyElement)result.elementAt(0);
        return body;
    }

    public OPALService[] parseServiceList(String body) {
        try {
            ArrayList<OPALService> list = new ArrayList<OPALService>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            body = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + body;
            Document response = parser.parse(new InputSource(new StringReader(body)));
            NodeList nl = response.getElementsByTagName("service");
            if (nl == null || nl.getLength() < 1) {
                log.error((Object)"the deployment descriptor does not have any elements!! Check the server.");
                return null;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!GetServiceListHelper.isValidService(node)) continue;
                NamedNodeMap attributes = node.getAttributes();
                String serviceName = attributes.getNamedItem("name").getNodeValue();
                OPALService service = new OPALService();
                service.setURL(this.basePublicURL + "/" + serviceName);
                service.setServiceID(serviceName);
                service.setServiceName(serviceName);
                list.add(service);
                log.debug((Object)("added -> " + service));
            }
            return list.toArray(new OPALService[list.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OPALService[] getOpalServiceList() {
        SOAPBodyElement list = this.getServiceList();
        if (list == null) {
            log.error((Object)"Unable to get the list of service.");
            return null;
        }
        return this.parseServiceList(list.toString());
    }

    private static boolean isValidService(Node service) {
        NodeList ns = service.getChildNodes();
        boolean isValid = false;
        Node node = null;
        if (ns == null) {
            return false;
        }
        for (int i = 0; i < ns.getLength(); ++i) {
            node = ns.item(i);
            if (!node.getNodeName().equals("operation") || !node.getAttributes().getNamedItem("name").getNodeValue().equals("getAppConfig")) continue;
            return true;
        }
        return false;
    }

    public boolean setServiceName(OPALService[] serviceList) {
        AppServiceLocator asl = new AppServiceLocator();
        for (int i = 0; i < serviceList.length; ++i) {
            AppMetadataType amt;
            String url = serviceList[i].getURL();
            try {
                AppServicePortType appServicePort = asl.getAppServicePort(new URL(url));
                amt = appServicePort.getAppMetadata(new AppMetadataInputType());
            }
            catch (Exception e) {
                log.error((Object)("Error retrieving the Service name for URL: " + url), (Throwable)e);
                return false;
            }
            String serviceName = amt.getAppName();
            String description = amt.getUsage();
            serviceList[i].setDescription(description);
            if (serviceName != null) {
                serviceList[i].setServiceName(serviceName);
            } else {
                serviceList[i].setServiceName(serviceList[i].getServiceID());
            }
            if (amt.getTypes() == null || amt.getTypes().getTaggedParams() == null && amt.getTypes().getUntaggedParams() == null) {
                serviceList[i].setComplexForm(Boolean.FALSE);
                continue;
            }
            serviceList[i].setComplexForm(Boolean.TRUE);
        }
        return true;
    }

    public static void main(String[] argv) {
        GetServiceListHelper servicelist = new GetServiceListHelper();
        servicelist.setBasePrivateURL("http://localhost:8080/axis/services");
        servicelist.setBasePublicURL("http://localhost:8080/axis/services");
        SOAPBodyElement list = servicelist.getServiceList();
        System.out.println("the result was: " + list.toString());
        OPALService[] serviceList = servicelist.parseServiceList(list.toString());
        for (int i = 0; i < serviceList.length; ++i) {
            System.out.println("the service " + i + " is: " + serviceList[i]);
        }
    }

    public void setBasePrivateURL(String url) {
        this.basePrivateURL = url;
    }

    public void setBasePublicURL(String url) {
        this.basePublicURL = url;
    }
}

