# mecab-ipadic-NEologd : Neologism dictionary for MeCab

## 詳細な情報
mecab-ipadic-neologd に関する詳細な情報(サンプルコードなど)は以下の Wiki に書いてあります。

- https://github.com/neologd/mecab-ipadic-neologd/wiki/Home.ja

## mecab-ipadic-neologd とは
mecab-ipadic-neologd は、多数のWeb上の言語資源から得た新語を追加することでカスタマイズした MeCab 用のシステム辞書です。

Web上の文書の解析をする際には、この辞書と標準のシステム辞書(ipadic)を併用することをオススメします。

## 特徴
### 利点
- MeCab の標準のシステム辞書では正しく分割できない固有表現などの語の表層(表記)とフリガナの組を約156万組(重複エントリを含む)採録しています
- この辞書の更新は開発サーバ上で自動的におこなわれます
    - 毎月月初と中旬に更新する予定です
- Web上の言語資源を活用しているので、更新時に新しい固有表現を採録できます
    - 現在使用している資源は以下のとおりです
        - はてなキーワードのダンプデータ
        - 郵便番号データダウンロード
        - 日本全国駅名一覧のコーナー
        - 人名(姓/名)エントリデータ
        - Web からクロールした大量の文書データ
    - 今後も他の新たな言語資源から抽出した固有表現などの語を採録する予定です

### 欠点
- 固有表現の分類が不十分です
    - 例えば一部の人名と製品名が同じ固有表現カテゴリに分類されています
- 固有表現では無い語も固有表現として登録されています
- 固有表現の表記とフリガナの対応づけを間違っている場合があります
    - すべての固有表現とフリガナの組に対する人手による検査を実施していないためです
- Web上の資源が更新されないなら、新しい固有表現は辞書に追加されません
- 対応している文字コードは UTF-8 のみです
    - インストール済みの MeCab が使用している ipadic が UTF-8 版である必要があります

## 使用開始
### 動作に必要なもの

インストール時に mecab-ipadic をベースにビルド処理をするために必要なライブラリがあります。

apt、yum や homebrew でインストールするか、自前でコンパイルしてインストールして下さい。

- C++ コンパイラ
    - GCC-4.4.7 と Apple LLVM version 6.0 で動作を確認しています
- iconv (libiconv)
    - 辞書のコード変換に使います
- mecab
    - MeCab 本体です
    - mecab と mecab-config を使います
- mecab-ipadic
    - MeCab 用の辞書のひとつです
        - インストール時のテストに使います
        - ソースコードからインストールするときは以下の手順で文字コードを UTF-8 インストールして下さい

    ./configure --with-charset=utf8; make; sudo make install

- xz
    - mecab-ipadic-neologd のシードの解凍に unxz を使います

他にも足りないものがあったら適時インストールして下さい。

#### 例
- CentOS の場合

    $ sudo yum install mecab mecab-ipadic git make curl xz

- Fedora の場合

    $ sudo yum install mecab mecab-devel mecab-ipadic git make curl xz

- Ubuntu の場合

    $ sudo aptitude install mecab libmecab-dev mecab-ipadic-utf8 git make curl xz-utils

- Mac OSX の場合

    $ brew install mecab mecab-ipadic git curl xz

### mecab-ipadic-neologd をインストールする準備

辞書の元になるデータの配布と更新は GitHub 経由で行います。

初回は以下のコマンドでgit cloneしてください。

    $ git clone https://github.com/neologd/mecab-ipadic-neologd.git

または

    $ git clone git@github.com:neologd/mecab-ipadic-neologd.git


### mecab-ipadic-neologd のインストール/更新
#### Step.1
上記の準備でcloneしたリポジトリに移動します。

    $ cd mecab-ipadic-neologd

#### Step.2
リポジトリの状態を最新の状態にします。

    $ git pull

#### Step.3
以下のコマンドを実行するとインストール、または、上書きによる更新ができます。

    $ ./bin/install-mecab-ipadic-neologd

インストール先はオプション未指定の場合 mecab-config に従って決まります。

以下のコマンドを実行すると確認できます。

    $ echo `mecab-config --dicdir`"/mecab-ipadic-neologd"

複数の MeCab をインストールしている場合は、任意の mecab-config にパスを通して下さい。

任意の path にインストールしたい場合や、user 権限でインストールする際のオプションなどは以下で確認できます。

    $ ./bin/install-mecab-ipadic-neologd -h


### mecab-ipadic-neologd の使用方法
mecab-ipadic-neologd を使いたいときは、MeCab の -d オプションにカスタムシステム辞書のパス(例: */lib/mecab/dic/mecab-ipadic-neologd/)を指定してください。

#### 例 (CentOS 上でインストールした場合)

    $ mecab -d /usr/local/lib/mecab/dic/mecab-ipadic-neologd/

## MeCabの実行結果の例
### mecab-ipadic-neologd をシステム辞書として使った場合
    $echo "10日放送の「中居正広のミになる図書館」（テレビ朝日系）で、SMAPの中居正広が、篠原信一の過去の勘違いを明かす一幕があった。" | mecab -d /usr/local/lib/mecab/dic/mecab-ipadic-neologd
    10日    名詞,固有名詞,一般,*,*,*,10日,トオカ,トオカ
    放送    名詞,サ変接続,*,*,*,*,放送,ホウソウ,ホーソー
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    「      記号,括弧開,*,*,*,*,「,「,「
    中居正広のミになる図書館        名詞,固有名詞,一般,*,*,*,中居正広のミになる図書館,ナカイマサヒロノミニナルトショカン,ナカイマサヒロノミニナルトショカン
    」      記号,括弧閉,*,*,*,*,」,」,」
    （      記号,括弧開,*,*,*,*,（,（,（
    テレビ朝日      名詞,固有名詞,組織,*,*,*,テレビ朝日,テレビアサヒ,テレビアサヒ
    系      名詞,接尾,一般,*,*,*,系,ケイ,ケイ
    ）      記号,括弧閉,*,*,*,*,）,）,）
    で      助詞,格助詞,一般,*,*,*,で,デ,デ
    、      記号,読点,*,*,*,*,、,、,、
    SMAP    名詞,固有名詞,一般,*,*,*,SMAP,スマップ,スマップ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    中居正広        名詞,固有名詞,人名,*,*,*,中居正広,ナカイマサヒロ,ナカイマサヒロ
    が      助詞,格助詞,一般,*,*,*,が,ガ,ガ
    、      記号,読点,*,*,*,*,、,、,、
    篠原信一        名詞,固有名詞,人名,*,*,*,篠原信一,シノハラシンイチ,シノハラシンイチ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    過去    名詞,副詞可能,*,*,*,*,過去,カコ,カコ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    勘違い  名詞,サ変接続,*,*,*,*,勘違い,カンチガイ,カンチガイ
    を      助詞,格助詞,一般,*,*,*,を,ヲ,ヲ
    明かす  動詞,自立,*,*,五段・サ行,基本形,明かす,アカス,アカス
    一幕    名詞,一般,*,*,*,*,一幕,ヒトマク,ヒトマク
    が      助詞,格助詞,一般,*,*,*,が,ガ,ガ
    あっ    動詞,自立,*,*,五段・ラ行,連用タ接続,ある,アッ,アッ
    た      助動詞,*,*,*,特殊・タ,基本形,た,タ,タ
    。      記号,句点,*,*,*,*,。,。,。
    EOS

#### どこに効果が出ている?
- Mecab は mecab-ipadic-neologd に収録された語を正しく分割できました
    - 「中居正広のミになる図書館」は2011年後半に生まれた新しい語です
        - この語はWeb上の言語資源が更新されたので正しく分割できました
- mecab-ipadic-neologd に収録されているほとんどの語にフリガナが付いています

### 標準のシステム辞書(ipadic-2.7.0)を使った場合
    $echo "10日放送の「中居正広のミになる図書館」（テレビ朝日系）で、SMAPの中居正広が、篠原信一の過去の勘違いを明かす一幕があった。" | mecab
    10      名詞,数,*,*,*,*,*
    日      名詞,接尾,助数詞,*,*,*,日,ニチ,ニチ
    放送    名詞,サ変接続,*,*,*,*,放送,ホウソウ,ホーソー
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    「      記号,括弧開,*,*,*,*,「,「,「
    中居    名詞,固有名詞,人名,姓,*,*,中居,ナカイ,ナカイ
    正広    名詞,固有名詞,人名,名,*,*,正広,マサヒロ,マサヒロ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    ミ      名詞,一般,*,*,*,*,ミ,ミ,ミ
    に      助詞,格助詞,一般,*,*,*,に,ニ,ニ
    なる    動詞,自立,*,*,五段・ラ行,基本形,なる,ナル,ナル
    図書館  名詞,一般,*,*,*,*,図書館,トショカン,トショカン
    」      記号,括弧閉,*,*,*,*,」,」,」
    （      記号,括弧開,*,*,*,*,（,（,（
    テレビ朝日      名詞,固有名詞,組織,*,*,*,テレビ朝日,テレビアサヒ,テレビアサヒ
    系      名詞,接尾,一般,*,*,*,系,ケイ,ケイ
    ）      記号,括弧閉,*,*,*,*,）,）,）
    で      助詞,格助詞,一般,*,*,*,で,デ,デ
    、      記号,読点,*,*,*,*,、,、,、
    SMAP    名詞,固有名詞,組織,*,*,*,*
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    中居    名詞,固有名詞,人名,姓,*,*,中居,ナカイ,ナカイ
    正広    名詞,固有名詞,人名,名,*,*,正広,マサヒロ,マサヒロ
    が      助詞,格助詞,一般,*,*,*,が,ガ,ガ
    、      記号,読点,*,*,*,*,、,、,、
    篠原    名詞,固有名詞,人名,姓,*,*,篠原,シノハラ,シノハラ
    信一    名詞,固有名詞,人名,名,*,*,信一,シンイチ,シンイチ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    過去    名詞,副詞可能,*,*,*,*,過去,カコ,カコ
    の      助詞,連体化,*,*,*,*,の,ノ,ノ
    勘違い  名詞,サ変接続,*,*,*,*,勘違い,カンチガイ,カンチガイ
    を      助詞,格助詞,一般,*,*,*,を,ヲ,ヲ
    明かす  動詞,自立,*,*,五段・サ行,基本形,明かす,アカス,アカス
    一幕    名詞,一般,*,*,*,*,一幕,ヒトマク,ヒトマク
    が      助詞,格助詞,一般,*,*,*,が,ガ,ガ
    あっ    動詞,自立,*,*,五段・ラ行,連用タ接続,ある,アッ,アッ
    た      助動詞,*,*,*,特殊・タ,基本形,た,タ,タ
    。      記号,句点,*,*,*,*,。,。,。
    EOS

## 今後の発展
継続して開発しますので、気になるところはどんどん改善されます。

ユーザの8割が気になる部分を優先して改善します。

## Bibtex

    @misc{sato2015mecabipadicneologd,
        title  = {Neologism dictionary based on the language resources on the Web for Mecab},
        author = {Toshinori, Sato},
        url    = {https://github.com/neologd/mecab-ipadic-neologd},
        year   = {2015}
    }

## Copyrights
Copyright (c) 2015 Toshinori Sato (@overlast) All rights reserved.

ライセンスは Apache License, Version 2.0 です。下記をご参照下さい。

- https://github.com/neologd/mecab-ipadic-neologd/blob/master/COPYING
