/**
 * \file doc_mainpage.h
 *
 * \brief Main page documentation file.
 */
/*
 *
 *  Copyright (C) 2006-2019, ARM Limited, All Rights Reserved
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may
 *  not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  This file is part of mbed TLS (https://tls.mbed.org)
 */

/**
 * @mainpage Mbed Crypto v0.1.0 source code documentation
 *
 * This documentation describes the internal structure of mbed TLS.  It was
 * automatically generated from specially formatted comment blocks in
 * mbed TLS's source code using Doxygen.  (See
 * http://www.stack.nl/~dimitri/doxygen/ for more information on Doxygen)
 *
 * Mbed Crypto provides an implementation of the PSA Crypto API. The library is
 * comprised of a number of independent modules, listed in the \ref
 * mainpage_modules "Modules section". This "Modules section" introduces the
 * high-level module concepts used throughout this documentation.
 *
 * @section mainpage_modules Modules
 *
 * Mbed Crypto provides the following modules:
 * - Random number generation
 * - Hashing
 * - Encryption/decryption
 *
 * Above functions are split up neatly into logical interfaces. These can be
 * used separately to provide any of the above functions or to mix-and-match.
 *
 */
