/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.v4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.RepositoryBase;
import org.apache.maven.api.settings.RepositoryPolicy;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.api.settings.TrackableBase;
import org.apache.maven.api.xml.XmlNode;

@Generated
public class SettingsTransformer {
    private final UnaryOperator<String> transformer;

    public SettingsTransformer(UnaryOperator<String> transformer) {
        this.transformer = transformer;
    }

    public Settings visit(Settings target) {
        Objects.requireNonNull(target, "target cannot be null");
        return this.transformSettings(target);
    }

    protected String transform(String value) {
        return (String)this.transformer.apply(value);
    }

    protected TrackableBase transformTrackableBase(TrackableBase target) {
        if (target == null) {
            return null;
        }
        Supplier<TrackableBase.Builder> creator = () -> TrackableBase.newBuilder((TrackableBase)target);
        Object builder = null;
        return builder != null ? builder.build() : target;
    }

    protected IdentifiableBase transformIdentifiableBase(IdentifiableBase target) {
        if (target == null) {
            return null;
        }
        Supplier<IdentifiableBase.Builder> creator = () -> IdentifiableBase.newBuilder((IdentifiableBase)target);
        IdentifiableBase.Builder builder = null;
        return (builder = this.transformIdentifiableBase_Id(creator, builder, target)) != null ? builder.build() : target;
    }

    protected IdentifiableBase.Builder transformIdentifiableBase_Id(Supplier<? extends IdentifiableBase.Builder> creator, IdentifiableBase.Builder builder, IdentifiableBase target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Settings transformSettings(Settings target) {
        if (target == null) {
            return null;
        }
        Supplier<Settings.Builder> creator = () -> Settings.newBuilder((Settings)target);
        Settings.Builder builder = null;
        builder = this.transformSettings_LocalRepository(creator, builder, target);
        builder = this.transformSettings_InteractiveMode(creator, builder, target);
        builder = this.transformSettings_UsePluginRegistry(creator, builder, target);
        builder = this.transformSettings_Offline(creator, builder, target);
        builder = this.transformSettings_Proxies(creator, builder, target);
        builder = this.transformSettings_Servers(creator, builder, target);
        builder = this.transformSettings_Mirrors(creator, builder, target);
        builder = this.transformSettings_Repositories(creator, builder, target);
        builder = this.transformSettings_PluginRepositories(creator, builder, target);
        builder = this.transformSettings_Profiles(creator, builder, target);
        builder = this.transformSettings_ActiveProfiles(creator, builder, target);
        return (builder = this.transformSettings_PluginGroups(creator, builder, target)) != null ? builder.build() : target;
    }

    protected Settings.Builder transformSettings_LocalRepository(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        String oldVal = target.getLocalRepository();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).localRepository(newVal) : builder;
    }

    protected Settings.Builder transformSettings_InteractiveMode(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        return builder;
    }

    protected Settings.Builder transformSettings_UsePluginRegistry(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        return builder;
    }

    protected Settings.Builder transformSettings_Offline(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        return builder;
    }

    protected Settings.Builder transformSettings_Proxies(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getProxies();
        List newVal = this.transform(oldVal, this::transformProxy);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).proxies(newVal) : builder;
    }

    protected Settings.Builder transformSettings_Servers(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getServers();
        List newVal = this.transform(oldVal, this::transformServer);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).servers(newVal) : builder;
    }

    protected Settings.Builder transformSettings_Mirrors(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getMirrors();
        List newVal = this.transform(oldVal, this::transformMirror);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).mirrors(newVal) : builder;
    }

    protected Settings.Builder transformSettings_Repositories(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getRepositories();
        List newVal = this.transform(oldVal, this::transformRepository);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).repositories(newVal) : builder;
    }

    protected Settings.Builder transformSettings_PluginRepositories(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getPluginRepositories();
        List newVal = this.transform(oldVal, this::transformRepository);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).pluginRepositories(newVal) : builder;
    }

    protected Settings.Builder transformSettings_Profiles(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getProfiles();
        List newVal = this.transform(oldVal, this::transformProfile);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).profiles(newVal) : builder;
    }

    protected Settings.Builder transformSettings_ActiveProfiles(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getActiveProfiles();
        List newVal = this.transform(oldVal, this::transform);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).activeProfiles(newVal) : builder;
    }

    protected Settings.Builder transformSettings_PluginGroups(Supplier<? extends Settings.Builder> creator, Settings.Builder builder, Settings target) {
        List oldVal = target.getPluginGroups();
        List newVal = this.transform(oldVal, this::transform);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).pluginGroups(newVal) : builder;
    }

    protected Proxy transformProxy(Proxy target) {
        if (target == null) {
            return null;
        }
        Supplier<Proxy.Builder> creator = () -> Proxy.newBuilder((Proxy)target);
        Proxy.Builder builder = null;
        builder = this.transformProxy_ActiveString(creator, builder, target);
        builder = this.transformProxy_Protocol(creator, builder, target);
        builder = this.transformProxy_Username(creator, builder, target);
        builder = this.transformProxy_Password(creator, builder, target);
        builder = this.transformProxy_PortString(creator, builder, target);
        builder = this.transformProxy_Host(creator, builder, target);
        builder = this.transformProxy_NonProxyHosts(creator, builder, target);
        return (builder = (Proxy.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected Proxy.Builder transformProxy_ActiveString(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getActiveString();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).activeString(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_Protocol(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getProtocol();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).protocol(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_Username(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getUsername();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).username(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_Password(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getPassword();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).password(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_PortString(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getPortString();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).portString(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_Host(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getHost();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).host(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_NonProxyHosts(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getNonProxyHosts();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).nonProxyHosts(newVal) : builder;
    }

    protected Proxy.Builder transformProxy_Id(Supplier<? extends Proxy.Builder> creator, Proxy.Builder builder, Proxy target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Server transformServer(Server target) {
        if (target == null) {
            return null;
        }
        Supplier<Server.Builder> creator = () -> Server.newBuilder((Server)target);
        Server.Builder builder = null;
        builder = this.transformServer_Username(creator, builder, target);
        builder = this.transformServer_Password(creator, builder, target);
        builder = this.transformServer_PrivateKey(creator, builder, target);
        builder = this.transformServer_Passphrase(creator, builder, target);
        builder = this.transformServer_FilePermissions(creator, builder, target);
        builder = this.transformServer_DirectoryPermissions(creator, builder, target);
        builder = this.transformServer_Configuration(creator, builder, target);
        return (builder = (Server.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected Server.Builder transformServer_Username(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getUsername();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).username(newVal) : builder;
    }

    protected Server.Builder transformServer_Password(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getPassword();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).password(newVal) : builder;
    }

    protected Server.Builder transformServer_PrivateKey(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getPrivateKey();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).privateKey(newVal) : builder;
    }

    protected Server.Builder transformServer_Passphrase(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getPassphrase();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).passphrase(newVal) : builder;
    }

    protected Server.Builder transformServer_FilePermissions(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getFilePermissions();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).filePermissions(newVal) : builder;
    }

    protected Server.Builder transformServer_DirectoryPermissions(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getDirectoryPermissions();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).directoryPermissions(newVal) : builder;
    }

    protected Server.Builder transformServer_Configuration(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        XmlNode oldVal = target.getConfiguration();
        XmlNode newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).configuration(newVal) : builder;
    }

    protected Server.Builder transformServer_Id(Supplier<? extends Server.Builder> creator, Server.Builder builder, Server target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Mirror transformMirror(Mirror target) {
        if (target == null) {
            return null;
        }
        Supplier<Mirror.Builder> creator = () -> Mirror.newBuilder((Mirror)target);
        Mirror.Builder builder = null;
        builder = this.transformMirror_MirrorOf(creator, builder, target);
        builder = this.transformMirror_Name(creator, builder, target);
        builder = this.transformMirror_Url(creator, builder, target);
        builder = this.transformMirror_Layout(creator, builder, target);
        builder = this.transformMirror_MirrorOfLayouts(creator, builder, target);
        builder = this.transformMirror_Blocked(creator, builder, target);
        return (builder = (Mirror.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected Mirror.Builder transformMirror_MirrorOf(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getMirrorOf();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).mirrorOf(newVal) : builder;
    }

    protected Mirror.Builder transformMirror_Name(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getName();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).name(newVal) : builder;
    }

    protected Mirror.Builder transformMirror_Url(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getUrl();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).url(newVal) : builder;
    }

    protected Mirror.Builder transformMirror_Layout(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getLayout();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).layout(newVal) : builder;
    }

    protected Mirror.Builder transformMirror_MirrorOfLayouts(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getMirrorOfLayouts();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).mirrorOfLayouts(newVal) : builder;
    }

    protected Mirror.Builder transformMirror_Blocked(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        return builder;
    }

    protected Mirror.Builder transformMirror_Id(Supplier<? extends Mirror.Builder> creator, Mirror.Builder builder, Mirror target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Profile transformProfile(Profile target) {
        if (target == null) {
            return null;
        }
        Supplier<Profile.Builder> creator = () -> Profile.newBuilder((Profile)target);
        Profile.Builder builder = null;
        builder = this.transformProfile_Activation(creator, builder, target);
        builder = this.transformProfile_Properties(creator, builder, target);
        builder = this.transformProfile_Repositories(creator, builder, target);
        builder = this.transformProfile_PluginRepositories(creator, builder, target);
        return (builder = (Profile.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected Profile.Builder transformProfile_Activation(Supplier<? extends Profile.Builder> creator, Profile.Builder builder, Profile target) {
        Activation oldVal = target.getActivation();
        Activation newVal = this.transformActivation(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).activation(newVal) : builder;
    }

    protected Profile.Builder transformProfile_Properties(Supplier<? extends Profile.Builder> creator, Profile.Builder builder, Profile target) {
        Map props = target.getProperties();
        HashMap<String, String> newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap<String, String>();
                newProps.putAll(props);
                builder = builder != null ? builder : creator.get();
                builder.properties(newProps);
            }
            newProps.put((String)entry.getKey(), newVal);
        }
        return builder;
    }

    protected Profile.Builder transformProfile_Repositories(Supplier<? extends Profile.Builder> creator, Profile.Builder builder, Profile target) {
        List oldVal = target.getRepositories();
        List newVal = this.transform(oldVal, this::transformRepository);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).repositories(newVal) : builder;
    }

    protected Profile.Builder transformProfile_PluginRepositories(Supplier<? extends Profile.Builder> creator, Profile.Builder builder, Profile target) {
        List oldVal = target.getPluginRepositories();
        List newVal = this.transform(oldVal, this::transformRepository);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).pluginRepositories(newVal) : builder;
    }

    protected Profile.Builder transformProfile_Id(Supplier<? extends Profile.Builder> creator, Profile.Builder builder, Profile target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Activation transformActivation(Activation target) {
        if (target == null) {
            return null;
        }
        Supplier<Activation.Builder> creator = () -> Activation.newBuilder((Activation)target);
        Activation.Builder builder = null;
        builder = this.transformActivation_ActiveByDefault(creator, builder, target);
        builder = this.transformActivation_Jdk(creator, builder, target);
        builder = this.transformActivation_Os(creator, builder, target);
        builder = this.transformActivation_Property(creator, builder, target);
        builder = this.transformActivation_File(creator, builder, target);
        builder = this.transformActivation_Packaging(creator, builder, target);
        return (builder = this.transformActivation_Condition(creator, builder, target)) != null ? builder.build() : target;
    }

    protected Activation.Builder transformActivation_ActiveByDefault(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        return builder;
    }

    protected Activation.Builder transformActivation_Jdk(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        String oldVal = target.getJdk();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).jdk(newVal) : builder;
    }

    protected Activation.Builder transformActivation_Os(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        ActivationOS oldVal = target.getOs();
        ActivationOS newVal = this.transformActivationOS(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).os(newVal) : builder;
    }

    protected Activation.Builder transformActivation_Property(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        ActivationProperty oldVal = target.getProperty();
        ActivationProperty newVal = this.transformActivationProperty(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).property(newVal) : builder;
    }

    protected Activation.Builder transformActivation_File(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        ActivationFile oldVal = target.getFile();
        ActivationFile newVal = this.transformActivationFile(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).file(newVal) : builder;
    }

    protected Activation.Builder transformActivation_Packaging(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        String oldVal = target.getPackaging();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).packaging(newVal) : builder;
    }

    protected Activation.Builder transformActivation_Condition(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
        String oldVal = target.getCondition();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).condition(newVal) : builder;
    }

    protected RepositoryBase transformRepositoryBase(RepositoryBase target) {
        if (target == null) {
            return null;
        }
        Supplier<RepositoryBase.Builder> creator = () -> RepositoryBase.newBuilder((RepositoryBase)target);
        RepositoryBase.Builder builder = null;
        builder = this.transformRepositoryBase_Name(creator, builder, target);
        builder = this.transformRepositoryBase_Url(creator, builder, target);
        builder = this.transformRepositoryBase_Layout(creator, builder, target);
        return (builder = (RepositoryBase.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected RepositoryBase.Builder transformRepositoryBase_Name(Supplier<? extends RepositoryBase.Builder> creator, RepositoryBase.Builder builder, RepositoryBase target) {
        String oldVal = target.getName();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).name(newVal) : builder;
    }

    protected RepositoryBase.Builder transformRepositoryBase_Url(Supplier<? extends RepositoryBase.Builder> creator, RepositoryBase.Builder builder, RepositoryBase target) {
        String oldVal = target.getUrl();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).url(newVal) : builder;
    }

    protected RepositoryBase.Builder transformRepositoryBase_Layout(Supplier<? extends RepositoryBase.Builder> creator, RepositoryBase.Builder builder, RepositoryBase target) {
        String oldVal = target.getLayout();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).layout(newVal) : builder;
    }

    protected RepositoryBase.Builder transformRepositoryBase_Id(Supplier<? extends RepositoryBase.Builder> creator, RepositoryBase.Builder builder, RepositoryBase target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected Repository transformRepository(Repository target) {
        if (target == null) {
            return null;
        }
        Supplier<Repository.Builder> creator = () -> Repository.newBuilder((Repository)target);
        Repository.Builder builder = null;
        builder = this.transformRepository_Releases(creator, builder, target);
        builder = this.transformRepository_Snapshots(creator, builder, target);
        builder = (Repository.Builder)this.transformRepositoryBase_Name(creator, (RepositoryBase.Builder)builder, (RepositoryBase)target);
        builder = (Repository.Builder)this.transformRepositoryBase_Url(creator, (RepositoryBase.Builder)builder, (RepositoryBase)target);
        builder = (Repository.Builder)this.transformRepositoryBase_Layout(creator, (RepositoryBase.Builder)builder, (RepositoryBase)target);
        return (builder = (Repository.Builder)this.transformIdentifiableBase_Id(creator, (IdentifiableBase.Builder)builder, (IdentifiableBase)target)) != null ? builder.build() : target;
    }

    protected Repository.Builder transformRepository_Releases(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        RepositoryPolicy oldVal = target.getReleases();
        RepositoryPolicy newVal = this.transformRepositoryPolicy(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).releases(newVal) : builder;
    }

    protected Repository.Builder transformRepository_Snapshots(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        RepositoryPolicy oldVal = target.getSnapshots();
        RepositoryPolicy newVal = this.transformRepositoryPolicy(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).snapshots(newVal) : builder;
    }

    protected Repository.Builder transformRepository_Name(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        String oldVal = target.getName();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).name(newVal) : builder;
    }

    protected Repository.Builder transformRepository_Url(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        String oldVal = target.getUrl();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).url(newVal) : builder;
    }

    protected Repository.Builder transformRepository_Layout(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        String oldVal = target.getLayout();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).layout(newVal) : builder;
    }

    protected Repository.Builder transformRepository_Id(Supplier<? extends Repository.Builder> creator, Repository.Builder builder, Repository target) {
        String oldVal = target.getId();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).id(newVal) : builder;
    }

    protected RepositoryPolicy transformRepositoryPolicy(RepositoryPolicy target) {
        if (target == null) {
            return null;
        }
        Supplier<RepositoryPolicy.Builder> creator = () -> RepositoryPolicy.newBuilder((RepositoryPolicy)target);
        RepositoryPolicy.Builder builder = null;
        builder = this.transformRepositoryPolicy_Enabled(creator, builder, target);
        builder = this.transformRepositoryPolicy_UpdatePolicy(creator, builder, target);
        return (builder = this.transformRepositoryPolicy_ChecksumPolicy(creator, builder, target)) != null ? builder.build() : target;
    }

    protected RepositoryPolicy.Builder transformRepositoryPolicy_Enabled(Supplier<? extends RepositoryPolicy.Builder> creator, RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        return builder;
    }

    protected RepositoryPolicy.Builder transformRepositoryPolicy_UpdatePolicy(Supplier<? extends RepositoryPolicy.Builder> creator, RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String oldVal = target.getUpdatePolicy();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).updatePolicy(newVal) : builder;
    }

    protected RepositoryPolicy.Builder transformRepositoryPolicy_ChecksumPolicy(Supplier<? extends RepositoryPolicy.Builder> creator, RepositoryPolicy.Builder builder, RepositoryPolicy target) {
        String oldVal = target.getChecksumPolicy();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).checksumPolicy(newVal) : builder;
    }

    protected ActivationProperty transformActivationProperty(ActivationProperty target) {
        if (target == null) {
            return null;
        }
        Supplier<ActivationProperty.Builder> creator = () -> ActivationProperty.newBuilder((ActivationProperty)target);
        ActivationProperty.Builder builder = null;
        builder = this.transformActivationProperty_Name(creator, builder, target);
        return (builder = this.transformActivationProperty_Value(creator, builder, target)) != null ? builder.build() : target;
    }

    protected ActivationProperty.Builder transformActivationProperty_Name(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
        String oldVal = target.getName();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).name(newVal) : builder;
    }

    protected ActivationProperty.Builder transformActivationProperty_Value(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
        String oldVal = target.getValue();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).value(newVal) : builder;
    }

    protected ActivationOS transformActivationOS(ActivationOS target) {
        if (target == null) {
            return null;
        }
        Supplier<ActivationOS.Builder> creator = () -> ActivationOS.newBuilder((ActivationOS)target);
        ActivationOS.Builder builder = null;
        builder = this.transformActivationOS_Name(creator, builder, target);
        builder = this.transformActivationOS_Family(creator, builder, target);
        builder = this.transformActivationOS_Arch(creator, builder, target);
        return (builder = this.transformActivationOS_Version(creator, builder, target)) != null ? builder.build() : target;
    }

    protected ActivationOS.Builder transformActivationOS_Name(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
        String oldVal = target.getName();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).name(newVal) : builder;
    }

    protected ActivationOS.Builder transformActivationOS_Family(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
        String oldVal = target.getFamily();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).family(newVal) : builder;
    }

    protected ActivationOS.Builder transformActivationOS_Arch(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
        String oldVal = target.getArch();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).arch(newVal) : builder;
    }

    protected ActivationOS.Builder transformActivationOS_Version(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
        String oldVal = target.getVersion();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).version(newVal) : builder;
    }

    protected ActivationFile transformActivationFile(ActivationFile target) {
        if (target == null) {
            return null;
        }
        Supplier<ActivationFile.Builder> creator = () -> ActivationFile.newBuilder((ActivationFile)target);
        ActivationFile.Builder builder = null;
        builder = this.transformActivationFile_Missing(creator, builder, target);
        return (builder = this.transformActivationFile_Exists(creator, builder, target)) != null ? builder.build() : target;
    }

    protected ActivationFile.Builder transformActivationFile_Missing(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
        String oldVal = target.getMissing();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).missing(newVal) : builder;
    }

    protected ActivationFile.Builder transformActivationFile_Exists(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
        String oldVal = target.getExists();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).exists(newVal) : builder;
    }

    protected <T> List<T> transform(List<T> list, UnaryOperator<T> transformer) {
        List<T> newList = list;
        for (int i = 0; i < list.size(); ++i) {
            T oldVal = list.get(i);
            Object newVal = transformer.apply(oldVal);
            if (newVal == oldVal) continue;
            if (newList == list) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newVal);
        }
        return newList;
    }

    protected <T> Map<String, T> transform(Map<String, T> map, UnaryOperator<T> transformer) {
        Map<String, T> newMap = map;
        for (String key : map.keySet()) {
            T oldVal = map.get(key);
            Object newVal = transformer.apply(oldVal);
            if (newVal == oldVal) continue;
            if (newMap == map) {
                newMap = new HashMap<String, T>(map);
            }
            newMap.put(key, newVal);
        }
        return newMap;
    }

    protected XmlNode transform(XmlNode node) {
        if (node != null) {
            String oldValue = node.value();
            String newValue = this.transform(oldValue);
            Map oldAttrs = node.attributes();
            Map newAttrs = this.transform(oldAttrs, this::transform);
            List oldChildren = node.children();
            List newChildren = this.transform(oldChildren, this::transform);
            if (oldValue != newValue || oldAttrs != newAttrs || oldChildren != newChildren) {
                return XmlNode.newBuilder().name(node.name()).prefix(node.prefix()).namespaceUri(node.namespaceUri()).value(newValue).attributes(newAttrs).children(newChildren).inputLocation(node.inputLocation()).build();
            }
        }
        return node;
    }
}

