/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.ImmutableCollections;
import org.apache.maven.api.xml.XmlService;

@Experimental
@ThreadSafe
@Immutable
public interface XmlNode {
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String SELF_COMBINATION_MERGE = "merge";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String SELF_COMBINATION_REMOVE = "remove";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String ID_COMBINATION_MODE_ATTRIBUTE = "combine.id";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String KEYS_COMBINATION_MODE_ATTRIBUTE = "combine.keys";
    @Deprecated(since="4.0.0", forRemoval=true)
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";

    @Nonnull
    public String name();

    @Nonnull
    public String namespaceUri();

    @Nonnull
    public String prefix();

    @Nullable
    public String value();

    @Nonnull
    public Map<String, String> attributes();

    @Nullable
    public String attribute(@Nonnull String var1);

    @Nonnull
    public List<XmlNode> children();

    @Nullable
    public XmlNode child(String var1);

    @Nullable
    public Object inputLocation();

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    default public String getName() {
        return this.name();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    default public String getNamespaceUri() {
        return this.namespaceUri();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    default public String getPrefix() {
        return this.prefix();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nullable
    default public String getValue() {
        return this.value();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    default public Map<String, String> getAttributes() {
        return this.attributes();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nullable
    default public String getAttribute(@Nonnull String name) {
        return this.attribute(name);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nonnull
    default public List<XmlNode> getChildren() {
        return this.children();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nullable
    default public XmlNode getChild(String name) {
        return this.child(name);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nullable
    default public Object getInputLocation() {
        return this.inputLocation();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    default public XmlNode merge(@Nullable XmlNode source) {
        return XmlService.merge(this, source);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    default public XmlNode merge(@Nullable XmlNode source, @Nullable Boolean childMergeOverride) {
        return XmlService.merge(this, source, childMergeOverride);
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    @Nullable
    public static XmlNode merge(@Nullable XmlNode dominant, @Nullable XmlNode recessive) {
        return XmlService.merge(dominant, recessive, null);
    }

    @Nullable
    public static XmlNode merge(@Nullable XmlNode dominant, @Nullable XmlNode recessive, @Nullable Boolean childMergeOverride) {
        return XmlService.merge(dominant, recessive, childMergeOverride);
    }

    public static XmlNode newInstance(String name) {
        return XmlNode.newBuilder().name(name).build();
    }

    public static XmlNode newInstance(String name, String value) {
        return XmlNode.newBuilder().name(name).value(value).build();
    }

    public static XmlNode newInstance(String name, List<XmlNode> children) {
        return XmlNode.newBuilder().name(name).children(children).build();
    }

    public static XmlNode newInstance(String name, String value, Map<String, String> attrs, List<XmlNode> children, Object location) {
        return XmlNode.newBuilder().name(name).value(value).attributes(attrs).children(children).inputLocation(location).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String value;
        private String namespaceUri;
        private String prefix;
        private Map<String, String> attributes;
        private List<XmlNode> children;
        private Object inputLocation;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder children(List<XmlNode> children) {
            this.children = children;
            return this;
        }

        public Builder inputLocation(Object inputLocation) {
            this.inputLocation = inputLocation;
            return this;
        }

        public XmlNode build() {
            return new Impl(this.prefix, this.namespaceUri, this.name, this.value, this.attributes, this.children, this.inputLocation);
        }

        private record Impl(String prefix, String namespaceUri, @Nonnull String name, String value, @Nonnull Map<String, String> attributes, @Nonnull List<XmlNode> children, Object inputLocation) implements XmlNode,
        Serializable
        {
            private Impl {
                prefix = prefix == null ? "" : prefix;
                namespaceUri = namespaceUri == null ? "" : namespaceUri;
                name = Objects.requireNonNull(name);
                attributes = ImmutableCollections.copy(attributes);
                children = ImmutableCollections.copy(children);
            }

            @Override
            public String attribute(@Nonnull String name) {
                return this.attributes.get(name);
            }

            @Override
            public XmlNode child(String name) {
                if (name != null) {
                    ListIterator<XmlNode> it = this.children.listIterator(this.children.size());
                    while (it.hasPrevious()) {
                        XmlNode child = it.previous();
                        if (!name.equals(child.name())) continue;
                        return child;
                    }
                }
                return null;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Impl that = (Impl)o;
                return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.children, that.children);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.name, this.value, this.attributes, this.children);
            }

            @Override
            public String toString() {
                try {
                    StringWriter writer = new StringWriter();
                    XmlService.write(this, writer);
                    return writer.toString();
                }
                catch (IOException e) {
                    return this.toStringObject();
                }
            }

            private String toStringObject() {
                StringBuilder sb = new StringBuilder();
                sb.append("XmlNode[");
                boolean w = false;
                w = Impl.addToStringField(sb, this.prefix, o -> !o.isEmpty(), "prefix", w);
                w = Impl.addToStringField(sb, this.namespaceUri, o -> !o.isEmpty(), "namespaceUri", w);
                w = Impl.addToStringField(sb, this.name, o -> !o.isEmpty(), "name", w);
                w = Impl.addToStringField(sb, this.value, o -> !o.isEmpty(), "value", w);
                w = Impl.addToStringField(sb, this.attributes, o -> !o.isEmpty(), "attributes", w);
                w = Impl.addToStringField(sb, this.children, o -> !o.isEmpty(), "children", w);
                w = Impl.addToStringField(sb, this.inputLocation, Objects::nonNull, "inputLocation", w);
                sb.append("]");
                return sb.toString();
            }

            private static <T> boolean addToStringField(StringBuilder sb, T o, Function<T, Boolean> p, String n, boolean w) {
                if (!p.apply(o).booleanValue()) {
                    if (w) {
                        sb.append(", ");
                    } else {
                        w = true;
                    }
                    sb.append(n).append("='").append(o).append('\'');
                }
                return w;
            }
        }
    }
}

