/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.api.Session;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.transformation.impl.ConsumerPomBuilder;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
class DefaultConsumerPomBuilder
implements ConsumerPomBuilder {
    private static final String BOM_PACKAGING = "bom";
    public static final String POM_PACKAGING = "pom";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsumerPomBuilder.class);
    private final LifecycleBindingsInjector lifecycleBindingsInjector;

    @Inject
    DefaultConsumerPomBuilder(LifecycleBindingsInjector lifecycleBindingsInjector) {
        this.lifecycleBindingsInjector = lifecycleBindingsInjector;
    }

    @Override
    public Model build(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        Model model = project.getModel().getDelegate();
        String packaging = model.getPackaging();
        String originalPackaging = project.getOriginalModel().getPackaging();
        if (POM_PACKAGING.equals(packaging) && !BOM_PACKAGING.equals(originalPackaging)) {
            return this.buildPom(session, project, src);
        }
        return this.buildNonPom(session, project, src);
    }

    protected Model buildPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, project, src);
        Model model = result.getRawModel();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    protected Model buildNonPom(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        ModelBuilderResult result = this.buildModel(session, project, src);
        Model model = result.getEffectiveModel();
        return DefaultConsumerPomBuilder.transform(model, project);
    }

    private ModelBuilderResult buildModel(RepositorySystemSession session, MavenProject project, Path src) throws ModelBuilderException {
        InternalSession iSession = InternalSession.from((RepositorySystemSession)session);
        ModelBuilderRequest.ModelBuilderRequestBuilder request = ModelBuilderRequest.builder();
        request.requestType(ModelBuilderRequest.RequestType.BUILD_CONSUMER);
        request.session((Session)iSession);
        request.source(ModelSource.fromPath((Path)src));
        request.locationTracking(false);
        request.systemProperties(session.getSystemProperties());
        request.userProperties(session.getUserProperties());
        request.lifecycleBindingsInjector((arg_0, arg_1, arg_2) -> ((LifecycleBindingsInjector)this.lifecycleBindingsInjector).injectLifecycleBindings(arg_0, arg_1, arg_2));
        ModelBuilder.ModelBuilderSession mbSession = (ModelBuilder.ModelBuilderSession)iSession.getData().get(SessionData.key(ModelBuilder.ModelBuilderSession.class));
        return mbSession.build(request.build());
    }

    static Model transform(Model model, MavenProject project) {
        String packaging = model.getPackaging();
        boolean preserveModelVersion = model.isPreserveModelVersion();
        if (POM_PACKAGING.equals(packaging)) {
            if ((model = model.withRoot(false).withModules(null).withSubprojects(null)).getParent() != null) {
                model = model.withParent(model.getParent().withRelativePath(null));
            }
            if (!preserveModelVersion) {
                model = model.withPreserveModelVersion(false);
                String modelVersion = new MavenModelVersion().getModelVersion(model);
                model = model.withModelVersion(modelVersion);
            }
        } else if (BOM_PACKAGING.equals(packaging)) {
            DependencyManagement dependencyManagement = project.getOriginalModel().getDependencyManagement().getDelegate();
            ArrayList dependencies = new ArrayList();
            String version = model.getVersion();
            dependencyManagement.getDependencies().forEach(dependency -> dependencies.add(dependency.withVersion(version)));
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).dependencyManagement(dependencyManagement.withDependencies(dependencies)).build(null), (ModelBase)model);
            builder.packaging(POM_PACKAGING);
            builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            if (!"4.0.0".equals(modelVersion) && !preserveModelVersion) {
                DefaultConsumerPomBuilder.warnNotDowngraded(project);
            }
            model = model.withModelVersion(modelVersion);
        } else {
            Model.Builder builder = DefaultConsumerPomBuilder.prune(Model.newBuilder((Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model);
            builder.profiles(DefaultConsumerPomBuilder.prune(model.getProfiles()));
            model = builder.build();
            String modelVersion = new MavenModelVersion().getModelVersion(model);
            if (!"4.0.0".equals(modelVersion) && !preserveModelVersion) {
                DefaultConsumerPomBuilder.warnNotDowngraded(project);
            }
            model = model.withModelVersion(modelVersion);
        }
        return model;
    }

    static void warnNotDowngraded(MavenProject project) {
        LOGGER.warn("The consumer POM for " + project.getId() + " cannot be downgraded to 4.0.0. If you intent your build to be consumed with Maven 3 projects, you need to remove the features that request a newer model version.  If you're fine with having the consumer POM not consumable with Maven 3, add the `preserve.model.version='true'` attribute on the <project> element of your POM.");
    }

    private static List<Profile> prune(List<Profile> profiles) {
        return profiles.stream().map(p -> {
            Profile.Builder builder = Profile.newBuilder((Profile)p, (boolean)true);
            DefaultConsumerPomBuilder.prune(builder, (ModelBase)p);
            return builder.build(null).build();
        }).filter(p -> !DefaultConsumerPomBuilder.isEmpty(p)).collect(Collectors.toList());
    }

    private static boolean isEmpty(Profile profile) {
        return profile.getActivation() == null && profile.getBuild() == null && profile.getDependencies().isEmpty() && (profile.getDependencyManagement() == null || profile.getDependencyManagement().getDependencies().isEmpty()) && profile.getDistributionManagement() == null && profile.getModules().isEmpty() && profile.getSubprojects().isEmpty() && profile.getProperties().isEmpty() && profile.getRepositories().isEmpty() && profile.getPluginRepositories().isEmpty() && profile.getReporting() == null;
    }

    private static <T extends ModelBase.Builder> T prune(T builder, ModelBase model) {
        builder.properties(null).reporting(null);
        if (model.getDistributionManagement() != null && model.getDistributionManagement().getRelocation() != null) {
            builder.distributionManagement(DistributionManagement.newBuilder().relocation(model.getDistributionManagement().getRelocation()).build());
        }
        builder.pluginRepositories(DefaultConsumerPomBuilder.pruneRepositories(model.getPluginRepositories()));
        builder.repositories(DefaultConsumerPomBuilder.pruneRepositories(model.getRepositories()));
        return builder;
    }

    private static List<Repository> pruneRepositories(List<Repository> repositories) {
        return repositories.stream().filter(r -> !"central".equals(r.getId())).collect(Collectors.toList());
    }
}

