/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.internal.transformation.ConsumerPomArtifactTransformer;
import org.apache.maven.internal.transformation.impl.ConsumerPomBuilder;
import org.apache.maven.internal.transformation.impl.TransformedArtifact;
import org.apache.maven.model.v4.MavenStaxWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.sisu.PreDestroy;

@Singleton
@Named(value="consumer-pom")
class DefaultConsumerPomArtifactTransformer
implements ConsumerPomArtifactTransformer {
    private static final String NAMESPACE_FORMAT = "http://maven.apache.org/POM/%s";
    private static final String SCHEMA_LOCATION_FORMAT = "https://maven.apache.org/xsd/maven-%s.xsd";
    private final Set<Path> toDelete = new CopyOnWriteArraySet<Path>();
    private final ConsumerPomBuilder builder;

    @Inject
    DefaultConsumerPomArtifactTransformer(ConsumerPomBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void injectTransformedArtifacts(RepositorySystemSession session, MavenProject project) throws IOException {
        if (project.getFile() == null) {
            return;
        }
        boolean isModel40 = "4.0.0".equals(project.getModelVersion());
        if (Features.consumerPom((Map)session.getUserProperties(), (!isModel40 ? 1 : 0) != 0)) {
            Path buildDir;
            Path path = buildDir = project.getBuild() != null ? Paths.get(project.getBuild().getDirectory(), new String[0]) : null;
            if (buildDir != null) {
                Files.createDirectories(buildDir, new FileAttribute[0]);
            }
            Path consumer = buildDir != null ? Files.createTempFile(buildDir, "consumer-", ".pom", new FileAttribute[0]) : Files.createTempFile("consumer-", ".pom", new FileAttribute[0]);
            this.deferDeleteFile(consumer);
            project.addAttachedArtifact((org.apache.maven.artifact.Artifact)this.createConsumerPomArtifact(project, consumer, session));
        } else if (project.getModel().getDelegate().isRoot()) {
            throw new IllegalStateException("The use of the root attribute on the model requires the buildconsumer feature to be active");
        }
    }

    TransformedArtifact createConsumerPomArtifact(MavenProject project, Path consumer, RepositorySystemSession session) {
        return new TransformedArtifact(this, project, consumer, session, (org.apache.maven.artifact.Artifact)new ProjectArtifact(project), () -> project.getFile().toPath(), "consumer", "pom");
    }

    void transform(MavenProject project, RepositorySystemSession session, Path src, Path tgt) throws ModelBuilderException, XMLStreamException, IOException {
        Model model = this.builder.build(session, project, src);
        this.write(model, tgt);
    }

    private void deferDeleteFile(Path generatedFile) {
        this.toDelete.add(generatedFile.toAbsolutePath());
    }

    @PreDestroy
    private void doDeleteFiles() {
        for (Path file : this.toDelete) {
            try {
                Files.delete(file);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        if (this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    @Override
    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        if (this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    private boolean consumerPomPresent(Collection<Artifact> artifacts) {
        return artifacts.stream().anyMatch(a -> "pom".equals(a.getExtension()) && "consumer".equals(a.getClassifier()));
    }

    private Collection<Artifact> replacePom(Collection<Artifact> artifacts) {
        ArrayList<Artifact> consumers = new ArrayList<Artifact>();
        ArrayList<Artifact> mains = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!"pom".equals(artifact.getExtension()) && !artifact.getExtension().startsWith("pom.")) continue;
            if ("consumer".equals(artifact.getClassifier())) {
                consumers.add(artifact);
                continue;
            }
            if (!"".equals(artifact.getClassifier())) continue;
            mains.add(artifact);
        }
        if (!mains.isEmpty() && !consumers.isEmpty()) {
            ArrayList<Artifact> result = new ArrayList<Artifact>(artifacts);
            for (Artifact main : mains) {
                result.remove(main);
                result.add((Artifact)new DefaultArtifact(main.getGroupId(), main.getArtifactId(), "build", main.getExtension(), main.getVersion(), main.getProperties(), main.getFile()));
            }
            for (Artifact consumer : consumers) {
                result.remove(consumer);
                result.add((Artifact)new DefaultArtifact(consumer.getGroupId(), consumer.getArtifactId(), "", consumer.getExtension(), consumer.getVersion(), consumer.getProperties(), consumer.getFile()));
            }
            artifacts = result;
        }
        return artifacts;
    }

    void write(Model model, Path dest) throws IOException, XMLStreamException {
        String version = model.getModelVersion();
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        try (BufferedWriter w = Files.newBufferedWriter(dest, new OpenOption[0]);){
            MavenStaxWriter writer = new MavenStaxWriter();
            writer.setNamespace(String.format(NAMESPACE_FORMAT, version));
            writer.setSchemaLocation(String.format(SCHEMA_LOCATION_FORMAT, version));
            writer.setAddLocationInformation(false);
            writer.write((Writer)w, model);
        }
    }
}

