/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DuplicateProjectException;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.MissingProfilesException;
import org.apache.maven.ProjectCycleException;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.api.Session;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.BuildResumptionAnalyzer;
import org.apache.maven.execution.BuildResumptionData;
import org.apache.maven.execution.BuildResumptionDataRepository;
import org.apache.maven.execution.BuildResumptionPersistenceException;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.graph.ProjectSelector;
import org.apache.maven.internal.impl.DefaultSessionFactory;
import org.apache.maven.internal.impl.InternalMavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.resolver.MavenChainedWorkspaceReader;
import org.apache.maven.resolver.RepositorySystemSessionFactory;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.settings.IdentifiableBase;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.sisu.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

@Named
@Singleton
public class DefaultMaven
implements Maven {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Lookup lookup;
    private final ExecutionEventCatapult eventCatapult;
    private final LegacySupport legacySupport;
    private final SessionScope sessionScope;
    private final RepositorySystemSessionFactory repositorySessionFactory;
    private final GraphBuilder graphBuilder;
    private final BuildResumptionAnalyzer buildResumptionAnalyzer;
    private final BuildResumptionDataRepository buildResumptionDataRepository;
    private final SuperPomProvider superPomProvider;
    private final DefaultSessionFactory defaultSessionFactory;
    private final WorkspaceReader ideWorkspaceReader;
    private final ProjectSelector projectSelector;

    @Inject
    public DefaultMaven(Lookup lookup, ExecutionEventCatapult eventCatapult, LegacySupport legacySupport, SessionScope sessionScope, RepositorySystemSessionFactory repositorySessionFactory, @Named(value="graphBuilder") GraphBuilder graphBuilder, BuildResumptionAnalyzer buildResumptionAnalyzer, BuildResumptionDataRepository buildResumptionDataRepository, SuperPomProvider superPomProvider, DefaultSessionFactory defaultSessionFactory, @Nullable @Named(value="ide") WorkspaceReader ideWorkspaceReader) {
        this.lookup = lookup;
        this.eventCatapult = eventCatapult;
        this.legacySupport = legacySupport;
        this.sessionScope = sessionScope;
        this.repositorySessionFactory = repositorySessionFactory;
        this.graphBuilder = graphBuilder;
        this.buildResumptionAnalyzer = buildResumptionAnalyzer;
        this.buildResumptionDataRepository = buildResumptionDataRepository;
        this.superPomProvider = superPomProvider;
        this.ideWorkspaceReader = ideWorkspaceReader;
        this.defaultSessionFactory = defaultSessionFactory;
        this.projectSelector = new ProjectSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        MavenExecutionResult result;
        try {
            result = this.doExecute(request);
        }
        catch (OutOfMemoryError e) {
            result = this.addExceptionToResult(new DefaultMavenExecutionResult(), e);
        }
        catch (RuntimeException e) {
            result = e.getCause() instanceof ProjectCycleException ? this.addExceptionToResult(new DefaultMavenExecutionResult(), e.getCause()) : this.addExceptionToResult(new DefaultMavenExecutionResult(), new InternalErrorException("Internal error: " + e, e));
        }
        finally {
            this.legacySupport.setSession(null);
        }
        return result;
    }

    private MavenExecutionResult doExecute(MavenExecutionRequest request) {
        request.setStartInstant(MonotonicClock.now());
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            this.validateLocalRepository(request);
        }
        catch (IOException e) {
            return this.addExceptionToResult(result, e);
        }
        this.sessionScope.enter();
        MavenChainedWorkspaceReader chainedWorkspaceReader = new MavenChainedWorkspaceReader(request.getWorkspaceReader(), this.ideWorkspaceReader);
        try {
            MavenExecutionResult mavenExecutionResult;
            block11: {
                RepositorySystemSession.CloseableSession closeableSession = this.newCloseableSession(request, (WorkspaceReader)chainedWorkspaceReader);
                try {
                    MavenSession session = new MavenSession((RepositorySystemSession)closeableSession, request, result);
                    session.setSession((Session)this.defaultSessionFactory.newSession(session));
                    this.sessionScope.seed(MavenSession.class, session);
                    this.sessionScope.seed(Session.class, session.getSession());
                    this.sessionScope.seed(InternalMavenSession.class, InternalMavenSession.from(session.getSession()));
                    this.legacySupport.setSession(session);
                    mavenExecutionResult = this.doExecute(request, session, result, chainedWorkspaceReader);
                    if (closeableSession == null) break block11;
                }
                catch (Throwable throwable) {
                    if (closeableSession != null) {
                        try {
                            closeableSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                closeableSession.close();
            }
            return mavenExecutionResult;
        }
        finally {
            this.sessionScope.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenExecutionResult doExecute(MavenExecutionRequest request, MavenSession session, MavenExecutionResult result, MavenChainedWorkspaceReader chainedWorkspaceReader) {
        try {
            this.afterSessionStart(session);
        }
        catch (MavenExecutionException e) {
            return this.addExceptionToResult(result, e);
        }
        try {
            chainedWorkspaceReader.addReader((WorkspaceReader)this.lookup.lookup(WorkspaceReader.class, "reactor"));
        }
        catch (LookupException e) {
            return this.addExceptionToResult(result, e);
        }
        this.eventCatapult.fire(ExecutionEvent.Type.ProjectDiscoveryStarted, session, null);
        Result<? extends ProjectDependencyGraph> graphResult = this.buildGraph(session);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result, ((ModelProblem)graphResult.getProblems().iterator().next()).getException());
        }
        try {
            session.setProjectMap(this.getProjectMap(session.getProjects()));
        }
        catch (DuplicateProjectException e) {
            return this.addExceptionToResult(result, e);
        }
        try {
            this.setupWorkspaceReader(session, chainedWorkspaceReader);
        }
        catch (LookupException e) {
            return this.addExceptionToResult(result, e);
        }
        try {
            this.afterProjectsRead(session);
        }
        catch (MavenExecutionException e) {
            return this.addExceptionToResult(result, e);
        }
        graphResult = this.buildGraph(session);
        if (graphResult.hasErrors()) {
            return this.addExceptionToResult(result, ((ModelProblem)graphResult.getProblems().iterator().next()).getException());
        }
        try {
            if (result.hasExceptions()) {
                MavenExecutionResult e = result;
                return e;
            }
            result.setTopologicallySortedProjects(session.getProjects());
            result.setProject(session.getTopLevelProject());
            this.validatePrerequisitesForNonMavenPluginProjects(session.getProjects());
            this.validateRequiredProfiles(session, request.getProfileActivation());
            if (session.getResult().hasExceptions()) {
                MavenExecutionResult e = result;
                return e;
            }
            this.validateOptionalProfiles(session, request.getProfileActivation());
            LifecycleStarter lifecycleStarter = this.lookup.lookupOptional(LifecycleStarter.class, request.getBuilderId()).orElseGet(() -> (LifecycleStarter)this.lookup.lookup(LifecycleStarter.class));
            lifecycleStarter.execute(session);
            this.validateOptionalProjects(request, session);
            this.validateOptionalProfiles(session, request.getProfileActivation());
            if (session.getResult().hasExceptions()) {
                this.addExceptionToResult(result, session.getResult().getExceptions().get(0));
                this.persistResumptionData(result, session);
                MavenExecutionResult mavenExecutionResult = result;
                return mavenExecutionResult;
            }
            session.getAllProjects().stream().filter(MavenProject::isExecutionRoot).findFirst().ifPresent(this.buildResumptionDataRepository::removeResumptionData);
        }
        finally {
            try {
                this.afterSessionEnd(session);
            }
            catch (MavenExecutionException e) {
                this.addExceptionToResult(result, e);
            }
        }
        return result;
    }

    private void setupWorkspaceReader(MavenSession session, MavenChainedWorkspaceReader chainedWorkspaceReader) {
        LinkedHashSet<WorkspaceReader> workspaceReaders = new LinkedHashSet<WorkspaceReader>();
        WorkspaceReader reactorReader = (WorkspaceReader)this.lookup.lookup(WorkspaceReader.class, "reactor");
        workspaceReaders.add(reactorReader);
        for (WorkspaceReader repoWorkspaceReader : chainedWorkspaceReader.getReaders()) {
            if (repoWorkspaceReader == null || repoWorkspaceReader == reactorReader) continue;
            workspaceReaders.add(repoWorkspaceReader);
        }
        workspaceReaders.addAll(this.getProjectScopedExtensionComponents(session.getProjects(), WorkspaceReader.class));
        chainedWorkspaceReader.setReaders(workspaceReaders);
    }

    private void afterSessionStart(MavenSession session) throws MavenExecutionException {
        this.callListeners(session, AbstractMavenLifecycleParticipant::afterSessionStart);
    }

    private void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.callListeners(session, AbstractMavenLifecycleParticipant::afterProjectsRead);
    }

    private void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        this.callListeners(session, AbstractMavenLifecycleParticipant::afterSessionEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners(MavenSession session, ListenerMethod method) throws MavenExecutionException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getExtensionComponents(session.getProjects(), AbstractMavenLifecycleParticipant.class)) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                method.run(listener, session);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void persistResumptionData(MavenExecutionResult result, MavenSession session) {
        boolean hasLifecycleExecutionExceptions = result.getExceptions().stream().anyMatch(LifecycleExecutionException.class::isInstance);
        if (hasLifecycleExecutionExceptions) {
            MavenProject rootProject = session.getAllProjects().stream().filter(MavenProject::isExecutionRoot).findFirst().orElseThrow(() -> new IllegalStateException("No project in the session is execution root"));
            this.buildResumptionAnalyzer.determineBuildResumptionData(result).ifPresent(resumption -> {
                try {
                    this.buildResumptionDataRepository.persistResumptionData(rootProject, (BuildResumptionData)resumption);
                    result.setCanResume(true);
                }
                catch (BuildResumptionPersistenceException e) {
                    this.logger.warn("Could not persist build resumption data", (Throwable)e);
                }
            });
        }
    }

    @Deprecated
    public RepositorySystemSession newRepositorySession(MavenExecutionRequest request) {
        return this.newCloseableSession(request, (WorkspaceReader)new MavenChainedWorkspaceReader(new WorkspaceReader[0]));
    }

    private RepositorySystemSession.CloseableSession newCloseableSession(MavenExecutionRequest request, WorkspaceReader workspaceReader) {
        return this.repositorySessionFactory.newRepositorySessionBuilder(request).setWorkspaceReader(workspaceReader).build();
    }

    private void validateLocalRepository(MavenExecutionRequest request) throws IOException {
        File localRepoDir = request.getLocalRepositoryPath();
        this.logger.debug("Using local repository at {}", (Object)localRepoDir);
        localRepoDir.mkdirs();
        if (!localRepoDir.isDirectory()) {
            throw new IOException("Could not create local repository at " + localRepoDir);
        }
    }

    private <T> Collection<T> getExtensionComponents(Collection<MavenProject> projects, Class<T> role) {
        LinkedHashSet<T> foundComponents = new LinkedHashSet<T>();
        foundComponents.addAll(this.lookup.lookupList(role));
        foundComponents.addAll(this.getProjectScopedExtensionComponents(projects, role));
        return foundComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Collection<T> getProjectScopedExtensionComponents(Collection<MavenProject> projects, Class<T> role) {
        if (projects == null) {
            return Collections.emptyList();
        }
        LinkedHashSet foundComponents = new LinkedHashSet();
        HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
        try {
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                currentThread.setContextClassLoader((ClassLoader)projectRealm);
                foundComponents.addAll(this.lookup.lookupList(role));
            }
            LinkedHashSet linkedHashSet = foundComponents;
            return linkedHashSet;
        }
        finally {
            currentThread.setContextClassLoader(originalContextClassLoader);
        }
    }

    private MavenExecutionResult addExceptionToResult(MavenExecutionResult result, Throwable e) {
        if (!result.getExceptions().contains(e)) {
            result.addException(e);
        }
        return result;
    }

    private void validatePrerequisitesForNonMavenPluginProjects(List<MavenProject> projects) {
        for (MavenProject mavenProject : projects) {
            Prerequisites prerequisites;
            if ("maven-plugin".equals(mavenProject.getPackaging()) || (prerequisites = mavenProject.getModel().getDelegate().getPrerequisites()) == null || prerequisites.getMaven() == null) continue;
            this.logger.warn("The project {} uses prerequisites which is only intended for maven-plugin projects but not for non maven-plugin projects. For such purposes you should use the maven-enforcer-plugin. See https://maven.apache.org/enforcer/enforcer-rules/requireMavenVersion.html", (Object)mavenProject.getId());
        }
    }

    private Set<String> getAllProfiles(MavenSession session) {
        HashMap<String, Model> superPomModels = new HashMap<String, Model>();
        HashSet<MavenProject> projectsIncludingParents = new HashSet<MavenProject>();
        for (MavenProject project : session.getProjects()) {
            superPomModels.computeIfAbsent(project.getModelVersion(), v -> this.superPomProvider.getSuperModel(v).getDelegate());
            boolean isAdded = projectsIncludingParents.add(project);
            for (MavenProject parent = project.getParent(); isAdded && parent != null; parent = parent.getParent()) {
                isAdded = projectsIncludingParents.add(parent);
            }
        }
        Stream<String> projectProfiles = projectsIncludingParents.stream().flatMap(p -> p.getModel().getDelegate().getProfiles().stream()).map(Profile::getId);
        Stream<String> settingsProfiles = session.getSettings().getProfiles().stream().map(IdentifiableBase::getId);
        Stream<String> superPomProfiles = superPomModels.values().stream().flatMap(p -> p.getProfiles().stream()).map(Profile::getId);
        return Stream.of(projectProfiles, settingsProfiles, superPomProfiles).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    private void validateRequiredProfiles(MavenSession session, ProfileActivation profileActivation) {
        Set<String> allAvailableProfiles = this.getAllProfiles(session);
        HashSet<String> requiredProfiles = new HashSet<String>();
        requiredProfiles.addAll(profileActivation.getRequiredActiveProfileIds());
        requiredProfiles.addAll(profileActivation.getRequiredInactiveProfileIds());
        Set notFoundRequiredProfiles = requiredProfiles.stream().filter(rap -> !allAvailableProfiles.contains(rap)).collect(Collectors.toSet());
        if (!notFoundRequiredProfiles.isEmpty()) {
            String message = MessageFormatter.format((String)"The requested profiles {} could not be activated or deactivated because they do not exist.", notFoundRequiredProfiles).getMessage();
            this.addExceptionToResult(session.getResult(), new MissingProfilesException(message));
        }
    }

    private void validateOptionalProjects(MavenExecutionRequest request, MavenSession session) {
        ProjectActivation projectActivation = request.getProjectActivation();
        HashSet<String> allOptionalSelectors = new HashSet<String>();
        allOptionalSelectors.addAll(projectActivation.getOptionalActiveProjectSelectors());
        allOptionalSelectors.addAll(projectActivation.getRequiredActiveProjectSelectors());
        this.projectSelector.getOptionalProjectsBySelectors(request, session.getAllProjects(), allOptionalSelectors);
    }

    private void validateOptionalProfiles(MavenSession session, ProfileActivation profileActivation) {
        Set<String> allAvailableProfiles = this.getAllProfiles(session);
        HashSet<String> optionalProfiles = new HashSet<String>();
        optionalProfiles.addAll(profileActivation.getOptionalActiveProfileIds());
        optionalProfiles.addAll(profileActivation.getOptionalInactiveProfileIds());
        Set notFoundOptionalProfiles = optionalProfiles.stream().filter(rap -> !allAvailableProfiles.contains(rap)).collect(Collectors.toSet());
        if (!notFoundOptionalProfiles.isEmpty()) {
            this.logger.info("The requested optional profiles {} could not be activated or deactivated because they do not exist.", notFoundOptionalProfiles);
        }
    }

    private Map<String, MavenProject> getProjectMap(Collection<MavenProject> projects) throws DuplicateProjectException {
        LinkedHashMap<String, MavenProject> index = new LinkedHashMap<String, MavenProject>();
        LinkedHashMap<String, List<File>> collisions = new LinkedHashMap<String, List<File>>();
        for (MavenProject project : projects) {
            String projectId = ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
            MavenProject collision = (MavenProject)index.get(projectId);
            if (collision == null) {
                index.put(projectId, project);
                continue;
            }
            ArrayList<File> pomFiles = (ArrayList<File>)collisions.get(projectId);
            if (pomFiles == null) {
                pomFiles = new ArrayList<File>(Arrays.asList(collision.getFile(), project.getFile()));
                collisions.put(projectId, pomFiles);
                continue;
            }
            pomFiles.add(project.getFile());
        }
        if (!collisions.isEmpty()) {
            throw new DuplicateProjectException("Two or more projects in the reactor have the same identifier, please make sure that <groupId>:<artifactId>:<version> is unique for each project: " + collisions, collisions);
        }
        return index;
    }

    private Result<? extends ProjectDependencyGraph> buildGraph(MavenSession session) {
        Result<? extends ProjectDependencyGraph> graphResult = this.graphBuilder.build(session);
        for (ModelProblem problem : graphResult.getProblems()) {
            if (problem.getSeverity() == ModelProblem.Severity.WARNING) {
                this.logger.warn(problem.getMessage());
                continue;
            }
            this.logger.error(problem.getMessage());
        }
        if (!graphResult.hasErrors()) {
            ProjectDependencyGraph projectDependencyGraph = (ProjectDependencyGraph)graphResult.get();
            session.setProjects(projectDependencyGraph.getSortedProjects());
            session.setAllProjects(projectDependencyGraph.getAllProjects());
            session.setProjectDependencyGraph(projectDependencyGraph);
        }
        return graphResult;
    }

    @Deprecated
    protected Logger getLogger() {
        return this.logger;
    }

    @FunctionalInterface
    static interface ListenerMethod {
        public void run(AbstractMavenLifecycleParticipant var1, MavenSession var2) throws MavenExecutionException;
    }
}

