/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.spi.ModelParser;
import org.apache.maven.api.spi.ModelParserException;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.locator.ModelLocator;
import org.eclipse.sisu.Typed;

@Named(value="core-default")
@Singleton
@Typed(value={ModelProcessor.class})
@Deprecated(since="4.0.0")
public class DefaultModelProcessor
implements ModelProcessor {
    private final Collection<ModelParser> modelParsers;
    private final ModelLocator modelLocator;
    private final ModelReader modelReader;

    @Inject
    public DefaultModelProcessor(List<ModelParser> modelParsers, ModelLocator modelLocator, ModelReader modelReader) {
        this.modelParsers = modelParsers;
        this.modelLocator = modelLocator;
        this.modelReader = modelReader;
    }

    @Override
    @Deprecated
    public File locatePom(File projectDirectory) {
        return this.locatePom(projectDirectory.toPath()).toFile();
    }

    @Override
    public Path locatePom(Path projectDirectory) {
        Path pom = this.modelParsers.stream().map(m -> m.locate(projectDirectory).map(Source::getPath).orElse(null)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.modelLocator.locatePom(projectDirectory));
        if (!pom.equals(projectDirectory) && !pom.getParent().equals(projectDirectory)) {
            throw new IllegalArgumentException("The POM found does not belong to the given directory: " + pom);
        }
        return pom;
    }

    @Override
    @Deprecated
    public File locateExistingPom(File projectDirectory) {
        Path path = this.locateExistingPom(projectDirectory.toPath());
        return path != null ? path.toFile() : null;
    }

    @Override
    public Path locateExistingPom(Path projectDirectory) {
        Path pom = this.modelParsers.stream().map(m -> m.locate(projectDirectory).map(Source::getPath).orElse(null)).filter(Objects::nonNull).findFirst().orElseGet(() -> this.modelLocator.locateExistingPom(projectDirectory));
        if (pom != null && !pom.equals(projectDirectory) && !pom.getParent().equals(projectDirectory)) {
            throw new IllegalArgumentException("The POM found does not belong to the given directory: " + pom);
        }
        return pom;
    }

    protected org.apache.maven.api.model.Model read(Path pomFile, InputStream input, Reader reader, Map<String, ?> options) throws IOException {
        if (pomFile != null) {
            Path projectDirectory = pomFile.getParent();
            ArrayList<ModelParserException> exceptions = new ArrayList<ModelParserException>();
            for (ModelParser parser : this.modelParsers) {
                try {
                    Optional model = parser.locateAndParse(projectDirectory, options);
                    if (!model.isPresent()) continue;
                    return ((org.apache.maven.api.model.Model)model.get()).withPomFile(pomFile);
                }
                catch (ModelParserException e) {
                    exceptions.add(e);
                }
            }
            try {
                return this.readXmlModel(pomFile, null, null, options);
            }
            catch (IOException e) {
                exceptions.forEach(e::addSuppressed);
                throw e;
            }
        }
        return this.readXmlModel(pomFile, input, reader, options);
    }

    private org.apache.maven.api.model.Model readXmlModel(Path pomFile, InputStream input, Reader reader, Map<String, ?> options) throws IOException {
        if (pomFile != null) {
            return this.modelReader.read(pomFile, options).getDelegate();
        }
        if (input != null) {
            return this.modelReader.read(input, options).getDelegate();
        }
        return this.modelReader.read(reader, options).getDelegate();
    }

    @Override
    @Deprecated
    public Model read(File file, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(file, "file cannot be null");
        return this.read(file.toPath(), options);
    }

    @Override
    public Model read(Path path, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(path, "path cannot be null");
        org.apache.maven.api.model.Model model = this.read(path, null, null, options);
        return new Model(model);
    }

    @Override
    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model model;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            InputStream in = input;
            try {
                org.apache.maven.api.model.Model model2 = this.read(null, in, null, options);
                model = new Model(model2);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ModelParserException e) {
                    throw new ModelParseException("Unable to read model: " + e, e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return model;
    }

    @Override
    public Model read(Reader reader, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(reader, "reader cannot be null");
        try (Reader r = reader;){
            org.apache.maven.api.model.Model model = this.read(null, null, r, options);
            Model model2 = new Model(model);
            return model2;
        }
    }
}

