/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.MavenException;

@Experimental
public abstract class MavenBuilderException
extends MavenException {
    private final List<BuilderProblem> problems;

    public MavenBuilderException(String message, Throwable cause) {
        super(message, cause);
        this.problems = List.of();
    }

    public MavenBuilderException(String message, List<BuilderProblem> problems) {
        super(MavenBuilderException.buildMessage(message, problems), null);
        this.problems = problems;
    }

    protected static String buildMessage(String message, List<BuilderProblem> problems) {
        StringBuilder msg = new StringBuilder(message);
        ArrayList<BuilderProblem> sorted = new ArrayList<BuilderProblem>(problems);
        sorted.sort(Comparator.comparing(BuilderProblem::getSeverity));
        for (BuilderProblem problem : sorted) {
            msg.append("\n * ").append(problem.getSeverity().name()).append(": ").append(problem.getMessage());
        }
        return msg.toString();
    }

    public List<BuilderProblem> getProblems() {
        return this.problems;
    }
}

