/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model.profile;

import java.util.Locale;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;
import org.apache.maven.internal.impl.model.profile.Os;

@Named(value="os")
@Singleton
public class OperatingSystemProfileActivator
implements ProfileActivator {
    private static final String REGEX_PREFIX = "regex:";

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        if (os == null) {
            return false;
        }
        boolean active = this.ensureAtLeastOneNonNull(os);
        String actualOsName = this.getSystemProperty(context, "os.name", Os.OS_NAME).toLowerCase(Locale.ENGLISH);
        String actualOsArch = this.getSystemProperty(context, "os.arch", Os.OS_ARCH).toLowerCase(Locale.ENGLISH);
        String actualOsVersion = this.getSystemProperty(context, "os.version", Os.OS_VERSION).toLowerCase(Locale.ENGLISH);
        if (active && os.getFamily() != null) {
            active = this.determineFamilyMatch(os.getFamily(), actualOsName);
        }
        if (active && os.getName() != null) {
            active = this.determineNameMatch(os.getName(), actualOsName);
        }
        if (active && os.getArch() != null) {
            active = this.determineArchMatch(os.getArch(), actualOsArch);
        }
        if (active && os.getVersion() != null) {
            active = this.determineVersionMatch(os.getVersion(), actualOsVersion);
        }
        return active;
    }

    private String getSystemProperty(ProfileActivationContext context, String key, String defValue) {
        String val = context.getSystemProperty(key);
        return val != null ? val : defValue;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationOS os = activation.getOs();
        return os != null;
    }

    private boolean ensureAtLeastOneNonNull(ActivationOS os) {
        return os.getArch() != null || os.getFamily() != null || os.getName() != null || os.getVersion() != null;
    }

    private boolean determineVersionMatch(String expectedVersion, String actualVersion) {
        boolean result;
        String test = expectedVersion.toLowerCase(Locale.ENGLISH);
        boolean reverse = false;
        if (test.startsWith(REGEX_PREFIX)) {
            result = actualVersion.matches(test.substring(REGEX_PREFIX.length()));
        } else {
            if (test.startsWith("!")) {
                reverse = true;
                test = test.substring(1);
            }
            result = actualVersion.equals(test);
        }
        return reverse != result;
    }

    private boolean determineArchMatch(String expectedArch, String actualArch) {
        boolean result;
        String test = expectedArch.toLowerCase(Locale.ENGLISH);
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = actualArch.equals(test));
    }

    private boolean determineNameMatch(String family, String actualName) {
        boolean result;
        String test = family.toLowerCase(Locale.ENGLISH);
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = actualName.equals(test));
    }

    private boolean determineFamilyMatch(String family, String actualName) {
        boolean result;
        String test = family;
        boolean reverse = false;
        if (test.startsWith("!")) {
            reverse = true;
            test = test.substring(1);
        }
        return reverse != (result = Os.isFamily(test, actualName));
    }
}

