/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.annotations.Nonnull;

class PathModularization {
    public static final PathModularization NONE = new PathModularization();
    private static final String MODULE_INFO = "module-info.class";
    private static final Attributes.Name AUTO_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private final String filename;
    @Nonnull
    final Map<Path, Object> descriptors;
    final boolean isModuleHierarchy;

    private PathModularization() {
        this.filename = "(none)";
        this.descriptors = Collections.emptyMap();
        this.isModuleHierarchy = false;
    }

    PathModularization(Path path, boolean resolve) throws IOException {
        this.filename = path.getFileName().toString();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Path file = path.resolve(MODULE_INFO);
            if (Files.isRegularFile(file, new LinkOption[0])) {
                ModuleDescriptor descriptor = null;
                if (resolve) {
                    try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                        descriptor = ModuleDescriptor.read(in);
                    }
                }
                this.descriptors = Collections.singletonMap(file, descriptor);
                this.isModuleHierarchy = false;
                return;
            }
            if (Files.isDirectory(file, new LinkOption[0])) {
                HashMap multi = new HashMap();
                try (Stream<Path> subdirs = Files.list(file);){
                    subdirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(subdir -> {
                        Path mf = subdir.resolve(MODULE_INFO);
                        if (Files.isRegularFile(mf, new LinkOption[0])) {
                            ModuleDescriptor descriptor = null;
                            if (resolve) {
                                try (InputStream in = Files.newInputStream(mf, new OpenOption[0]);){
                                    descriptor = ModuleDescriptor.read(in);
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            }
                            multi.put(mf, descriptor);
                        }
                    });
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                if (!multi.isEmpty()) {
                    this.descriptors = Collections.unmodifiableMap(multi);
                    this.isModuleHierarchy = true;
                    return;
                }
            }
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            try (JarFile jar = new JarFile(path.toFile());){
                Object name;
                ZipEntry entry = jar.getEntry(MODULE_INFO);
                if (entry != null) {
                    ModuleDescriptor descriptor = null;
                    if (resolve) {
                        try (InputStream in = jar.getInputStream(entry);){
                            descriptor = ModuleDescriptor.read(in);
                        }
                    }
                    this.descriptors = Collections.singletonMap(path, descriptor);
                    this.isModuleHierarchy = false;
                    return;
                }
                Manifest mf = jar.getManifest();
                if (mf != null && (name = mf.getMainAttributes().get(AUTO_MODULE_NAME)) instanceof String) {
                    this.descriptors = Collections.singletonMap(path, name);
                    this.isModuleHierarchy = false;
                    return;
                }
            }
        }
        this.descriptors = Collections.emptyMap();
        this.isModuleHierarchy = false;
    }

    public JavaPathType getPathType() {
        return this.descriptors.isEmpty() ? JavaPathType.CLASSES : JavaPathType.MODULES;
    }

    public void addIfFilenameBasedAutomodules(Collection<String> automodulesDetected) {
        if (this.descriptors.isEmpty()) {
            automodulesDetected.add(this.filename);
        }
    }

    public boolean containsModule(String name) {
        return this.descriptors.containsValue(name);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.filename + "]";
    }
}

