/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.secdispatcher;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Provides;
import org.codehaus.plexus.components.secdispatcher.Cipher;
import org.codehaus.plexus.components.secdispatcher.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.MasterSource;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.DefaultSecDispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.cipher.AESGCMNoPadding;
import org.codehaus.plexus.components.secdispatcher.internal.dispatchers.LegacyDispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.dispatchers.MasterDispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.sources.EnvMasterSource;
import org.codehaus.plexus.components.secdispatcher.internal.sources.GpgAgentMasterSource;
import org.codehaus.plexus.components.secdispatcher.internal.sources.PinEntryMasterSource;
import org.codehaus.plexus.components.secdispatcher.internal.sources.SystemPropertyMasterSource;

@Named
public class SecDispatcherProvider {
    private static final String FILE_NAME = "settings-security4.xml";

    @Provides
    public static SecDispatcher secDispatcher(Map<String, Dispatcher> dispatchers) {
        return new DefaultSecDispatcher(dispatchers, SecDispatcherProvider.configurationFile());
    }

    @Provides
    @Named(value="legacy")
    public static Dispatcher legacyDispatcher() {
        return new LegacyDispatcher();
    }

    @Provides
    @Named(value="master")
    public static Dispatcher masterDispatcher(Map<String, Cipher> masterCiphers, Map<String, MasterSource> masterSources) {
        return new MasterDispatcher(masterCiphers, masterSources);
    }

    @Provides
    @Named(value="AES/GCM/NoPadding")
    public static Cipher aesGcmNoPaddingCipher() {
        return new AESGCMNoPadding();
    }

    @Provides
    @Named(value="env")
    public static MasterSource envMasterSource() {
        return new EnvMasterSource();
    }

    @Provides
    @Named(value="gpg-agent")
    public static MasterSource gpgAgentMasterSource() {
        return new GpgAgentMasterSource();
    }

    @Provides
    @Named(value="pinentry-prompt")
    public static MasterSource pinEntryMasterSource() {
        return new PinEntryMasterSource();
    }

    @Provides
    @Named(value="system-property")
    public static MasterSource systemPropertyMasterSource() {
        return new SystemPropertyMasterSource();
    }

    private static Path configurationFile() {
        String mavenUserConf = System.getProperty("maven.user.conf");
        if (mavenUserConf != null) {
            return Paths.get(mavenUserConf, FILE_NAME);
        }
        return Paths.get(System.getProperty("user.home"), ".m2", FILE_NAME);
    }
}

