/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.ProfileActivationFilePathInterpolator;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.codehaus.plexus.interpolation.InterpolationException;

@Named(value="file")
@Singleton
@Deprecated(since="4.0.0")
public class FileProfileActivator
implements ProfileActivator {
    private final ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator;

    @Inject
    public FileProfileActivator(ProfileActivationFilePathInterpolator profileActivationFilePathInterpolator) {
        this.profileActivationFilePathInterpolator = profileActivationFilePathInterpolator;
    }

    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        boolean missing;
        String path;
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        if (file == null) {
            return false;
        }
        if (file.getExists() != null && !file.getExists().isEmpty()) {
            path = file.getExists();
            missing = false;
        } else if (file.getMissing() != null && !file.getMissing().isEmpty()) {
            path = file.getMissing();
            missing = true;
        } else {
            return false;
        }
        try {
            path = this.profileActivationFilePathInterpolator.interpolate(path, context);
        }
        catch (InterpolationException e) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Failed to interpolate file location " + path + " for profile " + profile.getId() + ": " + e.getMessage()).setLocation(file.getLocation((Object)(missing ? "missing" : "exists"))).setException((Exception)((Object)e)));
            return false;
        }
        if (path == null) {
            return false;
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return false;
        }
        boolean fileExists = f.exists();
        return missing != fileExists;
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        Activation activation = profile.getActivation();
        if (activation == null) {
            return false;
        }
        ActivationFile file = activation.getFile();
        return file != null;
    }
}

