/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.internal.PhaseComparator;
import org.apache.maven.lifecycle.internal.PhaseId;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.project.MavenProject;

@Named(value="default")
@Singleton
public class DefaultLifecycleMappingDelegate
implements LifecycleMappingDelegate {
    public static final String HINT = "default";
    private final BuildPluginManager pluginManager;

    @Inject
    public DefaultLifecycleMappingDelegate(BuildPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session, MavenProject project, Lifecycle lifecycle, String lifecyclePhase) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        TreeMap<String, Map<PhaseId, List<MojoExecution>>> mappings = new TreeMap<String, Map<PhaseId, List<MojoExecution>>>(new PhaseComparator(lifecycle.getPhases()));
        Map<String, String> aliases = lifecycle.getDelegate().aliases().stream().collect(Collectors.toMap(a -> a.v3Phase(), a -> a.v4Phase()));
        if (aliases.containsKey(lifecyclePhase)) {
            lifecyclePhase = PhaseId.of(aliases.get(lifecyclePhase)).phase();
        }
        for (String phase : lifecycle.getPhases()) {
            TreeMap phaseBindings = new TreeMap(Comparator.comparing(PhaseId::toString, new PhaseComparator(lifecycle.getPhases())));
            mappings.put(phase, phaseBindings);
            if (!phase.equals(lifecyclePhase)) continue;
            break;
        }
        for (Plugin plugin : project.getBuild().getPlugins()) {
            for (PluginExecution execution : plugin.getExecutions()) {
                String phase = execution.getPhase();
                if (aliases.containsKey(phase)) {
                    phase = aliases.get(phase);
                }
                if (phase != null) {
                    Map<PhaseId, List<MojoExecution>> phaseBindings = this.getPhaseBindings(mappings, phase);
                    if (phaseBindings == null) continue;
                    for (String goal : execution.getGoals()) {
                        MojoExecution mojoExecution = new MojoExecution(plugin, goal, execution.getId());
                        mojoExecution.setLifecyclePhase(phase);
                        PhaseId phaseId = PhaseId.of(phase);
                        if (phaseId.priority() == 0) {
                            phaseId = PhaseId.of(phase + "[" + execution.getPriority() + "]");
                        }
                        this.addMojoExecution(phaseBindings, mojoExecution, phaseId);
                    }
                    continue;
                }
                for (String goal : execution.getGoals()) {
                    Map<PhaseId, List<MojoExecution>> phaseBindings;
                    MojoDescriptor mojoDescriptor = this.pluginManager.getMojoDescriptor(plugin, goal, project.getRemotePluginRepositories(), session.getRepositorySession());
                    phase = mojoDescriptor.getPhase();
                    if (aliases.containsKey(phase)) {
                        phase = aliases.get(phase);
                    }
                    if ((phaseBindings = this.getPhaseBindings(mappings, phase)) == null) continue;
                    MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, execution.getId());
                    mojoExecution.setLifecyclePhase(phase);
                    PhaseId phaseId = PhaseId.of(phase + "[" + execution.getPriority() + "]");
                    this.addMojoExecution(phaseBindings, mojoExecution, phaseId);
                }
            }
        }
        LinkedHashMap<String, List<MojoExecution>> lifecycleMappings = new LinkedHashMap<String, List<MojoExecution>>();
        for (Map.Entry entry : mappings.entrySet()) {
            ArrayList mojoExecutions = new ArrayList();
            for (List executions : ((Map)entry.getValue()).values()) {
                mojoExecutions.addAll(executions);
            }
            lifecycleMappings.put((String)entry.getKey(), mojoExecutions);
        }
        return lifecycleMappings;
    }

    private Map<PhaseId, List<MojoExecution>> getPhaseBindings(Map<String, Map<PhaseId, List<MojoExecution>>> mappings, String phase) {
        if (phase != null) {
            PhaseId id = PhaseId.of(phase);
            return mappings.get(id.phase());
        }
        return null;
    }

    private void addMojoExecution(Map<PhaseId, List<MojoExecution>> phaseBindings, MojoExecution mojoExecution, PhaseId phaseId) {
        List mojoExecutions = phaseBindings.computeIfAbsent(phaseId, k -> new ArrayList());
        mojoExecutions.add(mojoExecution);
    }
}

