/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.ActivationSettings;

public class ProjectActivation {
    private final List<ProjectActivationSettings> activations = new ArrayList<ProjectActivationSettings>();

    public void addProjectActivation(String selector, boolean active, boolean optional) {
        ActivationSettings settings = ActivationSettings.of(active, optional);
        this.activations.add(new ProjectActivationSettings(selector, settings));
    }

    private Stream<ProjectActivationSettings> getProjects(Predicate<ActivationSettings> predicate) {
        return this.activations.stream().filter(activation -> predicate.test(activation.activationSettings));
    }

    private Set<String> getProjectSelectors(Predicate<ActivationSettings> predicate) {
        return this.getProjects(predicate).map(activation -> activation.selector).collect(Collectors.toSet());
    }

    public Set<String> getRequiredActiveProjectSelectors() {
        return this.getProjectSelectors(pa -> !pa.optional && pa.active);
    }

    public Set<String> getOptionalActiveProjectSelectors() {
        return this.getProjectSelectors(pa -> pa.optional && pa.active);
    }

    public Set<String> getRequiredInactiveProjectSelectors() {
        return this.getProjectSelectors(pa -> !pa.optional && !pa.active);
    }

    public Set<String> getOptionalInactiveProjectSelectors() {
        return this.getProjectSelectors(pa -> pa.optional && !pa.active);
    }

    @Deprecated
    public List<String> getSelectedProjects() {
        return Collections.unmodifiableList(new ArrayList<String>(this.getProjectSelectors(pa -> pa.active)));
    }

    @Deprecated
    public List<String> getExcludedProjects() {
        return Collections.unmodifiableList(new ArrayList<String>(this.getProjectSelectors(pa -> !pa.active)));
    }

    @Deprecated
    public void overwriteActiveProjects(List<String> activeProjectSelectors) {
        List projects = this.getProjects(pa -> pa.active).collect(Collectors.toList());
        this.activations.removeAll(projects);
        activeProjectSelectors.forEach(this::activateOptionalProject);
    }

    @Deprecated
    public void overwriteInactiveProjects(List<String> inactiveProjectSelectors) {
        List projects = this.getProjects(pa -> !pa.active).collect(Collectors.toList());
        this.activations.removeAll(projects);
        inactiveProjectSelectors.forEach(this::deactivateOptionalProject);
    }

    public void activateRequiredProject(String selector) {
        this.activations.add(new ProjectActivationSettings(selector, ActivationSettings.ACTIVATION_REQUIRED));
    }

    public void activateOptionalProject(String selector) {
        this.activations.add(new ProjectActivationSettings(selector, ActivationSettings.ACTIVATION_OPTIONAL));
    }

    public void deactivateRequiredProject(String selector) {
        this.activations.add(new ProjectActivationSettings(selector, ActivationSettings.DEACTIVATION_REQUIRED));
    }

    public void deactivateOptionalProject(String selector) {
        this.activations.add(new ProjectActivationSettings(selector, ActivationSettings.DEACTIVATION_OPTIONAL));
    }

    public boolean isEmpty() {
        return this.activations.isEmpty();
    }

    private static class ProjectActivationSettings {
        final String selector;
        final ActivationSettings activationSettings;

        ProjectActivationSettings(String selector, ActivationSettings activationSettings) {
            this.selector = selector;
            this.activationSettings = activationSettings;
        }
    }
}

