<?xml version="1.0" encoding="UTF-8"?>
<!-- 
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0" xmlns:fox="http://xml.apache.org/fop/extensions">
    <!-- Templates for handling the outline -->
    <xsl:template name="fo-outline">
        <xsl:apply-templates mode="outline"/>
    </xsl:template>

    <xsl:template match="project/body" mode="outline">
        <xsl:apply-templates mode="outline"/>
    </xsl:template>

    <xsl:template match="menu | menu/item | menu/item/item | menu/item/item/item" mode="outline">
        <!-- use the apache FOP outline extension to recursively create bookmark block -->
        <fox:outline internal-destination="{@href}{generate-id()}">
            <fox:label><xsl:value-of select="@name"/></fox:label>
            <xsl:apply-templates mode="outline"/>
        </fox:outline>
    </xsl:template>


</xsl:stylesheet>