package @PACKAGE@;

/* ====================================================================
 *   Copyright 2004 The Apache Software Foundation.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * ====================================================================
 */

import org.apache.cactus.ServletTestCase;

import com.meterware.httpunit.WebConversation;

/**
 * This tests the system using the HttpUnit
 */
public class HttpUnitTest extends ServletTestCase {

    /**
     * This tests if the Hello World servlet provides the correct output
     * 
     * @throws Exception
     *                    thrown when there is a problem with the test
     */
    public void testHelloWorldServlet() throws Exception {
        WebConversation wc = new WebConversation();
        wc.getResponse(requestUrl("/HelloWorld"));
        assertTrue(wc.getCurrentPage().getText().startsWith("Hello world on"));
    }

    /**
     * This tests if the Hello World JSP provides the correct output
     * 
     * @throws Exception
     *                    thrown when there is a problem with the test
     */
    public void testHelloWorldJsp() throws Exception {
        WebConversation wc = new WebConversation();
        wc.getResponse(requestUrl("/sample.jsp"));
        assertTrue(wc.getCurrentPage().getText().startsWith("Hello world JSP on"));
    }

    /**
     * This is a helper method to create the URL string for the initial web
     * conversation request
     * 
     * @param relativeUrl
     *                   the relative URL including the leading"/"
     * @return the context url with the relative URL appended to it
     */
    private String requestUrl(String relativeUrl) {
        StringBuffer url = request.getRequestURL();
        url.delete(url.lastIndexOf("/"), url.length());
        url.append(relativeUrl);
        return url.toString();
    }
}
