/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.javacc;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.javacc.BaseBean;
import org.javacc.jjtree.JJTree;

public class JJTreeBean
extends BaseBean {
    public int generate() throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        File outputDir = this.getJJTreeOutputDir();
        System.err.println("-OUTPUT_DIRECTORY=" + outputDir.getCanonicalPath());
        long timestamp = System.currentTimeMillis();
        System.err.println("Creating directory: " + outputDir.getCanonicalPath());
        if (!outputDir.exists()) {
            System.out.println("Creating directorty: " + outputDir.getAbsolutePath());
            outputDir.mkdirs();
        } else if (!this.checkTimestamp()) {
            return 0;
        }
        params.add("-OUTPUT_DIRECTORY=" + outputDir.getCanonicalPath());
        params.add(this.getGrammar());
        String[] args = params.toArray(new String[params.size()]);
        JJTree jjtree = new JJTree();
        int retValue = jjtree.main(args);
        this.moveJJTJavaParserState();
        this.createTimestampFile(timestamp, outputDir);
        return retValue;
    }

    private void moveJJTJavaParserState() {
        File jjtJavaParserStateFileNew;
        File jjtJavaParserStateFileOrg = new File(this.getJJTreeOutputDir(), "JJTJavaParserState.java");
        if (!jjtJavaParserStateFileOrg.equals(jjtJavaParserStateFileNew = new File(this.getJavaccOutputDir(), "JJTJavaParserState.java"))) {
            File dir = jjtJavaParserStateFileNew.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            System.out.println("Moving: " + jjtJavaParserStateFileOrg + " to: " + jjtJavaParserStateFileNew);
            jjtJavaParserStateFileOrg.renameTo(jjtJavaParserStateFileNew);
        }
    }

    public String getJavaccGrammar() {
        File grammarFile = new File(this.getGrammar());
        String grammarName = grammarFile.getName();
        grammarName = grammarName.substring(0, grammarName.length() - 1);
        String retValue = this.getJJTreeOutputDir() + File.separator + grammarName;
        return retValue;
    }
}

