/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.javacc;

import java.io.File;
import org.codehaus.plexus.util.FileUtils;

public class BaseBean {
    private String grammar;
    private String javaccPackageName;
    private String jjtreePackageName;
    private String header;
    private String generatedSourceDirectory;

    public String getGrammar() {
        return this.grammar;
    }

    public void setGrammar(String grammar) {
        this.grammar = grammar;
    }

    public void setJavaccPackageName(String javaccPackageName) {
        this.javaccPackageName = javaccPackageName;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public File getJavaccOutputDir() {
        String packagePath = this.javaccPackageName.replace('.', File.separatorChar);
        return new File(this.generatedSourceDirectory, packagePath);
    }

    public File getJJTreeOutputDir() {
        String packagePath = this.jjtreePackageName.replace('.', File.separatorChar);
        return new File(this.generatedSourceDirectory, packagePath);
    }

    protected void addHeader(File directory) throws Exception {
        File headerFile = new File(this.getHeader());
        if (headerFile.exists()) {
            String headerContent = this.getHeaderContent();
            File[] generatedFiles = directory.listFiles();
            for (int i = 0; i < generatedFiles.length; ++i) {
                File generatedFile = generatedFiles[i];
                this.addHeader(generatedFile, headerContent);
            }
        }
    }

    protected String getHeaderContent() {
        try {
            return FileUtils.fileRead((String)this.header);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void addHeader(File file, String headerContent) throws Exception {
        if (!file.getName().endsWith(".java")) {
            return;
        }
        String content = FileUtils.fileRead((String)file.getCanonicalPath());
        content = headerContent + content;
        FileUtils.fileWrite((String)file.getCanonicalPath(), (String)content);
    }

    public void createTimestampFile(long timestamp, File directory) throws Exception {
        File timestampFile = new File(directory, ".timestamp");
        FileUtils.fileWrite((String)timestampFile.getAbsolutePath(), (String)("" + timestamp));
    }

    public long readTimestampFile(File directory) {
        return 0L;
    }

    public boolean checkTimestamp() throws Exception {
        return true;
    }

    public String getJjtreePackageName() {
        return this.jjtreePackageName;
    }

    public void setJjtreePackageName(String jjtreePackageName) {
        this.jjtreePackageName = jjtreePackageName;
    }

    public String getGeneratedSourceDirectory() {
        return this.generatedSourceDirectory;
    }

    public void setGeneratedSourceDirectory(String generatedSourceDirectory) {
        this.generatedSourceDirectory = generatedSourceDirectory;
    }
}

