/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.linkcheck.validation;

import java.io.File;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationItem;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationResult;
import org.apache.maven.plugin.linkcheck.validation.LinkValidator;

public final class FileLinkValidator
implements LinkValidator {
    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        File f = this.getFile(lvi);
        if (f.exists()) {
            return new LinkValidationResult(2, false, "");
        }
        return new LinkValidationResult(1, false, "doesn't exist.");
    }

    public Object getResourceKey(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.startsWith("http://") || link.startsWith("https://") || link.indexOf(64) != -1) {
            return null;
        }
        return this.getFile(lvi).getAbsolutePath();
    }

    protected File getFile(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.indexOf(35) != -1 && (link = link.substring(0, link.indexOf(35))).trim().length() == 0) {
            return lvi.getSource();
        }
        if (link.indexOf(63) != -1 && (link = link.substring(0, link.indexOf(63))).trim().length() == 0) {
            return lvi.getSource();
        }
        File f = new File(lvi.getSource().getParentFile(), link);
        return f;
    }
}

