/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.linkcheck;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.linkcheck.LinkCheckResult;
import org.apache.maven.plugin.linkcheck.LinkMatcher;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationItem;
import org.apache.maven.plugin.linkcheck.validation.LinkValidationResult;
import org.apache.maven.plugin.linkcheck.validation.LinkValidatorManager;

public final class FileToCheck {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$plugin$linkcheck$FileToCheck == null ? (class$org$apache$maven$plugin$linkcheck$FileToCheck = FileToCheck.class$("org.apache.maven.plugin.linkcheck.FileToCheck")) : class$org$apache$maven$plugin$linkcheck$FileToCheck));
    public static final String STATUS_UNKNOWN = null;
    public static final String STATUS_JTIDY_FAILURE = "Unable to tidy source";
    public static final String STATUS_OK = "OK";
    private String base;
    private File fileToCheck;
    private List links = new LinkedList();
    private String message = "";
    private String status = "OK";
    private int successful;
    private int unsuccessful;
    static /* synthetic */ Class class$org$apache$maven$plugin$linkcheck$FileToCheck;

    public String getMessage() {
        return this.message;
    }

    public String getName() {
        String fileName = this.fileToCheck.getAbsolutePath();
        if (fileName.startsWith(this.base)) {
            fileName = fileName.substring(this.base.length() + 1);
        }
        fileName = fileName.replace('\\', '/');
        return fileName;
    }

    public List getResults() {
        return this.links;
    }

    public String getStatus() {
        return this.status;
    }

    public int getSuccessful() {
        return this.successful;
    }

    public int getUnsuccessful() {
        return this.unsuccessful;
    }

    public FileToCheck(File baseFile, File fileToCheck) {
        this.base = baseFile.getAbsolutePath();
        this.fileToCheck = fileToCheck;
    }

    public void check(LinkValidatorManager lvm) throws Exception {
        this.successful = 0;
        this.unsuccessful = 0;
        this.status = STATUS_OK;
        this.message = "";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validating " + this.getName()));
        }
        try {
            LinkValidationResult result;
            LinkValidationItem lvi;
            LinkCheckResult lcr;
            String href;
            Set hrefs;
            try {
                hrefs = LinkMatcher.match(this.fileToCheck);
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)("Received: [" + t + "] in page [" + this.getName() + "]"), t);
                } else {
                    LOG.error((Object)("Received: [" + t + "] in page [" + this.getName() + "]"));
                }
                LinkCheckResult lcr2 = new LinkCheckResult();
                lcr2.setStatus("PARSE FAILURE");
                lcr2.setTarget("N/A");
                this.addResult(lcr2);
                return;
            }
            Iterator iter = hrefs.iterator();
            while (iter.hasNext()) {
                href = (String)iter.next();
                lcr = new LinkCheckResult();
                lvi = new LinkValidationItem(this.fileToCheck, href);
                result = lvm.validateLink(lvi);
                lcr.setTarget(href);
                lcr.setErrorMessage(result.getErrorMessage());
                switch (result.getStatus()) {
                    case 2: {
                        ++this.successful;
                        lcr.setStatus("valid");
                        this.addResult(lcr);
                        break;
                    }
                    case 3: {
                        ++this.unsuccessful;
                        lcr.setStatus("unknown");
                        this.addResult(lcr);
                        break;
                    }
                    case 1: {
                        ++this.unsuccessful;
                        lcr.setStatus("error");
                        this.addResult(lcr);
                        break;
                    }
                    case 4: {
                        ++this.unsuccessful;
                        lcr.setStatus("warning");
                        this.addResult(lcr);
                    }
                }
            }
            href = null;
            lcr = null;
            lvi = null;
            result = null;
        }
        catch (Exception e) {
            LOG.error((Object)this.message);
            throw e;
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("  <file>\n");
        buf.append("    <name><![CDATA[" + this.getName() + "]]></name>\n");
        buf.append("    <successful>" + this.getSuccessful() + "</successful>\n");
        buf.append("    <unsuccessful>" + this.getUnsuccessful() + "</unsuccessful>\n");
        Iterator iter = this.getResults().iterator();
        while (iter.hasNext()) {
            LinkCheckResult result = (LinkCheckResult)iter.next();
            buf.append(result.toXML());
        }
        buf.append("  </file>\n");
        return buf.toString();
    }

    private void addResult(LinkCheckResult lcr) {
        this.links.add(lcr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

