/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenException;
import org.apache.maven.project.Project;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.ftp.FtpWagon;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.providers.ssh.external.ScpExternalWagon;
import org.apache.maven.wagon.providers.ssh.jsch.ScpWagon;
import org.apache.maven.wagon.providers.ssh.jsch.SftpWagon;
import org.apache.maven.wagon.providers.ssh.knownhost.KnownHostsProvider;
import org.apache.maven.wagon.providers.ssh.knownhost.NullKnownHostProvider;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.repository.RepositoryPermissions;

public class RepositoryBuilder {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$artifact$deployer$RepositoryBuilder == null ? (class$org$apache$maven$artifact$deployer$RepositoryBuilder = RepositoryBuilder.class$("org.apache.maven.artifact.deployer.RepositoryBuilder")) : class$org$apache$maven$artifact$deployer$RepositoryBuilder));
    static /* synthetic */ Class class$org$apache$maven$artifact$deployer$RepositoryBuilder;

    public static Repository getRepository(Project project, String id) throws MavenException {
        String url = (String)project.getContext().getVariable("maven.repo." + id);
        if (url == null) {
            throw new MavenException("URL not specified in property: maven.repo." + id);
        }
        Repository repository = new Repository(id, url);
        String dir = (String)project.getContext().getVariable("maven.repo." + id + ".directory");
        if (repository.getBasedir() != null && dir != null) {
            dir = dir.replace('\\', '/');
            if (!repository.getBasedir().endsWith("/") && !dir.startsWith("/")) {
                dir = "/" + dir;
            }
            dir = repository.getBasedir() + dir;
        }
        repository.setBasedir(dir);
        if (dir == null) {
            throw new MavenException("Directory not specified in property: maven.repo." + id + ".directory");
        }
        String port = (String)project.getContext().getVariable("maven.repo." + id + ".port");
        if (port != null) {
            try {
                repository.setPort(Integer.valueOf(port).intValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Invalid format for port: " + port));
            }
        }
        String remoteGroup = (String)project.getContext().getVariable("maven.repo." + id + ".group");
        String remoteMode = (String)project.getContext().getVariable("maven.repo." + id + ".mode");
        String remoteDirectoryMode = (String)project.getContext().getVariable("maven.repo." + id + ".directory.mode");
        if (remoteMode == null) {
            remoteMode = "g+w";
        }
        if (remoteDirectoryMode == null) {
            remoteDirectoryMode = remoteMode;
        }
        RepositoryPermissions permissions = new RepositoryPermissions();
        permissions.setDirectoryMode(remoteDirectoryMode);
        permissions.setFileMode(remoteMode);
        permissions.setGroup(remoteGroup);
        repository.setPermissions(permissions);
        return repository;
    }

    public static void configureFtpWagon(Project project, String id, FtpWagon wagon) {
    }

    public static void configureSshWagon(Project project, String id, AbstractSshWagon wagon) {
        NullKnownHostProvider nkhp = new NullKnownHostProvider();
        nkhp.setHostKeyChecking("no");
        wagon.setKnownHostsProvider((KnownHostsProvider)nkhp);
    }

    public static void configureSftpWagon(Project project, String id, SftpWagon wagon) {
        RepositoryBuilder.configureSshWagon(project, id, (AbstractSshWagon)wagon);
    }

    public static void configureScpWagon(Project project, String id, ScpWagon wagon) {
        RepositoryBuilder.configureSshWagon(project, id, (AbstractSshWagon)wagon);
    }

    public static void configureSshExternalWagon(Project project, String id, ScpExternalWagon wagon) {
        String sshArgs;
        String sshExe;
        String scpArgs;
        String scpExe = (String)project.getContext().getVariable("maven.repo." + id + ".scp.executable");
        if (scpExe == null) {
            scpExe = (String)project.getContext().getVariable("maven.scp.executable");
        }
        if (scpExe != null) {
            wagon.setScpExecutable(scpExe);
        }
        if ((scpArgs = (String)project.getContext().getVariable("maven.repo." + id + ".scp.args")) == null) {
            scpArgs = (String)project.getContext().getVariable("maven.scp.args");
        }
        if (scpArgs != null) {
            wagon.setScpArgs(scpArgs);
        }
        if ((sshExe = (String)project.getContext().getVariable("maven.repo." + id + ".ssh.executable")) == null) {
            sshExe = (String)project.getContext().getVariable("maven.ssh.executable");
        }
        if (sshExe != null) {
            wagon.setSshExecutable(sshExe);
        }
        if ((sshArgs = (String)project.getContext().getVariable("maven.repo." + id + ".ssh.args")) == null) {
            sshArgs = (String)project.getContext().getVariable("maven.ssh.args");
        }
        if (sshArgs != null) {
            wagon.setSshArgs(sshArgs);
        }
    }

    public static void getProxyInfo(Project project) {
        ProxyInfo proxyInfo = new ProxyInfo();
        String proxyHost = project.getContext().getProxyHost();
        String proxyUser = project.getContext().getProxyUserName();
        String proxyPassword = project.getContext().getProxyPassword();
        String proxyPort = project.getContext().getProxyPort();
        if (proxyPort != null) {
            try {
                proxyInfo.setPort(Integer.valueOf(proxyPort).intValue());
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Invalid format for port: " + proxyPort));
            }
        }
        proxyInfo.setType("http");
        proxyInfo.setHost(proxyHost);
        proxyInfo.setNonProxyHosts((String)project.getContext().getVariable("maven.proxy.nonProxyHosts"));
        proxyInfo.setNtlmDomain((String)project.getContext().getVariable("maven.proxy.ntlm.domain"));
        proxyInfo.setNtlmHost((String)project.getContext().getVariable("maven.proxy.ntlm.host"));
        proxyInfo.setUserName(proxyUser);
        proxyInfo.setPassword(proxyPassword);
    }

    public static AuthenticationInfo getAuthenticationInfo(Project project, String id) {
        String username = (String)project.getContext().getVariable("maven.repo." + id + ".username");
        String password = (String)project.getContext().getVariable("maven.repo." + id + ".password");
        String passphrase = (String)project.getContext().getVariable("maven.repo." + id + ".passphrase");
        String privateKey = (String)project.getContext().getVariable("maven.repo." + id + ".privatekey");
        if (username == null) {
            username = (String)project.getContext().getVariable("maven.username");
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setUserName(username);
        authenticationInfo.setPassword(password);
        authenticationInfo.setPrivateKey(privateKey);
        authenticationInfo.setPassphrase(passphrase);
        return authenticationInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

