/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import org.apache.maven.MavenException;
import org.apache.maven.artifact.deployer.NamedArtifactDeployer;
import org.apache.maven.artifact.deployer.NamedArtifactTypeHandler;
import org.apache.maven.project.Project;
import org.apache.maven.repository.ArtifactTypeHandler;

public class DeployBean {
    private NamedArtifactDeployer artifactDeployer = new NamedArtifactDeployer();
    private Project project;
    private String artifact;
    private String type;
    private String artifactIdOverride;
    private ArtifactTypeHandler typeHandler;

    public ArtifactTypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(ArtifactTypeHandler typeHandler) {
        this.typeHandler = typeHandler;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArtifactIdOverride() {
        return this.artifactIdOverride;
    }

    public void setArtifactIdOverride(String newIdOverride) {
        this.artifactIdOverride = newIdOverride;
    }

    protected void checkAttributes() throws MavenException {
        if (this.project == null) {
            throw new MavenException("attribute 'project' is required");
        }
        if (this.artifact == null) {
            throw new MavenException("attribute 'artifact' is required");
        }
        if (this.type == null) {
            throw new MavenException("attribute 'type' is required");
        }
        if (this.typeHandler == null) {
            this.typeHandler = new NamedArtifactTypeHandler();
            if (this.artifactIdOverride != null) {
                ((NamedArtifactTypeHandler)this.typeHandler).setArtifactId(this.artifactIdOverride);
            }
        }
    }

    public void deploy() throws MavenException {
        this.checkAttributes();
        if (this.artifactIdOverride != null) {
            this.artifactDeployer.deploy(this.artifact, this.type, this.project, (NamedArtifactTypeHandler)this.typeHandler);
        } else {
            this.artifactDeployer.deploy(this.artifact, this.type, this.project, this.typeHandler);
        }
    }

    public void deploySnapshot() throws MavenException {
        this.checkAttributes();
        if (this.artifactIdOverride != null) {
            this.artifactDeployer.deploySnapshot(this.artifact, this.type, this.project, (NamedArtifactTypeHandler)this.typeHandler);
        } else {
            this.artifactDeployer.deploySnapshot(this.artifact, this.type, this.project, this.typeHandler);
        }
    }

    public void install() throws MavenException {
        this.checkAttributes();
        if (this.artifactIdOverride != null) {
            this.artifactDeployer.install(this.artifact, this.type, this.project, this.typeHandler);
        } else {
            this.artifactDeployer.install(this.artifact, this.type, this.project, this.typeHandler);
        }
    }

    public void installSnapshot() throws MavenException {
        this.checkAttributes();
        if (this.artifactIdOverride != null) {
            this.artifactDeployer.installSnapshot(this.artifact, this.type, this.project, this.typeHandler);
        } else {
            this.artifactDeployer.installSnapshot(this.artifact, this.type, this.project, this.typeHandler);
        }
    }
}

