/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenException;
import org.apache.maven.artifact.PomRewriter;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.RepositoryBuilder;
import org.apache.maven.artifact.deployer.UploadMeter;
import org.apache.maven.project.Project;
import org.apache.maven.repository.ArtifactTypeHandler;
import org.apache.maven.repository.DefaultArtifactTypeHandler;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.ftp.FtpWagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.providers.ssh.external.ScpExternalWagon;
import org.apache.maven.wagon.providers.ssh.jsch.ScpWagon;
import org.apache.maven.wagon.providers.ssh.jsch.SftpWagon;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DefaultArtifactDeployer
implements ArtifactDeployer {
    protected static final String POM_TYPE = "pom";
    public static final String SIGNATURE_EXTENSION = ".asc";
    private static final ArtifactTypeHandler POM_ARTIFACT_TYPE_HANDLER = new DefaultArtifactTypeHandler();
    protected static final String SNAPSHOT_FORMAT = "yyyyMMdd.HHmmss";
    protected String snapshotSignature;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$artifact$deployer$DefaultArtifactDeployer == null ? (class$org$apache$maven$artifact$deployer$DefaultArtifactDeployer = DefaultArtifactDeployer.class$("org.apache.maven.artifact.deployer.DefaultArtifactDeployer")) : class$org$apache$maven$artifact$deployer$DefaultArtifactDeployer));
    static /* synthetic */ Class class$org$apache$maven$artifact$deployer$DefaultArtifactDeployer;

    public void deploy(String artifact, String type, Project project, ArtifactTypeHandler handler) throws MavenException {
        this.handleDeploy(type, project, project.getArtifactId(), artifact, handler, project.getCurrentVersion());
    }

    public void deploySnapshot(String artifact, String type, Project project, ArtifactTypeHandler handler) throws MavenException {
        this.handleDeploy(type, project, project.getArtifactId(), artifact, handler, "SNAPSHOT");
    }

    protected void handleDeploy(String type, Project project, String artifactId, String artifact, ArtifactTypeHandler handler, String version) throws MavenException {
        Boolean gpgSkip = Boolean.valueOf((String)project.getContext().getVariable("maven.artifact.gpg.skip"));
        String gpgPassphrase = null;
        if (!gpgSkip.booleanValue()) {
            try {
                gpgPassphrase = this.getPassphrase(project);
            }
            catch (IOException e) {
                throw new MavenException("Error while retreiving the passphrase for gpg", (Throwable)e);
            }
        }
        String gpgKeyname = (String)project.getContext().getVariable("maven.artifact.gpg.keyname");
        Boolean gpgUseagent = Boolean.valueOf((String)project.getContext().getVariable("maven.artifact.gpg.useagent"));
        File file = POM_TYPE.equals(type) ? PomRewriter.getRewrittenPom(project) : this.getFileForArtifact(artifact);
        if (!POM_TYPE.equals(type)) {
            File pomFile = PomRewriter.getRewrittenPom(project);
            if (!gpgSkip.booleanValue()) {
                this.generateSignatureForArtifact(pomFile, gpgPassphrase, gpgUseagent, gpgKeyname);
            }
            this.doDeploy(pomFile, project, artifactId, POM_ARTIFACT_TYPE_HANDLER, version, POM_TYPE, gpgSkip, gpgPassphrase, gpgUseagent, gpgKeyname);
        }
        if (!gpgSkip.booleanValue()) {
            this.generateSignatureForArtifact(file, gpgPassphrase, gpgUseagent, gpgKeyname);
        }
        this.doDeploy(file, project, artifactId, handler, version, type, gpgSkip, gpgPassphrase, gpgUseagent, gpgKeyname);
        this.snapshotSignature = null;
    }

    public void install(String artifact, String type, Project project, ArtifactTypeHandler handler) throws MavenException {
        this.handleInstall(type, project, artifact, handler, project.getCurrentVersion());
    }

    public void installSnapshot(String artifact, String type, Project project, ArtifactTypeHandler handler) throws MavenException {
        this.handleInstall(type, project, artifact, handler, "SNAPSHOT");
    }

    private void handleInstall(String type, Project project, String artifact, ArtifactTypeHandler handler, String version) throws MavenException {
        File file = POM_TYPE.equals(type) ? PomRewriter.getRewrittenPom(project) : this.getFileForArtifact(artifact);
        this.doInstall(file, type, project, version, handler);
        if (!POM_TYPE.equals(type)) {
            this.doInstall(PomRewriter.getRewrittenPom(project), POM_TYPE, project, version, POM_ARTIFACT_TYPE_HANDLER);
        }
    }

    private void doInstall(File file, String type, Project project, String version, ArtifactTypeHandler handler) throws MavenException {
        try {
            Repository repository = new Repository("local", "file:" + project.getContext().getMavenRepoLocal());
            String repositoryPath = handler.constructRepositoryFullPath(type, project, version);
            this.deployFile(repository, file, repositoryPath, project, true, null, false, null);
        }
        catch (Exception e) {
            String msg = "Cannot install file: '" + file + "'. Reason: " + e.getMessage();
            throw new MavenException(msg, (Throwable)e);
        }
    }

    protected String findSshIdentity() {
        String key = this.findSshIdentity(System.getProperty("user.home"));
        if (key != null) {
            return key;
        }
        if (!System.getProperty("user.home").equals(System.getProperty("user.home.env")) && (key = this.findSshIdentity(System.getProperty("user.home.env"))) != null) {
            return key;
        }
        LOG.warn((Object)"Unable to locate identity id_rsa, id_dsa or identity - set maven.repo.default.privatekey");
        return null;
    }

    private String findSshIdentity(String home) {
        if (home == null) {
            return null;
        }
        File sshHome = new File(home, ".ssh");
        LOG.debug((Object)("Looking for SSH keys in " + sshHome));
        File key = new File(sshHome, "id_dsa");
        if (key.exists()) {
            LOG.debug((Object)("found " + key));
            return key.getAbsolutePath();
        }
        key = new File(sshHome, "id_rsa");
        if (key.exists()) {
            LOG.debug((Object)("found " + key));
            return key.getAbsolutePath();
        }
        key = new File(sshHome, "identity");
        if (key.exists()) {
            LOG.debug((Object)("found " + key));
            return key.getAbsolutePath();
        }
        return null;
    }

    private void doDeploy(File file, Project project, String artifactId, ArtifactTypeHandler handler, String version, String type, boolean gpgSkip, String gpgPass, boolean gpgUseAgent, String gpgKeyname) throws MavenException {
        String repoStr;
        ArrayList<File> srcFiles = new ArrayList<File>(3);
        ArrayList<String> destFiles = new ArrayList<String>(3);
        srcFiles.add(file);
        destFiles.add(handler.constructRepositoryFullPath(type, project, version));
        if (version.indexOf("SNAPSHOT") >= 0) {
            String signature = this.getSnapshotSignature();
            String v = StringUtils.replace((String)version, (String)"SNAPSHOT", (String)signature);
            File snapshotVersionFile = this.createSnapshotVersionFile(file, v, artifactId, type);
            String snapshotVersionsFilename = handler.constructRepositoryDirectoryPath(type, project) + artifactId + "-snapshot-version";
            srcFiles.add(snapshotVersionFile);
            destFiles.add(snapshotVersionsFilename);
            String deployTimestamp = (String)project.getContext().getVariable("maven.artifact.deploy.timestamps");
            if (deployTimestamp.equals("true")) {
                srcFiles.add(file);
                destFiles.add(handler.constructRepositoryFullPath(type, project, v));
            }
        }
        if ((repoStr = (String)project.getContext().getVariable("maven.repo.list")) == null || repoStr.trim().length() == 0) {
            String central = project.getDistributionSite();
            String centralDirectory = project.getDistributionDirectory();
            if (central == null || central.trim().length() == 0) {
                central = (String)project.getContext().getVariable("maven.repo.central");
                centralDirectory = (String)project.getContext().getVariable("maven.repo.central.directory");
            }
            if (central != null && central.trim().length() > 0) {
                repoStr = "default";
                project.getContext().setVariable("maven.repo.default", (Object)("scp://" + central));
                if (project.getContext().getVariable("maven.repo.default.privatekey") == null) {
                    project.getContext().setVariable("maven.repo.default.privatekey", (Object)this.findSshIdentity());
                }
                if (project.getContext().getVariable("maven.repo.default.passphrase") == null) {
                    LOG.warn((Object)"WARNING: assuming empty passphrase. Specify maven.repo.default.passphrase if needed");
                    project.getContext().setVariable("maven.repo.default.passphrase", (Object)"");
                }
                project.getContext().setVariable("maven.repo.default.directory", (Object)centralDirectory);
                project.getContext().setVariable("maven.repo.default.username", project.getContext().getVariable("maven.username"));
                project.getContext().setVariable("maven.repo.default.group", project.getContext().getVariable("maven.remote.group"));
            }
        }
        String[] repos = StringUtils.split((String)repoStr, (String)",");
        LOG.info((Object)("Will deploy to " + repos.length + " repository(ies): " + repoStr));
        boolean success = false;
        for (int i = 0; i < repos.length; ++i) {
            String repo = repos[i].trim();
            LOG.info((Object)("Deploying to repository: " + repo));
            Repository repository = RepositoryBuilder.getRepository(project, repo);
            AuthenticationInfo authenticationInfo = RepositoryBuilder.getAuthenticationInfo(project, repo);
            try {
                this.deployFiles(repository, srcFiles, destFiles, authenticationInfo, project, gpgSkip, gpgPass, gpgUseAgent, gpgKeyname);
                success = true;
                continue;
            }
            catch (Exception e) {
                String msg = "Failed to deploy to: " + repository.getId() + " Reason: " + e;
                LOG.warn((Object)msg, (Throwable)e);
            }
        }
        if (!success) {
            throw new MavenException("Unable to deploy to any repositories");
        }
    }

    protected void deployFile(Repository repository, File src, String dest, Project project, boolean gpgSkip, String gpgPass, boolean gpgUseAgent, String gpgKeyname) throws ResourceDoesNotExistException, MalformedURLException, NoSuchAlgorithmException, TransferFailedException, ConnectionException, AuthenticationException, AuthorizationException, MavenException {
        this.deployFiles(repository, Collections.singletonList(src), Collections.singletonList(dest), null, project, gpgSkip, gpgPass, gpgUseAgent, gpgKeyname);
    }

    protected void deployFiles(Repository repository, List srcFiles, List destFiles, AuthenticationInfo authenticationInfo, Project project, boolean gpgSkip, String gpgPass, boolean gpgUseAgent, String gpgKeyname) throws ConnectionException, AuthenticationException, ResourceDoesNotExistException, TransferFailedException, AuthorizationException, MalformedURLException, NoSuchAlgorithmException, MavenException {
        if (srcFiles.size() != destFiles.size()) {
            String msg = "Lengths of the lists should be the same";
            throw new IllegalArgumentException("Lengths of the lists should be the same");
        }
        Wagon wagon = this.getWagon(repository.getProtocol(), project, repository.getId());
        UploadMeter uploadMonitor = new UploadMeter();
        HashMap<String, ChecksumObserver> checksums = new HashMap<String, ChecksumObserver>(2);
        ChecksumObserver observer = new ChecksumObserver("MD5");
        checksums.put("md5", observer);
        wagon.addTransferListener((TransferListener)observer);
        observer = new ChecksumObserver("SHA-1");
        checksums.put("sha1", observer);
        wagon.addTransferListener((TransferListener)observer);
        try {
            wagon.connect(repository, authenticationInfo);
            Iterator srcIterator = srcFiles.iterator();
            Iterator destIterator = destFiles.iterator();
            while (srcIterator.hasNext()) {
                String extension;
                wagon.addTransferListener((TransferListener)uploadMonitor);
                File srcFile = (File)srcIterator.next();
                String destFile = (String)destIterator.next();
                wagon.put(srcFile, destFile);
                wagon.removeTransferListener((TransferListener)uploadMonitor);
                HashMap<String, String> sums = new HashMap<String, String>(2);
                Iterator i = checksums.keySet().iterator();
                while (i.hasNext()) {
                    extension = (String)i.next();
                    observer = (ChecksumObserver)checksums.get(extension);
                    sums.put(extension, observer.getActualChecksum());
                }
                i = checksums.keySet().iterator();
                while (i.hasNext()) {
                    extension = (String)i.next();
                    File temp = File.createTempFile("maven-artifact", null);
                    temp.deleteOnExit();
                    FileUtils.fileWrite((String)temp.getAbsolutePath(), (String)((String)sums.get(extension)));
                    wagon.put(temp, destFile + "." + extension);
                }
                if (gpgSkip) continue;
                File gpgSignature = this.generateSignatureForArtifact(srcFile, gpgPass, gpgUseAgent, gpgKeyname);
                wagon.put(gpgSignature, destFile + SIGNATURE_EXTENSION);
            }
        }
        catch (IOException e) {
            throw new MavenException("Error creating temporary file to transfer checksums", (Throwable)e);
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (Exception e) {
                LOG.error((Object)"Error cleaning up from the deployer", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Wagon getWagon(String protocol, Project project, String id) throws MalformedURLException {
        void var4_4;
        HttpWagon wagon;
        if (protocol.equals("http")) {
            wagon = new HttpWagon();
        } else if (protocol.equals("ftp")) {
            wagon = new FtpWagon();
            RepositoryBuilder.configureFtpWagon(project, id, (FtpWagon)wagon);
        } else if (protocol.equals("sftp")) {
            wagon = new SftpWagon();
            RepositoryBuilder.configureSftpWagon(project, id, (SftpWagon)wagon);
        } else if (protocol.equals("file")) {
            wagon = new FileWagon();
        } else if (protocol.equals("scp")) {
            wagon = new ScpWagon();
            RepositoryBuilder.configureScpWagon(project, id, (ScpWagon)wagon);
        } else {
            if (protocol.equals("scpexe")) {
                ScpExternalWagon wagon2 = new ScpExternalWagon();
                RepositoryBuilder.configureSshExternalWagon(project, id, wagon2);
                return wagon2;
            }
            throw new MalformedURLException("Unknown Wagon protocol: " + protocol);
        }
        return var4_4;
    }

    protected String getSnapshotSignature() {
        if (this.snapshotSignature == null) {
            SimpleDateFormat fmt = new SimpleDateFormat(SNAPSHOT_FORMAT);
            fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.snapshotSignature = fmt.format(new Date());
        }
        return this.snapshotSignature;
    }

    protected File getFileForArtifact(String artifact) throws MavenException {
        File file = new File(artifact);
        if (!file.exists()) {
            String msg = "Artifact file: '" + artifact + "' must exist";
            throw new MavenException(msg);
        }
        if (!file.canRead()) {
            String msg = "Artifact file: '" + artifact + "' must be readable";
            throw new MavenException(msg);
        }
        if (file.isDirectory()) {
            String msg = "Artifact file: '" + artifact + "' must not be a directory";
            throw new MavenException(msg);
        }
        return file.getAbsoluteFile();
    }

    protected File createSnapshotVersionFile(File artifact, String snapshotVersion, String artifactId, String type) throws MavenException {
        File file = null;
        String filename = artifactId + "-" + type + "-snapshot-version";
        try {
            file = new File(artifact.getParent(), filename);
            FileUtils.fileWrite((String)file.getAbsolutePath(), (String)snapshotVersion);
            file.deleteOnExit();
        }
        catch (Exception e) {
            throw new MavenException("Cannot create snapshot-version file:" + file);
        }
        return file;
    }

    protected File generateSignatureForArtifact(File file, String pass, boolean useAgent, String keyname) throws MavenException {
        File signature = new File(file + SIGNATURE_EXTENSION);
        if (signature.exists()) {
            signature.delete();
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable("gpg" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
        if (useAgent) {
            cmd.createArgument().setValue("--use-agent");
        } else {
            cmd.createArgument().setValue("--no-use-agent");
        }
        ByteArrayInputStream in = null;
        if (null != pass) {
            cmd.createArgument().setValue("--passphrase-fd");
            cmd.createArgument().setValue("0");
            in = new ByteArrayInputStream(pass.getBytes());
        }
        if (null != keyname) {
            cmd.createArgument().setValue("--local-user");
            cmd.createArgument().setValue(keyname);
        }
        cmd.createArgument().setValue("--armor");
        cmd.createArgument().setValue("--detach-sign");
        cmd.createArgument().setFile(file);
        try {
            LOG.debug((Object)("GPG cmd : " + cmd));
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (InputStream)in, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (exitCode != 0) {
                throw new MavenException("Exit code: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new MavenException("Unable to execute gpg command", (Throwable)e);
        }
        return signature;
    }

    protected String getPassphrase(Project project) throws IOException {
        String pass = (String)project.getContext().getVariable("maven.artifact.gpg.passphrase");
        if (pass == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (System.in.available() != 0) {
                System.in.read();
            }
            System.out.print("GPG Passphrase: ");
            MaskingThread thread = new MaskingThread();
            thread.start();
            pass = in.readLine();
            thread.stopMasking();
        }
        project.getContext().setVariable("maven.artifact.gpg.passphrase", (Object)pass);
        return pass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;

        MaskingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\b*");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

