/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jxr.JXR;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.log.Log;

public class JxrBean {
    private List sourceDirs;
    private String destDir;
    private Locale locale;
    private String inputEncoding;
    private String outputEncoding;
    private String javadocDir;
    private String windowTitle;
    private String docTitle;
    private String bottom;
    private String templateDir;
    private final org.apache.commons.logging.Log log = LogFactory.getLog((Class)(class$org$apache$maven$jxr$JxrBean == null ? (class$org$apache$maven$jxr$JxrBean = JxrBean.class$("org.apache.maven.jxr.JxrBean")) : class$org$apache$maven$jxr$JxrBean));
    static /* synthetic */ Class class$org$apache$maven$jxr$JxrBean;

    public JxrBean() {
        this.sourceDirs = new LinkedList();
    }

    public void xref() throws JxrException {
        Log logger = new Log(){

            public void info(String message) {
                JxrBean.this.log.info((Object)message);
            }

            public void debug(String message) {
                JxrBean.this.log.debug((Object)message);
            }

            public void warn(String message) {
                JxrBean.this.log.warn((Object)message);
            }

            public void error(String message) {
                JxrBean.this.log.error((Object)message);
            }
        };
        JXR jxr = new JXR();
        jxr.setDest(this.destDir);
        jxr.setLocale(this.locale);
        jxr.setInputEncoding(this.inputEncoding);
        jxr.setOutputEncoding(this.outputEncoding);
        jxr.setJavadocLinkDir(this.javadocDir);
        jxr.setRevision("HEAD");
        jxr.setLog(logger);
        try {
            jxr.xref(this.sourceDirs, this.getTemplateDir(), this.getWindowTitle(), this.getDocTitle(), this.getBottom());
        }
        catch (IOException e) {
            throw new JxrException("Error processing files", (Exception)e);
        }
    }

    public void setSourceDirs(List newSourceDirs) {
        if (!this.sourceDirs.isEmpty()) {
            this.sourceDirs.clear();
        }
        this.sourceDirs = newSourceDirs;
    }

    public void setSourceDir(String sourceDir) {
        if (!this.sourceDirs.isEmpty()) {
            this.sourceDirs.clear();
        }
        this.addSourceDir(sourceDir);
    }

    public void addSourceDir(String sourceDir) {
        this.sourceDirs.add(sourceDir);
    }

    public void setDestDir(String newDestDir) {
        this.destDir = newDestDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    public void setInputEncoding(String newInputEncoding) {
        this.inputEncoding = newInputEncoding;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String newOutputEncoding) {
        this.outputEncoding = newOutputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setJavadocDir(String newJavadocDir) {
        this.javadocDir = newJavadocDir;
    }

    public String getJavadocDir() {
        return this.javadocDir;
    }

    public void setWindowTitle(String newWindowTitle) {
        this.windowTitle = newWindowTitle;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setDocTitle(String newDocTitle) {
        this.docTitle = newDocTitle;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setBottom(String newBottom) {
        this.bottom = newBottom;
    }

    public String getBottom() {
        return this.bottom;
    }

    public void setTemplateDir(String newTemplateDir) {
        this.templateDir = newTemplateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

