/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.io.dom4j;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.BuildBase;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.FileSet;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Model;
import org.apache.maven.project.ModelBase;
import org.apache.maven.project.Organization;
import org.apache.maven.project.PackageGroup;
import org.apache.maven.project.PatternSet;
import org.apache.maven.project.PluginConfiguration;
import org.apache.maven.project.PluginContainer;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MavenDom4jWriter {
    public void write(Writer writer, Model project) throws IOException {
        Document document = new DocumentFactory().createDocument();
        this.writeModel(project, "project", document);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setLineSeparator(System.getProperty("line.separator"));
        XMLWriter serializer = new XMLWriter(writer, format);
        serializer.write(document);
    }

    public void writeXpp3DomToElement(Xpp3Dom xpp3Dom, Element parentElement) {
        Element element = parentElement.addElement(xpp3Dom.getName());
        if (xpp3Dom.getValue() != null) {
            element.setText(xpp3Dom.getValue());
        }
        Iterator<String> i = Arrays.asList(xpp3Dom.getAttributeNames()).iterator();
        while (i.hasNext()) {
            String name = i.next();
            element.addAttribute(name, xpp3Dom.getAttribute(name));
        }
        i = Arrays.asList(xpp3Dom.getChildren()).iterator();
        while (i.hasNext()) {
            Xpp3Dom child = (Xpp3Dom)i.next();
            this.writeXpp3DomToElement(child, element);
        }
    }

    private void writeBranch(Branch branch, String tagName, Element parentElement) throws IOException {
        if (branch != null) {
            Element element = parentElement.addElement(tagName);
            if (branch.getTag() != null) {
                element.addElement("tag").setText(branch.getTag());
            }
        }
    }

    private void writeBuild(Build build, String tagName, Element parentElement) throws IOException {
        if (build != null) {
            FileSet o;
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (build.getNagEmailAddress() != null) {
                element.addElement("nagEmailAddress").setText(build.getNagEmailAddress());
            }
            if (build.getSourceDirectory() != null) {
                element.addElement("sourceDirectory").setText(build.getSourceDirectory());
            }
            if (build.getUnitTestSourceDirectory() != null) {
                element.addElement("unitTestSourceDirectory").setText(build.getUnitTestSourceDirectory());
            }
            if (build.getAspectSourceDirectory() != null) {
                element.addElement("aspectSourceDirectory").setText(build.getAspectSourceDirectory());
            }
            if (build.getIntegrationUnitTestSourceDirectory() != null) {
                element.addElement("integrationUnitTestSourceDirectory").setText(build.getIntegrationUnitTestSourceDirectory());
            }
            if (build.getSourceModifications() != null && build.getSourceModifications().size() > 0) {
                listElement = element;
                listElement = element.addElement("sourceModifications");
                iter = build.getSourceModifications().iterator();
                while (iter.hasNext()) {
                    o = (SourceModification)iter.next();
                    this.writeSourceModification((SourceModification)o, "sourceModification", listElement);
                }
            }
            if (build.getUnitTest() != null) {
                this.writeUnitTest(build.getUnitTest(), "unitTest", element);
            }
            if (build.getDefaultGoal() != null) {
                element.addElement("defaultGoal").setText(build.getDefaultGoal());
            }
            if (build.getResources() != null && build.getResources().size() > 0) {
                listElement = element;
                listElement = element.addElement("resources");
                iter = build.getResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "resource", listElement);
                }
            }
        }
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, Element parentElement) throws IOException {
        if (buildBase != null) {
            Element element = parentElement.addElement(tagName);
            if (buildBase.getDefaultGoal() != null) {
                element.addElement("defaultGoal").setText(buildBase.getDefaultGoal());
            }
            if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
                Element listElement = element;
                listElement = element.addElement("resources");
                Iterator iter = buildBase.getResources().iterator();
                while (iter.hasNext()) {
                    Resource o = (Resource)iter.next();
                    this.writeResource(o, "resource", listElement);
                }
            }
        }
    }

    private void writeContributor(Contributor contributor, String tagName, Element parentElement) throws IOException {
        if (contributor != null) {
            Iterator<Object> iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (contributor.getName() != null) {
                element.addElement("name").setText(contributor.getName());
            }
            if (contributor.getEmail() != null) {
                element.addElement("email").setText(contributor.getEmail());
            }
            if (contributor.getUrl() != null) {
                element.addElement("url").setText(contributor.getUrl());
            }
            if (contributor.getOrganization() != null) {
                element.addElement("organization").setText(contributor.getOrganization());
            }
            if (contributor.getOrganizationUrl() != null) {
                element.addElement("organizationUrl").setText(contributor.getOrganizationUrl());
            }
            if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
                listElement = element;
                listElement = element.addElement("roles");
                iter = contributor.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    listElement.addElement("role").setText(role);
                }
            }
            if (contributor.getTimezone() != null) {
                element.addElement("timezone").setText(contributor.getTimezone());
            }
            if (contributor.getProperties() != null && contributor.getProperties().size() > 0) {
                listElement = element;
                listElement = element.addElement("properties");
                iter = contributor.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)contributor.getProperties().get(key);
                    listElement.addElement(key).setText(value);
                }
            }
        }
    }

    private void writeDependency(Dependency dependency, String tagName, Element parentElement) throws IOException {
        if (dependency != null) {
            Element element = parentElement.addElement(tagName);
            if (dependency.getId() != null) {
                element.addElement("id").setText(dependency.getId());
            }
            if (dependency.getGroupId() != null) {
                element.addElement("groupId").setText(dependency.getGroupId());
            }
            if (dependency.getArtifactId() != null) {
                element.addElement("artifactId").setText(dependency.getArtifactId());
            }
            if (dependency.getVersion() != null) {
                element.addElement("version").setText(dependency.getVersion());
            }
            if (dependency.getUrl() != null) {
                element.addElement("url").setText(dependency.getUrl());
            }
            if (dependency.getJar() != null) {
                element.addElement("jar").setText(dependency.getJar());
            }
            if (dependency.getType() != null && !dependency.getType().equals("jar")) {
                element.addElement("type").setText(dependency.getType());
            }
            if (dependency.getProperties() != null && dependency.getProperties().size() > 0) {
                Element listElement = element;
                listElement = element.addElement("properties");
                Iterator<Object> iter = dependency.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)dependency.getProperties().get(key);
                    listElement.addElement(key).setText(value);
                }
            }
        }
    }

    private void writeDeveloper(Developer developer, String tagName, Element parentElement) throws IOException {
        if (developer != null) {
            Iterator<Object> iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (developer.getId() != null) {
                element.addElement("id").setText(developer.getId());
            }
            if (developer.getName() != null) {
                element.addElement("name").setText(developer.getName());
            }
            if (developer.getEmail() != null) {
                element.addElement("email").setText(developer.getEmail());
            }
            if (developer.getUrl() != null) {
                element.addElement("url").setText(developer.getUrl());
            }
            if (developer.getOrganization() != null) {
                element.addElement("organization").setText(developer.getOrganization());
            }
            if (developer.getOrganizationUrl() != null) {
                element.addElement("organizationUrl").setText(developer.getOrganizationUrl());
            }
            if (developer.getRoles() != null && developer.getRoles().size() > 0) {
                listElement = element;
                listElement = element.addElement("roles");
                iter = developer.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    listElement.addElement("role").setText(role);
                }
            }
            if (developer.getTimezone() != null) {
                element.addElement("timezone").setText(developer.getTimezone());
            }
            if (developer.getProperties() != null && developer.getProperties().size() > 0) {
                listElement = element;
                listElement = element.addElement("properties");
                iter = developer.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)developer.getProperties().get(key);
                    listElement.addElement(key).setText(value);
                }
            }
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, Element parentElement) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (fileSet.getDirectory() != null) {
                element.addElement("directory").setText(fileSet.getDirectory());
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    listElement.addElement("include").setText(include);
                }
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    listElement.addElement("exclude").setText(exclude);
                }
            }
        }
    }

    private void writeLicense(License license, String tagName, Element parentElement) throws IOException {
        if (license != null) {
            Element element = parentElement.addElement(tagName);
            if (license.getName() != null) {
                element.addElement("name").setText(license.getName());
            }
            if (license.getUrl() != null) {
                element.addElement("url").setText(license.getUrl());
            }
            if (license.getDistribution() != null) {
                element.addElement("distribution").setText(license.getDistribution());
            }
            if (license.getComments() != null) {
                element.addElement("comments").setText(license.getComments());
            }
        }
    }

    private void writeMailingList(MailingList mailingList, String tagName, Element parentElement) throws IOException {
        if (mailingList != null) {
            Element element = parentElement.addElement(tagName);
            if (mailingList.getName() != null) {
                element.addElement("name").setText(mailingList.getName());
            }
            if (mailingList.getSubscribe() != null) {
                element.addElement("subscribe").setText(mailingList.getSubscribe());
            }
            if (mailingList.getUnsubscribe() != null) {
                element.addElement("unsubscribe").setText(mailingList.getUnsubscribe());
            }
            if (mailingList.getPost() != null) {
                element.addElement("post").setText(mailingList.getPost());
            }
            if (mailingList.getArchive() != null) {
                element.addElement("archive").setText(mailingList.getArchive());
            }
            if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
                Element listElement = element;
                listElement = element.addElement("otherArchives");
                Iterator iter = mailingList.getOtherArchives().iterator();
                while (iter.hasNext()) {
                    String otherArchive = (String)iter.next();
                    listElement.addElement("otherArchive").setText(otherArchive);
                }
            }
        }
    }

    private void writeModel(Model model, String tagName, Document parentElement) throws IOException {
        if (model != null) {
            Serializable o;
            Iterator<Object> iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (model.getExtend() != null) {
                element.addElement("extend").setText(model.getExtend());
            }
            if (model.getPomVersion() != null) {
                element.addElement("pomVersion").setText(model.getPomVersion());
            }
            if (model.getGroupId() != null) {
                element.addElement("groupId").setText(model.getGroupId());
            }
            if (model.getArtifactId() != null) {
                element.addElement("artifactId").setText(model.getArtifactId());
            }
            if (model.getId() != null) {
                element.addElement("id").setText(model.getId());
            }
            if (model.getName() != null) {
                element.addElement("name").setText(model.getName());
            }
            if (model.getCurrentVersion() != null) {
                element.addElement("currentVersion").setText(model.getCurrentVersion());
            }
            if (model.getShortDescription() != null) {
                element.addElement("shortDescription").setText(model.getShortDescription());
            }
            if (model.getDescription() != null) {
                element.addElement("description").setText(model.getDescription());
            }
            if (model.getUrl() != null) {
                element.addElement("url").setText(model.getUrl());
            }
            if (model.getLogo() != null) {
                element.addElement("logo").setText(model.getLogo());
            }
            if (model.getIssueTrackingUrl() != null) {
                element.addElement("issueTrackingUrl").setText(model.getIssueTrackingUrl());
            }
            if (model.getInceptionYear() != null) {
                element.addElement("inceptionYear").setText(model.getInceptionYear());
            }
            if (model.getGumpRepositoryId() != null) {
                element.addElement("gumpRepositoryId").setText(model.getGumpRepositoryId());
            }
            if (model.getSiteAddress() != null) {
                element.addElement("siteAddress").setText(model.getSiteAddress());
            }
            if (model.getSiteDirectory() != null) {
                element.addElement("siteDirectory").setText(model.getSiteDirectory());
            }
            if (model.getDistributionSite() != null) {
                element.addElement("distributionSite").setText(model.getDistributionSite());
            }
            if (model.getDistributionDirectory() != null) {
                element.addElement("distributionDirectory").setText(model.getDistributionDirectory());
            }
            if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
                listElement = element;
                listElement = element.addElement("mailingLists");
                iter = model.getMailingLists().iterator();
                while (iter.hasNext()) {
                    o = (MailingList)iter.next();
                    this.writeMailingList((MailingList)o, "mailingList", listElement);
                }
            }
            if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
                listElement = element;
                listElement = element.addElement("developers");
                iter = model.getDevelopers().iterator();
                while (iter.hasNext()) {
                    o = (Developer)iter.next();
                    this.writeDeveloper((Developer)o, "developer", listElement);
                }
            }
            if (model.getContributors() != null && model.getContributors().size() > 0) {
                listElement = element;
                listElement = element.addElement("contributors");
                iter = model.getContributors().iterator();
                while (iter.hasNext()) {
                    o = (Contributor)iter.next();
                    this.writeContributor((Contributor)o, "contributor", listElement);
                }
            }
            if (model.getLicenses() != null && model.getLicenses().size() > 0) {
                listElement = element;
                listElement = element.addElement("licenses");
                iter = model.getLicenses().iterator();
                while (iter.hasNext()) {
                    o = (License)iter.next();
                    this.writeLicense((License)o, "license", listElement);
                }
            }
            if (model.getVersions() != null && model.getVersions().size() > 0) {
                listElement = element;
                listElement = element.addElement("versions");
                iter = model.getVersions().iterator();
                while (iter.hasNext()) {
                    o = (Version)iter.next();
                    this.writeVersion((Version)o, "version", listElement);
                }
            }
            if (model.getBranches() != null && model.getBranches().size() > 0) {
                listElement = element;
                listElement = element.addElement("branches");
                iter = model.getBranches().iterator();
                while (iter.hasNext()) {
                    o = (Branch)iter.next();
                    this.writeBranch((Branch)o, "branch", listElement);
                }
            }
            if (model.getPackageGroups() != null && model.getPackageGroups().size() > 0) {
                listElement = element;
                listElement = element.addElement("packageGroups");
                iter = model.getPackageGroups().iterator();
                while (iter.hasNext()) {
                    o = (PackageGroup)iter.next();
                    this.writePackageGroup((PackageGroup)o, "packageGroup", listElement);
                }
            }
            if (model.getReports() != null && model.getReports().size() > 0) {
                listElement = element;
                listElement = element.addElement("reports");
                iter = model.getReports().iterator();
                while (iter.hasNext()) {
                    String report = (String)iter.next();
                    listElement.addElement("report").setText(report);
                }
            }
            if (model.getRepository() != null) {
                this.writeRepository(model.getRepository(), "repository", element);
            }
            if (model.getOrganization() != null) {
                this.writeOrganization(model.getOrganization(), "organization", element);
            }
            if (model.getProperties() != null && model.getProperties().size() > 0) {
                listElement = element;
                listElement = element.addElement("properties");
                iter = model.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)model.getProperties().get(key);
                    listElement.addElement(key).setText(value);
                }
            }
            if (model.getPackageName() != null) {
                element.addElement("package").setText(model.getPackageName());
            }
            if (model.getBuild() != null) {
                this.writeBuild(model.getBuild(), "build", element);
            }
            if (model.getDependencies() != null && model.getDependencies().size() > 0) {
                listElement = element;
                listElement = element.addElement("dependencies");
                iter = model.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", listElement);
                }
            }
        }
    }

    private void writeModelBase(ModelBase modelBase, String tagName, Element parentElement) throws IOException {
        if (modelBase != null) {
            Element element = parentElement.addElement(tagName);
            if (modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0) {
                Element listElement = element;
                listElement = element.addElement("dependencies");
                Iterator iter = modelBase.getDependencies().iterator();
                while (iter.hasNext()) {
                    Dependency o = (Dependency)iter.next();
                    this.writeDependency(o, "dependency", listElement);
                }
            }
        }
    }

    private void writeOrganization(Organization organization, String tagName, Element parentElement) throws IOException {
        if (organization != null) {
            Element element = parentElement.addElement(tagName);
            if (organization.getName() != null) {
                element.addElement("name").setText(organization.getName());
            }
            if (organization.getUrl() != null) {
                element.addElement("url").setText(organization.getUrl());
            }
            if (organization.getLogo() != null) {
                element.addElement("logo").setText(organization.getLogo());
            }
        }
    }

    private void writePackageGroup(PackageGroup packageGroup, String tagName, Element parentElement) throws IOException {
        if (packageGroup != null) {
            Element element = parentElement.addElement(tagName);
            if (packageGroup.getTitle() != null) {
                element.addElement("title").setText(packageGroup.getTitle());
            }
            if (packageGroup.getPackages() != null) {
                element.addElement("packages").setText(packageGroup.getPackages());
            }
        }
    }

    private void writePatternSet(PatternSet patternSet, String tagName, Element parentElement) throws IOException {
        if (patternSet != null) {
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("includes");
                iter = patternSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    listElement.addElement("include").setText(include);
                }
            }
            if (patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("excludes");
                iter = patternSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    listElement.addElement("exclude").setText(exclude);
                }
            }
        }
    }

    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, Element parentElement) throws IOException {
        if (pluginConfiguration != null) {
            Element element = parentElement.addElement(tagName);
        }
    }

    private void writePluginContainer(PluginContainer pluginContainer, String tagName, Element parentElement) throws IOException {
        if (pluginContainer != null) {
            Element element = parentElement.addElement(tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, Element parentElement) throws IOException {
        if (repository != null) {
            Element element = parentElement.addElement(tagName);
            if (repository.getConnection() != null) {
                element.addElement("connection").setText(repository.getConnection());
            }
            if (repository.getDeveloperConnection() != null) {
                element.addElement("developerConnection").setText(repository.getDeveloperConnection());
            }
            if (repository.getUrl() != null) {
                element.addElement("url").setText(repository.getUrl());
            }
        }
    }

    private void writeResource(Resource resource, String tagName, Element parentElement) throws IOException {
        if (resource != null) {
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (resource.getTargetPath() != null) {
                element.addElement("targetPath").setText(resource.getTargetPath());
            }
            if (resource.isFiltering()) {
                element.addElement("filtering").setText(String.valueOf(resource.isFiltering()));
            }
            if (resource.getDirectory() != null) {
                element.addElement("directory").setText(resource.getDirectory());
            }
            if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("includes");
                iter = resource.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    listElement.addElement("include").setText(include);
                }
            }
            if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("excludes");
                iter = resource.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    listElement.addElement("exclude").setText(exclude);
                }
            }
        }
    }

    private void writeSourceModification(SourceModification sourceModification, String tagName, Element parentElement) throws IOException {
        if (sourceModification != null) {
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (sourceModification.getClassName() != null) {
                element.addElement("className").setText(sourceModification.getClassName());
            }
            if (sourceModification.getProperty() != null) {
                element.addElement("property").setText(sourceModification.getProperty());
            }
            if (sourceModification.getDirectory() != null) {
                element.addElement("directory").setText(sourceModification.getDirectory());
            }
            if (sourceModification.getIncludes() != null && sourceModification.getIncludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("includes");
                iter = sourceModification.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    listElement.addElement("include").setText(include);
                }
            }
            if (sourceModification.getExcludes() != null && sourceModification.getExcludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("excludes");
                iter = sourceModification.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    listElement.addElement("exclude").setText(exclude);
                }
            }
        }
    }

    private void writeUnitTest(UnitTest unitTest, String tagName, Element parentElement) throws IOException {
        if (unitTest != null) {
            Iterator iter;
            Element listElement;
            Element element = parentElement.addElement(tagName);
            if (unitTest.getResources() != null && unitTest.getResources().size() > 0) {
                listElement = element;
                listElement = element.addElement("resources");
                iter = unitTest.getResources().iterator();
                while (iter.hasNext()) {
                    Resource o = (Resource)iter.next();
                    this.writeResource(o, "resource", listElement);
                }
            }
            if (unitTest.getIncludes() != null && unitTest.getIncludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("includes");
                iter = unitTest.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    listElement.addElement("include").setText(include);
                }
            }
            if (unitTest.getExcludes() != null && unitTest.getExcludes().size() > 0) {
                listElement = element;
                listElement = element.addElement("excludes");
                iter = unitTest.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    listElement.addElement("exclude").setText(exclude);
                }
            }
        }
    }

    private void writeVersion(Version version, String tagName, Element parentElement) throws IOException {
        if (version != null) {
            Element element = parentElement.addElement(tagName);
            if (version.getName() != null) {
                element.addElement("name").setText(version.getName());
            }
            if (version.getTag() != null) {
                element.addElement("tag").setText(version.getTag());
            }
            if (version.getId() != null) {
                element.addElement("id").setText(version.getId());
            }
        }
    }
}

