/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.stax;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, Model model) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(model.getModelEncoding(), "1.0");
        this.writeModel(model, "project", (XMLStreamWriter)serializer);
        serializer.writeEndDocument();
    }

    private void writeBranch(Branch branch, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (branch != null) {
            serializer.writeStartElement(tagName);
            if (branch.getTag() != null) {
                serializer.writeStartElement("tag");
                serializer.writeCharacters(branch.getTag());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeBuild(Build build, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (build != null) {
            FileSet o;
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (build.getNagEmailAddress() != null) {
                serializer.writeStartElement("nagEmailAddress");
                serializer.writeCharacters(build.getNagEmailAddress());
                serializer.writeEndElement();
            }
            if (build.getSourceDirectory() != null) {
                serializer.writeStartElement("sourceDirectory");
                serializer.writeCharacters(build.getSourceDirectory());
                serializer.writeEndElement();
            }
            if (build.getUnitTestSourceDirectory() != null) {
                serializer.writeStartElement("unitTestSourceDirectory");
                serializer.writeCharacters(build.getUnitTestSourceDirectory());
                serializer.writeEndElement();
            }
            if (build.getAspectSourceDirectory() != null) {
                serializer.writeStartElement("aspectSourceDirectory");
                serializer.writeCharacters(build.getAspectSourceDirectory());
                serializer.writeEndElement();
            }
            if (build.getIntegrationUnitTestSourceDirectory() != null) {
                serializer.writeStartElement("integrationUnitTestSourceDirectory");
                serializer.writeCharacters(build.getIntegrationUnitTestSourceDirectory());
                serializer.writeEndElement();
            }
            if (build.getSourceModifications() != null && build.getSourceModifications().size() > 0) {
                serializer.writeStartElement("sourceModifications");
                iter = build.getSourceModifications().iterator();
                while (iter.hasNext()) {
                    o = (SourceModification)iter.next();
                    this.writeSourceModification((SourceModification)o, "sourceModification", serializer);
                }
                serializer.writeEndElement();
            }
            if (build.getUnitTest() != null) {
                this.writeUnitTest(build.getUnitTest(), "unitTest", serializer);
            }
            if (build.getDefaultGoal() != null) {
                serializer.writeStartElement("defaultGoal");
                serializer.writeCharacters(build.getDefaultGoal());
                serializer.writeEndElement();
            }
            if (build.getResources() != null && build.getResources().size() > 0) {
                serializer.writeStartElement("resources");
                iter = build.getResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "resource", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (buildBase != null) {
            serializer.writeStartElement(tagName);
            if (buildBase.getDefaultGoal() != null) {
                serializer.writeStartElement("defaultGoal");
                serializer.writeCharacters(buildBase.getDefaultGoal());
                serializer.writeEndElement();
            }
            if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
                serializer.writeStartElement("resources");
                Iterator iter = buildBase.getResources().iterator();
                while (iter.hasNext()) {
                    Resource o = (Resource)iter.next();
                    this.writeResource(o, "resource", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeContributor(Contributor contributor, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (contributor != null) {
            Iterator<Object> iter;
            serializer.writeStartElement(tagName);
            if (contributor.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(contributor.getName());
                serializer.writeEndElement();
            }
            if (contributor.getEmail() != null) {
                serializer.writeStartElement("email");
                serializer.writeCharacters(contributor.getEmail());
                serializer.writeEndElement();
            }
            if (contributor.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(contributor.getUrl());
                serializer.writeEndElement();
            }
            if (contributor.getOrganization() != null) {
                serializer.writeStartElement("organization");
                serializer.writeCharacters(contributor.getOrganization());
                serializer.writeEndElement();
            }
            if (contributor.getOrganizationUrl() != null) {
                serializer.writeStartElement("organizationUrl");
                serializer.writeCharacters(contributor.getOrganizationUrl());
                serializer.writeEndElement();
            }
            if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
                serializer.writeStartElement("roles");
                iter = contributor.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.writeStartElement("role");
                    serializer.writeCharacters(role);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (contributor.getTimezone() != null) {
                serializer.writeStartElement("timezone");
                serializer.writeCharacters(contributor.getTimezone());
                serializer.writeEndElement();
            }
            if (contributor.getProperties() != null && contributor.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                iter = contributor.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)contributor.getProperties().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDependency(Dependency dependency, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependency != null) {
            serializer.writeStartElement(tagName);
            if (dependency.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(dependency.getId());
                serializer.writeEndElement();
            }
            if (dependency.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(dependency.getGroupId());
                serializer.writeEndElement();
            }
            if (dependency.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(dependency.getArtifactId());
                serializer.writeEndElement();
            }
            if (dependency.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(dependency.getVersion());
                serializer.writeEndElement();
            }
            if (dependency.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(dependency.getUrl());
                serializer.writeEndElement();
            }
            if (dependency.getJar() != null) {
                serializer.writeStartElement("jar");
                serializer.writeCharacters(dependency.getJar());
                serializer.writeEndElement();
            }
            if (dependency.getType() != null && !dependency.getType().equals("jar")) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(dependency.getType());
                serializer.writeEndElement();
            }
            if (dependency.getProperties() != null && dependency.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                Iterator<Object> iter = dependency.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)dependency.getProperties().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeDeveloper(Developer developer, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (developer != null) {
            Iterator<Object> iter;
            serializer.writeStartElement(tagName);
            if (developer.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(developer.getId());
                serializer.writeEndElement();
            }
            if (developer.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(developer.getName());
                serializer.writeEndElement();
            }
            if (developer.getEmail() != null) {
                serializer.writeStartElement("email");
                serializer.writeCharacters(developer.getEmail());
                serializer.writeEndElement();
            }
            if (developer.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(developer.getUrl());
                serializer.writeEndElement();
            }
            if (developer.getOrganization() != null) {
                serializer.writeStartElement("organization");
                serializer.writeCharacters(developer.getOrganization());
                serializer.writeEndElement();
            }
            if (developer.getOrganizationUrl() != null) {
                serializer.writeStartElement("organizationUrl");
                serializer.writeCharacters(developer.getOrganizationUrl());
                serializer.writeEndElement();
            }
            if (developer.getRoles() != null && developer.getRoles().size() > 0) {
                serializer.writeStartElement("roles");
                iter = developer.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.writeStartElement("role");
                    serializer.writeCharacters(role);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (developer.getTimezone() != null) {
                serializer.writeStartElement("timezone");
                serializer.writeCharacters(developer.getTimezone());
                serializer.writeEndElement();
            }
            if (developer.getProperties() != null && developer.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                iter = developer.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)developer.getProperties().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer) throws XMLStreamException {
        serializer.writeStartElement(dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.writeAttribute(attributeName, dom.getAttribute(attributeName));
        }
        Xpp3Dom[] children = dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeDom(children[i], serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeFileSet(FileSet fileSet, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (fileSet != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (fileSet.getDirectory() != null) {
                serializer.writeStartElement("directory");
                serializer.writeCharacters(fileSet.getDirectory());
                serializer.writeEndElement();
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(include);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.writeStartElement("excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.writeStartElement("exclude");
                    serializer.writeCharacters(exclude);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeLicense(License license, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (license != null) {
            serializer.writeStartElement(tagName);
            if (license.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(license.getName());
                serializer.writeEndElement();
            }
            if (license.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(license.getUrl());
                serializer.writeEndElement();
            }
            if (license.getDistribution() != null) {
                serializer.writeStartElement("distribution");
                serializer.writeCharacters(license.getDistribution());
                serializer.writeEndElement();
            }
            if (license.getComments() != null) {
                serializer.writeStartElement("comments");
                serializer.writeCharacters(license.getComments());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeMailingList(MailingList mailingList, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (mailingList != null) {
            serializer.writeStartElement(tagName);
            if (mailingList.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(mailingList.getName());
                serializer.writeEndElement();
            }
            if (mailingList.getSubscribe() != null) {
                serializer.writeStartElement("subscribe");
                serializer.writeCharacters(mailingList.getSubscribe());
                serializer.writeEndElement();
            }
            if (mailingList.getUnsubscribe() != null) {
                serializer.writeStartElement("unsubscribe");
                serializer.writeCharacters(mailingList.getUnsubscribe());
                serializer.writeEndElement();
            }
            if (mailingList.getPost() != null) {
                serializer.writeStartElement("post");
                serializer.writeCharacters(mailingList.getPost());
                serializer.writeEndElement();
            }
            if (mailingList.getArchive() != null) {
                serializer.writeStartElement("archive");
                serializer.writeCharacters(mailingList.getArchive());
                serializer.writeEndElement();
            }
            if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
                serializer.writeStartElement("otherArchives");
                Iterator iter = mailingList.getOtherArchives().iterator();
                while (iter.hasNext()) {
                    String otherArchive = (String)iter.next();
                    serializer.writeStartElement("otherArchive");
                    serializer.writeCharacters(otherArchive);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModel(Model model, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (model != null) {
            Serializable o;
            Iterator<Object> iter;
            serializer.writeStartElement(tagName);
            if (model.getExtend() != null) {
                serializer.writeStartElement("extend");
                serializer.writeCharacters(model.getExtend());
                serializer.writeEndElement();
            }
            if (model.getPomVersion() != null) {
                serializer.writeStartElement("pomVersion");
                serializer.writeCharacters(model.getPomVersion());
                serializer.writeEndElement();
            }
            if (model.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(model.getGroupId());
                serializer.writeEndElement();
            }
            if (model.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(model.getArtifactId());
                serializer.writeEndElement();
            }
            if (model.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(model.getId());
                serializer.writeEndElement();
            }
            if (model.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(model.getName());
                serializer.writeEndElement();
            }
            if (model.getCurrentVersion() != null) {
                serializer.writeStartElement("currentVersion");
                serializer.writeCharacters(model.getCurrentVersion());
                serializer.writeEndElement();
            }
            if (model.getShortDescription() != null) {
                serializer.writeStartElement("shortDescription");
                serializer.writeCharacters(model.getShortDescription());
                serializer.writeEndElement();
            }
            if (model.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(model.getDescription());
                serializer.writeEndElement();
            }
            if (model.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(model.getUrl());
                serializer.writeEndElement();
            }
            if (model.getLogo() != null) {
                serializer.writeStartElement("logo");
                serializer.writeCharacters(model.getLogo());
                serializer.writeEndElement();
            }
            if (model.getIssueTrackingUrl() != null) {
                serializer.writeStartElement("issueTrackingUrl");
                serializer.writeCharacters(model.getIssueTrackingUrl());
                serializer.writeEndElement();
            }
            if (model.getInceptionYear() != null) {
                serializer.writeStartElement("inceptionYear");
                serializer.writeCharacters(model.getInceptionYear());
                serializer.writeEndElement();
            }
            if (model.getGumpRepositoryId() != null) {
                serializer.writeStartElement("gumpRepositoryId");
                serializer.writeCharacters(model.getGumpRepositoryId());
                serializer.writeEndElement();
            }
            if (model.getSiteAddress() != null) {
                serializer.writeStartElement("siteAddress");
                serializer.writeCharacters(model.getSiteAddress());
                serializer.writeEndElement();
            }
            if (model.getSiteDirectory() != null) {
                serializer.writeStartElement("siteDirectory");
                serializer.writeCharacters(model.getSiteDirectory());
                serializer.writeEndElement();
            }
            if (model.getDistributionSite() != null) {
                serializer.writeStartElement("distributionSite");
                serializer.writeCharacters(model.getDistributionSite());
                serializer.writeEndElement();
            }
            if (model.getDistributionDirectory() != null) {
                serializer.writeStartElement("distributionDirectory");
                serializer.writeCharacters(model.getDistributionDirectory());
                serializer.writeEndElement();
            }
            if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
                serializer.writeStartElement("mailingLists");
                iter = model.getMailingLists().iterator();
                while (iter.hasNext()) {
                    o = (MailingList)iter.next();
                    this.writeMailingList((MailingList)o, "mailingList", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
                serializer.writeStartElement("developers");
                iter = model.getDevelopers().iterator();
                while (iter.hasNext()) {
                    o = (Developer)iter.next();
                    this.writeDeveloper((Developer)o, "developer", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getContributors() != null && model.getContributors().size() > 0) {
                serializer.writeStartElement("contributors");
                iter = model.getContributors().iterator();
                while (iter.hasNext()) {
                    o = (Contributor)iter.next();
                    this.writeContributor((Contributor)o, "contributor", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getLicenses() != null && model.getLicenses().size() > 0) {
                serializer.writeStartElement("licenses");
                iter = model.getLicenses().iterator();
                while (iter.hasNext()) {
                    o = (License)iter.next();
                    this.writeLicense((License)o, "license", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getVersions() != null && model.getVersions().size() > 0) {
                serializer.writeStartElement("versions");
                iter = model.getVersions().iterator();
                while (iter.hasNext()) {
                    o = (Version)iter.next();
                    this.writeVersion((Version)o, "version", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getBranches() != null && model.getBranches().size() > 0) {
                serializer.writeStartElement("branches");
                iter = model.getBranches().iterator();
                while (iter.hasNext()) {
                    o = (Branch)iter.next();
                    this.writeBranch((Branch)o, "branch", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getPackageGroups() != null && model.getPackageGroups().size() > 0) {
                serializer.writeStartElement("packageGroups");
                iter = model.getPackageGroups().iterator();
                while (iter.hasNext()) {
                    o = (PackageGroup)iter.next();
                    this.writePackageGroup((PackageGroup)o, "packageGroup", serializer);
                }
                serializer.writeEndElement();
            }
            if (model.getReports() != null && model.getReports().size() > 0) {
                serializer.writeStartElement("reports");
                iter = model.getReports().iterator();
                while (iter.hasNext()) {
                    String report = (String)iter.next();
                    serializer.writeStartElement("report");
                    serializer.writeCharacters(report);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (model.getRepository() != null) {
                this.writeRepository(model.getRepository(), "repository", serializer);
            }
            if (model.getOrganization() != null) {
                this.writeOrganization(model.getOrganization(), "organization", serializer);
            }
            if (model.getProperties() != null && model.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                iter = model.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)model.getProperties().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (model.getPackageName() != null) {
                serializer.writeStartElement("package");
                serializer.writeCharacters(model.getPackageName());
                serializer.writeEndElement();
            }
            if (model.getBuild() != null) {
                this.writeBuild(model.getBuild(), "build", serializer);
            }
            if (model.getDependencies() != null && model.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                iter = model.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeModelBase(ModelBase modelBase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelBase != null) {
            serializer.writeStartElement(tagName);
            if (modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                Iterator iter = modelBase.getDependencies().iterator();
                while (iter.hasNext()) {
                    Dependency o = (Dependency)iter.next();
                    this.writeDependency(o, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeOrganization(Organization organization, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (organization != null) {
            serializer.writeStartElement(tagName);
            if (organization.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(organization.getName());
                serializer.writeEndElement();
            }
            if (organization.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(organization.getUrl());
                serializer.writeEndElement();
            }
            if (organization.getLogo() != null) {
                serializer.writeStartElement("logo");
                serializer.writeCharacters(organization.getLogo());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePackageGroup(PackageGroup packageGroup, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (packageGroup != null) {
            serializer.writeStartElement(tagName);
            if (packageGroup.getTitle() != null) {
                serializer.writeStartElement("title");
                serializer.writeCharacters(packageGroup.getTitle());
                serializer.writeEndElement();
            }
            if (packageGroup.getPackages() != null) {
                serializer.writeStartElement("packages");
                serializer.writeCharacters(packageGroup.getPackages());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePatternSet(PatternSet patternSet, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (patternSet != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                iter = patternSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(include);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0) {
                serializer.writeStartElement("excludes");
                iter = patternSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.writeStartElement("exclude");
                    serializer.writeCharacters(exclude);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginConfiguration != null) {
            serializer.writeStartElement(tagName);
            serializer.writeEndElement();
        }
    }

    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginContainer != null) {
            serializer.writeStartElement(tagName);
            serializer.writeEndElement();
        }
    }

    private void writeRepository(Repository repository, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repository != null) {
            serializer.writeStartElement(tagName);
            if (repository.getConnection() != null) {
                serializer.writeStartElement("connection");
                serializer.writeCharacters(repository.getConnection());
                serializer.writeEndElement();
            }
            if (repository.getDeveloperConnection() != null) {
                serializer.writeStartElement("developerConnection");
                serializer.writeCharacters(repository.getDeveloperConnection());
                serializer.writeEndElement();
            }
            if (repository.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(repository.getUrl());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeResource(Resource resource, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (resource != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (resource.getTargetPath() != null) {
                serializer.writeStartElement("targetPath");
                serializer.writeCharacters(resource.getTargetPath());
                serializer.writeEndElement();
            }
            if (resource.isFiltering()) {
                serializer.writeStartElement("filtering");
                serializer.writeCharacters(String.valueOf(resource.isFiltering()));
                serializer.writeEndElement();
            }
            if (resource.getDirectory() != null) {
                serializer.writeStartElement("directory");
                serializer.writeCharacters(resource.getDirectory());
                serializer.writeEndElement();
            }
            if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                iter = resource.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(include);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
                serializer.writeStartElement("excludes");
                iter = resource.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.writeStartElement("exclude");
                    serializer.writeCharacters(exclude);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeSourceModification(SourceModification sourceModification, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (sourceModification != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (sourceModification.getClassName() != null) {
                serializer.writeStartElement("className");
                serializer.writeCharacters(sourceModification.getClassName());
                serializer.writeEndElement();
            }
            if (sourceModification.getProperty() != null) {
                serializer.writeStartElement("property");
                serializer.writeCharacters(sourceModification.getProperty());
                serializer.writeEndElement();
            }
            if (sourceModification.getDirectory() != null) {
                serializer.writeStartElement("directory");
                serializer.writeCharacters(sourceModification.getDirectory());
                serializer.writeEndElement();
            }
            if (sourceModification.getIncludes() != null && sourceModification.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                iter = sourceModification.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(include);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (sourceModification.getExcludes() != null && sourceModification.getExcludes().size() > 0) {
                serializer.writeStartElement("excludes");
                iter = sourceModification.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.writeStartElement("exclude");
                    serializer.writeCharacters(exclude);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeUnitTest(UnitTest unitTest, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (unitTest != null) {
            Iterator iter;
            serializer.writeStartElement(tagName);
            if (unitTest.getResources() != null && unitTest.getResources().size() > 0) {
                serializer.writeStartElement("resources");
                iter = unitTest.getResources().iterator();
                while (iter.hasNext()) {
                    Resource o = (Resource)iter.next();
                    this.writeResource(o, "resource", serializer);
                }
                serializer.writeEndElement();
            }
            if (unitTest.getIncludes() != null && unitTest.getIncludes().size() > 0) {
                serializer.writeStartElement("includes");
                iter = unitTest.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.writeStartElement("include");
                    serializer.writeCharacters(include);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (unitTest.getExcludes() != null && unitTest.getExcludes().size() > 0) {
                serializer.writeStartElement("excludes");
                iter = unitTest.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.writeStartElement("exclude");
                    serializer.writeCharacters(exclude);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeVersion(Version version, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (version != null) {
            serializer.writeStartElement(tagName);
            if (version.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(version.getName());
                serializer.writeEndElement();
            }
            if (version.getTag() != null) {
                serializer.writeStartElement("tag");
                serializer.writeCharacters(version.getTag());
                serializer.writeEndElement();
            }
            if (version.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(version.getId());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

