/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.dom4j;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MavenDom4jReader {
    public boolean getBooleanValue(String s, String attribute) {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute) {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute) throws DocumentException {
        if (s != null) {
            DateFormat dateParser = DateFormat.getDateTimeInstance(0, 0, Locale.US);
            dateParser.setLenient(true);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new DocumentException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, boolean strict) throws DocumentException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new DocumentException("Unable to parse element '" + attribute + "', must be a floating point number");
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, boolean strict) throws DocumentException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new DocumentException("Unable to parse element '" + attribute + "', must be a floating point number");
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, boolean strict) throws DocumentException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new DocumentException("Unable to parse element '" + attribute + "', must be an integer");
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, boolean strict) throws DocumentException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new DocumentException("Unable to parse element '" + attribute + "', must be a long integer");
                }
            }
        }
        return 0L;
    }

    public short getShortValue(String s, String attribute, boolean strict) throws DocumentException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new DocumentException("Unable to parse element '" + attribute + "', must be a short integer");
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public Xpp3Dom writeElementToXpp3Dom(Element element) {
        Xpp3Dom xpp3Dom = new Xpp3Dom(element.getName());
        if (element.elements().isEmpty() && element.getText() != null) {
            xpp3Dom.setValue(element.getText());
        }
        Iterator i = element.attributeIterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            xpp3Dom.setAttribute(attribute.getName(), attribute.getValue());
        }
        i = element.elementIterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            xpp3Dom.addChild(this.writeElementToXpp3Dom(child));
        }
        return xpp3Dom;
    }

    private Branch parseBranch(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Branch branch = new Branch();
        branch.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("tag")) {
                if (parsed.contains("tag")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("tag");
                branch.setTag(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return branch;
    }

    private Build parseBuild(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Build build = new Build();
        build.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("nagEmailAddress")) {
                if (parsed.contains("nagEmailAddress")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("nagEmailAddress");
                build.setNagEmailAddress(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("sourceDirectory")) {
                if (parsed.contains("sourceDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("sourceDirectory");
                build.setSourceDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("unitTestSourceDirectory")) {
                if (parsed.contains("unitTestSourceDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("unitTestSourceDirectory");
                build.setUnitTestSourceDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("aspectSourceDirectory")) {
                if (parsed.contains("aspectSourceDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("aspectSourceDirectory");
                build.setAspectSourceDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("integrationUnitTestSourceDirectory")) {
                if (parsed.contains("integrationUnitTestSourceDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("integrationUnitTestSourceDirectory");
                build.setIntegrationUnitTestSourceDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("sourceModifications")) {
                if (parsed.contains("sourceModifications")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("sourceModifications");
                ArrayList<SourceModification> sourceModifications = new ArrayList<SourceModification>();
                build.setSourceModifications(sourceModifications);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("sourceModification")) continue;
                    sourceModifications.add(this.parseSourceModification("sourceModification", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("unitTest")) {
                if (parsed.contains("unitTest")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("unitTest");
                build.setUnitTest(this.parseUnitTest("unitTest", childElement, strict, encoding));
                continue;
            }
            if (childElement.getName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("defaultGoal");
                build.setDefaultGoal(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("resources");
                ArrayList<Resource> resources = new ArrayList<Resource>();
                build.setResources(resources);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("resource")) continue;
                    resources.add(this.parseResource("resource", listElement, strict, encoding));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return build;
    }

    private BuildBase parseBuildBase(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        BuildBase buildBase = new BuildBase();
        buildBase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("defaultGoal")) {
                if (parsed.contains("defaultGoal")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("defaultGoal");
                buildBase.setDefaultGoal(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("resources");
                ArrayList<Resource> resources = new ArrayList<Resource>();
                buildBase.setResources(resources);
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Element listElement;
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("resource")) continue;
                    resources.add(this.parseResource("resource", listElement, strict, encoding));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return buildBase;
    }

    private Contributor parseContributor(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Contributor contributor = new Contributor();
        contributor.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                contributor.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("email");
                contributor.setEmail(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                contributor.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("organization") || childElement.getName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("organization");
                contributor.setOrganization(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("organizationUrl") || childElement.getName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("organizationUrl");
                contributor.setOrganizationUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                contributor.setRoles(roles);
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Element listElement;
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("role")) continue;
                    roles.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("timezone");
                contributor.setTimezone(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("properties");
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1) continue;
                    Element listElement = (Element)n;
                    String key = listElement.getName();
                    String value = listElement.getText().trim();
                    contributor.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return contributor;
    }

    private Dependency parseDependency(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Dependency dependency = new Dependency();
        dependency.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("id");
                dependency.setId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("groupId");
                dependency.setGroupId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("artifactId");
                dependency.setArtifactId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("version");
                dependency.setVersion(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                dependency.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("jar")) {
                if (parsed.contains("jar")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("jar");
                dependency.setJar(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("type");
                dependency.setType(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("properties");
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1) continue;
                    Element listElement = (Element)n;
                    String key = listElement.getName();
                    String value = listElement.getText().trim();
                    dependency.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return dependency;
    }

    private Developer parseDeveloper(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Developer developer = new Developer();
        developer.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("id");
                developer.setId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                developer.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("email");
                developer.setEmail(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                developer.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("organization") || childElement.getName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("organization");
                developer.setOrganization(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("organizationUrl") || childElement.getName().equals("organisationUrl")) {
                if (parsed.contains("organizationUrl")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("organizationUrl");
                developer.setOrganizationUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("roles");
                ArrayList<String> roles = new ArrayList<String>();
                developer.setRoles(roles);
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Element listElement;
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("role")) continue;
                    roles.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("timezone")) {
                if (parsed.contains("timezone")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("timezone");
                developer.setTimezone(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("properties");
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1) continue;
                    Element listElement = (Element)n;
                    String key = listElement.getName();
                    String value = listElement.getText().trim();
                    developer.addProperty(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return developer;
    }

    private FileSet parseFileSet(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        FileSet fileSet = new FileSet();
        fileSet.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("directory");
                fileSet.setDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("include")) continue;
                    includes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("exclude")) continue;
                    excludes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return fileSet;
    }

    private License parseLicense(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        License license = new License();
        license.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                license.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                license.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("distribution")) {
                if (parsed.contains("distribution")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("distribution");
                license.setDistribution(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("comments")) {
                if (parsed.contains("comments")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("comments");
                license.setComments(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return license;
    }

    private MailingList parseMailingList(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        MailingList mailingList = new MailingList();
        mailingList.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                mailingList.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("subscribe")) {
                if (parsed.contains("subscribe")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("subscribe");
                mailingList.setSubscribe(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("unsubscribe")) {
                if (parsed.contains("unsubscribe")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("unsubscribe");
                mailingList.setUnsubscribe(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("post")) {
                if (parsed.contains("post")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("post");
                mailingList.setPost(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("archive")) {
                if (parsed.contains("archive")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("archive");
                mailingList.setArchive(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("otherArchives")) {
                if (parsed.contains("otherArchives")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("otherArchives");
                ArrayList<String> otherArchives = new ArrayList<String>();
                mailingList.setOtherArchives(otherArchives);
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Element listElement;
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("otherArchive")) continue;
                    otherArchives.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return mailingList;
    }

    private Model parseModel(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Model model = new Model();
        model.setModelEncoding(encoding);
        if (strict && !element.getName().equals(tagName)) {
            throw new DocumentException("Error parsing model: root element tag is '" + element.getName() + "' instead of '" + tagName + "'");
        }
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("extend")) {
                if (parsed.contains("extend")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("extend");
                model.setExtend(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("pomVersion")) {
                if (parsed.contains("pomVersion")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("pomVersion");
                model.setPomVersion(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("groupId");
                model.setGroupId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("artifactId");
                model.setArtifactId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("id");
                model.setId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                model.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("currentVersion")) {
                if (parsed.contains("currentVersion")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("currentVersion");
                model.setCurrentVersion(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("shortDescription")) {
                if (parsed.contains("shortDescription")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("shortDescription");
                model.setShortDescription(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("description");
                model.setDescription(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                model.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("logo")) {
                if (parsed.contains("logo")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("logo");
                model.setLogo(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("issueTrackingUrl")) {
                if (parsed.contains("issueTrackingUrl")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("issueTrackingUrl");
                model.setIssueTrackingUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("inceptionYear")) {
                if (parsed.contains("inceptionYear")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("inceptionYear");
                model.setInceptionYear(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("gumpRepositoryId")) {
                if (parsed.contains("gumpRepositoryId")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("gumpRepositoryId");
                model.setGumpRepositoryId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("siteAddress")) {
                if (parsed.contains("siteAddress")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("siteAddress");
                model.setSiteAddress(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("siteDirectory")) {
                if (parsed.contains("siteDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("siteDirectory");
                model.setSiteDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("distributionSite")) {
                if (parsed.contains("distributionSite")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("distributionSite");
                model.setDistributionSite(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("distributionDirectory")) {
                if (parsed.contains("distributionDirectory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("distributionDirectory");
                model.setDistributionDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("mailingLists")) {
                if (parsed.contains("mailingLists")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("mailingLists");
                ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
                model.setMailingLists(mailingLists);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("mailingList")) continue;
                    mailingLists.add(this.parseMailingList("mailingList", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("developers")) {
                if (parsed.contains("developers")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("developers");
                ArrayList<Developer> developers = new ArrayList<Developer>();
                model.setDevelopers(developers);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("developer")) continue;
                    developers.add(this.parseDeveloper("developer", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("contributors")) {
                if (parsed.contains("contributors")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("contributors");
                ArrayList<Contributor> contributors = new ArrayList<Contributor>();
                model.setContributors(contributors);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("contributor")) continue;
                    contributors.add(this.parseContributor("contributor", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("licenses")) {
                if (parsed.contains("licenses")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("licenses");
                ArrayList<License> licenses = new ArrayList<License>();
                model.setLicenses(licenses);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("license")) continue;
                    licenses.add(this.parseLicense("license", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("versions")) {
                if (parsed.contains("versions")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("versions");
                ArrayList<Version> versions = new ArrayList<Version>();
                model.setVersions(versions);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("version")) continue;
                    versions.add(this.parseVersion("version", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("branches")) {
                if (parsed.contains("branches")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("branches");
                ArrayList<Branch> branches = new ArrayList<Branch>();
                model.setBranches(branches);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("branch")) continue;
                    branches.add(this.parseBranch("branch", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("packageGroups")) {
                if (parsed.contains("packageGroups")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("packageGroups");
                ArrayList<PackageGroup> packageGroups = new ArrayList<PackageGroup>();
                model.setPackageGroups(packageGroups);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("packageGroup")) continue;
                    packageGroups.add(this.parsePackageGroup("packageGroup", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("reports")) {
                if (parsed.contains("reports")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("reports");
                ArrayList<String> reports = new ArrayList<String>();
                model.setReports(reports);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("report")) continue;
                    reports.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("repository")) {
                if (parsed.contains("repository")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("repository");
                model.setRepository(this.parseRepository("repository", childElement, strict, encoding));
                continue;
            }
            if (childElement.getName().equals("organization") || childElement.getName().equals("organisation")) {
                if (parsed.contains("organization")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("organization");
                model.setOrganization(this.parseOrganization("organization", childElement, strict, encoding));
                continue;
            }
            if (childElement.getName().equals("properties")) {
                if (parsed.contains("properties")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("properties");
                Iterator j2 = childElement.nodeIterator();
                while (j2.hasNext()) {
                    Node n2 = (Node)j2.next();
                    if (n2.getNodeType() != 1) continue;
                    Element listElement2 = (Element)n2;
                    String key = listElement2.getName();
                    String value = listElement2.getText().trim();
                    model.addProperty(key, value);
                }
                continue;
            }
            if (childElement.getName().equals("package")) {
                if (parsed.contains("package")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("package");
                model.setPackageName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("build")) {
                if (parsed.contains("build")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("build");
                model.setBuild(this.parseBuild("build", childElement, strict, encoding));
                continue;
            }
            if (childElement.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                model.setDependencies(dependencies);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("dependency")) continue;
                    dependencies.add(this.parseDependency("dependency", listElement, strict, encoding));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return model;
    }

    private ModelBase parseModelBase(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        ModelBase modelBase = new ModelBase();
        modelBase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("dependencies");
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
                modelBase.setDependencies(dependencies);
                Iterator j = childElement.nodeIterator();
                while (j.hasNext()) {
                    Element listElement;
                    Node n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("dependency")) continue;
                    dependencies.add(this.parseDependency("dependency", listElement, strict, encoding));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return modelBase;
    }

    private Organization parseOrganization(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Organization organization = new Organization();
        organization.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                organization.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                organization.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("logo")) {
                if (parsed.contains("logo")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("logo");
                organization.setLogo(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return organization;
    }

    private PackageGroup parsePackageGroup(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        PackageGroup packageGroup = new PackageGroup();
        packageGroup.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("title")) {
                if (parsed.contains("title")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("title");
                packageGroup.setTitle(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("packages")) {
                if (parsed.contains("packages")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("packages");
                packageGroup.setPackages(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return packageGroup;
    }

    private PatternSet parsePatternSet(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        PatternSet patternSet = new PatternSet();
        patternSet.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                patternSet.setIncludes(includes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("include")) continue;
                    includes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                patternSet.setExcludes(excludes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("exclude")) continue;
                    excludes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return patternSet;
    }

    private PluginConfiguration parsePluginConfiguration(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setModelEncoding(encoding);
        HashSet parsed = new HashSet();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return pluginConfiguration;
    }

    private PluginContainer parsePluginContainer(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        PluginContainer pluginContainer = new PluginContainer();
        pluginContainer.setModelEncoding(encoding);
        HashSet parsed = new HashSet();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return pluginContainer;
    }

    private Repository parseRepository(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Repository repository = new Repository();
        repository.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("connection")) {
                if (parsed.contains("connection")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("connection");
                repository.setConnection(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("developerConnection")) {
                if (parsed.contains("developerConnection")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("developerConnection");
                repository.setDeveloperConnection(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("url");
                repository.setUrl(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return repository;
    }

    private Resource parseResource(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Resource resource = new Resource();
        resource.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("targetPath")) {
                if (parsed.contains("targetPath")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("targetPath");
                resource.setTargetPath(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("filtering")) {
                if (parsed.contains("filtering")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("filtering");
                resource.setFiltering(this.getBooleanValue(this.getTrimmedValue(childElement.getText()), "filtering"));
                continue;
            }
            if (childElement.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("directory");
                resource.setDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                resource.setIncludes(includes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("include")) continue;
                    includes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                resource.setExcludes(excludes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("exclude")) continue;
                    excludes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return resource;
    }

    private SourceModification parseSourceModification(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        SourceModification sourceModification = new SourceModification();
        sourceModification.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("className")) {
                if (parsed.contains("className")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("className");
                sourceModification.setClassName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("property")) {
                if (parsed.contains("property")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("property");
                sourceModification.setProperty(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("directory")) {
                if (parsed.contains("directory")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("directory");
                sourceModification.setDirectory(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                sourceModification.setIncludes(includes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("include")) continue;
                    includes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                sourceModification.setExcludes(excludes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("exclude")) continue;
                    excludes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return sourceModification;
    }

    private UnitTest parseUnitTest(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        UnitTest unitTest = new UnitTest();
        unitTest.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Element listElement;
            Node n;
            Iterator j;
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("resources");
                ArrayList<Resource> resources = new ArrayList<Resource>();
                unitTest.setResources(resources);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("resource")) continue;
                    resources.add(this.parseResource("resource", listElement, strict, encoding));
                }
                continue;
            }
            if (childElement.getName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                unitTest.setIncludes(includes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("include")) continue;
                    includes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (childElement.getName().equals("excludes")) {
                if (parsed.contains("excludes")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("excludes");
                ArrayList<String> excludes = new ArrayList<String>();
                unitTest.setExcludes(excludes);
                j = childElement.nodeIterator();
                while (j.hasNext()) {
                    n = (Node)j.next();
                    if (n.getNodeType() != 1 || !(listElement = (Element)n).getName().equals("exclude")) continue;
                    excludes.add(this.getTrimmedValue(listElement.getText()));
                }
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return unitTest;
    }

    private Version parseVersion(String tagName, Element element, boolean strict, String encoding) throws IOException, DocumentException {
        Version version = new Version();
        version.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        Iterator i = element.nodeIterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if (childElement.getName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("name");
                version.setName(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("tag")) {
                if (parsed.contains("tag")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("tag");
                version.setTag(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (childElement.getName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new DocumentException("Duplicated tag: '" + element.getName() + "'");
                }
                parsed.add("id");
                version.setId(this.getTrimmedValue(childElement.getText()));
                continue;
            }
            if (!strict) continue;
            throw new DocumentException("Unrecognised tag: '" + childElement.getName() + "'");
        }
        return version;
    }

    public Model read(Reader reader, boolean strict) throws IOException, DocumentException {
        SAXReader parser = new SAXReader();
        Document document = parser.read(reader);
        String encoding = document.getXMLEncoding();
        return this.parseModel("project", document.getRootElement(), strict, encoding);
    }

    public Model read(Reader reader) throws IOException, DocumentException {
        return this.read(reader, true);
    }

    public Model read(URL url, boolean strict) throws IOException, DocumentException {
        SAXReader parser = new SAXReader();
        Document document = parser.read(url);
        String encoding = document.getXMLEncoding();
        return this.parseModel("project", document.getRootElement(), strict, encoding);
    }

    public Model read(URL url) throws IOException, DocumentException {
        return this.read(url, true);
    }
}

